/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileInfo {
    private static TraceComponent tc = Tr.register(FileInfo.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    final File file;
    boolean bExists = false;
    long lLength = -1L;
    long lLastModified = -1L;
    String path = null;
    static final long serialVersionUID = -178292152816793834L;

    private FileInfo(File file) {
        this.file = file;
    }

    /*
     * WARNING - void declaration
     */
    public static FileInfo getFileInfo(final File file) throws Exception {
        FileInfo fileInfo = null;
        try {
            fileInfo = (FileInfo)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -7155225235584870730L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    FileInfo fileInfo = new FileInfo(file);
                    fileInfo.path = file.getPath();
                    fileInfo.bExists = file.exists();
                    fileInfo.lLength = file.length();
                    fileInfo.lLastModified = file.lastModified();
                    return fileInfo;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.client.internal.FileInfo$1", 1.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.openidconnect.client.internal.FileInfo", (String)"57", null, (Object[])new Object[]{file});
            throw new Exception((Throwable)e);
        }
        return fileInfo;
    }

    public String getPath() {
        return this.path;
    }

    public boolean exists() {
        return this.bExists;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FileInfo) {
            boolean result;
            FileInfo newFileInfo = (FileInfo)obj;
            boolean bl = result = newFileInfo.file.equals(this.file) && newFileInfo.lLastModified == this.lLastModified && newFileInfo.lLength == this.lLength;
            if (!result && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Equals:" + newFileInfo.file.equals(this.file) + " " + (newFileInfo.lLastModified == this.lLastModified) + " " + (newFileInfo.lLength == this.lLength)), (Object[])new Object[0]);
            }
            return result;
        }
        return false;
    }

    public static String getHostName() {
        try {
            String hostName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -8891931870543140549L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.client.internal.FileInfo$2", 2.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
                }
            });
            return hostName;
        }
        catch (PrivilegedActionException hostName) {
            FFDCFilter.processException((Throwable)hostName, (String)"com.ibm.ws.security.openidconnect.client.internal.FileInfo", (String)"106", null, (Object[])new Object[0]);
            return "localhost";
        }
    }
}

