/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;

public class BasicHttpClientSecurityConfiguration
implements HttpClientSecurityConfiguration {
    @Nullable
    private CredentialsProvider credentialsProvider;
    @Nullable
    private TrustEngine<? super X509Credential> tlsTrustEngine;
    @Nullable
    private List<String> tlsProtocols;
    @Nullable
    private List<String> tlsCipherSuites;
    @Nullable
    private X509HostnameVerifier hostnameVerifier;
    @Nullable
    private X509Credential clientTLSCredential;
    @Nullable
    private Boolean serverTLSFailureFatal;

    @Override
    @Nullable
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(@Nullable CredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    public void setBasicCredentials(@Nullable UsernamePasswordCredentials credentials) {
        this.setBasicCredentialsWithScope(credentials, null);
    }

    public void setBasicCredentialsWithScope(@Nullable UsernamePasswordCredentials credentials, @Nullable AuthScope scope) {
        if (credentials != null) {
            AuthScope authScope = scope;
            if (authScope == null) {
                authScope = new AuthScope(AuthScope.ANY_HOST, -1);
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(authScope, (Credentials)credentials);
            this.credentialsProvider = provider;
        } else {
            this.credentialsProvider = null;
        }
    }

    @Override
    @Nullable
    public TrustEngine<? super X509Credential> getTLSTrustEngine() {
        return this.tlsTrustEngine;
    }

    public void setTLSTrustEngine(@Nullable TrustEngine<? super X509Credential> engine) {
        this.tlsTrustEngine = engine;
    }

    @Override
    @Nullable
    public List<String> getTLSProtocols() {
        return this.tlsProtocols;
    }

    public void setTLSProtocols(@Nullable Collection<String> protocols) {
        this.tlsProtocols = new ArrayList<String>(StringSupport.normalizeStringCollection(protocols));
        if (this.tlsProtocols.isEmpty()) {
            this.tlsProtocols = null;
        }
    }

    @Override
    @Nullable
    public List<String> getTLSCipherSuites() {
        return this.tlsCipherSuites;
    }

    public void setTLSCipherSuites(@Nullable Collection<String> cipherSuites) {
        this.tlsCipherSuites = new ArrayList<String>(StringSupport.normalizeStringCollection(cipherSuites));
        if (this.tlsCipherSuites.isEmpty()) {
            this.tlsCipherSuites = null;
        }
    }

    @Override
    @Nullable
    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(@Nullable X509HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    @Override
    @Nullable
    public X509Credential getClientTLSCredential() {
        return this.clientTLSCredential;
    }

    public void setClientTLSCredential(@Nullable X509Credential credential) {
        this.clientTLSCredential = credential;
    }

    @Override
    @Nullable
    public Boolean isServerTLSFailureFatal() {
        return this.serverTLSFailureFatal;
    }

    public void setServerTLSFailureFatal(@Nullable Boolean flag) {
        this.serverTLSFailureFatal = flag;
    }
}

