/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.sar;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppInfoFailure;
import com.ibm.ws.app.manager.sar.SARDeployedAppInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.application.handler.DefaultApplicationMonitoringInformation;
import java.util.Collections;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "type:String=sar"})
public class SARApplicationHandlerImpl
implements ApplicationHandler<DeployedAppInfo> {
    private FutureMonitor futureMonitor;
    private DeployedAppInfoFactory deployedAppFactory;
    static final long serialVersionUID = -7717637736387105201L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setFutureMonitor(FutureMonitor fm) {
        this.futureMonitor = fm;
    }

    protected void unsetFutureMonitor(FutureMonitor fm) {
    }

    @Reference(name="deployedAppFactory", target="(type=sar)")
    protected void setDeployedAppFactory(DeployedAppInfoFactory factory) {
        this.deployedAppFactory = factory;
    }

    protected void unsetDeployedAppFactory(DeployedAppInfoFactory factory) {
        this.deployedAppFactory = null;
    }

    public ApplicationMonitoringInformation setUpApplicationMonitoring(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        DefaultNotification webInfNotification = new DefaultNotification(applicationInformation.getContainer(), "/WEB-INF");
        return new DefaultApplicationMonitoringInformation(Collections.singleton(webInfNotification), false);
    }

    /*
     * WARNING - void declaration
     */
    public Future<Boolean> install(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        SARDeployedAppInfo deployedApp;
        Future result = this.futureMonitor.createFuture(Boolean.class);
        try {
            deployedApp = (SARDeployedAppInfo)this.deployedAppFactory.createDeployedAppInfo(applicationInformation);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void ex;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.sar.SARApplicationHandlerImpl", (String)"80", (Object)this, (Object[])new Object[]{applicationInformation});
            Throwable cause = ex.getCause();
            if (cause instanceof DDParser.ParseException) {
                this.futureMonitor.setResult(result, (Throwable)new DeployedAppInfoFailure(cause.getMessage(), cause));
            } else {
                this.futureMonitor.setResult(result, (Throwable)ex);
            }
            return result;
        }
        if (!deployedApp.deployApp(result)) {
            this.futureMonitor.setResult(result, (Object)false);
            return result;
        }
        return result;
    }

    public Future<Boolean> uninstall(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        SARDeployedAppInfo deployedApp = (SARDeployedAppInfo)((Object)applicationInformation.getHandlerInfo());
        if (deployedApp == null) {
            return this.futureMonitor.createFutureWithResult((Object)false);
        }
        boolean success = deployedApp.uninstallApp();
        return this.futureMonitor.createFutureWithResult((Object)success);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SARApplicationHandlerImpl.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.sar.internal.resources.Messages", (String)"com.ibm.ws.app.manager.sar.SARApplicationHandlerImpl");
    }
}

