/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.parser.StreamMessageParser;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnectionAdapter;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedList;

public abstract class SIPStreamConectionAdapter
extends SIPConnectionAdapter {
    private static final LogMgr c_logger = Log.get(SIPStreamConectionAdapter.class);
    protected Socket m_socket;
    private SIPListenningConnection m_listenningConnection;
    private NetworkReader m_netReader;
    private NetworkWriter m_netWriter;
    private MessageParser m_messageParser;
    private static boolean s_blockingConnect = false;
    private static int s_connectTimeout = SIPTransactionStack.instance().getConfiguration().getConnectTimeout();

    public SIPStreamConectionAdapter(SIPListenningConnection listenningConnection, Socket socket) {
        this(listenningConnection, SIPStackUtil.getHostAddress(socket.getInetAddress()), socket.getPort());
        this.m_socket = socket;
        this.connectionEstablished();
    }

    public SIPStreamConectionAdapter(SIPListenningConnection listenningConnection, String peerHost, int peerPort) {
        super(peerHost, peerPort);
        this.m_listenningConnection = listenningConnection;
        this.m_socket = null;
        this.m_connectionStatus = SIPConnectionAdapter.ConnectionStatus.PRE_CONNECT;
        this.m_messageParser = new StreamMessageParser(this);
    }

    @Override
    public void write(MessageContext messageContext, boolean considerMtu, UseCompactHeaders useCompactHeaders) throws IOException {
        this.prepareBuffer(messageContext, considerMtu, useCompactHeaders);
        this.write(messageContext);
    }

    private void write(MessageContext messageContext) throws IOException {
        if (this.m_netWriter != null && !this.isClosed()) {
            this.m_netWriter.send(messageContext);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "write", "m_netwriter is null!!!");
            }
            IOException e2 = new IOException("m_netwriter is null!!!");
            this.connectionError(e2);
            messageContext.writeError(e2);
        }
    }

    @Override
    public SIPListenningConnection getSIPListenningConnection() {
        return this.m_listenningConnection;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (s_blockingConnect) {
            this.establishConnection();
        }
    }

    private void establishConnection() throws IOException {
        String host = this.getRemoteHost();
        int port = this.getRemotePort();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "establishConnection", host + ":" + port);
        }
        this.m_socket = this.createSocket();
        InetSocketAddress address = InetAddressCache.getInetSocketAddress(host, port);
        try {
            this.m_socket.connect(address, s_connectTimeout);
            this.connectionEstablished();
        }
        catch (IOException e2) {
            this.connectionError(e2);
            throw e2;
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.m_connectionStatus = SIPConnectionAdapter.ConnectionStatus.CLOSED;
            if (this.m_socket != null) {
                this.m_socket.close();
            }
            this.m_netWriter.wakeUp();
        }
        catch (IOException exp) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "close", exp.getMessage(), exp);
            }
        }
        finally {
            super.close();
        }
    }

    @Override
    public void start() throws IOException {
        if (this.m_socket != null) {
            this.startReader();
        }
        this.startWriter();
    }

    private void startReader() throws IOException {
        this.m_netReader = new NetworkReader(this.m_socket.getInputStream(), this);
        StringBuffer reader = new StringBuffer("SIP Reader ");
        this.getPeer(reader);
        Thread networkListeningThread = new Thread((Runnable)this.m_netReader, reader.toString());
        networkListeningThread.start();
    }

    private void startWriter() {
        this.m_netWriter = new NetworkWriter(this);
        StringBuffer writer = new StringBuffer("SIP Writer ");
        this.getPeer(writer);
        Thread networkWritingThread = new Thread((Runnable)this.m_netWriter, writer.toString());
        networkWritingThread.start();
    }

    public int hashCode() {
        return this.m_socket.hashCode();
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public MessageParser getMessageParser() {
        return this.m_messageParser;
    }

    private void getPeer(StringBuffer buf) {
        buf.append(this.getRemoteHost());
        buf.append(':');
        buf.append(this.getRemotePort());
        buf.append('/');
        buf.append(this.getTransport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionError(Exception e2) {
        if (!this.isClosed()) {
            super.connectionError(e2);
        }
        LinkedList<MessageContext> pendingMessageContextList = null;
        if (this.m_netWriter != null) {
            pendingMessageContextList = this.m_netWriter.getMessages();
        }
        LinkedList<MessageContext> linkedList = pendingMessageContextList;
        synchronized (linkedList) {
            this.cleanPendingMessages(pendingMessageContextList, e2);
        }
    }

    public abstract Socket createSocket() throws IOException;

    @Override
    public int getPathMTU() {
        return -1;
    }

    static class NetworkWriter
    implements Runnable {
        private LinkedList<MessageContext> m_msgQueue = new LinkedList();
        private SIPStreamConectionAdapter m_connection;

        NetworkWriter(SIPStreamConectionAdapter connection) {
            this.m_connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeUp() {
            LinkedList<MessageContext> linkedList = this.m_msgQueue;
            synchronized (linkedList) {
                this.m_msgQueue.notify();
            }
        }

        public LinkedList<MessageContext> getMessages() {
            return this.m_msgQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(MessageContext messageSendingContext) {
            LinkedList<MessageContext> linkedList = this.m_msgQueue;
            synchronized (linkedList) {
                this.m_msgQueue.addLast(messageSendingContext);
                this.m_msgQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.m_connection.m_socket == null) {
                try {
                    this.m_connection.establishConnection();
                }
                catch (IOException e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("Failed connecting to [");
                        this.m_connection.getPeer(buf);
                        buf.append(']');
                        c_logger.traceDebug(buf.toString());
                        c_logger.traceDebug(this, "run", "IOException", e2);
                    }
                    return;
                }
                try {
                    this.m_connection.startReader();
                }
                catch (IOException e3) {
                    if (c_logger.isTraceDebugEnabled()) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("Failed starting reader thread with [");
                        this.m_connection.getPeer(buf);
                        buf.append(']');
                        c_logger.traceDebug(buf.toString());
                        c_logger.traceDebug(this, "run", "IOException", e3);
                    }
                    return;
                }
            }
            OutputStream outStream = null;
            try {
                outStream = this.m_connection.m_socket.getOutputStream();
            }
            catch (IOException e1) {
                this.m_connection.connectionError(e1);
            }
            SipMessageByteBuffer msg = null;
            MessageContext messageSendingContext = null;
            while (this.m_connection.isConnected()) {
                block19: {
                    messageSendingContext = null;
                    msg = null;
                    try {
                        LinkedList<MessageContext> linkedList = this.m_msgQueue;
                        synchronized (linkedList) {
                            if (this.m_msgQueue.isEmpty()) {
                                this.m_msgQueue.wait();
                            }
                            if (!this.m_msgQueue.isEmpty()) {
                                messageSendingContext = this.m_msgQueue.removeFirst();
                            }
                        }
                    }
                    catch (InterruptedException e4) {
                        if (!c_logger.isTraceDebugEnabled()) break block19;
                        c_logger.traceDebug(this, "run", e4.getMessage(), e4);
                    }
                }
                if (messageSendingContext == null) continue;
                msg = messageSendingContext.getSipMessageByteBuffer();
                try {
                    outStream.write(msg.getBytes(), 0, msg.getMarkedBytesNumber());
                    outStream.flush();
                    msg.reset();
                    msg = null;
                    messageSendingContext.writeComplete();
                }
                catch (Exception e5) {
                    this.m_connection.connectionError(e5);
                    messageSendingContext.writeError(e5);
                }
            }
        }
    }

    static class NetworkReader
    implements Runnable {
        private InputStream m_networkInputStream;
        private SIPStreamConectionAdapter m_connection;

        NetworkReader(InputStream networkInputStream, SIPStreamConectionAdapter connection) {
            this.m_networkInputStream = networkInputStream;
            this.m_connection = connection;
        }

        @Override
        public void run() {
            Dispatcher dispatch = Dispatcher.instance();
            try {
                SIPStreamConectionAdapter connection = this.m_connection;
                Socket socket = connection.m_socket;
                int packetSize = socket.getReceiveBufferSize();
                String peerHost = connection.getRemoteHost();
                int peerPort = connection.getRemotePort();
                byte[] buf = new byte[packetSize];
                while (connection.isConnected()) {
                    int nBytes = this.m_networkInputStream.read(buf, 0, packetSize);
                    if (nBytes == -1) {
                        throw new IOException("Socket broken" + this);
                    }
                    SipMessageByteBuffer byteBuffer = SipMessageByteBuffer.fromNetwork(buf, nBytes, peerHost, peerPort);
                    dispatch.queueIncomingDataEvent(byteBuffer, connection);
                }
            }
            catch (IOException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "run", "Connection closed" + e2.getMessage(), e2);
                }
                this.m_connection.connectionError(e2);
            }
        }
    }
}

