/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.transaction;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.sessions.SipTransactionUserTable;
import com.ibm.ws.sip.container.transaction.ServerTransactionListener;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.sip.SipServletRequest;

public class ServerTransaction
extends SipTransaction {
    private static final LogMgr c_logger = Log.get(ServerTransaction.class);
    private List<TransactionUserWrapper> m_derivedTU = new LinkedList<TransactionUserWrapper>();

    protected ServerTransaction(long transactionID, SipServletRequestImpl request) {
        super(transactionID, request);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "ServerTransaction", "transID = " + transactionID + "  request.method =" + request.getMethod());
        }
    }

    public ServerTransactionListener getServerTransactionLisener() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getServerTransactionLisener", "listener=" + this.m_listener);
        }
        return (ServerTransactionListener)this.m_listener;
    }

    public void processRequest(SipServletRequest request) {
        TransactionUserWrapper tu;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{request.getMethod()};
            c_logger.traceEntry((Object)this, "processRequest", params);
        }
        if ((tu = SipTransactionUserTable.getInstance().getTransactionUserForInboundRequest((SipServletRequestImpl)request)) != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequest", "processing request with TU=" + tu);
            }
            tu.processRequest(request);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequest", "processing request with transaction listener=" + this.m_listener);
            }
            this.getServerTransactionLisener().processRequest(request);
        }
        if (request.getMethod().equals("ACK")) {
            this.removeFromTransactionTable(null);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processRequest");
        }
    }

    public void sendResponse(OutgoingSipServletResponse response) throws IOException {
        ServerTransactionListener lstr;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{response.getMethod()};
            c_logger.traceEntry((Object)this, "sendResponse", params);
        }
        if ((lstr = this.getServerTransactionLisener()) != null) {
            lstr.onSendingResponse(response);
        }
        response.sendImpl();
        int status = response.getStatus();
        if (status >= 200) {
            this.onFinalResponse(response);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "sendResponse");
        }
    }

    @Override
    protected void transactionTerminated(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "transactionTerminated");
        }
        if (this.m_listener != null) {
            this.getServerTransactionLisener().serverTransactionTerminated(request);
            if (!this.m_derivedTU.isEmpty()) {
                TransactionUserWrapper activeListener = (TransactionUserWrapper)this.m_listener;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "transactionTerminated", "Active listener ID = " + activeListener.getId());
                }
                for (TransactionUserWrapper dtu : this.m_derivedTU) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "notifyDerivedTUs", "Found DTU = " + dtu.getId());
                    }
                    if (activeListener == dtu) continue;
                    dtu.originalServerTransactionTerminated(request);
                }
            }
        }
    }

    @Override
    protected void notifyDerivedTUs() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "notifyDerivedTUs");
        }
        TransactionUserWrapper activeListener = (TransactionUserWrapper)this.m_listener;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "notifyDerivedTUs", "Active listener TU = " + activeListener.getId());
        }
        if (!this.m_derivedTU.isEmpty()) {
            for (TransactionUserWrapper dtu : this.m_derivedTU) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "notifyDerivedTUs", "Found DTU = " + dtu.getId());
                }
                if (dtu == activeListener) continue;
                dtu.removeTransaction(null);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "notifyDerivedTUs");
        }
    }

    @Override
    protected void replaceListener() {
        if (!this.m_derivedTU.contains(this.m_listener)) {
            this.addReferece((TransactionUserWrapper)this.m_listener);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "replaceListener", "store listener in derived list");
            }
        }
    }

    @Override
    public void addReferece(TransactionUserWrapper dtu) {
        this.m_derivedTU.add(dtu);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "ServerTransaction", "New related DTU which should be updated when this ST is ended" + dtu.getId());
        }
    }
}

