/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl.netty;

import com.ibm.ws.sip.channel.resolver.dns.impl.netty.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.ResourceRecord;
import io.netty.buffer.ByteBuf;

public class NAPTRRecord
extends ResourceRecord {
    private short _order;
    private short _preference;
    private String _flags;
    private String _service;
    private String _regexp;
    private Name _replacement;

    protected NAPTRRecord() {
        this._order = 0;
        this._preference = 0;
        this._flags = new String();
        this._service = new String();
        this._regexp = new String();
        this._replacement = null;
    }

    protected NAPTRRecord(ByteBuf buffer) {
        super(buffer);
        this._order = buffer.readShort();
        this._preference = buffer.readShort();
        byte length = buffer.readByte();
        byte[] b = new byte[length];
        buffer.readBytes(b);
        this._flags = new String(b);
        length = buffer.readByte();
        b = new byte[length];
        buffer.readBytes(b);
        this._service = new String(b);
        length = buffer.readByte();
        b = new byte[length];
        buffer.readBytes(b);
        this._regexp = new String(b);
        this._replacement = new Name(buffer);
    }

    @Override
    protected void toBuffer(ByteBuf buffer) {
        super.toBuffer(buffer);
        buffer.writeShort((int)this._order);
        buffer.writeShort((int)this._preference);
        buffer.writeByte((int)((byte)this._flags.length()));
        buffer.writeBytes(this._flags.getBytes());
        buffer.writeByte((int)((byte)this._service.length()));
        buffer.writeBytes(this._service.getBytes());
        buffer.writeByte((int)((byte)this._regexp.length()));
        buffer.writeBytes(this._regexp.getBytes());
        this._replacement.toBuffer(buffer);
    }

    public void setOrder(short s) {
        this._order = s;
    }

    public Short getOrder() {
        return this._order;
    }

    public void setPreference(short s) {
        this._preference = s;
    }

    public Short getPreference() {
        return this._preference;
    }

    public void setFlags(String s) {
        this._flags = s;
    }

    public void setService(String s) {
        this._service = s;
    }

    public String getService() {
        return this._service;
    }

    public void setRegexp(String s) {
        this._regexp = s;
    }

    public void setReplacement(Name name) {
        this._replacement = name;
    }

    public Name getReplacement() {
        return this._replacement;
    }

    public short calcrdLength() {
        int length = 0;
        length = 5 + this._flags.length() + 1 + this._service.length() + 1 + this._regexp.length() + this._replacement.length();
        return (short)length;
    }

    @Override
    public String toString() {
        String s = new String();
        s = s + super.toString();
        s = s + "        order: " + new Short(this._order).toString() + "\n        preference: " + new Short(this._preference).toString() + "\n        flags: " + this._flags.toString() + "\n        service: " + this._service.toString() + "\n        regexp: " + this._regexp.toString() + "\n        replacement: " + this._replacement.toString() + "\n";
        return s;
    }
}

