/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import java.util.NoSuchElementException;

public final class SipResponseCodes {
    public static final int INFO_TRYING = 100;
    public static final int INFO_RINGING = 180;
    public static final int INFO_CALL_FORWARDING = 181;
    public static final int INFO_QUEUED = 182;
    public static final int INFO_SESSION_PROGRESS = 183;
    public static final int OK = 200;
    public static final int ACCEPTED = 202;
    public static final int REDIRECT_MULTIPLE_CHOICES = 300;
    public static final int REDIRECT_MOVED_PERMANENTLY = 301;
    public static final int REDIRECT_MOVED_TEMPORARILY = 302;
    public static final int REDIRECT_USE_PROXY = 305;
    public static final int REDIRECT_ALTERNATIVE_SERVICE = 380;
    public static final int CLIENT_BAD_REQUEST = 400;
    public static final int CLIENT_UNAUTHORIZED = 401;
    public static final int CLIENT_PAYMENT_REQUIRED = 402;
    public static final int CLIENT_FORBIDDEN = 403;
    public static final int CLIENT_NOT_FOUND = 404;
    public static final int CLIENT_METHOD_NOT_ALLOWED = 405;
    public static final int CLIENT_NOT_ACCEPTABLE = 406;
    public static final int CLIENT_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int CLIENT_REQUEST_TIMEOUT = 408;
    public static final int CLIENT_CONFLICT = 409;
    public static final int CLIENT_GONE = 410;
    public static final int CLIENT_LENGTH_REQUIRED = 411;
    public static final int CLIENT_CONDITIONAL_REQUEST_FAILED = 412;
    public static final int CLIENT_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int CLIENT_REQUEST_URI_TOO_LARGE = 414;
    public static final int CLIENT_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int CLIENT_UNSUPPORTED_URI_SCHEME = 416;
    public static final int CLIENT_UNKNOWN_RESOURCE_PRIORITY = 417;
    public static final int CLIENT_BAD_EXTENSION = 420;
    public static final int CLIENT_EXTENSION_REQUIRED = 421;
    public static final int CLIENT_SESSION_INTERVAL_TOO_SMALL = 422;
    public static final int CLIENT_INTERVAL_TOO_BRIEF = 423;
    public static final int CLIENT_BAD_LOCATION_INFORMATION = 424;
    public static final int CLIENT_USE_IDENTITY_HEADER = 428;
    public static final int CLIENT_PROVIDE_REFERER_IDENTITY = 429;
    public static final int CLIENT_ANONYMILY_DISALLOWED = 433;
    public static final int CLIENT_BAD_IDENTITY_INFO = 436;
    public static final int CLIENT_UNSUPPORTED_CERTIFICATE = 437;
    public static final int CLIENT_INVALID_IDENTITY_HEADER = 438;
    public static final int CLIENT_TEMPORARILY_UNAVAILABLE = 480;
    public static final int CLIENT_CALL_OR_TRANSACTION_DOES_NOT_EXIST = 481;
    public static final int CLIENT_LOOP_DETECTED = 482;
    public static final int CLIENT_TOO_MANY_HOPS = 483;
    public static final int CLIENT_ADDRESS_INCOMPLETE = 484;
    public static final int CLIENT_AMBIGUOUS = 485;
    public static final int CLIENT_BUSY_HERE = 486;
    public static final int CLIENT_REQUEST_CANCELLED = 487;
    public static final int CLIENT_REQUEST_TERMINATED = 487;
    public static final int CLIENT_NOT_ACCEPTABLE_HERE = 488;
    public static final int CLIENT_BAD_EVENT = 489;
    public static final int CLIENT_REQUEST_PENDING = 491;
    public static final int CLIENT_UNDECIPHERABLE = 493;
    public static final int CLIENT_SECURITY_AGREEMENT_REQUIRED = 494;
    public static final int SERVER_INTERNAL_FAILURE = 500;
    public static final int SERVER_NOT_IMPLEMENTED = 501;
    public static final int SERVER_BAD_GATEWAY = 502;
    public static final int SERVER_SERVICE_UNAVAILABLE = 503;
    public static final int SERVER_GATEWAY_TIMEOUT = 504;
    public static final int SERVER_SIP_VERSION_NOT_SUPPORTED = 505;
    public static final int SC_MESSAGE_TOO_LARGE = 513;
    public static final int SERVER_PRECONDITION_FAILURE = 580;
    public static final int GLOBAL_BUSY_EVERYWHERE = 600;
    public static final int GLOBAL_DECLINE = 603;
    public static final int GLOBAL_DOES_NOT_EXIST_ANYWHERE = 604;
    public static final int GLOBAL_NOT_ACCEPTABLE = 606;

    private SipResponseCodes() {
    }

    public static final String getResponseCodeText(int responseCode) throws NoSuchElementException {
        String retval;
        block0 : switch (responseCode) {
            case 100: {
                retval = "Trying";
                break;
            }
            case 180: {
                retval = "Ringing";
                break;
            }
            case 181: {
                retval = "Call Is Being Forwarded";
                break;
            }
            case 182: {
                retval = "Queued";
                break;
            }
            case 183: {
                retval = "Session Progress";
                break;
            }
            case 200: {
                retval = "OK";
                break;
            }
            case 202: {
                retval = "ACCEPTED";
                break;
            }
            case 300: {
                retval = "Multiple Choices";
                break;
            }
            case 301: {
                retval = "Moved Permanently";
                break;
            }
            case 302: {
                retval = "Moved Temporarily";
                break;
            }
            case 305: {
                retval = "Use Proxy";
                break;
            }
            case 380: {
                retval = "Alternative Service";
                break;
            }
            case 400: {
                retval = "Bad Request";
                break;
            }
            case 401: {
                retval = "Unauthorized";
                break;
            }
            case 402: {
                retval = "Payment Required";
                break;
            }
            case 403: {
                retval = "Forbidden";
                break;
            }
            case 404: {
                retval = "Not Found";
                break;
            }
            case 405: {
                retval = "Method Not Allowed";
                break;
            }
            case 406: {
                retval = "Not Acceptable";
                break;
            }
            case 407: {
                retval = "Proxy Authentication Required";
                break;
            }
            case 408: {
                retval = "Request Timeout";
                break;
            }
            case 409: {
                retval = "Conflict";
                break;
            }
            case 410: {
                retval = "Gone";
                break;
            }
            case 411: {
                retval = "Length Required";
                break;
            }
            case 412: {
                retval = "Conditional Request Failed";
                break;
            }
            case 413: {
                retval = "Request Entity Too Large";
                break;
            }
            case 414: {
                retval = "Request-URI Too Long";
                break;
            }
            case 415: {
                retval = "Unsupported Media Type";
                break;
            }
            case 416: {
                retval = "Unsupported URI Scheme";
                break;
            }
            case 417: {
                retval = "Unknown Resource-Priority";
                break;
            }
            case 420: {
                retval = "Bad Extension";
                break;
            }
            case 422: {
                retval = "Session Interval Too Small";
                break;
            }
            case 421: {
                retval = "Extension Required";
                break;
            }
            case 423: {
                retval = "Interval Too Brief";
                break;
            }
            case 424: {
                retval = "Bad Location Information";
                break;
            }
            case 428: {
                retval = "Use Identity Header";
                break;
            }
            case 429: {
                retval = "Provide Referrer Identity";
                break;
            }
            case 433: {
                retval = "Anonymity Disallowed";
                break;
            }
            case 436: {
                retval = "Bad Identity-Info";
                break;
            }
            case 437: {
                retval = "Unsupported Certificate";
                break;
            }
            case 438: {
                retval = "Invalid Identity Header";
                break;
            }
            case 480: {
                retval = "Temporarily Unavailable";
                break;
            }
            case 481: {
                retval = "Call/Transaction Does Not Exist";
                break;
            }
            case 482: {
                retval = "Loop Detected";
                break;
            }
            case 483: {
                retval = "Too Many Hops";
                break;
            }
            case 484: {
                retval = "Address Incomplete";
                break;
            }
            case 485: {
                retval = "Ambiguous";
                break;
            }
            case 486: {
                retval = "Busy Here";
                break;
            }
            case 487: {
                retval = "Request Terminated";
                break;
            }
            case 488: {
                retval = "Not Acceptable Here";
                break;
            }
            case 491: {
                retval = "Request Pending";
                break;
            }
            case 493: {
                retval = "Undecipherable";
                break;
            }
            case 494: {
                retval = "Security Agreement Required";
                break;
            }
            case 489: {
                retval = "Bad Event";
                break;
            }
            case 500: {
                retval = "Server Internal Error";
                break;
            }
            case 501: {
                retval = "Not Implemented";
                break;
            }
            case 502: {
                retval = "Bad Gateway";
                break;
            }
            case 503: {
                retval = "Service Unavailable";
                break;
            }
            case 504: {
                retval = "Server Time-out";
                break;
            }
            case 505: {
                retval = "Version Not Supported";
                break;
            }
            case 513: {
                retval = "Message Too Large";
                break;
            }
            case 580: {
                retval = "Precondition Failure";
                break;
            }
            case 600: {
                retval = "Busy Everywhere";
                break;
            }
            case 603: {
                retval = "Decline";
                break;
            }
            case 604: {
                retval = "Does Not Exist Anywhere";
                break;
            }
            case 606: {
                retval = "Not Acceptable";
                break;
            }
            default: {
                switch (responseCode / 100) {
                    case 1: {
                        retval = "Session Progress";
                        break block0;
                    }
                    case 2: {
                        retval = "OK";
                        break block0;
                    }
                    case 3: {
                        retval = "Multiple Choices";
                        break block0;
                    }
                    case 4: {
                        retval = "Bad Request";
                        break block0;
                    }
                    case 5: {
                        retval = "Server Internal Error";
                        break block0;
                    }
                    case 6: {
                        retval = "Busy Everywhere";
                        break block0;
                    }
                }
                retval = "Bad Request";
            }
        }
        return retval;
    }

    public static boolean isProvionalResponse(int reasonCode) {
        return reasonCode >= 100 && reasonCode < 200;
    }

    public static boolean isRedirectResponse(int reasonCode) {
        return reasonCode >= 300 && reasonCode < 400;
    }

    public static boolean isFinalResponse(int reasonCode) {
        return reasonCode >= 200 && reasonCode < 700;
    }

    public static boolean isNonOkFinalResponse(int reasonCode) {
        return reasonCode >= 300 && reasonCode < 700;
    }

    public static boolean isOKFinalResponse(int reasonCode) {
        return reasonCode >= 200 && reasonCode < 300;
    }

    public static boolean isClientFailResponse(int reasonCode) {
        return reasonCode >= 400 && reasonCode < 400;
    }
}

