/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.ContentLengthHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderFactoryImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderSeparator;
import com.ibm.ws.jain.protocol.ip.sip.message.HeaderIteratorImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersion;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersionFactory;
import com.ibm.ws.sip.parser.DatagramMessageParser;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ContentLengthHeader;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.DateHeader;
import jain.protocol.ip.sip.header.EncryptionHeader;
import jain.protocol.ip.sip.header.ExpiresHeader;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.OrganizationHeader;
import jain.protocol.ip.sip.header.RetryAfterHeader;
import jain.protocol.ip.sip.header.TimeStampHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.header.UserAgentHeader;
import jain.protocol.ip.sip.message.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;

public abstract class MessageImpl
implements Message,
Externalizable,
HeaderIteratorImpl.HeaderIteratorListener {
    private static final long serialVersionUID = 2332293185980703896L;
    private static final LogMgr c_logger = Log.get(MessageImpl.class);
    static final String CHARSET = "charset";
    private static final boolean s_hideBody = SIPTransactionStack.instance().getConfiguration().hideMessageContent();
    private static final boolean s_removeEmptyCommaSeparatedHeaders = SIPTransactionStack.instance().getConfiguration().removeEmptyCommaSeparatedHeaders();
    private HeaderEntry m_top = null;
    private HeaderEntry m_bottom = null;
    public HeaderEntry m_topVia = null;
    public HeaderEntry m_callId = null;
    public HeaderEntry m_cseq = null;
    public HeaderEntry m_to = null;
    public HeaderEntry m_from = null;
    private byte[] m_body;
    private SipVersion m_version = SipVersionFactory.createVersion();
    private boolean m_loopback = false;
    private static final Field TOP_VIA;
    private static final Field CALL_ID;
    private static final Field CSEQ;
    private static final Field TO;
    private static final Field FROM;
    private Message m_deserializedMessage = null;
    private HeaderForm m_headerForm = null;

    MessageImpl() {
    }

    private static Field getDirectAccessMember(String name) {
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case 'V': 
                case 'v': {
                    return TOP_VIA;
                }
                case 'T': 
                case 't': {
                    return TO;
                }
                case 'F': 
                case 'f': {
                    return FROM;
                }
                case 'I': 
                case 'i': {
                    return CALL_ID;
                }
            }
            return null;
        }
        switch (name.charAt(0)) {
            case 'V': 
            case 'v': {
                if (name.length() != 3 || name.charAt(1) != 'i' && name.charAt(1) != 'I' || name.charAt(2) != 'a' && name.charAt(2) != 'A') break;
                return TOP_VIA;
            }
            case 'T': 
            case 't': {
                if (name.length() != 2 || name.charAt(1) != 'o' && name.charAt(1) != 'O') break;
                return TO;
            }
            case 'F': 
            case 'f': {
                if (name.length() != 4 || name.charAt(1) != 'r' && name.charAt(1) != 'R' || name.charAt(2) != 'o' && name.charAt(2) != 'O' || name.charAt(3) != 'm' && name.charAt(3) != 'M') break;
                return FROM;
            }
            case 'C': 
            case 'c': {
                if (!(name.length() != 7 || name.charAt(1) != 'a' && name.charAt(1) != 'A' || name.charAt(2) != 'l' && name.charAt(2) != 'L' || name.charAt(3) != 'l' && name.charAt(3) != 'L' || name.charAt(4) != '-' || name.charAt(5) != 'i' && name.charAt(5) != 'I' || name.charAt(6) != 'd' && name.charAt(6) != 'D')) {
                    return CALL_ID;
                }
                if (name.length() != 4 || name.charAt(1) != 's' && name.charAt(1) != 'S' || name.charAt(2) != 'e' && name.charAt(2) != 'E' || name.charAt(3) != 'q' && name.charAt(3) != 'Q') break;
                return CSEQ;
            }
        }
        return null;
    }

    private HeaderEntry getDirectHeaderEntry(Field member) {
        try {
            return (HeaderEntry)member.get(this);
        }
        catch (IllegalAccessException e2) {
            return null;
        }
    }

    private boolean setDirectHeaderEntry(Field member, HeaderEntry entry) {
        try {
            member.set(this, entry);
            return true;
        }
        catch (IllegalAccessException e2) {
            return false;
        }
    }

    private HeaderEntry topHeader(String headerName, HeaderEntry direct) {
        HeaderImpl h;
        if (direct != null) {
            return direct;
        }
        HeaderEntry e2 = this.m_top;
        while (e2 != null && !MessageImpl.headerNamesEqual((h = e2.m_header).getName(), headerName)) {
            e2 = e2.m_next;
        }
        return e2;
    }

    private HeaderEntry bottomHeader(String headerName, HeaderEntry direct) {
        HeaderImpl h;
        HeaderEntry e2 = this.topHeader(headerName, direct);
        if (e2 == null) {
            return null;
        }
        HeaderEntry lookAhead = e2.m_next;
        while (lookAhead != null && MessageImpl.headerNamesEqual((h = lookAhead.m_header).getName(), headerName)) {
            e2 = lookAhead;
            lookAhead = lookAhead.m_next;
        }
        return e2;
    }

    @Override
    public void addHeaders(String headerName, List headers, boolean top) throws IllegalArgumentException {
        HeaderEntry l;
        HeaderEntry r;
        HeaderEntry direct;
        if (headerName == null) {
            throw new IllegalArgumentException("Message: Null headerName");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Message: Null headers");
        }
        if (headers.isEmpty()) {
            throw new IllegalArgumentException("Message: empty header list");
        }
        HeaderEntry head = null;
        HeaderEntry tail = null;
        for (Object o : headers) {
            if (!(o instanceof HeaderImpl)) {
                throw new IllegalArgumentException("Message: All headers must be from IBM jain sip implementation. received " + o.getClass().toString());
            }
            HeaderImpl h = (HeaderImpl)o;
            if (!MessageImpl.headerNamesEqual(h.getName(), headerName)) {
                throw new IllegalArgumentException("Message: expected header name [" + headerName + "] received [" + h.getName() + ']');
            }
            HeaderEntry n = new HeaderEntry(tail, h, null);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addHeaders", "m_prev(tail) is " + tail + " m_header(h) is " + h + " m_next(null) is " + null);
            }
            if (head == null) {
                head = n;
            }
            if (tail != null) {
                tail.m_next = n;
            }
            tail = n;
        }
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry headerEntry = direct = member == null ? null : this.getDirectHeaderEntry(member);
        if (top) {
            r = this.topHeader(headerName, direct);
            HeaderEntry headerEntry2 = l = r == null ? this.m_bottom : r.m_prev;
            if (member != null) {
                this.setDirectHeaderEntry(member, head);
            }
        } else {
            l = this.bottomHeader(headerName, direct);
            HeaderEntry headerEntry3 = r = l == null ? this.m_top : l.m_next;
            if (member != null && direct == null) {
                this.setDirectHeaderEntry(member, head);
            }
        }
        head.m_prev = l;
        if (l == null) {
            this.m_top = head;
        } else {
            l.m_next = head;
        }
        tail.m_next = r;
        if (r == null) {
            this.m_bottom = tail;
        } else {
            r.m_prev = tail;
        }
    }

    @Override
    public void addHeader(Header header, boolean top) throws IllegalArgumentException {
        HeaderEntry n;
        HeaderEntry l;
        HeaderEntry r;
        HeaderEntry direct;
        if (header == null) {
            throw new IllegalArgumentException("Message: Null Header");
        }
        if (!(header instanceof HeaderImpl)) {
            throw new IllegalArgumentException("Message: header must be from IBM jain sip implementation. received " + header.getClass().toString());
        }
        HeaderImpl h = (HeaderImpl)header;
        String headerName = header.getName();
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry headerEntry = direct = member == null ? null : this.getDirectHeaderEntry(member);
        if (top) {
            r = this.topHeader(headerName, direct);
            l = r == null ? this.m_bottom : r.m_prev;
            n = new HeaderEntry(l, h, r);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addHeader", "m_prev(l) is " + l + " m_header(h) is " + h + " m_next(r) is " + r);
            }
            if (member != null) {
                this.setDirectHeaderEntry(member, n);
            }
        } else {
            l = this.bottomHeader(headerName, direct);
            r = l == null ? this.m_top : l.m_next;
            n = new HeaderEntry(l, h, r);
            if (member != null && direct == null) {
                this.setDirectHeaderEntry(member, n);
            }
        }
        if (l == null) {
            this.m_top = n;
        } else {
            l.m_next = n;
        }
        if (r == null) {
            this.m_bottom = n;
        } else {
            r.m_prev = n;
        }
    }

    @Override
    public void setHeaders(String headerName, List headers) throws IllegalArgumentException {
        if (headerName == null) {
            throw new IllegalArgumentException("Message: Null headerName");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Message: Null headers");
        }
        if (headers.isEmpty()) {
            throw new IllegalArgumentException("Message: empty header list");
        }
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry direct = member == null ? null : this.getDirectHeaderEntry(member);
        HeaderEntry iOld = this.topHeader(headerName, direct);
        Iterator iNew = headers.iterator();
        HeaderEntry i = null;
        HeaderEntry l = iOld == null ? this.m_bottom : iOld.m_prev;
        HeaderEntry r = null;
        do {
            HeaderImpl hOld;
            Object o;
            if (!((o = iNew.next()) instanceof HeaderImpl)) {
                throw new IllegalArgumentException("Message: All headers must be from IBM jain sip implementation. received " + o.getClass().toString());
            }
            HeaderImpl hNew = (HeaderImpl)o;
            if (!MessageImpl.headerNamesEqual(hNew.getName(), headerName)) {
                throw new IllegalArgumentException("Message: expected header name [" + headerName + "] received [" + hNew.getName() + ']');
            }
            if (iOld == null) {
                boolean first = i == null;
                i = new HeaderEntry(i, hNew, r);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setHeaders", "m_prev(i) is " + i + " m_header(hNew) is " + hNew + " m_next(r) is " + r);
                }
                if (first) {
                    if (this.m_top == null) {
                        this.m_top = i;
                    }
                    if (member != null && direct == null) {
                        direct = i;
                        this.setDirectHeaderEntry(member, direct);
                    }
                    if (l == null) {
                        this.m_top = i;
                    } else {
                        l.m_next = i;
                    }
                    i.m_prev = l;
                } else {
                    i.m_prev.m_next = i;
                }
                if (r == null) {
                    this.m_bottom = i;
                    continue;
                }
                r.m_prev = i;
                continue;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setHeaders", "iOld.m_header is " + iOld.m_header + " hNew is " + hNew);
            }
            iOld.m_header = hNew;
            i = iOld;
            r = iOld = iOld.m_next;
            if (iOld == null || MessageImpl.headerNamesEqual((hOld = iOld.m_header).getName(), headerName)) continue;
            iOld = null;
        } while (iNew.hasNext());
        if (iOld != null) {
            HeaderEntry last = iOld.m_prev;
            r = iOld.m_next;
            while (r != null) {
                HeaderImpl hOld = r.m_header;
                if (!MessageImpl.headerNamesEqual(hOld.getName(), headerName)) {
                    r.m_prev = last;
                    break;
                }
                r = r.m_next;
            }
            last.m_next = r;
            if (r == null) {
                this.m_bottom = last;
            }
        }
    }

    @Override
    public void setHeader(Header header, boolean first) throws IllegalArgumentException {
        HeaderEntry e2;
        if (header == null) {
            throw new IllegalArgumentException("Message: Null header");
        }
        if (!(header instanceof HeaderImpl)) {
            throw new IllegalArgumentException("Message: header must be from IBM jain sip implementation. received " + header.getClass().toString());
        }
        HeaderImpl h = (HeaderImpl)header;
        String headerName = h.getName();
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry direct = member == null ? null : this.getDirectHeaderEntry(member);
        HeaderEntry headerEntry = e2 = first ? this.topHeader(headerName, direct) : this.bottomHeader(headerName, direct);
        if (e2 == null) {
            e2 = new HeaderEntry(this.m_bottom, h, null);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setHeader", "m_prev(m_bottom) is " + this.m_bottom + " m_header(h) is " + h + " m_next(null) is " + null);
            }
            if (this.m_bottom != null) {
                this.m_bottom.m_next = e2;
            }
            this.m_bottom = e2;
            if (this.m_top == null) {
                this.m_top = e2;
            }
            if (member != null && direct == null) {
                this.setDirectHeaderEntry(member, e2);
            }
        } else {
            e2.m_header = h;
        }
    }

    @Override
    public void removeHeader(String headerName, boolean first) throws IllegalArgumentException {
        this.removeHeader(headerName, null, first);
    }

    protected void removeHeader(HeaderEntry headerEntry) throws IllegalArgumentException {
        if (headerEntry == null || headerEntry.m_header == null) {
            return;
        }
        String headerName = headerEntry.m_header.getName();
        this.removeHeader(headerName, headerEntry, true);
    }

    private void removeHeader(String headerName, HeaderEntry givenEntry, boolean first) throws IllegalArgumentException {
        if (headerName == null) {
            throw new IllegalArgumentException("Message: null headerName");
        }
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry direct = member == null ? null : this.getDirectHeaderEntry(member);
        HeaderEntry entryToRemove = givenEntry;
        if (givenEntry == null) {
            HeaderEntry headerEntry = entryToRemove = first ? this.topHeader(headerName, direct) : this.bottomHeader(headerName, direct);
            if (entryToRemove == null) {
                return;
            }
        }
        HeaderEntry lbridge = entryToRemove.m_prev;
        HeaderEntry rbridge = entryToRemove.m_next;
        if (lbridge == null) {
            if (this.m_top == entryToRemove) {
                this.m_top = rbridge;
            }
        } else {
            lbridge.m_next = rbridge;
        }
        if (rbridge == null) {
            if (this.m_bottom == entryToRemove) {
                this.m_bottom = lbridge;
            }
        } else {
            rbridge.m_prev = lbridge;
        }
        if (direct == entryToRemove) {
            HeaderEntry headerEntry = direct = first ? entryToRemove.m_next : entryToRemove.m_prev;
            if (direct != null && !MessageImpl.headerNamesEqual(direct.m_header.getName(), headerName)) {
                direct = null;
            }
            this.setDirectHeaderEntry(member, direct);
        }
    }

    @Override
    public void removeHeaders(String headerName) throws IllegalArgumentException {
        HeaderImpl h;
        if (headerName == null) {
            throw new IllegalArgumentException("Message: null headerName");
        }
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry direct = member == null ? null : this.getDirectHeaderEntry(member);
        HeaderEntry first = this.topHeader(headerName, direct);
        if (first == null) {
            return;
        }
        HeaderEntry last = first;
        HeaderEntry lookAhead = last.m_next;
        while (lookAhead != null && MessageImpl.headerNamesEqual((h = lookAhead.m_header).getName(), headerName)) {
            last = lookAhead;
            lookAhead = lookAhead.m_next;
        }
        HeaderEntry lbridge = first.m_prev;
        HeaderEntry rbridge = last.m_next;
        if (lbridge == null) {
            if (this.m_top == first) {
                this.m_top = rbridge;
            }
        } else {
            lbridge.m_next = rbridge;
        }
        if (rbridge == null) {
            if (this.m_bottom == last) {
                this.m_bottom = lbridge;
            }
        } else {
            rbridge.m_prev = lbridge;
        }
        if (direct == first) {
            this.setDirectHeaderEntry(member, null);
        }
    }

    @Override
    public HeaderIterator getHeaders() {
        if (this.m_top == null) {
            return null;
        }
        return new HeaderIteratorImpl.General(this.m_top, this);
    }

    public HeaderIterator getHeadersUnparsed() {
        return new HeaderIteratorImpl.Unparsed(this.m_top, this);
    }

    @Override
    public HeaderIterator getHeaders(String headerName) throws IllegalArgumentException {
        return this.getHeaders(headerName, true);
    }

    public HeaderIterator getHeadersUnparsed(String headerName) throws IllegalArgumentException {
        return this.getHeaders(headerName, false);
    }

    private HeaderIterator getHeaders(String headerName, boolean isParsed) {
        if (headerName == null) {
            throw new IllegalArgumentException("Message: headerName cannot be null");
        }
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry direct = member == null ? null : this.getDirectHeaderEntry(member);
        HeaderEntry e2 = this.topHeader(headerName, direct);
        if (e2 == null) {
            return null;
        }
        if (isParsed) {
            return new HeaderIteratorImpl.Specific(e2, this);
        }
        return new HeaderIteratorImpl.UnparsedSpecific(e2, this);
    }

    @Override
    public Header getHeader(String headerName, boolean first) throws IllegalArgumentException, HeaderParseException {
        HeaderEntry e2;
        if (headerName == null) {
            throw new IllegalArgumentException("Message: null headerName");
        }
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry direct = member == null ? null : this.getDirectHeaderEntry(member);
        HeaderEntry headerEntry = e2 = first ? this.topHeader(headerName, direct) : this.bottomHeader(headerName, direct);
        if (e2 == null) {
            return null;
        }
        HeaderImpl h = e2.m_header;
        try {
            h.parse();
        }
        catch (SipParseException x) {
            throw new HeaderParseException(h);
        }
        return h;
    }

    @Override
    public boolean hasHeaders() {
        return this.m_top != null;
    }

    @Override
    public boolean hasHeaders(String headerName) throws IllegalArgumentException {
        if (headerName == null) {
            throw new IllegalArgumentException("Message: null headerName");
        }
        Field member = MessageImpl.getDirectAccessMember(headerName);
        HeaderEntry direct = member == null ? null : this.getDirectHeaderEntry(member);
        HeaderEntry e2 = this.topHeader(headerName, direct);
        return e2 != null;
    }

    @Override
    public CallIdHeader getCallIdHeader() {
        if (this.m_callId == null) {
            return null;
        }
        HeaderImpl h = this.m_callId.m_header;
        try {
            h.parse();
        }
        catch (SipParseException e2) {
            return null;
        }
        return (CallIdHeader)((Object)h);
    }

    @Override
    public void setCallIdHeader(CallIdHeader callIdHeader) throws IllegalArgumentException {
        this.setHeader(callIdHeader, true);
    }

    @Override
    public CSeqHeader getCSeqHeader() {
        if (this.m_cseq == null) {
            return null;
        }
        HeaderImpl h = this.m_cseq.m_header;
        try {
            h.parse();
        }
        catch (SipParseException e2) {
            return null;
        }
        return (CSeqHeader)((Object)h);
    }

    @Override
    public void setCSeqHeader(CSeqHeader cSeqHeader) throws IllegalArgumentException {
        this.setHeader(cSeqHeader, true);
    }

    @Override
    public ToHeader getToHeader() {
        if (this.m_to == null) {
            return null;
        }
        HeaderImpl h = this.m_to.m_header;
        try {
            h.parse();
        }
        catch (SipParseException e2) {
            return null;
        }
        return (ToHeader)((Object)h);
    }

    @Override
    public void setToHeader(ToHeader toHeader) throws IllegalArgumentException {
        this.setHeader(toHeader, true);
    }

    @Override
    public FromHeader getFromHeader() {
        if (this.m_from == null) {
            return null;
        }
        HeaderImpl h = this.m_from.m_header;
        try {
            h.parse();
        }
        catch (SipParseException e2) {
            return null;
        }
        return (FromHeader)((Object)h);
    }

    @Override
    public void setFromHeader(FromHeader fromHeader) throws IllegalArgumentException {
        this.setHeader(fromHeader, true);
    }

    @Override
    public HeaderIterator getViaHeaders() {
        if (this.m_topVia == null) {
            return null;
        }
        return new HeaderIteratorImpl.Specific(this.m_topVia, this);
    }

    @Override
    public void setViaHeaders(List viaHeaders) throws IllegalArgumentException {
        this.setHeaders("Via", viaHeaders);
    }

    @Override
    public boolean hasViaHeaders() {
        return this.m_topVia != null;
    }

    @Override
    public void removeViaHeaders() {
        this.removeHeaders("Via");
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() throws HeaderParseException {
        return (ContentTypeHeader)this.getHeader("Content-Type", true);
    }

    @Override
    public void setContentTypeHeader(ContentTypeHeader contentTypeHeader) throws IllegalArgumentException {
        this.setHeader(contentTypeHeader, true);
    }

    @Override
    public boolean hasContentTypeHeader() {
        return this.hasHeaders("Content-Type");
    }

    @Override
    public void removeContentTypeHeader() {
        this.removeHeaders("Content-Type");
    }

    @Override
    public DateHeader getDateHeader() throws HeaderParseException {
        return (DateHeader)this.getHeader("Date", true);
    }

    @Override
    public boolean hasDateHeader() {
        return this.hasHeaders("Date");
    }

    @Override
    public void setDateHeader(DateHeader dateHeader) throws IllegalArgumentException {
        this.setHeader(dateHeader, true);
    }

    @Override
    public void removeDateHeader() {
        this.removeHeaders("Date");
    }

    @Override
    public EncryptionHeader getEncryptionHeader() throws HeaderParseException {
        return (EncryptionHeader)this.getHeader("Encryption", true);
    }

    @Override
    public boolean hasEncryptionHeader() {
        return this.hasHeaders("Encryption");
    }

    @Override
    public void setEncryptionHeader(EncryptionHeader encryptionHeader) throws IllegalArgumentException {
        this.setHeader(encryptionHeader, true);
    }

    @Override
    public void removeEncryptionHeader() {
        this.removeHeaders("Encryption");
    }

    @Override
    public UserAgentHeader getUserAgentHeader() throws HeaderParseException {
        return (UserAgentHeader)this.getHeader("User-Agent", true);
    }

    @Override
    public boolean hasUserAgentHeader() {
        return this.hasHeaders("User-Agent");
    }

    @Override
    public void setUserAgentHeader(UserAgentHeader userAgentHeader) throws IllegalArgumentException {
        this.setHeader(userAgentHeader, true);
    }

    @Override
    public void removeUserAgentHeader() {
        this.removeHeaders("Via");
    }

    @Override
    public TimeStampHeader getTimeStampHeader() throws HeaderParseException {
        return (TimeStampHeader)this.getHeader("Timestamp", true);
    }

    @Override
    public boolean hasTimeStampHeader() {
        return this.hasHeaders("Timestamp");
    }

    @Override
    public void removeTimeStampHeader() {
        this.removeHeaders("Timestamp");
    }

    @Override
    public void setTimeStampHeader(TimeStampHeader timeStampHeader) throws IllegalArgumentException {
        this.setHeader(timeStampHeader, true);
    }

    @Override
    public HeaderIterator getContentEncodingHeaders() {
        return this.getHeaders("Content-Encoding");
    }

    @Override
    public boolean hasContentEncodingHeaders() {
        return this.hasHeaders("Content-Encoding");
    }

    @Override
    public void removeContentEncodingHeaders() {
        this.removeHeaders("Content-Encoding");
    }

    @Override
    public void setContentEncodingHeaders(List contentEncodingHeaders) throws IllegalArgumentException, SipException {
        this.setHeaders("Content-Encoding", contentEncodingHeaders);
    }

    @Override
    public ContentLengthHeader getContentLengthHeader() throws HeaderParseException {
        return (ContentLengthHeader)this.getHeader("Content-Length", true);
    }

    @Override
    public boolean hasContentLengthHeader() {
        return this.hasHeaders("Content-Length");
    }

    @Override
    public void removeContentLengthHeader() {
        this.removeHeaders("Content-Length");
    }

    @Override
    public void setContentLengthHeader(ContentLengthHeader contentLengthHeader) throws IllegalArgumentException {
        this.setHeader(contentLengthHeader, true);
    }

    @Override
    public HeaderIterator getAcceptHeaders() {
        return this.getHeaders("Accept");
    }

    @Override
    public boolean hasAcceptHeaders() {
        return this.hasHeaders("Accept");
    }

    @Override
    public void removeAcceptHeaders() {
        this.removeHeaders("Accept");
    }

    @Override
    public void setAcceptHeaders(List acceptHeaders) throws IllegalArgumentException {
        this.setHeaders("Accept", acceptHeaders);
    }

    @Override
    public HeaderIterator getAcceptEncodingHeaders() {
        return this.getHeaders("Accept-Encoding");
    }

    @Override
    public boolean hasAcceptEncodingHeaders() {
        return this.hasHeaders("Accept-Encoding");
    }

    @Override
    public void removeAcceptEncodingHeaders() {
        this.removeHeaders("Accept-Encoding");
    }

    @Override
    public void setAcceptEncodingHeaders(List acceptEncodingHeaders) throws IllegalArgumentException {
        this.setHeaders("Accept-Encoding", acceptEncodingHeaders);
    }

    @Override
    public HeaderIterator getAcceptLanguageHeaders() {
        return this.getHeaders("Accept-Language");
    }

    @Override
    public boolean hasAcceptLanguageHeaders() {
        return this.hasHeaders("Accept-Language");
    }

    @Override
    public void removeAcceptLanguageHeaders() {
        this.removeHeaders("Accept-Language");
    }

    @Override
    public void setAcceptLanguageHeaders(List acceptLanguageHeaders) throws IllegalArgumentException {
        this.setHeaders("Accept-Language", acceptLanguageHeaders);
    }

    @Override
    public ExpiresHeader getExpiresHeader() throws HeaderParseException {
        return (ExpiresHeader)this.getHeader("Expires", true);
    }

    @Override
    public boolean hasExpiresHeader() {
        return this.hasHeaders("Expires");
    }

    @Override
    public void removeExpiresHeader() {
        this.removeHeaders("Expires");
    }

    @Override
    public void setExpiresHeader(ExpiresHeader expiresHeader) throws IllegalArgumentException {
        this.setHeader(expiresHeader, true);
    }

    @Override
    public HeaderIterator getContactHeaders() {
        return this.getHeaders("Contact");
    }

    @Override
    public boolean hasContactHeaders() {
        return this.hasHeaders("Contact");
    }

    @Override
    public void removeContactHeaders() {
        this.removeHeaders("Contact");
    }

    @Override
    public void setContactHeaders(List contactHeaders) throws IllegalArgumentException {
        this.setHeaders("Contact", contactHeaders);
    }

    @Override
    public OrganizationHeader getOrganizationHeader() throws HeaderParseException {
        return (OrganizationHeader)this.getHeader("Organization", true);
    }

    @Override
    public boolean hasOrganizationHeader() {
        return this.hasHeaders("Organization");
    }

    @Override
    public void removeOrganizationHeader() {
        this.removeHeaders("Organization");
    }

    @Override
    public void setOrganizationHeader(OrganizationHeader organizationHeader) throws IllegalArgumentException {
        this.setHeader(organizationHeader, true);
    }

    @Override
    public HeaderIterator getRecordRouteHeaders() {
        return this.getHeaders("Record-Route");
    }

    @Override
    public boolean hasRecordRouteHeaders() {
        return this.hasHeaders("Record-Route");
    }

    @Override
    public void removeRecordRouteHeaders() {
        this.removeHeaders("Record-Route");
    }

    @Override
    public void setRecordRouteHeaders(List recordRouteHeaders) throws IllegalArgumentException {
        this.setHeaders("Record-Route", recordRouteHeaders);
    }

    @Override
    public RetryAfterHeader getRetryAfterHeader() throws HeaderParseException {
        return (RetryAfterHeader)this.getHeader("Retry-After", true);
    }

    @Override
    public boolean hasRetryAfterHeader() {
        return this.hasHeaders("Retry-After");
    }

    @Override
    public void removeRetryAfterHeader() {
        this.removeHeaders("Retry-After");
    }

    @Override
    public void setRetryAfterHeader(RetryAfterHeader retryAfterHeader) throws IllegalArgumentException {
        this.setHeader(retryAfterHeader, true);
    }

    @Override
    public String getBodyAsString() {
        if (this.m_body == null) {
            return null;
        }
        try {
            String encoding;
            ContentTypeHeader ctHdr = this.getContentTypeHeader();
            String string = encoding = ctHdr == null ? null : ctHdr.getParameter(CHARSET);
            if (encoding == null || encoding.length() == 0) {
                encoding = "UTF-8";
            }
            return new String(this.m_body, encoding);
        }
        catch (UnsupportedEncodingException e2) {
            return new String(this.m_body);
        }
        catch (SipParseException e3) {
            return new String(this.m_body);
        }
    }

    @Override
    public byte[] getBodyAsBytes() {
        return this.m_body;
    }

    @Override
    public boolean hasBody() {
        return this.m_body != null;
    }

    @Override
    public void setBody(String body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        if (body == null) {
            throw new IllegalArgumentException("Message: Null body");
        }
        if (contentTypeHeader == null) {
            throw new IllegalArgumentException("Message: Null contentTypeHeader");
        }
        String encoding = contentTypeHeader.getParameter(CHARSET);
        if (encoding == null || encoding.length() == 0) {
            encoding = "UTF-8";
        }
        try {
            this.m_body = body.getBytes(encoding);
            this.setContentTypeHeader(contentTypeHeader);
        }
        catch (UnsupportedEncodingException e1) {
            throw new SipParseException(e1.getMessage());
        }
        try {
            ContentLengthHeader content = new HeaderFactoryImpl().createContentLengthHeader(this.m_body.length);
            this.setContentLengthHeader(content);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setBody(byte[] body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        if (body == null) {
            throw new IllegalArgumentException("Message: null body");
        }
        if (contentTypeHeader == null) {
            throw new IllegalArgumentException("Message: null ContentTypeHeader");
        }
        this.m_body = body;
        this.setContentTypeHeader(contentTypeHeader);
        try {
            ContentLengthHeader content = new HeaderFactoryImpl().createContentLengthHeader(this.m_body.length);
            this.setContentLengthHeader(content);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    public void setBody(byte[] body) throws IllegalArgumentException {
        if (body == null) {
            throw new IllegalArgumentException("Message: null body");
        }
        this.m_body = body;
        try {
            ContentLengthHeader content = new HeaderFactoryImpl().createContentLengthHeader(this.m_body.length);
            this.setContentLengthHeader(content);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void removeBody() {
        this.m_body = null;
        this.removeHeaders("Content-Type");
        this.removeHeaders("Content-Encoding");
        try {
            ContentLengthHeader content = new HeaderFactoryImpl().createContentLengthHeader(0);
            this.setContentLengthHeader(content);
        }
        catch (SipParseException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public int getVersionMajor() throws SipParseException {
        String major = this.m_version.getVersionMajor();
        try {
            int ret = Integer.parseInt(major);
            return ret;
        }
        catch (NumberFormatException ex) {
            throw new SipParseException(ex.getMessage(), "");
        }
    }

    @Override
    public int getVersionMinor() throws SipParseException {
        String minor = this.m_version.getVersionMinor();
        try {
            int ret = Integer.parseInt(minor);
            return ret;
        }
        catch (NumberFormatException ex) {
            throw new SipParseException(ex.getMessage());
        }
    }

    @Override
    public void setVersion(int versionMajor, int versionMinor) throws SipParseException {
        this.m_version = SipVersionFactory.createSipVersion(versionMajor, versionMinor);
    }

    protected SipVersion getVersion() {
        return this.m_version;
    }

    @Override
    public abstract boolean isRequest();

    @Override
    public abstract String getStartLine();

    public abstract void writeStartLineToBuffer(CharsBuffer var1, boolean var2);

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof MessageImpl)) {
            return false;
        }
        MessageImpl other = (MessageImpl)object;
        if (!this.getStartLine().equals(other.getStartLine())) {
            return false;
        }
        if (this.m_body == null || this.m_body.length == 0) {
            if (other.m_body != null && other.m_body.length > 0) {
                return false;
            }
        } else {
            if (other.m_body == null || other.m_body.length == 0) {
                return false;
            }
            for (int i = 0; i < this.m_body.length; ++i) {
                if (this.m_body[i] == other.m_body[i]) continue;
                return false;
            }
        }
        try {
            if (this.getVersionMajor() != other.getVersionMajor()) {
                return false;
            }
            if (this.getVersionMinor() != other.getVersionMinor()) {
                return false;
            }
        }
        catch (SipException e2) {
            return false;
        }
        HeaderEntry e1 = this.m_top;
        HeaderEntry e2 = other.m_top;
        while (e1 != null) {
            HeaderImpl h2;
            if (e2 == null) {
                return false;
            }
            HeaderImpl h1 = e1.m_header;
            if (!h1.equals(h2 = e2.m_header)) {
                return false;
            }
            e1 = e1.m_next;
            e2 = e2.m_next;
        }
        return e2 == null;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Object clone() {
        try {
            MessageImpl ret = (MessageImpl)super.clone();
            ret.m_bottom = null;
            ret.m_top = null;
            HeaderEntry old = this.m_top;
            while (old != null) {
                HeaderImpl h = (HeaderImpl)old.m_header.clone();
                HeaderEntry n = new HeaderEntry(ret.m_bottom, h, null);
                if (ret.m_top == null) {
                    ret.m_top = n;
                }
                if (ret.m_bottom != null) {
                    ret.m_bottom.m_next = n;
                }
                ret.m_bottom = n;
                Field member = MessageImpl.getDirectAccessMember(h.getName());
                if (member != null) {
                    HeaderEntry oldDirect = this.getDirectHeaderEntry(member);
                    HeaderEntry newDirect = ret.getDirectHeaderEntry(member);
                    if (newDirect == oldDirect) {
                        ret.setDirectHeaderEntry(member, n);
                    }
                }
                old = old.m_next;
            }
            if (ret.m_top == null && c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "clone", "ret.m_top is null");
                c_logger.traceDebug(this, "clone", "the stack trace is: ");
                for (StackTraceElement stackTrace : Thread.currentThread().getStackTrace()) {
                    c_logger.traceDebug(this, "a frame is ", stackTrace.toString());
                }
            }
            if (this.m_body == null) {
                ret.m_body = null;
            } else {
                ret.m_body = new byte[this.m_body.length];
                System.arraycopy(this.m_body, 0, ret.m_body, 0, this.m_body.length);
            }
            ret.m_version = this.m_version;
            ret.m_loopback = this.m_loopback;
            return ret;
        }
        catch (CloneNotSupportedException e2) {
            throw new Error("Message: Clone error?");
        }
    }

    @Override
    public String toString() {
        CharsBuffer ret = CharsBuffersPool.getBuffer();
        this.writeHeadersToBuffer(ret, HeaderForm.DEFAULT, false);
        if (this.m_body != null) {
            if (s_hideBody) {
                ret.append("<hidden content>");
            } else {
                ret.append(this.getBodyAsString());
            }
            ret.append("\r\n");
        }
        String value = ret.toString();
        CharsBuffersPool.putBufferBack(ret);
        return value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            SipMessageByteBuffer buf = SipMessageByteBuffer.fromMessage(this, HeaderForm.DEFAULT);
            buf.toStream(out);
            buf.reset();
        }
        catch (SipException e2) {
            throw new InvalidObjectException(e2.getMessage());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SipMessageByteBuffer buf = SipMessageByteBuffer.fromStream(in);
        MessageParser parser = DatagramMessageParser.getGlobalInstance();
        this.m_deserializedMessage = parser.parse(buf);
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.m_deserializedMessage == null) {
            throw new InvalidObjectException("null message");
        }
        return this.m_deserializedMessage;
    }

    public boolean isCompact() {
        HeaderForm form = this.getHeaderForm();
        switch (form) {
            case DEFAULT: {
                HeaderEntry e2 = this.m_top;
                while (e2 != null) {
                    HeaderImpl h = e2.m_header;
                    if (h.isCompactFormSupported() && !h.isCompactForm()) {
                        return false;
                    }
                    e2 = e2.m_next;
                }
                return true;
            }
            case LONG: {
                return false;
            }
            case COMPACT: {
                return true;
            }
        }
        throw new RuntimeException("unknown header form [" + (Object)((Object)form) + ']');
    }

    public HeaderForm getHeaderForm() {
        HeaderForm form = this.m_headerForm;
        return form == null ? HeaderForm.DEFAULT : form;
    }

    public void setHeaderForm(HeaderForm form) {
        this.m_headerForm = form;
    }

    public void writeHeadersToBuffer(CharsBuffer buffer, HeaderForm headerForm, boolean network) {
        this.writeStartLineToBuffer(buffer, network);
        boolean hasContentLengthHeader = false;
        boolean commaSeparated = false;
        HeaderSeparator headerSeparator = HeaderSeparator.instance();
        if (headerForm == HeaderForm.DEFAULT) {
            headerForm = this.getHeaderForm();
        }
        HeaderEntry e2 = this.m_top;
        while (e2 != null) {
            HeaderImpl h = e2.m_header;
            if (!commaSeparated) {
                h.writeNameToCharBuffer(buffer, headerForm);
            }
            h.writeValueToCharBuffer(buffer, network);
            String headerName = h.getName();
            String nextHeaderName = null;
            if (e2.m_next != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "writeHeadersToBuffer", "e is " + e2.toString() + " e.m_next is " + e2.m_next + " e.m_next.getHeader() is " + e2.m_next.getHeader());
                }
                nextHeaderName = e2.m_next.getHeader().getName();
            }
            boolean bl = commaSeparated = headerName.equals(nextHeaderName) && h.isNested() && headerSeparator.isCommaSeparated(headerName, false);
            if (commaSeparated) {
                if (!s_removeEmptyCommaSeparatedHeaders || h.getValue().length() > 0) {
                    buffer.append(',');
                    if (headerForm != HeaderForm.COMPACT) {
                        buffer.append(' ');
                    }
                }
            } else {
                buffer.append('\r').append('\n');
            }
            if (MessageImpl.headerNamesEqual(headerName, "Content-Length")) {
                hasContentLengthHeader = true;
            }
            e2 = e2.m_next;
        }
        if (!hasContentLengthHeader) {
            ContentLengthHeaderImpl h = new ContentLengthHeaderImpl();
            h.writeNameToCharBuffer(buffer, headerForm);
            h.writeValueToCharBuffer(buffer, network);
            buffer.append('\r').append('\n');
        }
        buffer.append('\r').append('\n');
    }

    private static boolean headerNamesEqual(String h1, String h2) {
        return HeaderImpl.headerNamesEqual(h1, h2);
    }

    public void copyCriticalHeaders(MessageImpl dest) {
        if (this.m_to != null) {
            dest.setHeader(this.m_to.m_header, true);
        }
        if (this.m_from != null) {
            dest.setHeader(this.m_from.m_header, true);
        }
        if (this.m_callId != null) {
            dest.setHeader(this.m_callId.m_header, true);
        }
        if (this.m_cseq != null) {
            dest.setHeader(this.m_cseq.m_header, true);
        }
        dest.removeViaHeaders();
        if (this.m_topVia != null) {
            HeaderImpl via;
            HeaderEntry e2 = this.m_topVia;
            while (e2 != null && MessageImpl.headerNamesEqual((via = e2.m_header).getName(), "Via")) {
                dest.addHeader(via, false);
                e2 = e2.m_next;
            }
        }
    }

    public boolean isLoopback() {
        return this.m_loopback;
    }

    public void setLoopback(boolean loopback) {
        this.m_loopback = loopback;
    }

    @Override
    public void onEntryDeleted(HeaderEntry headerEntry) {
        this.removeHeader(headerEntry);
    }

    static {
        try {
            TOP_VIA = MessageImpl.class.getField("m_topVia");
            CALL_ID = MessageImpl.class.getField("m_callId");
            CSEQ = MessageImpl.class.getField("m_cseq");
            TO = MessageImpl.class.getField("m_to");
            FROM = MessageImpl.class.getField("m_from");
        }
        catch (SecurityException e2) {
            throw e2;
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException(e3.getMessage());
        }
    }

    static class HeaderEntry
    implements Serializable {
        private static final LogMgr c_logger = Log.get(HeaderEntry.class);
        private HeaderImpl m_header;
        private HeaderEntry m_next;
        private HeaderEntry m_prev;

        private HeaderEntry(HeaderEntry prev, HeaderImpl header, HeaderEntry next) {
            this.m_prev = prev;
            this.m_header = header;
            this.m_next = next;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "HeaderEntry", "m_prev is " + this.m_prev + " m_header is " + this.m_header + " m_next is " + this.m_next);
            }
        }

        HeaderImpl getHeader() {
            return this.m_header;
        }

        HeaderEntry getNext() {
            return this.m_next;
        }

        HeaderEntry getPrev() {
            return this.m_prev;
        }
    }

    public static enum HeaderForm {
        COMPACT,
        DEFAULT,
        LONG;

    }
}

