/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.command;

import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandIdGenerator;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class CommandCacheProcessor
extends CacheProcessor {
    private static TraceComponent tc = Tr.register(CommandCacheProcessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    protected CacheableCommand command;
    private int commandCacheSharingPolicy;

    public String getBaseName() {
        return this.command.getClass().getName();
    }

    public void reset(ConfigEntry ce) {
        super.reset(ce);
        if (ce != null) {
            this.commandCacheSharingPolicy = ce.sharingPolicy;
        }
        this.command = null;
    }

    public void setCacheableCommand(CacheableCommand command) {
        this.command = command;
    }

    protected Object getComponentValue(Component c) {
        Object result = null;
        if (c.idMethod != null) {
            result = this.processMethod(c.idMethod, this.command);
        } else if (c.idField != null) {
            result = this.processField(c.idField, this.command);
        } else if (c.type.equals("method")) {
            c.idMethod = new Method();
            c.idMethod.name = c.id;
            c.idMethod.index = c.index;
            result = this.processMethod(c.idMethod, this.command);
        } else if (c.type.equals("field")) {
            c.idField = new Field();
            c.idField.name = c.id;
            c.idField.index = c.index;
            result = this.processField(c.idField, this.command);
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA0038E", (Object[])new Object[]{c.type, this.command.getClass().getName()});
        }
        if (result != null) {
            if (c.method != null) {
                result = this.processMethod(c.method, result);
            } else if (c.field != null) {
                result = this.processField(c.field, result);
            }
        }
        return result;
    }

    public int getSharingPolicy() {
        return this.commandCacheSharingPolicy;
    }

    protected String processIdGenerator(CacheId cacheid) {
        if (cacheid.idGeneratorImpl == null) {
            try {
                Class<?> c = Class.forName(cacheid.idGenerator, true, SerializationUtility.getContextClassLoader());
                cacheid.idGeneratorImpl = c.newInstance();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CommandCacheProcessor.processIdGenerator", (String)"121", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"dynacache.idgeneratorerror", (Object[])new Object[]{cacheid.idGenerator});
            }
        }
        if (this.groupIds == null) {
            this.groupIds = new ArrayList();
        }
        return ((CommandIdGenerator)cacheid.idGeneratorImpl).getId(this.command, this.groupIds);
    }

    protected void processMetaDataGenerator(CacheId cacheid) {
        Tr.error((TraceComponent)tc, (String)"DYNA0039E", (Object[])new Object[0]);
    }

    protected String[] processInvalidationGenerator(Invalidation invalidation) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Commands do not support custom invalidation generating classes.", (Object[])new Object[0]);
        }
        return null;
    }

    protected Object processMethod(Method m, Object o) {
        Object result;
        block17: {
            block16: {
                if (o == null) {
                    return null;
                }
                try {
                    m.methodImpl = o.getClass().getMethod(m.name, new Class[0]);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheProcessor.processMethod", (String)"275", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)"DYNA0033E", (Object[])new Object[]{m.name, o.getClass().getName(), ex.getMessage()});
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{ex});
                }
            }
            result = null;
            try {
                result = m.methodImpl.invoke(o, emptyArgs);
            }
            catch (RuntimeException rex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{rex});
                }
                try {
                    CacheableCommand cc = (CacheableCommand)o;
                    byte[] b = SerializationUtility.serialize((Serializable)cc);
                    o = SerializationUtility.deserialize((byte[])b, (String)this.configEntry.instanceName);
                    m.methodImpl = o.getClass().getMethod(m.name, new Class[0]);
                    result = m.methodImpl.invoke(o, emptyArgs);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheProcessor.processMethod", (String)"284", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)"DYNA0034E", (Object[])new Object[]{m.name, o.getClass().getName(), ex.getMessage()});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{ex});
                    }
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheProcessor.processMethod", (String)"284", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"DYNA0034E", (Object[])new Object[]{m.name, o.getClass().getName(), ex.getMessage()});
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{ex});
            }
        }
        if (m.method != null) {
            result = this.processMethod(m.method, result);
        } else if (m.field != null) {
            result = this.processField(m.field, result);
        }
        if (m.index > -1) {
            if (result instanceof Collection) {
                result = ((Collection)result).toArray();
            }
            if (result instanceof Object[] && ((Object[])result).length > m.index) {
                result = result[m.index];
            }
        }
        return result;
    }

    protected Object processField(Field f, Object o) {
        Object result;
        block13: {
            block12: {
                if (o == null) {
                    return null;
                }
                if (f.fieldImpl == null) {
                    try {
                        f.fieldImpl = o.getClass().getField(f.name);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheProcessor.processField", (String)"301", (Object)((Object)this));
                        Tr.error((TraceComponent)tc, (String)"DYNA0035E", (Object[])new Object[]{f.name, o.getClass().getName(), ex.getMessage()});
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{ex});
                    }
                }
            }
            result = null;
            try {
                result = f.fieldImpl.get(o);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.CacheProcessor.processField", (String)"310", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"DYNA0036E", (Object[])new Object[]{f.name, o.getClass().getName(), ex.getMessage()});
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{ex});
            }
        }
        if (f.method != null) {
            result = this.processMethod(f.method, result);
        } else if (f.field != null) {
            result = this.processField(f.field, result);
        }
        if (f.index > -1) {
            if (result instanceof Collection) {
                result = ((Collection)result).toArray();
            }
            if (result instanceof Object[] && ((Object[])result).length > f.index) {
                result = result[f.index];
            }
        }
        return result;
    }
}

