/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.TranManagerSet;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    private static final TraceComponent tc = Tr.register(TransactionSynchronizationRegistryImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");

    protected TransactionImpl getTransaction() {
        return ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).getTransactionImpl();
    }

    public Object getTransactionKey() {
        Long key;
        TransactionImpl transaction;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransactionKey", (Object[])new Object[]{this});
        }
        if ((transaction = this.getTransaction()) == null) {
            key = null;
        } else {
            long id = transaction.getLocalId();
            key = new Long(id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransactionKey", (Object)key);
        }
        return key;
    }

    public void putResource(Object key, Object resource) {
        TransactionImpl transaction;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putResource", (Object[])new Object[]{key, resource, this});
        }
        if ((transaction = this.getTransaction()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putResource", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        transaction.putResource(key, resource);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putResource");
        }
    }

    public Object getResource(Object key) {
        TransactionImpl transaction;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResource", (Object[])new Object[]{key, this});
        }
        if ((transaction = this.getTransaction()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResource", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        Object resource = transaction.getResource(key);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResource", (Object)resource);
        }
        return resource;
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object[])new Object[]{sync, this});
        }
        if (sync == null) {
            NullPointerException npe = new NullPointerException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object)npe);
            }
            throw npe;
        }
        TransactionImpl transaction = this.getTransaction();
        if (transaction == null) {
            IllegalStateException ise = new IllegalStateException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object)ise);
            }
            throw ise;
        }
        transaction.registerInterposedSynchronization(sync);
    }

    public int getTransactionStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransactionStatus", (Object[])new Object[]{this});
        }
        int status = ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).getStatus();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransactionStatus", (Object)Util.printStatus(status));
        }
        return status;
    }

    public void setRollbackOnly() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRollbackOnly", (Object[])new Object[]{this});
        }
        ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).setRollbackOnly();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRollbackOnly");
        }
    }

    public boolean getRollbackOnly() {
        TransactionImpl transaction;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRollbackOnly", (Object[])new Object[]{this});
        }
        if ((transaction = this.getTransaction()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRollbackOnly", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        boolean rollbackOnly = transaction.getRollbackOnly();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRollbackOnly", (Object)rollbackOnly);
        }
        return rollbackOnly;
    }
}

