/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer61.srt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer31.srt.SRTInputStream31;
import com.ibm.ws.webcontainer31.srt.SRTServletRequest31;
import io.openliberty.webcontainer61.srt.SRTServletRequest61;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class SRTInputStream61
extends SRTInputStream31 {
    private static final String CLASS_NAME = SRTInputStream61.class.getName();
    private static final TraceComponent tc = Tr.register(SRTInputStream61.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");

    public SRTInputStream61(SRTServletRequest61 request) {
        super((SRTServletRequest31)request);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            Tr.debug((TraceComponent)tc, (String)("constructor, SRTInputStream61 [" + String.valueOf((Object)this) + "] , request [" + String.valueOf((Object)request) + "]"), (Object[])new Object[0]);
        }
    }

    public void init(InputStream in) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            Tr.debug((TraceComponent)tc, (String)("Initializing ... passing through ; underlying stream [" + String.valueOf(in) + "] ; this [" + String.valueOf((Object)this) + "]"), (Object[])new Object[0]);
        }
        super.init(in);
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            Tr.entry((TraceComponent)tc, (String)"read(ByteBuffer)", (Object[])new Object[]{" this [" + String.valueOf((Object)this) + "]"});
        }
        if (buffer == null) {
            Tr.error((TraceComponent)tc, (String)nls.getString("read.write.bytebuffer.null"), (Object[])new Object[0]);
            throw new NullPointerException(nls.getString("read.write.bytebuffer.null"));
        }
        if (!this.isReady()) {
            Tr.error((TraceComponent)tc, (String)nls.getString("read.write.failed.isReady.false"), (Object[])new Object[0]);
            throw new IllegalStateException(nls.getString("read.write.failed.isReady.false"));
        }
        if (buffer.remaining() == 0) {
            return 0;
        }
        byte[] b = new byte[buffer.remaining()];
        int returnByte = this.read(b);
        if (returnByte == -1) {
            return -1;
        }
        int position = buffer.position();
        buffer.put(b, 0, returnByte);
        buffer.position(position);
        buffer.limit(position + returnByte);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            Tr.exit((TraceComponent)tc, (String)("read(ByteBuffer) : [" + returnByte + "]"));
        }
        return returnByte;
    }
}

