/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaBifurcatedConsumerSession;
import com.ibm.ws.sib.ra.impl.SibRaBrowserSession;
import com.ibm.ws.sib.ra.impl.SibRaConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaConsumerSession;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnection;
import com.ibm.ws.sib.ra.impl.SibRaProducerSession;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SICommandInvocationFailedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import com.ibm.wsspi.sib.ra.SibRaAutoCommitTransaction;
import com.ibm.wsspi.sib.ra.SibRaNotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.LazyAssociatableConnectionManager;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.io.Serializable;
import java.util.Map;

final class SibRaConnection
implements SICoreConnection {
    private SibRaManagedConnection _managedConnection;
    private final SibRaConnectionRequestInfo _requestInfo;
    private final SICoreConnection _delegateConnection;
    private boolean _valid = true;
    private SibRaUncoordinatedTransaction _applicationLocalTransaction;
    private SibRaConnectionFactory _connectionFactory;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnection.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();

    SibRaConnection(SibRaManagedConnection managedConnection, SibRaConnectionRequestInfo requestInfo, SICoreConnection coreConnection) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnection", (Object)new Object[]{managedConnection, requestInfo, coreConnection});
        }
        this._managedConnection = managedConnection;
        this._requestInfo = requestInfo;
        this._delegateConnection = coreConnection;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnection");
        }
    }

    public byte[] createUniqueId() throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.createUniqueId();
    }

    public SIDestinationAddress createTemporaryDestination(Distribution distribution, String destinationPrefix) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIInvalidDestinationPrefixException, SIResourceException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.createTemporaryDestination(distribution, destinationPrefix);
    }

    public Serializable invokeCommand(String key, String commandName, Serializable commandData) throws SIConnectionDroppedException, SIConnectionUnavailableException, SINotAuthorizedException, SIResourceException, SIIncorrectCallException, SICommandInvocationFailedException {
        return this._delegateConnection.invokeCommand(key, commandName, commandData);
    }

    public Serializable invokeCommand(String key, String commandName, Serializable commandData, SITransaction tran) throws SIConnectionDroppedException, SIConnectionUnavailableException, SINotAuthorizedException, SIResourceException, SIIncorrectCallException, SICommandInvocationFailedException {
        return this._delegateConnection.invokeCommand(key, commandName, commandData, this.mapTransaction(tran));
    }

    public void close() throws SIConnectionLostException, SIResourceException, SIErrorException, SIConnectionDroppedException, SIConnectionUnavailableException {
        try {
            this._delegateConnection.close();
        }
        finally {
            if (this._managedConnection != null) {
                this._managedConnection.connectionClosed(this);
            }
        }
    }

    public void close(boolean bForceFlag) throws SIConnectionLostException, SIResourceException, SIErrorException, SIConnectionDroppedException, SIConnectionUnavailableException {
        try {
            this._delegateConnection.close(bForceFlag);
        }
        finally {
            if (this._managedConnection != null) {
                this._managedConnection.connectionClosed(this);
            }
        }
    }

    public SIUncoordinatedTransaction createUncoordinatedTransaction() throws SIIncorrectCallException, SIConnectionUnavailableException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createUncoordinatedTransaction");
        }
        this.checkValid();
        if (this._applicationLocalTransaction != null) {
            SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getString("ACTIVE_LOCAL_TRAN_CWSIV0150"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        if (this.getContainerTransaction() != null) {
            SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getString("ACTIVE_CONTAINER_TRAN_CWSIV0151"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        this._applicationLocalTransaction = new SibRaUncoordinatedTransaction(this._delegateConnection.createUncoordinatedTransaction());
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createUncoordinatedTransaction", (Object)this._applicationLocalTransaction);
        }
        return this._applicationLocalTransaction;
    }

    public SIUncoordinatedTransaction createUncoordinatedTransaction(boolean allowSubordinates) throws SIIncorrectCallException, SIConnectionUnavailableException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createUncoordinatedTransaction", (Object)allowSubordinates);
        }
        this.checkValid();
        if (this._applicationLocalTransaction != null) {
            SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getString("ACTIVE_LOCAL_TRAN_CWSIV0150"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        if (this.getContainerTransaction() != null) {
            SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getString("ACTIVE_CONTAINER_TRAN_CWSIV0151"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        this._applicationLocalTransaction = new SibRaUncoordinatedTransaction(this._delegateConnection.createUncoordinatedTransaction(allowSubordinates));
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createUncoordinatedTransaction", (Object)this._applicationLocalTransaction);
        }
        return this._applicationLocalTransaction;
    }

    public SIXAResource getSIXAResource() throws SibRaNotSupportedException {
        throw new SibRaNotSupportedException(NLS.getString("XARESOURCE_NOT_SUPPORTED_CWSIV0152"));
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, DestinationType destType, OrderingContext orderingContext, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        this.checkValid();
        ProducerSession session = this._delegateConnection.createProducerSession(destAddr, destType, orderingContext, alternateUser);
        return new SibRaProducerSession(this, session);
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, String discriminator, DestinationType destType, OrderingContext orderingContext, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIDiscriminatorSyntaxException, SIResourceException, SIErrorException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        this.checkValid();
        ProducerSession session = this._delegateConnection.createProducerSession(destAddr, discriminator, destType, orderingContext, alternateUser);
        return new SibRaProducerSession(this, session);
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, String discriminator, DestinationType destType, OrderingContext extendedMessageOrderingContext, String alternateUser, boolean fixedMessagePoint, boolean preferLocalMessagePoint) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SIIncorrectCallException, SIDiscriminatorSyntaxException {
        this.checkValid();
        ProducerSession session = this._delegateConnection.createProducerSession(destAddr, discriminator, destType, extendedMessageOrderingContext, alternateUser, fixedMessagePoint, preferLocalMessagePoint);
        return new SibRaProducerSession(this, session);
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        ConsumerSession session = this._delegateConnection.createConsumerSession(destAddr, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser);
        return new SibRaConsumerSession(this, session);
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        ConsumerSession session = this._delegateConnection.createConsumerSession(destAddr, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts);
        return new SibRaConsumerSession(this, session);
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean allowMessageGathering, Map<String, String> messageControlProperties) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        ConsumerSession session = this._delegateConnection.createConsumerSession(destAddr, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, messageControlProperties);
        return new SibRaConsumerSession(this, session);
    }

    public void send(SIBusMessage msg, SITransaction tran, SIDestinationAddress destAddr, DestinationType destType, OrderingContext orderingContext, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        this._delegateConnection.send(msg, this.mapTransaction(tran), destAddr, destType, orderingContext, alternateUser);
    }

    public SICoreConnection cloneConnection() throws SibRaNotSupportedException {
        throw new SibRaNotSupportedException(NLS.getString("CLONE_NOT_SUPPORTED_CWSIV0153"));
    }

    public boolean isEquivalentTo(SICoreConnection rhs) {
        boolean equivalent;
        if (rhs instanceof SibRaConnection) {
            SICoreConnection rhsDelegate = ((SibRaConnection)rhs)._delegateConnection;
            equivalent = this._delegateConnection.isEquivalentTo(rhsDelegate);
        } else {
            equivalent = this._delegateConnection.isEquivalentTo(rhs);
        }
        return equivalent;
    }

    public String getMeName() {
        return this._delegateConnection.getMeName();
    }

    public String getMeUuid() {
        return this._delegateConnection.getMeUuid();
    }

    public void addConnectionListener(SICoreConnectionListener listener) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        this.checkValid();
        this._delegateConnection.addConnectionListener(listener);
    }

    public void removeConnectionListener(SICoreConnectionListener listener) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        this._delegateConnection.removeConnectionListener(listener);
    }

    public SICoreConnectionListener[] getConnectionListeners() throws SIConnectionDroppedException, SIConnectionUnavailableException {
        return this._delegateConnection.getConnectionListeners();
    }

    public String getApiLevelDescription() {
        return this._delegateConnection.getApiLevelDescription();
    }

    public long getApiMajorVersion() {
        return this._delegateConnection.getApiMajorVersion();
    }

    public long getApiMinorVersion() {
        return this._delegateConnection.getApiMinorVersion();
    }

    public void sendToExceptionDestination(SIDestinationAddress address, SIBusMessage message, int reason, String[] inserts, SITransaction tran, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        this._delegateConnection.sendToExceptionDestination(address, message, reason, inserts, this.mapTransaction(tran), alternateUser);
    }

    public DestinationConfiguration getDestinationConfiguration(SIDestinationAddress destinationAddress) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        return this._delegateConnection.getDestinationConfiguration(destinationAddress);
    }

    public void deleteTemporaryDestination(SIDestinationAddress destinationAddress) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIDestinationLockedException, SIIncorrectCallException {
        this.checkValid();
        this._delegateConnection.deleteTemporaryDestination(destinationAddress);
    }

    public void createDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDurableSubscriptionAlreadyExistsException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        this._delegateConnection.createDurableSubscription(subscriptionName, durableSubscriptionHome, destinationAddress, criteria, supportsMultipleConsumers, nolocal, alternateUser);
    }

    public ConsumerSession createConsumerSessionForDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destinationAddress, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, Reliability reliability, boolean enableReadAhead, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException, SIResourceException, SIErrorException, SIIncorrectCallException {
        this.checkValid();
        ConsumerSession consumerSession = this._delegateConnection.createConsumerSessionForDurableSubscription(subscriptionName, durableSubscriptionHome, destinationAddress, criteria, supportsMultipleConsumers, nolocal, reliability, enableReadAhead, unrecoverableReliability, bifurcatable, alternateUser);
        return new SibRaConsumerSession(this, consumerSession);
    }

    public void deleteDurableSubscription(String subscriptionName, String durableSubscriptionHome) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SINotAuthorizedException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SIResourceException, SIErrorException, SIIncorrectCallException {
        this.checkValid();
        this._delegateConnection.deleteDurableSubscription(subscriptionName, durableSubscriptionHome);
    }

    public SIBusMessage receiveNoWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destinationAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        return this._delegateConnection.receiveNoWait(this.mapTransaction(tran), unrecoverableReliability, destinationAddress, destType, criteria, reliability, alternateUser);
    }

    public SIBusMessage receiveWithWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destinationAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, long timeout, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        return this._delegateConnection.receiveWithWait(this.mapTransaction(tran), unrecoverableReliability, destinationAddress, destType, criteria, reliability, timeout, alternateUser);
    }

    public BrowserSession createBrowserSession(SIDestinationAddress destinationAddress, DestinationType destType, SelectionCriteria criteria, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        BrowserSession session = this._delegateConnection.createBrowserSession(destinationAddress, destType, criteria, alternateUser);
        return new SibRaBrowserSession(this, session);
    }

    public BrowserSession createBrowserSession(SIDestinationAddress destinationAddress, DestinationType destType, SelectionCriteria criteria, String alternateUser, boolean allowMessageGathering) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        this.checkValid();
        BrowserSession session = this._delegateConnection.createBrowserSession(destinationAddress, destType, criteria, alternateUser, allowMessageGathering);
        return new SibRaBrowserSession(this, session);
    }

    public OrderingContext createOrderingContext() throws SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.createOrderingContext();
    }

    public String getResolvedUserid() throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        this.checkValid();
        return this._delegateConnection.getResolvedUserid();
    }

    public SIDestinationAddress checkMessagingRequired(SIDestinationAddress requestDestAddr, SIDestinationAddress replyDestAddr, DestinationType destinationType, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"checkMessagingRequired");
        }
        SIDestinationAddress retVal = this._delegateConnection.checkMessagingRequired(requestDestAddr, replyDestAddr, destinationType, alternateUser);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"checkMessagingRequired", (Object)retVal);
        }
        return retVal;
    }

    public BifurcatedConsumerSession createBifurcatedConsumerSession(long id) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIResourceException, SIErrorException, SIIncorrectCallException {
        this.checkValid();
        BifurcatedConsumerSession session = this._delegateConnection.createBifurcatedConsumerSession(id);
        return new SibRaBifurcatedConsumerSession(this, session);
    }

    public String toString() {
        StringBuffer buffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(buffer, "managedConnection", this._managedConnection);
        SibRaUtils.addFieldToString(buffer, "requestInfo", this._requestInfo);
        SibRaUtils.addFieldToString(buffer, "delegateConnection", this._delegateConnection);
        SibRaUtils.addFieldToString(buffer, "valid", this._valid);
        SibRaUtils.addFieldToString(buffer, "applicationLocalTransaction", this._applicationLocalTransaction);
        SibRaUtils.addFieldToString(buffer, "connectionFactory", this._connectionFactory);
        SibRaUtils.endToString(buffer);
        return buffer.toString();
    }

    SibRaManagedConnection getManagedConnection() {
        return this._managedConnection;
    }

    void setManagedConnection(SibRaManagedConnection managedConnection) {
        this._managedConnection = managedConnection;
    }

    private SibRaManagedConnection getAssociatedManagedConnection() throws SIResourceException {
        block5: {
            try {
                if (this._managedConnection != null) break block5;
                ConnectionManager connectionManager = this._connectionFactory.getConnectionManager();
                if (connectionManager instanceof LazyAssociatableConnectionManager) {
                    ((LazyAssociatableConnectionManager)connectionManager).associateConnection((Object)this, (ManagedConnectionFactory)this._connectionFactory.getManagedConnectionFactory(), (ConnectionRequestInfo)this._requestInfo);
                    break block5;
                }
                ResourceAdapterInternalException exception = new ResourceAdapterInternalException(NLS.getFormattedMessage("LAZY_ENLIST_NOT_SUPPORTED_CWSIV0154", new Object[]{connectionManager}, null));
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw exception;
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaConnection.getAssociatedManagedConnection", (String)"1:1843:1.41", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new SIResourceException(NLS.getFormattedMessage("REASSOCIATION_FAILED_CWSIV0155", new Object[]{exception}, null), (Throwable)exception);
            }
        }
        return this._managedConnection;
    }

    void invalidate() {
        block4: {
            try {
                this._delegateConnection.close();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaConnection.invalidate", (String)"1:1875:1.41", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaConnection.invalidate", (String)"1:1884:1.41", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) break block4;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
        }
        this._valid = false;
    }

    boolean isValid() {
        return this._valid;
    }

    private void checkValid() throws SIConnectionUnavailableException {
        if (!this._valid) {
            throw new SIConnectionUnavailableException(NLS.getString("INVALID_CONNECTION_CWSIV0156"));
        }
    }

    private SITransaction getContainerTransaction() throws SIResourceException {
        SITransaction containerTransaction;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction");
        }
        try {
            SibRaManagedConnection managedConnection = this.getAssociatedManagedConnection();
            containerTransaction = managedConnection.getContainerTransaction(this._connectionFactory.getConnectionManager());
        }
        catch (ResourceException exception) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new SIResourceException(NLS.getFormattedMessage("CONTAINER_TRAN_CWSIV0157", new Object[]{exception}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction", (Object)containerTransaction);
        }
        return containerTransaction;
    }

    SITransaction mapTransaction(SITransaction transactionParameter) throws SIIncorrectCallException, SIResourceException {
        SITransaction transaction;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"mapTransaction", (Object)transactionParameter);
        }
        if (transactionParameter == null) {
            if (this._applicationLocalTransaction != null) {
                SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getString("ACTIVE_LOCAL_TRAN_CWSIV0158"));
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw exception;
            }
            transaction = this.getContainerTransaction();
        } else if (transactionParameter instanceof SIUncoordinatedTransaction) {
            if (transactionParameter != this._applicationLocalTransaction) {
                SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getString("INCORRECT_LOCAL_TRAN_CWSIV0159"));
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw exception;
            }
            transaction = this._applicationLocalTransaction.getUncoordinatedTransaction();
        } else {
            if (transactionParameter instanceof SIXAResource) {
                SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getString("INVALID_XARESOURCE_CWSIV0160"));
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw exception;
            }
            if (transactionParameter instanceof SibRaAutoCommitTransaction) {
                transaction = null;
            } else {
                SIIncorrectCallException exception = new SIIncorrectCallException(NLS.getFormattedMessage("UNRECOGNISED_TRAN_CWSIV0161", new Object[]{transactionParameter}, null));
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"mapTransaction", (Object)transaction);
        }
        return transaction;
    }

    void setConnectionFactory(SibRaConnectionFactory connectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setConnectionFactory", (Object)connectionFactory);
        }
        this._connectionFactory = connectionFactory;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setConnectionFactory");
        }
    }

    void commitApplicationLocalTransaction() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"commitApplicationLocalTransaction");
        }
        if (this._applicationLocalTransaction != null) {
            SIUncoordinatedTransaction uncoordinatedTransaction = this._applicationLocalTransaction.getUncoordinatedTransaction();
            try {
                uncoordinatedTransaction.commit();
            }
            catch (SIException exception) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_COMMIT_FAILED_CWSIV0162", new Object[]{exception}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_COMMIT_FAILED_CWSIV0162", new Object[]{exception}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"commitApplicationLocalTransaction");
        }
    }

    void rollbackApplicationLocalTransaction() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollbackApplicationLocalTransaction");
        }
        if (this._applicationLocalTransaction != null) {
            SIUncoordinatedTransaction uncoordinatedTransaction = this._applicationLocalTransaction.getUncoordinatedTransaction();
            try {
                uncoordinatedTransaction.rollback();
            }
            catch (SIException exception) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_ROLLBACK_FAILED_CWSIV0163", new Object[]{exception}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONTAINER_ROLLBACK_FAILED_CWSIV0163", new Object[]{exception}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollbackApplicationLocalTransaction");
        }
    }

    public boolean isCoreConnectionInValid() {
        return this._delegateConnection == null;
    }

    public SIDestinationAddress[] addDestinationListener(String destinationNamePattern, DestinationListener destinationListener, DestinationType destinationType, DestinationAvailability destinationAvailability) throws SIIncorrectCallException, SICommandInvocationFailedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIConnectionLostException {
        return this._delegateConnection.addDestinationListener(destinationNamePattern, destinationListener, destinationType, destinationAvailability);
    }

    public boolean registerConsumerSetMonitor(SIDestinationAddress destinationAddress, String discriminatorExpression, ConsumerSetChangeCallback callback) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIConnectionUnavailableException, SIConnectionDroppedException, SIIncorrectCallException, SICommandInvocationFailedException {
        return this._delegateConnection.registerConsumerSetMonitor(destinationAddress, discriminatorExpression, callback);
    }

    public ConsumerSession createSharedConsumerSession(String subscriptionName, SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean supportsMultipleConsumers, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean allowMessageGathering, Map<String, String> messageControlProperties) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        return this._delegateConnection.createSharedConsumerSession(subscriptionName, destAddr, destType, criteria, reliability, enableReadAhead, supportsMultipleConsumers, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, messageControlProperties);
    }

    private final class SibRaUncoordinatedTransaction
    implements SIUncoordinatedTransaction {
        private final SIUncoordinatedTransaction _delegateUncoordinatedTransaction;

        private SibRaUncoordinatedTransaction(SIUncoordinatedTransaction delegate) throws SIResourceException {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaUncoordinatedTransaction", (Object)delegate);
            }
            this._delegateUncoordinatedTransaction = delegate;
            SibRaConnection.this.getAssociatedManagedConnection().localTransactionStarted(SibRaConnection.this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaUncoordinatedTransaction");
            }
        }

        private SIUncoordinatedTransaction getUncoordinatedTransaction() {
            return this._delegateUncoordinatedTransaction;
        }

        public void commit() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"commit");
            }
            this._delegateUncoordinatedTransaction.commit();
            SibRaConnection.this._applicationLocalTransaction = null;
            SibRaConnection.this.getAssociatedManagedConnection().localTransactionCommitted(SibRaConnection.this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"commit");
            }
        }

        public void rollback() throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"rollback");
            }
            this._delegateUncoordinatedTransaction.rollback();
            SibRaConnection.this._applicationLocalTransaction = null;
            SibRaConnection.this.getAssociatedManagedConnection().localTransactionRolledBack(SibRaConnection.this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"rollback");
            }
        }
    }
}

