/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.HeaderUtil;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxws.handler.AbstractProtocolHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.MessageObserver;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class SOAPHandlerInterceptor
extends AbstractProtocolHandlerInterceptor<SoapMessage>
implements SoapInterceptor {
    private static final SAAJOutInterceptor SAAJ_OUT = new SAAJOutInterceptor();
    private static final Logger LOG = LogUtils.getLogger(SOAPHandlerInterceptor.class);
    AbstractSoapInterceptor ending;
    static final long serialVersionUID = 3322351078986513298L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SOAPHandlerInterceptor(Binding binding) {
        super(binding, "pre-protocol-frontend");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "<init>", new Object[]{binding});
        }
        this.ending = new AbstractSoapInterceptor(SOAPHandlerInterceptor.class.getName() + ".ENDING", "user-protocol"){
            static final long serialVersionUID = 7854339064839231997L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void handleMessage(@Sensitive SoapMessage message) throws Fault {
                SOAPHandlerInterceptor.this.handleMessageInternal(message);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor$1", 1.class, null, null);
            }
        };
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<URI> getRoles() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getRoles", new Object[0]);
        }
        HashSet<URI> hashSet = new HashSet<URI>();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getRoles", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<QName> getUnderstoodHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getUnderstoodHeaders", new Object[0]);
        }
        HashSet<QName> understood = new HashSet<QName>();
        for (Handler h : this.getBinding().getHandlerChain()) {
            Set headers;
            if (!(h instanceof SOAPHandler) || (headers = CastUtils.cast((Set)((SOAPHandler)h).getHeaders())) == null) continue;
            understood.addAll(headers);
        }
        HashSet<QName> hashSet = understood;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getUnderstoodHeaders", hashSet);
        }
        return hashSet;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleMessage", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (this.binding.getHandlerChain().isEmpty()) {
            if (isFinestEnabled) {
                LOG.finest("Handler chain is empty. handleMessage won't be executed.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleMessage");
            }
            return;
        }
        if (this.getInvoker(message).getProtocolHandlers().isEmpty()) {
            if (isFinestEnabled) {
                LOG.finest("Message does not contain any protocol handlers. handleMessage won't be executed.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleMessage");
            }
            return;
        }
        this.checkUnderstoodHeaders(message);
        if (this.getInvoker(message).isOutbound()) {
            if (!SOAPHandlerInterceptor.chainAlreadyContainsSAAJ(message)) {
                SAAJ_OUT.handleMessage(message);
            }
            message.getInterceptorChain().add((Interceptor)this.ending);
        } else {
            boolean isFault = this.handleMessageInternal(message);
            SOAPMessage msg = (SOAPMessage)message.getContent(SOAPMessage.class);
            if (msg != null) {
                XMLStreamReader xmlReader = this.createXMLStreamReaderFromSOAPMessage(msg);
                message.setContent(XMLStreamReader.class, (Object)xmlReader);
                try {
                    SAAJInInterceptor.replaceHeaders((SOAPMessage)msg, (SoapMessage)message);
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                }
            }
            if (isFault) {
                Endpoint ep = message.getExchange().getEndpoint();
                message.getInterceptorChain().abort();
                if (ep.getInFaultObserver() != null) {
                    ep.getInFaultObserver().onMessage((Message)message);
                } else if (isFinestEnabled) {
                    LOG.finest("MessageObserver(ep.getInFaultObserver())  is null. onMessage method of MessageObserver won't get executed.");
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkUnderstoodHeaders(SoapMessage soapMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "checkUnderstoodHeaders", new Object[]{soapMessage});
        }
        Set paramHeaders = HeaderUtil.getHeaderQNameInOperationParam((SoapMessage)soapMessage);
        if (soapMessage.getHeaders().isEmpty() && paramHeaders.isEmpty()) {
            this.getUnderstoodHeaders();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "checkUnderstoodHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean handleMessageInternal(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleMessageInternal", new Object[]{message});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        MessageContext context = this.createProtocolMessageContext(message);
        if (context == null) {
            if (isFinestEnabled) {
                LOG.finest("MessageContext is null. handleMessageInternal won't be executed.");
            }
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleMessageInternal", bl);
            }
            return bl;
        }
        HandlerChainInvoker invoker = this.getInvoker(message);
        invoker.setProtocolMessageContext(context);
        if (!invoker.invokeProtocolHandlers(this.isRequestor((Message)message), context)) {
            if (isFinestEnabled) {
                LOG.finest("There is a problem invoking protocol handlers. handleAbort method will be executed.");
            }
            this.handleAbort(message, context);
        }
        if (isFinestEnabled) {
            LOG.finest("Is it an outbound message(isOutbound): " + this.isOutbound(message));
            LOG.finest("Is it MEP complete(isMEPComlete): " + this.isMEPComlete(message));
        }
        if (this.isRequestor((Message)message) && invoker.getLogicalHandlers().isEmpty() && !this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        } else if (this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleMessageInternal", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleAbort(SoapMessage message, MessageContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleAbort", new Object[]{message, context});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (this.isRequestor((Message)message)) {
            if (this.getInvoker(message).isOutbound()) {
                message.getInterceptorChain().abort();
                MessageObserver observer = (MessageObserver)message.getExchange().get(MessageObserver.class);
                if (isFinestEnabled) {
                    LOG.finest("MessageObserver(observer): " + observer);
                }
                if (!message.getExchange().isOneWay() && observer != null) {
                    Endpoint e = message.getExchange().getEndpoint();
                    MessageImpl responseMsg = new MessageImpl();
                    responseMsg.setExchange(message.getExchange());
                    responseMsg = e.getBinding().createMessage((Message)responseMsg);
                    message.getExchange().setInMessage((Message)responseMsg);
                    SOAPMessage soapMessage = ((SOAPMessageContext)context).getMessage();
                    if (soapMessage != null) {
                        responseMsg.setContent(SOAPMessage.class, (Object)soapMessage);
                        XMLStreamReader xmlReader = this.createXMLStreamReaderFromSOAPMessage(soapMessage);
                        responseMsg.setContent(XMLStreamReader.class, (Object)xmlReader);
                    }
                    responseMsg.put((Object)"starting_at_interceptor_id", (Object)SOAPHandlerInterceptor.class.getName());
                    if (isFinestEnabled) {
                        LOG.finest("New response message is created and will be passed as parameter to onMessage method of MessageObserver: " + responseMsg);
                    }
                    observer.onMessage((Message)responseMsg);
                }
            } else {
                if (isFinestEnabled) {
                    LOG.finest("Client side inbound onCompletion will be executed");
                }
                this.onCompletion(message);
            }
        } else if (!this.getInvoker(message).isOutbound()) {
            if (isFinestEnabled) {
                LOG.finest("Server side inbound interceptor chain will be aborted.");
            }
            message.getInterceptorChain().abort();
            Endpoint e = message.getExchange().getEndpoint();
            if (!message.getExchange().isOneWay()) {
                MessageImpl responseMsg = new MessageImpl();
                responseMsg.setExchange(message.getExchange());
                responseMsg = e.getBinding().createMessage((Message)responseMsg);
                message.getExchange().setOutMessage((Message)responseMsg);
                SOAPMessage soapMessage = ((SOAPMessageContext)context).getMessage();
                responseMsg.setContent(SOAPMessage.class, (Object)soapMessage);
                InterceptorChain chain = OutgoingChainInterceptor.getOutInterceptorChain((Exchange)message.getExchange());
                responseMsg.setInterceptorChain(chain);
                if (isFinestEnabled) {
                    LOG.finest("New response message is created and will be passed as parameter to doInterceptStartingAfter method of InterceptorChain: " + responseMsg);
                }
                chain.doInterceptStartingAfter((Message)responseMsg, SoapPreProtocolOutInterceptor.class.getName());
            }
        } else if (isFinestEnabled) {
            LOG.finest("Server side outbound. Do nothing.");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleAbort");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected MessageContext createProtocolMessageContext(SoapMessage message) {
        SOAPMessageContextImpl sm;
        block9: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "createProtocolMessageContext", new Object[]{message});
            }
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            sm = new SOAPMessageContextImpl((Message)message);
            Exchange exch = message.getExchange();
            this.setupBindingOperationInfo(exch, sm);
            SOAPMessage msg = sm.getMessage();
            if (msg != null) {
                MessageContext messageContext;
                block10: {
                    try {
                        ArrayList<SOAPElement> params = new ArrayList<SOAPElement>();
                        message.put((Object)"jakarta.xml.ws.reference.parameters", params);
                        SOAPHeader head = SAAJUtils.getHeader((SOAPMessage)msg);
                        if (head != null) {
                            Iterator it = CastUtils.cast((Iterator)head.getChildElements());
                            while (it != null && it.hasNext()) {
                                SOAPElement el;
                                Node nd = (Node)it.next();
                                if (!(nd instanceof SOAPElement) || !(el = (SOAPElement)nd).hasAttributeNS("http://www.w3.org/2005/08/addressing", "IsReferenceParameter") || !"1".equals(el.getAttributeNS("http://www.w3.org/2005/08/addressing", "IsReferenceParameter")) && !Boolean.parseBoolean(el.getAttributeNS("http://www.w3.org/2005/08/addressing", "IsReferenceParameter"))) continue;
                                params.add(el);
                            }
                        }
                        if (isFinestEnabled) {
                            LOG.finest("Reference parameters obtained from SOAP header: " + params);
                        }
                        if (!this.isRequestor((Message)message) || msg.getSOAPPart().getEnvelope().getBody() == null || !msg.getSOAPPart().getEnvelope().getBody().hasFault()) break block9;
                        if (isFinestEnabled) {
                            LOG.finest("Message body has fault on client side. Protocol message context won't be returned.");
                        }
                        messageContext = null;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block10;
                    }
                    catch (SOAPException e) {
                        throw new Fault((Throwable)e);
                    }
                    messageContext = messageContext;
                    LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "createProtocolMessageContext", messageContext);
                }
                return messageContext;
            }
        }
        SOAPMessageContextImpl sOAPMessageContextImpl = sm;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sOAPMessageContextImpl = sOAPMessageContextImpl;
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "createProtocolMessageContext", sOAPMessageContextImpl);
        }
        return sOAPMessageContextImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private XMLStreamReader createXMLStreamReaderFromSOAPMessage(SOAPMessage soapMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "createXMLStreamReaderFromSOAPMessage", new Object[]{soapMessage});
        }
        XMLStreamReader xmlReader = null;
        try {
            DOMSource bodySource = new DOMSource((org.w3c.dom.Node)soapMessage.getSOAPPart().getEnvelope().getBody());
            xmlReader = StaxUtils.createXMLStreamReader((Source)bodySource);
            xmlReader.nextTag();
            xmlReader.nextTag();
        }
        catch (SOAPException | XMLStreamException e) {
            e.printStackTrace();
        }
        XMLStreamReader xMLStreamReader = xmlReader;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "createXMLStreamReaderFromSOAPMessage", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleFault(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleFault", new Object[]{message});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (this.binding.getHandlerChain().isEmpty()) {
            if (isFinestEnabled) {
                LOG.finest("Handler chain is empty. handleFault won't be executed.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleFault");
            }
            return;
        }
        if (this.getInvoker(message).getProtocolHandlers().isEmpty()) {
            if (isFinestEnabled) {
                LOG.finest("Protocol handler list is empty. handleFault won't be executed.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleFault");
            }
            return;
        }
        if (this.getInvoker(message).isOutbound() && !SOAPHandlerInterceptor.chainAlreadyContainsSAAJ(message)) {
            SAAJ_OUT.handleFault(message);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "handleFault");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected QName getOpQName(Exchange ex, Object data) {
        block13: {
            QName qName;
            block14: {
                block11: {
                    QName qName2;
                    block12: {
                        SOAPMessage msg;
                        boolean isFinestEnabled;
                        block9: {
                            QName qName3;
                            block10: {
                                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                    LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getOpQName", new Object[]{ex, data});
                                }
                                isFinestEnabled = LOG.isLoggable(Level.FINEST);
                                SOAPMessageContextImpl sm = (SOAPMessageContextImpl)data;
                                msg = sm.getMessage();
                                if (msg != null) break block9;
                                if (isFinestEnabled) {
                                    LOG.finest("SOAP message is null. OpQname will not be returned.");
                                }
                                qName3 = null;
                                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block10;
                                qName3 = qName3;
                                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getOpQName", qName3);
                            }
                            return qName3;
                        }
                        SOAPBody body = SAAJUtils.getBody((SOAPMessage)msg);
                        if (body != null) break block11;
                        if (isFinestEnabled) {
                            LOG.finest("SOAP body is null. OpQname will not be returned.");
                        }
                        qName2 = null;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block12;
                        qName2 = qName2;
                        LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getOpQName", qName2);
                    }
                    return qName2;
                }
                try {
                    org.w3c.dom.Node nd;
                    for (nd = body.getFirstChild(); nd != null && !(nd instanceof Element); nd = nd.getNextSibling()) {
                    }
                    if (nd == null) break block13;
                    qName = new QName(nd.getNamespaceURI(), nd.getLocalName());
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block14;
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
                qName = qName;
                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getOpQName", qName);
            }
            return qName;
        }
        QName qName = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "getOpQName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean chainAlreadyContainsSAAJ(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "chainAlreadyContainsSAAJ", new Object[]{message});
        }
        ListIterator listIterator = message.getInterceptorChain().getIterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof SAAJOutInterceptor)) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "chainAlreadyContainsSAAJ", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor", "chainAlreadyContainsSAAJ", bl);
        }
        return bl;
    }
}

