/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSRepeated;
import com.ibm.ws.sib.mfp.jmf.impl.JSTuple;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HashedArray;

public final class CompatibilityMap
implements HashedArray.Element {
    private static TraceComponent tc = JmfTr.register(CompatibilityMap.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    public long accessSchemaId;
    public int[] indices;
    public int varBias;
    public int[][] setCases;
    public int[][] getCases;
    private byte[] encodedForm;

    public CompatibilityMap(byte[] frame, int offset, int length) {
        int j;
        int[] cases;
        int len;
        int i;
        this.encodedForm = new byte[length];
        System.arraycopy(frame, offset, this.encodedForm, 0, length);
        this.accessSchemaId = ArrayUtil.readLong(frame, offset);
        int[] limits = new int[]{offset + 8, offset + length};
        this.indices = new int[JSType.getCount(frame, limits)];
        for (i = 0; i < this.indices.length; ++i) {
            this.indices[i] = JSType.getCount(frame, limits);
        }
        this.varBias = JSType.getCount(frame, limits);
        this.setCases = new int[JSType.getCount(frame, limits)][];
        for (i = 0; i < this.setCases.length; ++i) {
            len = JSType.getCount(frame, limits);
            if (len == -1) continue;
            cases = new int[len];
            for (j = 0; j < len; ++j) {
                cases[j] = JSType.getCount(frame, limits);
            }
            this.setCases[i] = cases;
        }
        this.getCases = new int[JSType.getCount(frame, limits)][];
        for (i = 0; i < this.getCases.length; ++i) {
            len = JSType.getCount(frame, limits);
            if (len == -1) continue;
            cases = new int[len];
            for (j = 0; j < len; ++j) {
                cases[j] = JSType.getCount(frame, limits);
            }
            this.getCases[i] = cases;
        }
    }

    public byte[] toEncodedForm() {
        if (this.encodedForm == null) {
            this.encodedForm = new byte[this.encodedSize()];
            ArrayUtil.writeLong(this.encodedForm, 0, this.accessSchemaId);
            this.encode(this.encodedForm, new int[]{8, this.encodedForm.length});
        }
        return this.encodedForm;
    }

    private void encode(byte[] frame, int[] limits) {
        int j;
        int[] cases;
        int i;
        JSType.setCount(frame, limits, this.indices.length);
        for (i = 0; i < this.indices.length; ++i) {
            JSType.setCount(frame, limits, this.indices[i]);
        }
        JSType.setCount(frame, limits, this.varBias);
        JSType.setCount(frame, limits, this.setCases.length);
        for (i = 0; i < this.setCases.length; ++i) {
            cases = this.setCases[i];
            if (cases == null) {
                JSType.setCount(frame, limits, -1);
                continue;
            }
            JSType.setCount(frame, limits, cases.length);
            for (j = 0; j < cases.length; ++j) {
                JSType.setCount(frame, limits, cases[j]);
            }
        }
        JSType.setCount(frame, limits, this.getCases.length);
        for (i = 0; i < this.getCases.length; ++i) {
            cases = this.getCases[i];
            if (cases == null) {
                JSType.setCount(frame, limits, -1);
                continue;
            }
            JSType.setCount(frame, limits, cases.length);
            for (j = 0; j < cases.length; ++j) {
                JSType.setCount(frame, limits, cases[j]);
            }
        }
    }

    private int encodedSize() {
        int[] cases;
        int i;
        int ans = 16 + 2 * this.indices.length;
        for (i = 0; i < this.setCases.length; ++i) {
            cases = this.setCases[i];
            ans += 2;
            if (cases == null) continue;
            ans += 2 * cases.length;
        }
        for (i = 0; i < this.getCases.length; ++i) {
            cases = this.getCases[i];
            ans += 2;
            if (cases == null) continue;
            ans += 2 * cases.length;
        }
        return ans;
    }

    public CompatibilityMap(JSchema access, JSchema encoding) throws JMFSchemaViolationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "access Schema:   " + access.getJMFType());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(this, tc, "encoding Schema: " + encoding.getJMFType());
        }
        this.accessSchemaId = access.getID();
        this.indices = new int[access.getFields().length + access.getVariants().length];
        this.varBias = encoding.getFields().length;
        this.setCases = new int[encoding.getVariants().length][];
        this.getCases = new int[this.setCases.length][];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = -1;
        }
        this.recordCompatibilityInfo(access.getJMFType(), access, encoding.getJMFType(), encoding);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    private static void violation(JMFType from, JMFType to) throws JMFSchemaViolationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JmfTr.debug(tc, "Violation:  from = " + from.getFeatureName() + " : " + from + ", to = " + to.getFeatureName() + " : " + to);
        }
        throw new JMFSchemaViolationException(from.getFeatureName() + " not compatible with " + to.getFeatureName());
    }

    private void recordCompatibilityInfo(JMFType access, JSchema accSchema, JMFType encoding, JSchema encSchema) throws JMFSchemaViolationException {
        if (access instanceof JSPrimitive) {
            if (encoding instanceof JSPrimitive) {
                this.recordCompatibilityInfo((JSPrimitive)access, accSchema, (JSPrimitive)encoding, encSchema);
            } else if (encoding instanceof JSVariant) {
                this.checkForDeletingVariant(access, (JSVariant)encoding, false, accSchema, encSchema);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    JmfTr.debug(this, tc, "Compatibility violation (type mismatch) for JSPrimitive");
                }
                CompatibilityMap.violation(access, encoding);
            }
        } else if (access instanceof JSEnum) {
            if (encoding instanceof JSEnum) {
                this.recordCompatibilityInfo((JSEnum)access, accSchema, (JSEnum)encoding, encSchema);
            } else if (encoding instanceof JSVariant) {
                this.checkForDeletingVariant(access, (JSVariant)encoding, false, accSchema, encSchema);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    JmfTr.debug(this, tc, "Compatibility violation (type mismatch) for JSEnum");
                }
                CompatibilityMap.violation(access, encoding);
            }
        } else if (access instanceof JSDynamic) {
            if (encoding instanceof JSDynamic) {
                this.recordOnePair((JSField)access, accSchema, (JSField)encoding, encSchema);
            } else if (encoding instanceof JSVariant) {
                this.checkForDeletingVariant(access, (JSVariant)encoding, false, accSchema, encSchema);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    JmfTr.debug(this, tc, "Compatibility violation (type mismatch) for JSDynamic");
                }
                CompatibilityMap.violation(access, encoding);
            }
        } else if (access instanceof JSRepeated) {
            if (encoding instanceof JSRepeated) {
                this.recordCompatibilityInfo(((JSRepeated)access).getItemType(), accSchema, ((JSRepeated)encoding).getItemType(), encSchema);
            } else if (encoding instanceof JSVariant) {
                this.checkForDeletingVariant(access, (JSVariant)encoding, false, accSchema, encSchema);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    JmfTr.debug(this, tc, "Compatibility violation (type mismatch) for JSRepeated");
                }
                CompatibilityMap.violation(access, encoding);
            }
        } else if (access instanceof JSTuple) {
            if (encoding instanceof JSTuple) {
                this.recordCompatibilityInfo((JSTuple)access, accSchema, (JSTuple)encoding, encSchema);
            } else if (encoding instanceof JSVariant) {
                this.checkForDeletingVariant(access, (JSVariant)encoding, false, accSchema, encSchema);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    JmfTr.debug(this, tc, "Compatibility violation (type mismatch) for JSTuple");
                }
                CompatibilityMap.violation(access, encoding);
            }
        } else if (access instanceof JSVariant) {
            JSVariant accVar = (JSVariant)access;
            if (encoding instanceof JSVariant) {
                JSVariant encVar = (JSVariant)encoding;
                this.recordCompatibilityInfo(accVar, accSchema, encVar, encSchema);
            } else {
                this.checkForDeletingVariant(encoding, accVar, true, accSchema, encSchema);
            }
        }
    }

    private void recordCompatibilityInfo(JSPrimitive access, JSchema accSchema, JSPrimitive encoding, JSchema encSchema) throws JMFSchemaViolationException {
        if (access.getTypeCode() == encoding.getTypeCode()) {
            this.recordOnePair(access, accSchema, encoding, encSchema);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                JmfTr.debug(this, tc, "Compatibility violation (primitive type mismatch): access " + access + ", access TypeCode " + access.getTypeCode() + ", encoding " + encoding + ", encoding TypeCode " + encoding.getTypeCode());
            }
            CompatibilityMap.violation(access, encoding);
        }
    }

    private void recordCompatibilityInfo(JSEnum access, JSchema accSchema, JSEnum encoding, JSchema encSchema) throws JMFSchemaViolationException {
        if (access.getEnumeratorCount() == encoding.getEnumeratorCount()) {
            this.recordOnePair(access, accSchema, encoding, encSchema);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                JmfTr.debug(this, tc, "Compatibility violation (enumeration type mismatch): access " + access + ", access EnumeratorCount " + access.getEnumeratorCount() + ", encoding " + encoding + ", encoding EnumeratorCount " + encoding.getEnumeratorCount());
            }
            CompatibilityMap.violation(access, encoding);
        }
    }

    private void recordOnePair(JSField access, JSchema accSchema, JSField encoding, JSchema encSchema) {
        int acc = access.getAccessor(accSchema);
        if (acc >= this.indices.length) {
            return;
        }
        this.indices[acc] = encoding.getAccessor(encSchema);
    }

    private boolean isEmpty(JMFType toTest) {
        return toTest instanceof JSTuple && ((JSTuple)toTest).getFieldCount() == 0;
    }

    private void checkForDeletingVariant(JMFType nonVar, JSVariant var, boolean varIsAccess, JSchema accSchema, JSchema encSchema) throws JMFSchemaViolationException {
        if (var.getCaseCount() != 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                JmfTr.debug(this, tc, "Compatibility violation (deleting variant): var CaseCount = " + var.getCaseCount() + ", varIsAccess " + varIsAccess);
            }
            if (varIsAccess) {
                CompatibilityMap.violation(var, nonVar);
            } else {
                CompatibilityMap.violation(nonVar, var);
            }
        }
        if (this.isEmpty(var.getCase(1))) {
            JMFType compare = var.getCase(0);
            if (varIsAccess) {
                this.recordCompatibilityInfo(compare, accSchema, nonVar, encSchema);
            } else {
                this.recordCompatibilityInfo(nonVar, accSchema, compare, encSchema);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                JmfTr.debug(this, tc, "Compatibility violation (deleting variant): var Case(1) not empty");
            }
            if (varIsAccess) {
                CompatibilityMap.violation(var, nonVar);
            } else {
                CompatibilityMap.violation(nonVar, var);
            }
        }
    }

    private void recordCompatibilityInfo(JSVariant access, JSchema accSchema, JSVariant encoding, JSchema encSchema) throws JMFSchemaViolationException {
        int encodingCount;
        int accessCount;
        int accBox = access.getBoxAccessor(accSchema);
        int encBox = encoding.getBoxAccessor(encSchema);
        if (accBox != -1 && encBox != -1) {
            if (accBox < this.indices.length) {
                this.indices[accBox] = encBox;
            }
        } else if (accBox != -1 || encBox != -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                JmfTr.debug(this, tc, "Compatibility violation (variants): box mismatch " + accBox + " != " + encBox);
            }
            CompatibilityMap.violation(access, encoding);
        } else {
            this.recordOnePair(access, accSchema, encoding, encSchema);
        }
        if (!((accessCount = access.getCaseCount()) == (encodingCount = encoding.getCaseCount()) || this.isEmpty(access.getCase(0)) && this.isEmpty(encoding.getCase(0)))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                JmfTr.debug(this, tc, "Compatibility violation (variants): mismatch case count plus first not empty");
            }
            CompatibilityMap.violation(access, encoding);
        }
        int encodingIndex = encoding.getAccessor(encSchema) - this.varBias;
        int[] ourSets = null;
        int[] ourGets = null;
        if (encodingIndex < this.getCases.length) {
            ourGets = new int[encodingCount];
            this.getCases[encodingIndex] = ourGets;
            ourSets = new int[accessCount];
            this.setCases[encodingIndex] = ourSets;
        }
        for (int i = 0; i < (accessCount > encodingCount ? encodingCount : accessCount); ++i) {
            if (ourSets != null) {
                ourSets[i] = i;
                ourGets[i] = i;
            }
            this.recordCompatibilityInfo(access.getCase(i), accSchema, encoding.getCase(i), encSchema);
        }
    }

    private void recordCompatibilityInfo(JSTuple access, JSchema accSchema, JSTuple encoding, JSchema encSchema) throws JMFSchemaViolationException {
        int encodeCount;
        int count;
        int accessCount = access.getFieldCount();
        int n = count = accessCount < (encodeCount = encoding.getFieldCount()) ? accessCount : encodeCount;
        if (accessCount > count) {
            CompatibilityMap.checkExtraFields(access, count, accessCount);
        } else if (encodeCount > count) {
            CompatibilityMap.checkExtraFields(encoding, count, encodeCount);
        }
        for (int i = 0; i < count; ++i) {
            this.recordCompatibilityInfo(access.getField(i), accSchema, encoding.getField(i), encSchema);
        }
    }

    private static void checkExtraFields(JSTuple tuple, int startCol, int count) throws JMFSchemaViolationException {
        for (int i = startCol; i < count; ++i) {
            JMFType firstCase;
            JMFType field = tuple.getField(i);
            if (field instanceof JSVariant && (firstCase = ((JSVariant)field).getCase(0)) instanceof JSTuple && ((JSTuple)firstCase).getFieldCount() == 0) continue;
            throw new JMFSchemaViolationException(field.getFeatureName() + " not defaulting variant");
        }
    }

    @Override
    public long getIndex() {
        return this.accessSchemaId;
    }
}

