/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.ObjectFailedToSerializeException;
import com.ibm.ws.sib.mfp.WebJsMessageEncoder;
import com.ibm.ws.sib.mfp.impl.JsJmsMapMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsStreamMessageImpl;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebJsJmsMessageEncoderImpl
implements WebJsMessageEncoder {
    private static TraceComponent tc = SibTr.register(WebJsJmsMessageEncoderImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private JsJmsMessage jmsMsg;

    WebJsJmsMessageEncoderImpl(JsJmsMessage msg) {
        this.jmsMsg = msg;
    }

    @Override
    public String encodeForWebClient() throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeForWebClient");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Encoding Web Message", (Object)((MessageImpl)((Object)this.jmsMsg)).debugMsg());
        }
        ((JsJmsMessageImpl)this.jmsMsg).updateDataFields(2);
        StringBuffer result = new StringBuffer();
        result.append(1);
        result.append('~');
        byte[] id = this.jmsMsg.getCorrelationIdAsBytes();
        if (id != null) {
            HexString.binToHex((byte[])id, (int)0, (int)id.length, (StringBuffer)result);
        }
        result.append('~');
        String type = this.jmsMsg.getJmsxAppId();
        if (type == null || type.equals("WebSphere Embedded Messaging")) {
            type = "SIB";
        }
        this.URLEncode(result, type);
        result.append('~');
        result.append(this.jmsMsg.getFormat());
        result.append('~');
        String topic = this.jmsMsg.getDiscriminator();
        if (topic != null) {
            this.URLEncode(result, topic);
        }
        result.append('~');
        Set<String> names = this.jmsMsg.getPropertyNameSet();
        boolean first = true;
        for (String name : names) {
            Object value;
            if (name.equals("JMSXAppID") || (value = this.jmsMsg.getObjectProperty(name)) == null) continue;
            this.encodePair(result, name, value, first);
            first = false;
        }
        if (this.jmsMsg instanceof JsJmsTextMessage) {
            this.encodeTextBody(result, (JsJmsTextMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsBytesMessage) {
            this.encodeBytesBody(result, (JsJmsBytesMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsObjectMessage) {
            this.encodeObjectBody(result, (JsJmsObjectMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsStreamMessage) {
            this.encodeStreamBody(result, (JsJmsStreamMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsMapMessage) {
            this.encodeMapBody(result, (JsJmsMapMessage)this.jmsMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Encoded as web data", (Object)result);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeForWebClient");
        }
        return result.toString();
    }

    private void encodeTextBody(StringBuffer result, JsJmsTextMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeTextBody");
        }
        try {
            String body = msg.getText();
            if (body != null) {
                result.append('~');
                this.URLEncode(result, body);
            }
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl.encodeTextBody", (String)"193");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeTextBody");
        }
    }

    private void encodeBytesBody(StringBuffer result, JsJmsBytesMessage msg) {
        byte[] body;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeBytesBody");
        }
        if ((body = msg.getBytes()) != null) {
            result.append('~');
            HexString.binToHex((byte[])body, (int)0, (int)body.length, (StringBuffer)result);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeBytesBody");
        }
    }

    private void encodeObjectBody(StringBuffer result, JsJmsObjectMessage msg) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeObjectBody");
        }
        try {
            byte[] body = msg.getSerializedObject();
            if (body != null) {
                result.append('~');
                HexString.binToHex((byte[])body, (int)0, (int)body.length, (StringBuffer)result);
            }
        }
        catch (ObjectFailedToSerializeException ofse) {
            FFDCFilter.processException((Throwable)ofse, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl.encodeObjectBody", (String)"225");
            throw new MessageEncodeFailedException(ofse);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeObjectBody");
        }
    }

    private void encodeStreamBody(StringBuffer result, JsJmsStreamMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeStreamBody");
        }
        try {
            List<Object> body = ((JsJmsStreamMessageImpl)msg).getBodyList();
            if (body.size() > 0) {
                result.append('~');
                for (int i = 0; i < body.size(); ++i) {
                    this.encodeObject(result, body.get(i));
                    if (i >= body.size() - 1) continue;
                    result.append('&');
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl.encodeStreamBody", (String)"245");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeStreamBody");
        }
    }

    private void encodeMapBody(StringBuffer result, JsJmsMapMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeMapBody");
        }
        try {
            Map<String, Object> body = ((JsJmsMapMessageImpl)msg).getBodyMap();
            if (body.size() > 0) {
                result.append('~');
                Set<Map.Entry<String, Object>> entries = body.entrySet();
                boolean first = true;
                for (Map.Entry<String, Object> entry : entries) {
                    this.encodePair(result, entry.getKey(), entry.getValue(), first);
                    first = false;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl.encodeMapBody", (String)"269");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeMapBody");
        }
    }

    private void encodePair(StringBuffer result, String name, Object value, boolean first) {
        if (!first) {
            result.append('&');
        }
        this.URLEncode(result, name);
        result.append('=');
        this.encodeObject(result, value);
    }

    private void encodeObject(StringBuffer result, Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                result.append("[]");
                HexString.binToHex((byte[])((byte[])value), (int)0, (int)((byte[])value).length, (StringBuffer)result);
            } else {
                this.URLEncode(result, value.toString());
            }
        }
    }

    private void URLEncode(StringBuffer result, String text) {
        try {
            String enc = URLEncoder.encode(text, "UTF8");
            if (enc.indexOf(43) != -1) {
                enc = enc.replaceAll("\\+", "%20");
            }
            result.append(enc);
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl.URLEncode", (String)"306");
        }
    }
}

