/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.BaseSIXAResourceProxy;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.OptimizedTransaction;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsLightTrace;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class OptimizedSIXAResourceProxy
extends BaseSIXAResourceProxy
implements OptimizedTransaction {
    private static final String CLASS_NAME = OptimizedSIXAResourceProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(OptimizedSIXAResourceProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private boolean serverUowCreated = false;
    private Xid enlistedXid = null;
    private final ReentrantReadWriteLock closeLock;
    private boolean serverUowRequiresEnding = false;
    private int endFlags = 0;
    private boolean endHasBeenCalled = false;
    private int creatingConnectionId = 0;
    private int creatingConversationId = 0;
    private OptimizedSIXAResourceProxy joinedResource = null;
    private static HashMap<Xid, ResourceInfo> xidToResourceInfoMap;

    public OptimizedSIXAResourceProxy(Conversation conv, ConnectionProxy cp, boolean isMSXAResource) {
        super(conv, cp, isMSXAResource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conv, cp, "" + isMSXAResource});
        }
        this.closeLock = cp.closeLock;
        this.creatingConnectionId = this.getConnectionObjectID();
        this.creatingConversationId = conv.getId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public boolean isServerTransactionCreated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isServerTransactionCreated");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Joined Resource:", (Object)this.joinedResource);
        }
        boolean result = false;
        result = this.joinedResource != null ? this.joinedResource.serverUowCreated : this.serverUowCreated;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isServerTransactionCreated", (Object)("" + result));
        }
        return result;
    }

    @Override
    public void setServerTransactionCreated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setServerTransactionCreated");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Joined Resource:", (Object)this.joinedResource);
        }
        if (this.joinedResource != null) {
            this.joinedResource.serverUowCreated = true;
        } else {
            this.serverUowCreated = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setServerTransactionCreated");
        }
    }

    @Override
    public Xid getXidForCurrentUow() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getXidForCurrentUow");
        }
        Xid result = this.enlistedXid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getXidForCurrentUow", (Object)result);
        }
        return result;
    }

    public boolean isEnlisted() {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEnlisted");
        }
        boolean bl = result = this.enlistedXid != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEnlisted", (Object)("" + result));
        }
        return result;
    }

    @Override
    public void setEnlisted(Xid enlistedXid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setEnlisted", (Object)enlistedXid);
        }
        this.enlistedXid = enlistedXid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setEnlisted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block41: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object)new Object[]{xid, "" + onePhase});
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                CommsLightTrace.traceTransaction(tc, "CommitTxnTrace", xid, this.getTransactionId(), -1);
            }
            boolean performingRecovery = false;
            boolean thisResourceStartedUnitOfWork = false;
            boolean serverTransactionWasCreated = true;
            OptimizedSIXAResourceProxy delegateResource = null;
            ResourceInfo info = null;
            HashMap<Xid, ResourceInfo> hashMap = xidToResourceInfoMap;
            synchronized (hashMap) {
                info = xidToResourceInfoMap.get(xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource Info: ", (Object)info);
                }
                if (info == null) {
                    performingRecovery = true;
                } else if (info.resource == this) {
                    if (!info.resourceEnded) {
                        XAException exception = new XAException(-5);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                        }
                        throw exception;
                    }
                    if (onePhase && info.resourcePrepared) {
                        XAException exception = new XAException(-6);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                        }
                        throw exception;
                    }
                    thisResourceStartedUnitOfWork = true;
                    serverTransactionWasCreated = info.serverTransactionCreated;
                    xidToResourceInfoMap.remove(xid);
                } else {
                    delegateResource = info.resource;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String debugText = "thisResourceStartedUnitOfWork=" + thisResourceStartedUnitOfWork + "\nperformingRecoveryOr2PCCommit=" + performingRecovery + "\nserverTransactionWasCreated=" + serverTransactionWasCreated;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)debugText);
            }
            if (thisResourceStartedUnitOfWork || performingRecovery) {
                XAException exception;
                if (serverTransactionWasCreated) {
                    this.takeCloseLock();
                    try {
                        if (this.isClosed()) {
                            XAException xAException = exception = info == null || info.resourcePrepared ? new XAException(-7) : new XAException(100);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                            }
                            throw exception;
                        }
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putInt(this.getTransactionId());
                        request.putXid(xid);
                        request.put(onePhase ? (byte)1 : 0);
                        if (this.isEndRequired()) {
                            request.put((byte)1);
                            request.putInt(this.getEndFlags());
                            this.setEndNotRequired();
                        } else {
                            request.put((byte)0);
                            request.putInt(0);
                        }
                        if (this.fapLevel >= 5) {
                            request.put((byte)(this.isMSResource ? 1 : 0));
                        }
                        CommsByteBuffer reply = this.jfapExchange(request, 52, -1, true);
                        try {
                            reply.checkXACommandCompletionStatus(180, this.getConversation());
                            break block41;
                        }
                        finally {
                            if (reply != null) {
                                reply.release();
                            }
                        }
                    }
                    catch (XAException xa) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)xa);
                        }
                        throw xa;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".commit"), (String)"1-013-0001", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Non-XA exception caught: " + e));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                        }
                        XAException xaException = new XAException(-7);
                        xaException.initCause(e);
                        throw xaException;
                    }
                    finally {
                        this.releaseCloseLock();
                    }
                }
                if ((this.endFlags & 0x20000000) == 0x20000000) {
                    if (onePhase) {
                        exception = new XAException(6);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                        }
                        throw exception;
                    }
                    exception = new XAException(-6);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
            } else {
                delegateResource.commit(xid, onePhase);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        boolean performEndNow;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object)new Object[]{xid, "" + flags});
        }
        if (xid == null) {
            XAException exception = new XAException(-4);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if (this.enlistedXid == null) {
            XAException exception = new XAException(-5);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if (!this.enlistedXid.equals(xid)) {
            XAException exception = new XAException(-4);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if (this.joinedResource != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unjoining from: " + this.joinedResource));
            }
            this.joinedResource.unjoin(this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("JoinedResource.endHasBeenCalled: " + this.joinedResource.endHasBeenCalled));
            }
            performEndNow = !this.joinedResource.hasJoinedResources() && this.joinedResource.endHasBeenCalled;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not joined to any other resource");
            }
            boolean bl = performEndNow = !this.hasJoinedResources();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("performEndNow:" + performEndNow));
        }
        if (performEndNow) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Performing standard end");
            }
            HashMap<Xid, ResourceInfo> hashMap = xidToResourceInfoMap;
            synchronized (hashMap) {
                ResourceInfo info = xidToResourceInfoMap.get(xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource Info: ", (Object)info);
                }
                if (info == null || this.joinedResource == null && info.resource != this || this.joinedResource != null && info.resource != this.joinedResource) {
                    XAException exception = new XAException(-6);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
                info.serverTransactionCreated = this.joinedResource != null ? this.joinedResource.serverUowCreated : this.serverUowCreated;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"serverTransactionCreated", (Object)("" + info.serverTransactionCreated));
                }
                info.resourceEnded = true;
                if (info.serverTransactionCreated) {
                    if (this.joinedResource != null) {
                        this.joinedResource.serverUowRequiresEnding = true;
                        this.joinedResource.endFlags = flags;
                    } else {
                        this.serverUowRequiresEnding = true;
                        this.endFlags = flags;
                    }
                }
            }
            if (this.joinedResource != null) {
                this.joinedResource.serverUowCreated = false;
                this.joinedResource.enlistedXid = null;
            }
            this.serverUowCreated = false;
        }
        this.joinedResource = null;
        this.endHasBeenCalled = true;
        this.enlistedXid = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"forget", (Object)xid);
        }
        this.internalForget(xid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"forget");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout");
        }
        boolean result = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object)"0");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        int result;
        HashMap<Xid, ResourceInfo> hashMap;
        block48: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object)xid);
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                CommsLightTrace.traceTransaction(tc, "PrepareTxnTrace", xid, this.getTransactionId(), -1);
            }
            boolean performingRecovery = false;
            boolean thisResourceStartedUnitOfWork = false;
            boolean serverTransactionWasCreated = true;
            OptimizedSIXAResourceProxy delegateResource = null;
            ResourceInfo info = null;
            hashMap = xidToResourceInfoMap;
            synchronized (hashMap) {
                info = xidToResourceInfoMap.get(xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource Info: ", (Object)info);
                }
                if (info == null) {
                    performingRecovery = true;
                } else if (info.resource == this) {
                    if (!info.resourceEnded) {
                        XAException exception = new XAException(-5);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                        }
                        throw exception;
                    }
                    thisResourceStartedUnitOfWork = true;
                    serverTransactionWasCreated = info.serverTransactionCreated;
                    info.resourcePrepared = true;
                } else {
                    delegateResource = info.resource;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String debugText = "thisResourceStartedUnitOfWork=" + thisResourceStartedUnitOfWork + "\nperformingRecovery=" + performingRecovery + "\nserverTransactionWasCreated=" + serverTransactionWasCreated;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)debugText);
            }
            if (thisResourceStartedUnitOfWork || performingRecovery) {
                XAException exception;
                if (serverTransactionWasCreated) {
                    this.takeCloseLock();
                    try {
                        if (this.isClosed()) {
                            exception = new XAException(100);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                            }
                            throw exception;
                        }
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putInt(this.getTransactionId());
                        request.putXid(xid);
                        if (this.isEndRequired()) {
                            request.put((byte)1);
                            request.putInt(this.getEndFlags());
                            this.setEndNotRequired();
                        } else {
                            request.put((byte)0);
                            request.putInt(0);
                        }
                        if (this.fapLevel >= 5) {
                            request.put((byte)(this.isMSResource ? 1 : 0));
                        }
                        CommsByteBuffer reply = this.jfapExchange(request, 51, -1, true);
                        try {
                            reply.checkXACommandCompletionStatus(179, this.getConversation());
                            result = reply.getInt();
                            break block48;
                        }
                        finally {
                            if (reply != null) {
                                reply.release();
                            }
                        }
                    }
                    catch (XAException xa) {
                        if (xa.errorCode >= 100 && xa.errorCode <= 107) {
                            HashMap<Xid, ResourceInfo> reply = xidToResourceInfoMap;
                            synchronized (reply) {
                                if (xidToResourceInfoMap.containsKey(xid)) {
                                    xidToResourceInfoMap.remove(xid);
                                }
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)xa);
                        }
                        throw xa;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".prepare"), (String)"1-007-0001", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Non-XA exception caught: " + e));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                        }
                        XAException xaException = new XAException(-7);
                        xaException.initCause(e);
                        this.invalidateConnection(true, e, "Exception in SIXAResourceProxy.end");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
                        }
                        throw xaException;
                    }
                    finally {
                        this.releaseCloseLock();
                    }
                }
                if ((this.endFlags & 0x20000000) == 0x20000000) {
                    exception = new XAException(100);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
                result = 0;
            } else {
                result = delegateResource.prepare(xid);
            }
        }
        if (3 == result) {
            hashMap = xidToResourceInfoMap;
            synchronized (hashMap) {
                if (xidToResourceInfoMap.containsKey(xid)) {
                    xidToResourceInfoMap.remove(xid);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)("" + result));
        }
        return result;
    }

    public Xid[] recover(int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"recover", (Object)("" + flags));
        }
        Xid[] result = this.internalRecover(flags);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object)xid);
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            CommsLightTrace.traceTransaction(tc, "RollbackTxnTrace", xid, this.getTransactionId(), -1);
        }
        if (xid == null) {
            XAException exception = new XAException(-4);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        boolean performingRecovery = false;
        boolean thisResourceStartedUnitOfWork = false;
        boolean serverTransactionWasCreated = true;
        OptimizedSIXAResourceProxy delegateResource = null;
        ResourceInfo info = null;
        HashMap<Xid, ResourceInfo> hashMap = xidToResourceInfoMap;
        synchronized (hashMap) {
            info = xidToResourceInfoMap.get(xid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource Info: ", (Object)info);
            }
            if (info == null) {
                performingRecovery = true;
            } else if (info.resource == this) {
                if (!info.resourceEnded) {
                    XAException exception = new XAException(-5);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
                thisResourceStartedUnitOfWork = true;
                serverTransactionWasCreated = info.serverTransactionCreated;
                xidToResourceInfoMap.remove(xid);
            } else {
                delegateResource = info.resource;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String debugText = "thisResourceStartedUnitOfWork=" + thisResourceStartedUnitOfWork + "\nperformingRecovery=" + performingRecovery + "\nserverTransactionWasCreated=" + serverTransactionWasCreated;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)debugText);
        }
        if (thisResourceStartedUnitOfWork || performingRecovery) {
            if (serverTransactionWasCreated) {
                this.takeCloseLock();
                try {
                    if (this.isClosed()) {
                        XAException exception;
                        XAException xAException = exception = info == null || info.resourcePrepared ? new XAException(-7) : new XAException(100);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                        }
                        throw exception;
                    }
                    CommsByteBuffer request = this.getCommsByteBuffer();
                    request.putInt(this.getTransactionId());
                    request.putXid(xid);
                    if (this.isEndRequired()) {
                        request.put((byte)1);
                        request.putInt(this.getEndFlags());
                        this.setEndNotRequired();
                    } else {
                        request.put((byte)0);
                        request.putInt(0);
                    }
                    if (this.fapLevel >= 5) {
                        request.put((byte)(this.isMSResource ? 1 : 0));
                    }
                    CommsByteBuffer reply = this.jfapExchange(request, 53, -1, true);
                    try {
                        reply.checkXACommandCompletionStatus(181, this.getConversation());
                    }
                    finally {
                        if (reply != null) {
                            reply.release();
                        }
                    }
                }
                catch (XAException xa) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)xa);
                    }
                    throw xa;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rollback"), (String)"1-007-0001", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Non-XA exception caught: " + e));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                    }
                    XAException xaException = new XAException(-7);
                    xaException.initCause(e);
                    throw xaException;
                }
                finally {
                    this.releaseCloseLock();
                }
            }
        } else {
            delegateResource.rollback(xid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)("" + timeout));
        }
        boolean result = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)"false");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)new Object[]{xid, flags});
        }
        if (xid == null) {
            XAException exception = new XAException(-4);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if (this.enlistedXid != null) {
            XAException exception = new XAException(-6);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if ((flags & 0x200000) == 0x200000) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"TMJOIN was specified");
            }
            if (this.joinedResource != null) {
                XAException exception = new XAException(-6);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            HashMap<Xid, ResourceInfo> exception = xidToResourceInfoMap;
            synchronized (exception) {
                ResourceInfo info = xidToResourceInfoMap.get(xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource Info: ", (Object)info);
                }
                if (info == null) {
                    XAException exception2 = new XAException(-5);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception2);
                    }
                    throw exception2;
                }
                this.joinedResource = info.resource;
                this.enlistedXid = xid;
                this.joinedResource.join(this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Joined to resource: ", (Object)this.joinedResource);
                }
            }
        }
        ResourceInfo info = new ResourceInfo(this);
        HashMap<Xid, ResourceInfo> hashMap = xidToResourceInfoMap;
        synchronized (hashMap) {
            if (xidToResourceInfoMap.containsKey(xid)) {
                XAException exception = new XAException(-8);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            xidToResourceInfoMap.put(xid, info);
        }
        this.enlistedXid = xid;
        this.endHasBeenCalled = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        boolean result;
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)xaRes);
            }
            result = false;
            if (xaRes instanceof OptimizedSIXAResourceProxy) {
                try {
                    SICoreConnection thisConnection = ((ClientConversationState)this.getConversation().getAttachment()).getSICoreConnection();
                    SICoreConnection otherConnection = ((ClientConversationState)((OptimizedSIXAResourceProxy)((Object)xaRes)).getConversation().getAttachment()).getSICoreConnection();
                    result = thisConnection.isEquivalentTo(otherConnection);
                }
                catch (Throwable t) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception comparing the connections", (Object)t);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)t);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)("" + result));
        }
        return result;
    }

    private void takeCloseLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"takeCloseLock");
        }
        while (true) {
            try {
                this.closeLock.readLock().lockInterruptibly();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"takeCloseLock");
        }
    }

    private void releaseCloseLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"releaseCloseLock");
        }
        this.closeLock.readLock().unlock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"releaseCloseLock");
        }
    }

    @Override
    public boolean isEndRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEndRequired");
        }
        boolean result = this.serverUowRequiresEnding;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEndRequired", (Object)("" + result));
        }
        return result;
    }

    @Override
    public void setEndNotRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setEndNotRequired");
        }
        if (!this.serverUowRequiresEnding) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".setEndNotRequired"), (String)"1-013-0002", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        this.serverUowRequiresEnding = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setEndNotRequired");
        }
    }

    @Override
    public int getEndFlags() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getEndFlags");
        }
        if (!this.serverUowRequiresEnding) {
            SIErrorException exception = new SIErrorException();
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getEndFlags"), (String)"1-013-0003", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        int result = this.endFlags;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getEndFlags", (Object)("" + result));
        }
        return result;
    }

    @Override
    public boolean areSubordinatesAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"areSubordinatesAllowed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"areSubordinatesAllowed", (Object)"SIErrorException");
        }
        throw new SIErrorException();
    }

    @Override
    public int getCreatingConnectionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCreatingConnectionId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCreatingConnectionId", (Object)this.creatingConnectionId);
        }
        return this.creatingConnectionId;
    }

    @Override
    public int getCreatingConversationId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCreatingConversationId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCreatingConversationId", (Object)this.creatingConversationId);
        }
        return this.creatingConversationId;
    }

    @Override
    public short getLowestMessagePriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestMessagePriority");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Joined resource:", (Object)this.joinedResource);
        }
        short result = this.joinedResource != null ? this.joinedResource.getLowestMessagePriority() : super.getLowestMessagePriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestMessagePriority", (Object)result);
        }
        return result;
    }

    @Override
    public int getTransactionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Joined resource:", (Object)this.joinedResource);
        }
        int result = this.joinedResource != null ? this.joinedResource.getTransactionId() : super.getTransactionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionId", (Object)result);
        }
        return result;
    }

    @Override
    public void updateLowestMessagePriority(short messagePriority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLowestMessagePriority", (Object)messagePriority);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Joined resource:", (Object)this.joinedResource);
        }
        if (this.joinedResource != null) {
            this.joinedResource.updateLowestMessagePriority(messagePriority);
        } else {
            super.updateLowestMessagePriority(messagePriority);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateLowestMessagePriority");
        }
    }

    public String toString() {
        return super.toString() + "[commsTx=" + this.getTransactionId() + ",enlistedXid=" + this.enlistedXid + "]";
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) 1.36 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/OptimizedSIXAResourceProxy.java, SIB.comms, WASX.SIB, uu1215.01");
        }
        xidToResourceInfoMap = new HashMap();
    }

    private static class ResourceInfo {
        public OptimizedSIXAResourceProxy resource;
        public boolean serverTransactionCreated = false;
        public boolean resourceEnded = false;
        public boolean resourcePrepared = false;

        public ResourceInfo(OptimizedSIXAResourceProxy resource) {
            this.resource = resource;
        }

        public String toString() {
            return "ResourceInfo@" + Integer.toHexString(System.identityHashCode(this)) + ": { resource=" + this.resource + ", serverTransactionCreated=" + this.serverTransactionCreated + ", resourceEnded=" + this.resourceEnded + ", resourcePrepared=" + this.resourcePrepared + " }";
        }
    }
}

