/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata;

import java.util.Collection;
import java.util.function.Predicate;

public class ScanningPredicate<T>
implements Predicate<T> {
    private final Collection<Predicate<T>> includes;
    private final Collection<Predicate<T>> excludes;

    public ScanningPredicate(Collection<Predicate<T>> includes, Collection<Predicate<T>> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public boolean test(T input) {
        boolean apply = this.includes.isEmpty();
        for (Predicate<T> include : this.includes) {
            if (!include.test(input)) continue;
            apply = true;
        }
        for (Predicate<T> exclude : this.excludes) {
            if (!exclude.test(input)) continue;
            return false;
        }
        return apply;
    }
}

