/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class MariaDBPlatform
extends MySQLPlatform {
    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        this.driverSupportsNationalCharacterVarying = true;
    }

    @Override
    public boolean isMariaDB() {
        return true;
    }

    @Override
    public boolean isMySQL() {
        return false;
    }

    @Override
    public boolean supportsFractionalTime() {
        return true;
    }

    @Override
    public boolean supportsSequenceObjects() {
        return true;
    }

    @Override
    public Writer buildSequenceObjectCreationWriter(Writer writer, String fullSeqName, int increment, int start) throws IOException {
        writer.write("CREATE SEQUENCE ");
        writer.write(fullSeqName);
        if (start != 1) {
            writer.write(" START WITH " + start);
        }
        if (increment != 1) {
            writer.write(" INCREMENT BY " + increment);
        }
        return writer;
    }

    @Override
    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("select nextval(" + qualifiedSeqName + ")");
    }

    @Override
    public boolean isAlterSequenceObjectSupported() {
        return true;
    }

    @Override
    public String getDropDatabaseSchemaString(String schema) {
        return "DROP SCHEMA IF EXISTS " + schema;
    }
}

