/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import jakarta.validation.Configuration;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.metadata.listeners.BeanValidationListener;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public interface BeanValidationInitializationHelper {
    public void bootstrapBeanValidation(Map var1, AbstractSession var2, ClassLoader var3);

    public static class BeanValidationInitializationHelperImpl
    implements BeanValidationInitializationHelper {
        @Override
        public void bootstrapBeanValidation(Map puProperties, AbstractSession session, ClassLoader appClassLoader) {
            ValidatorFactory validatorFactory = this.getValidatorFactory(puProperties, appClassLoader);
            if (validatorFactory != null) {
                ValidatorFactory beanValidatorFactory = validatorFactory;
                Class<?>[] groupPrePersit = this.translateValidationGroups((String)puProperties.get("jakarta.persistence.validation.group.pre-persist"), appClassLoader);
                Class<?>[] groupPreUpdate = this.translateValidationGroups((String)puProperties.get("jakarta.persistence.validation.group.pre-update"), appClassLoader);
                Class<?>[] groupPreRemove = this.translateValidationGroups((String)puProperties.get("jakarta.persistence.validation.group.pre-remove"), appClassLoader);
                BeanValidationListener validationListener = new BeanValidationListener(beanValidatorFactory, groupPrePersit, groupPreUpdate, groupPreRemove);
                for (ClassDescriptor descriptor : session.getProject().getOrderedDescriptors()) {
                    if (!descriptor.isDescriptorTypeNormal()) continue;
                    descriptor.getEventManager().addInternalListener(validationListener);
                }
            }
        }

        private ValidatorFactory getValidatorFactory(Map puProperties, ClassLoader appClassLoader) {
            ValidatorFactory validatorFactory = (ValidatorFactory)puProperties.get("jakarta.persistence.validation.factory");
            if (validatorFactory == null) {
                Configuration conf = Validation.byDefaultProvider().configure();
                if (appClassLoader != null) {
                    try {
                        Configuration finalConf = conf;
                        conf = PrivilegedAccessHelper.callDoPrivilegedWithThrowable(() -> {
                            Method m = PrivilegedAccessHelper.getMethod(finalConf.getClass(), "externalClassLoader", new Class[]{ClassLoader.class}, false);
                            return (Configuration)m.invoke((Object)finalConf, appClassLoader);
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                validatorFactory = conf.buildValidatorFactory();
            }
            return validatorFactory;
        }

        private Class<?>[] translateValidationGroups(String validationGroups, ClassLoader appClassLoader) {
            Class[] validationGroupsClasses = null;
            if (validationGroups != null && !validationGroups.isEmpty()) {
                String[] validationGroupClassNames = validationGroups.split(",");
                validationGroupsClasses = new Class[validationGroupClassNames.length];
                for (int i = 0; i < validationGroupClassNames.length; ++i) {
                    String validationGroupClassName = validationGroupClassNames[i];
                    try {
                        validationGroupsClasses[i] = this.loadClass(validationGroupClassName, appClassLoader);
                        continue;
                    }
                    catch (Exception e) {
                        throw PersistenceUnitLoadingException.exceptionLoadingClassWhileInitializingValidationGroups(validationGroupClassName, e);
                    }
                }
            }
            return validationGroupsClasses;
        }

        private Class<?> loadClass(String className, ClassLoader classLoader) throws PrivilegedActionException, ClassNotFoundException {
            Class loadedClass = null;
            loadedClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader)) : PrivilegedAccessHelper.getClassForName(className, true, classLoader);
            return loadedClass;
        }
    }
}

