/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health40.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.health30.internal.HealthCheck30HttpResponseBuilder;
import io.openliberty.microprofile.health40.internal.FileHealthCheckBuilder;
import io.openliberty.microprofile.health40.internal.HealthCheck40Service;
import io.openliberty.microprofile.health40.internal.HealthFileUtils;
import io.openliberty.microprofile.health40.services.HealthCheck40Executor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HealthCheck40Service.class}, property={"service.vendor=IBM"}, configurationPid={"io.openliberty.microprofile.health"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true)
public class HealthCheck40ServiceImpl
implements HealthCheck40Service {
    private static final TraceComponent tc = Tr.register(HealthCheck40ServiceImpl.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private final AtomicBoolean isAllFilesCreated = new AtomicBoolean(false);
    private final AtomicBoolean isLiveUp = new AtomicBoolean(false);
    private final AtomicBoolean isReadyUp = new AtomicBoolean(false);
    private AppTracker appTracker;
    private HealthCheck40Executor hcExecutor;
    ComponentContext componentContext;
    private Timer createStartedTimer;
    private Timer createLiveTimer;
    private Timer createReadyTimer;
    private Timer updateLiveTimer;
    private Timer updateReadyTimer;
    private volatile int checkIntervalMilliseconds = -1;
    private volatile int startupCheckIntervalMilliseconds = -1;
    protected volatile boolean isCheckPointFinished = false;
    protected boolean isValidSystemForFileHealthCheck = false;
    final AtomicBoolean readinessWarningAlreadyShown = new AtomicBoolean(false);
    final AtomicBoolean startupWarningAlreadyShown = new AtomicBoolean(false);
    AtomicInteger unstartedAppsCounter = new AtomicInteger(0);
    static HealthCheckResponse.Status DEFAULT_READINESS_STATUS;
    static HealthCheckResponse.Status DEFAULT_STARTUP_STATUS;
    Set<String> stoppingApplication = ConcurrentHashMap.newKeySet();
    static final long serialVersionUID = 1700011086435916764L;

    private boolean isFileHealthCheckingEnabled() {
        return this.checkIntervalMilliseconds > 0;
    }

    private int getStartupCheckInterval() {
        return this.startupCheckIntervalMilliseconds <= 0 ? 100 : this.startupCheckIntervalMilliseconds;
    }

    @Reference(service=AppTracker.class)
    protected void setAppTracker(AppTracker service) {
        this.appTracker = service;
        this.appTracker.setHealthCheckService(this);
    }

    protected void unsetAppTracker(AppTracker service) {
        if (this.appTracker == service) {
            this.appTracker = null;
            this.stopAllTimers();
        }
    }

    private synchronized void stopAllTimers() {
        if (this.createStartedTimer != null) {
            this.createStartedTimer.cancel();
            this.createStartedTimer = null;
        }
        if (this.createLiveTimer != null) {
            this.createLiveTimer.cancel();
            this.createLiveTimer = null;
        }
        if (this.createReadyTimer != null) {
            this.createReadyTimer.cancel();
            this.createReadyTimer = null;
        }
        if (this.updateLiveTimer != null) {
            this.updateLiveTimer.cancel();
            this.updateLiveTimer = null;
        }
        if (this.updateReadyTimer != null) {
            this.updateReadyTimer.cancel();
            this.updateReadyTimer = null;
        }
    }

    private synchronized void stopUpdateTimers() {
        if (this.updateLiveTimer != null) {
            this.updateLiveTimer.cancel();
            this.updateLiveTimer = null;
        }
        if (this.updateReadyTimer != null) {
            this.updateReadyTimer.cancel();
            this.updateReadyTimer = null;
        }
    }

    private synchronized void stopCreateTimers() {
        if (this.createStartedTimer != null) {
            this.createStartedTimer.cancel();
            this.createStartedTimer = null;
        }
        if (this.createLiveTimer != null) {
            this.createLiveTimer.cancel();
            this.createLiveTimer = null;
        }
        if (this.createReadyTimer != null) {
            this.createReadyTimer.cancel();
            this.createReadyTimer = null;
        }
    }

    @Reference(service=HealthCheck40Executor.class)
    protected void setHealthExecutor(HealthCheck40Executor service) {
        this.hcExecutor = service;
    }

    protected void unsetHealthExecutor(HealthCheck40Executor service) {
        if (this.hcExecutor == service) {
            this.hcExecutor = null;
            this.stopAllTimers();
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.componentContext = cc;
        this.processConfig();
        if (this.isFileHealthCheckingEnabled() && this.isValidSystemForFileHealthCheck) {
            Set<String> apps = this.validateApplicationSet();
            if (apps.size() == 0) {
                this.startFileHealthCheckProcesses();
            }
        } else if (!this.isFileHealthCheckingEnabled() && this.startupCheckIntervalMilliseconds != -1) {
            Tr.warning((TraceComponent)tc, (String)"startup.check.interval.config.only.set.CWMMH01012W", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is activated", (Object[])new Object[0]);
        }
    }

    protected void processConfig() {
        Map properties = (Map)((Object)this.componentContext.getProperties());
        String serverCheckIntervalConfig = (String)properties.get("checkInterval");
        if (serverCheckIntervalConfig != null) {
            this.processCheckIntervalConfig(serverCheckIntervalConfig);
        } else {
            this.processCheckIntervalConfig(System.getenv("MP_HEALTH_CHECK_INTERVAL"));
        }
        String serverStartupCheckIntervalConfig = (String)properties.get("startupCheckInterval");
        if (serverStartupCheckIntervalConfig != null) {
            this.processStartupCheckIntervalConfig(serverStartupCheckIntervalConfig);
        } else {
            this.processStartupCheckIntervalConfig(System.getenv("MP_HEALTH_STARTUP_CHECK_INTERVAL"));
        }
        if (this.isFileHealthCheckingEnabled()) {
            try {
                this.isValidSystemForFileHealthCheck = HealthFileUtils.isValidSystem();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Is system valid for File health check: " + this.isValidSystemForFileHealthCheck), (Object[])new Object[0]);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl", (String)"277", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    protected void processCheckIntervalConfig(String configValue) {
        if (configValue != null && !configValue.trim().isEmpty()) {
            int prevCheckIntervalConfigMilliseconds = this.checkIntervalMilliseconds;
            if ((configValue = configValue.trim()).matches("^\\d+(ms|s)?$")) {
                this.checkIntervalMilliseconds = configValue.endsWith("ms") ? Integer.parseInt(configValue.substring(0, configValue.length() - 2)) : (configValue.endsWith("s") ? Integer.parseInt(configValue.substring(0, configValue.length() - 1)) * 1000 : Integer.parseInt(configValue) * 1000);
            } else {
                Tr.warning((TraceComponent)tc, (String)"check.interval.config.invalid.CWMMH01010W", (Object[])new Object[]{configValue});
                this.checkIntervalMilliseconds = 10000;
            }
            String updateValueMessage = String.format("The checkInterval is read in as [%s] and is resolved to be [%d] milliseconds", configValue, this.checkIntervalMilliseconds);
            if (prevCheckIntervalConfigMilliseconds >= 0 && prevCheckIntervalConfigMilliseconds != this.checkIntervalMilliseconds) {
                updateValueMessage = "The configuration has been updated. " + updateValueMessage;
                this.stopUpdateTimers();
                if (this.isFileHealthCheckingEnabled() && this.isAllFilesCreated.get()) {
                    this.startUpdateHealthCheckFileProcesses();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)updateValueMessage, (Object[])new Object[0]);
            }
        }
    }

    protected void processStartupCheckIntervalConfig(String configValue) {
        if (configValue != null && !configValue.trim().isEmpty()) {
            if ((configValue = configValue.trim()).matches("^\\d+(ms|s)?$")) {
                this.startupCheckIntervalMilliseconds = configValue.endsWith("ms") ? Integer.parseInt(configValue.substring(0, configValue.length() - 2)) : (configValue.endsWith("s") ? Integer.parseInt(configValue.substring(0, configValue.length() - 1)) * 1000 : Integer.parseInt(configValue));
            } else {
                Tr.warning((TraceComponent)tc, (String)"startup.check.interval.config.invalid.CWMMH01011W", (Object[])new Object[]{configValue});
                this.startupCheckIntervalMilliseconds = 100;
            }
            String updateValueMessage = String.format("The startupCheckInterval is read in as [%s] and is resolved to be [%d] milliseconds", configValue, this.startupCheckIntervalMilliseconds);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)updateValueMessage, (Object[])new Object[0]);
            }
        }
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        if (this.isValidSystemForFileHealthCheck) {
            this.processCheckIntervalConfig((String)properties.get("checkInterval"));
            this.processStartupCheckIntervalConfig((String)properties.get("startupCheckInterval"));
        }
    }

    @Override
    public void startFileHealthCheckProcesses() {
        this.isCheckPointFinished = true;
        if (!CheckpointPhase.getPhase().equals((Object)CheckpointPhase.INACTIVE)) {
            System.out.println("debug: reprocess");
            this.processConfig();
        }
        if (this.isValidSystemForFileHealthCheck && this.isFileHealthCheckingEnabled()) {
            File startFile = HealthFileUtils.getStartFile();
            if (!startFile.exists()) {
                this.createStartedTimer = new Timer(true);
                this.createStartedTimer.schedule((TimerTask)new StartedFileCreateProcess(), 0L, (long)this.getStartupCheckInterval());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initiated startup phase for local health check funcitonality. Querying for first succesful startup status.", (Object[])new Object[0]);
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"file.healthcheck.system.inconsistency.CWMMH0107W", (Object[])new Object[0]);
            }
        }
    }

    public void startLiveFileCreateHealthCheckProcess() {
        if (this.isValidSystemForFileHealthCheck && this.isFileHealthCheckingEnabled()) {
            File liveFile = HealthFileUtils.getLiveFile();
            this.createLiveTimer = new Timer(true);
            this.createLiveTimer.schedule((TimerTask)new FileCreateProcess(liveFile, "LIVE"), 0L, (long)this.getStartupCheckInterval());
        }
    }

    public void startReadyFileCreateHealthCheckProcess() {
        if (this.isValidSystemForFileHealthCheck && this.isFileHealthCheckingEnabled()) {
            File readyFile = HealthFileUtils.getReadyFile();
            this.createReadyTimer = new Timer(true);
            this.createReadyTimer.schedule((TimerTask)new FileCreateProcess(readyFile, "READY"), 0L, (long)this.getStartupCheckInterval());
        }
    }

    public void startUpdateHealthCheckFileProcesses() {
        if (this.isValidSystemForFileHealthCheck && this.isFileHealthCheckingEnabled()) {
            File readyFile = HealthFileUtils.getReadyFile();
            File liveFile = HealthFileUtils.getLiveFile();
            if (this.updateReadyTimer != null) {
                this.updateReadyTimer.cancel();
            }
            if (this.updateLiveTimer != null) {
                this.updateLiveTimer.cancel();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initiated update phase for local health check funcitonality.", (Object[])new Object[0]);
            }
            this.updateReadyTimer = new Timer(true);
            this.updateReadyTimer.schedule((TimerTask)new FileUpdateProcess(readyFile, "READY"), 0L, (long)this.checkIntervalMilliseconds);
            this.updateLiveTimer = new Timer(true);
            this.updateLiveTimer.schedule((TimerTask)new FileUpdateProcess(liveFile, "LIVE"), 0L, (long)this.checkIntervalMilliseconds);
        }
    }

    public synchronized void reportUpStatusFor(String healthCheckProcedure) {
        if (healthCheckProcedure.equals("READY")) {
            this.isReadyUp.set(true);
        } else if (healthCheckProcedure.equals("LIVE")) {
            this.isLiveUp.set(true);
        }
        if (this.isReadyUp.get() && this.isLiveUp.get()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Creating `started`, `live` and `ready` health check files", (Object[])new Object[0]);
            }
            HealthFileUtils.createFile(HealthFileUtils.getStartFile());
            HealthFileUtils.createFile(HealthFileUtils.getLiveFile());
            HealthFileUtils.createFile(HealthFileUtils.getReadyFile());
            this.isAllFilesCreated.set(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Startup phase for local health check functionality completed.", (Object[])new Object[0]);
            }
            this.startUpdateHealthCheckFileProcesses();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is deactivated", (Object[])new Object[0]);
        }
        this.stopAllTimers();
    }

    private void resolveDefaultStatuses() {
        String mpConfig_defaultReadiness = ConfigProvider.getConfig().getOptionalValue("mp.health.default.readiness.empty.response", String.class).orElse("");
        String mpConfig_defaultStartup = ConfigProvider.getConfig().getOptionalValue("mp.health.default.startup.empty.response", String.class).orElse("");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): The default overall Readiness status was configured to be overriden: mp.health.default.readiness.empty.response=" + mpConfig_defaultReadiness), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): The default overall Startup status was configured to be overriden: mp.health.default.startup.empty.response=" + mpConfig_defaultStartup), (Object[])new Object[0]);
        }
        DEFAULT_READINESS_STATUS = mpConfig_defaultReadiness.equalsIgnoreCase("UP") ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        DEFAULT_STARTUP_STATUS = mpConfig_defaultStartup.equalsIgnoreCase("UP") ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
    }

    private Set<String> validateApplicationSet() throws NullPointerException {
        Set<String> apps = this.appTracker.getAllAppNames();
        Set<String> configApps = this.appTracker.getAllConfigAppNames();
        for (String nextAppName : configApps) {
            if (apps.contains(nextAppName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): configAdmin found an application that the applicationStateListener already found. configAdminAppName = " + nextAppName), (Object[])new Object[0]);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): applicationStateListener couldn't find application. configAdmin added appName = " + nextAppName), (Object[])new Object[0]);
            }
            this.appTracker.addAppName(nextAppName);
        }
        apps = this.appTracker.getAllAppNames();
        return apps;
    }

    @Override
    public void performHealthCheck(HttpServletRequest request, HttpServletResponse httpResponse) {
        this.performHealthCheck(request, httpResponse, "ALL");
    }

    @Override
    public void performHealthCheck(HttpServletRequest request, HttpServletResponse httpResponse, String healthCheckProcedure) {
        this.resolveDefaultStatuses();
        HealthCheck30HttpResponseBuilder hcHttpResponseBuilder = new HealthCheck30HttpResponseBuilder();
        Set<String> appSet = this.validateApplicationSet();
        HashSet<String> unstartedAppSet = new HashSet<String>();
        this.runHealthChecks(appSet, healthCheckProcedure, unstartedAppSet, status -> hcHttpResponseBuilder.setOverallStatus((HealthCheckResponse.Status)status), x -> hcHttpResponseBuilder.handleUndeterminedResponse(httpResponse), responses -> hcHttpResponseBuilder.addResponses((Set<HealthCheckResponse>)responses));
        this.issueMessagesForUnstartedApps(unstartedAppSet, healthCheckProcedure);
        hcHttpResponseBuilder.setHttpResponse(httpResponse);
    }

    @Override
    public HealthCheckResponse.Status performFileHealthCheck(File file, String healthCheckProcedure) {
        if (!this.isCheckPointFinished) {
            return null;
        }
        if (this.isValidSystemForFileHealthCheck && this.isFileHealthCheckingEnabled()) {
            this.resolveDefaultStatuses();
            FileHealthCheckBuilder fhc = new FileHealthCheckBuilder(file);
            Set<String> appSet = this.validateApplicationSet();
            HashSet<String> unstartedAppSet = new HashSet<String>();
            this.runHealthChecks(appSet, healthCheckProcedure, unstartedAppSet, status -> fhc.setOverallStatus((HealthCheckResponse.Status)status), x -> fhc.handleUndeterminedResponse(), responses -> fhc.addResponses((Set<HealthCheckResponse>)responses));
            if (this.isAllFilesCreated.get()) {
                fhc.updateFile();
            }
            this.issueMessagesForUnstartedApps(unstartedAppSet, healthCheckProcedure);
            return fhc.getOverallStatus();
        }
        return null;
    }

    public void issueMessagesForUnstartedApps(Set<String> unstartedAppsSet, String healthCheckProcedure) {
        if (unstartedAppsSet.isEmpty()) {
            this.unstartedAppsCounter.set(0);
        } else if (!unstartedAppsSet.isEmpty() && this.unstartedAppsCounter.get() != unstartedAppsSet.size()) {
            this.unstartedAppsCounter.set(unstartedAppsSet.size());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): numOfUnstartedApps after unstarted app set was updated. = " + this.unstartedAppsCounter.get()), (Object[])new Object[0]);
            }
            if (!unstartedAppsSet.isEmpty()) {
                this.readinessWarningAlreadyShown.set(false);
                this.startupWarningAlreadyShown.set(false);
            } else {
                this.readinessWarningAlreadyShown.set(true);
                this.startupWarningAlreadyShown.set(true);
            }
        }
        if (!unstartedAppsSet.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): numOfUnstartedApps = " + this.unstartedAppsCounter.get()), (Object[])new Object[0]);
            }
            if (healthCheckProcedure.equals("START") && this.startupWarningAlreadyShown.compareAndSet(false, true) && !DEFAULT_STARTUP_STATUS.equals((Object)HealthCheckResponse.Status.UP)) {
                Tr.warning((TraceComponent)tc, (String)"startup.healthcheck.applications.not.started.down.CWMMH0054W", (Object[])new Object[]{unstartedAppsSet});
            } else if (healthCheckProcedure.equals("READY") && this.readinessWarningAlreadyShown.compareAndSet(false, true) && !DEFAULT_READINESS_STATUS.equals((Object)HealthCheckResponse.Status.UP)) {
                Tr.warning((TraceComponent)tc, (String)"readiness.healthcheck.applications.not.started.down.CWMMH0053W", (Object[])new Object[]{unstartedAppsSet});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void runHealthChecks(Set<String> appSet, String healthCheckProcedure, Set<String> unstartedAppsSet, Consumer<HealthCheckResponse.Status> setOverallStatusFx, Consumer<T> handleUndeterminedFx, Consumer<Set<HealthCheckResponse>> evaluatedStatusFx) {
        Set<HealthCheckResponse> hcResponses = null;
        boolean anyAppsInstalled = false;
        for (String appName : appSet) {
            if (this.appTracker.isInstalled(appName)) {
                anyAppsInstalled = true;
                if (healthCheckProcedure.equals("LIVE") || unstartedAppsSet.contains(appName)) continue;
                unstartedAppsSet.add(appName);
                continue;
            }
            if (!this.appTracker.isUninstalled(appName) && !this.appTracker.isStarted(appName)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): Application : " + appName + " has not started yet."), (Object[])new Object[0]);
                }
                if (!healthCheckProcedure.equals("LIVE")) {
                    if (healthCheckProcedure.equals("START")) {
                        setOverallStatusFx.accept(DEFAULT_STARTUP_STATUS);
                    } else if (healthCheckProcedure.equals("READY")) {
                        setOverallStatusFx.accept(DEFAULT_READINESS_STATUS);
                    } else {
                        setOverallStatusFx.accept(DEFAULT_STARTUP_STATUS.equals((Object)HealthCheckResponse.Status.UP) && DEFAULT_READINESS_STATUS.equals((Object)HealthCheckResponse.Status.UP) ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN);
                    }
                    if (!unstartedAppsSet.contains(appName)) {
                        unstartedAppsSet.add(appName);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): unstartedAppsSet after adding the unstarted app : " + unstartedAppsSet), (Object[])new Object[0]);
                    continue;
                }
                setOverallStatusFx.accept(HealthCheckResponse.Status.UP);
                continue;
            }
            Set<String> modules = this.appTracker.getModuleNames(appName);
            if (modules == null) continue;
            for (String moduleName : modules) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                }
                try {
                    if (!this.stoppingApplication.contains(appName)) {
                        hcResponses = this.hcExecutor.runHealthChecks(appName, moduleName, healthCheckProcedure);
                    }
                }
                catch (HealthCheckBeanCallException healthCheckBeanCallException) {
                    FFDCFilter.processException((Throwable)healthCheckBeanCallException, (String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl", (String)"784", (Object)this, (Object[])new Object[]{appSet, healthCheckProcedure, unstartedAppsSet, setOverallStatusFx, handleUndeterminedFx, evaluatedStatusFx});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): Caught the exception " + e + " for appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                    }
                    handleUndeterminedFx.accept(null);
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): hcResponses = " + hcResponses), (Object[])new Object[0]);
                }
                if (hcResponses == null || hcResponses.isEmpty()) continue;
                evaluatedStatusFx.accept(hcResponses);
            }
        }
        if (anyAppsInstalled && !healthCheckProcedure.equals("LIVE")) {
            setOverallStatusFx.accept(HealthCheckResponse.Status.DOWN);
        }
    }

    @Override
    public void removeModuleReferences(String appName, String moduleName) {
        if (this.hcExecutor != null) {
            this.hcExecutor.removeModuleReferences(appName, moduleName);
        }
    }

    public void stoppingApplication(String appName) {
        this.stoppingApplication.add(appName);
    }

    public void startedApplication(String appName) {
        this.stoppingApplication.remove(appName);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class StartedFileCreateProcess
    extends TimerTask {
        File startFile = HealthFileUtils.getStartFile();
        String healthCheckProcedure = "START";
        static final long serialVersionUID = 3274425009583215678L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public void run() {
            HealthCheckResponse.Status retStatus = HealthCheck40ServiceImpl.this.performFileHealthCheck(this.startFile, this.healthCheckProcedure);
            if (retStatus.equals((Object)HealthCheckResponse.Status.UP)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("First UP Status resolved for the health check procedure: " + this.healthCheckProcedure), (Object[])new Object[0]);
                }
                this.cancel();
                HealthCheck40ServiceImpl.this.startLiveFileCreateHealthCheckProcess();
                HealthCheck40ServiceImpl.this.startReadyFileCreateHealthCheckProcess();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl$StartedFileCreateProcess", StartedFileCreateProcess.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class FileCreateProcess
    extends TimerTask {
        File file;
        String healthCheckProcedure;
        static final long serialVersionUID = -2859525810529808775L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileCreateProcess(File file, String healthCheckProcedure) {
            this.file = file;
            this.healthCheckProcedure = healthCheckProcedure;
        }

        @Override
        public void run() {
            HealthCheckResponse.Status retStatus = HealthCheck40ServiceImpl.this.performFileHealthCheck(this.file, this.healthCheckProcedure);
            if (retStatus.equals((Object)HealthCheckResponse.Status.UP)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("First UP Status resolved for the health check procedure: " + this.healthCheckProcedure), (Object[])new Object[0]);
                }
                this.cancel();
                HealthCheck40ServiceImpl.this.reportUpStatusFor(this.healthCheckProcedure);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl$FileCreateProcess", FileCreateProcess.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class FileUpdateProcess
    extends TimerTask {
        File file;
        String healthCheckProcedure;
        static final long serialVersionUID = 5953665100363085987L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileUpdateProcess(File file, String healthCheckProcedure) {
            this.file = file;
            this.healthCheckProcedure = healthCheckProcedure;
        }

        @Override
        public void run() {
            HealthCheck40ServiceImpl.this.performFileHealthCheck(this.file, this.healthCheckProcedure);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl$FileUpdateProcess", FileUpdateProcess.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
        }
    }
}

