/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.naming;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.NotContextException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JavaColonNamespaceBindings<T>
extends HashMap<String, T> {
    private final NamingConstants.JavaColonNamespace namespace;
    private final ClassNameProvider<T> classNameProvider;
    private volatile Map<String, Map<String, NameClassPair>> contextBindings;
    private volatile Set<String> contexts;
    static final long serialVersionUID = -4020308321774505943L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    static String getContextName(String name) {
        int index = name.lastIndexOf(47);
        return index == -1 ? "" : name.substring(0, index);
    }

    public JavaColonNamespaceBindings(NamingConstants.JavaColonNamespace namespace, ClassNameProvider<T> nameProvider) {
        this.namespace = namespace;
        this.classNameProvider = nameProvider;
    }

    public void bind(String name, T binding) {
        Set<String> contexts;
        this.put(name, binding);
        Map<String, Map<String, NameClassPair>> bindingsByContext = this.contextBindings;
        if (bindingsByContext != null) {
            this.addContextBinding(bindingsByContext, name, binding);
        }
        if ((contexts = this.contexts) != null) {
            contexts.add(JavaColonNamespaceBindings.getContextName(name));
        }
    }

    public void unbind(String name) {
        super.remove(name);
        this.contextBindings = null;
        this.contexts = null;
    }

    public T lookup(String name) throws NamingException {
        Object binding = super.get(name);
        if (binding != null) {
            return (T)binding;
        }
        String contextName = name;
        while (!(contextName = JavaColonNamespaceBindings.getContextName(contextName)).isEmpty()) {
            if (!this.containsKey(contextName)) continue;
            throw new NotContextException((Object)((Object)this.namespace) + "/" + contextName);
        }
        return null;
    }

    public boolean hasObjectWithPrefix(String contextName) throws NamingException {
        return this.getContexts().contains(contextName);
    }

    private Set<String> getContexts() {
        Set<String> contexts = this.contexts;
        if (contexts == null) {
            this.contexts = contexts = this.createContexts();
        }
        return contexts;
    }

    private Set<String> createContexts() {
        HashSet<String> contexts = new HashSet<String>(4, 0.9f);
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            String contextName = name = (String)iterator.next();
            while (contexts.add(contextName = JavaColonNamespaceBindings.getContextName(contextName))) {
            }
        }
        return contexts;
    }

    public Collection<? extends NameClassPair> listInstances(String contextName) throws NamingException {
        Map<String, NameClassPair> bindings = this.getBindingsByContext().get(contextName);
        if (bindings != null) {
            return bindings.values();
        }
        do {
            if (!this.containsKey(contextName)) continue;
            throw new NotContextException((Object)((Object)this.namespace) + "/" + contextName);
        } while (!(contextName = JavaColonNamespaceBindings.getContextName(contextName)).isEmpty());
        return Collections.emptyList();
    }

    private Map<String, Map<String, NameClassPair>> getBindingsByContext() {
        Map<String, Map<String, NameClassPair>> bindingsByContext = this.contextBindings;
        if (bindingsByContext == null) {
            this.contextBindings = bindingsByContext = this.createBindingsByContext();
        }
        return bindingsByContext;
    }

    private Map<String, Map<String, NameClassPair>> createBindingsByContext() {
        HashMap<String, Map<String, NameClassPair>> bindingsByContext = new HashMap<String, Map<String, NameClassPair>>(4, 0.9f);
        for (Map.Entry entry : this.entrySet()) {
            String name = (String)entry.getKey();
            Object binding = entry.getValue();
            this.addContextBinding(bindingsByContext, name, binding);
        }
        return bindingsByContext;
    }

    private void addContextBinding(Map<String, Map<String, NameClassPair>> bindingsByContext, String nameInNamespace, T binding) {
        String className = this.classNameProvider.getBindingClassName(binding);
        boolean context = false;
        while (true) {
            String name;
            String contextName;
            int index;
            if ((index = nameInNamespace.lastIndexOf(47)) == -1) {
                contextName = "";
                name = nameInNamespace;
            } else {
                contextName = nameInNamespace.substring(0, index);
                name = nameInNamespace.substring(index + 1);
            }
            Map<String, NameClassPair> bindings = bindingsByContext.get(contextName);
            if (bindings == null) {
                bindings = new HashMap<String, NameClassPair>(4, 0.9f);
                bindingsByContext.put(contextName, bindings);
            } else if (context && bindings.containsKey(name)) {
                return;
            }
            bindings.put(name, new NameClassPair(name, className));
            if (contextName.isEmpty()) {
                return;
            }
            nameInNamespace = contextName;
            className = Context.class.getName();
            context = true;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.naming.JavaColonNamespaceBindings", JavaColonNamespaceBindings.class, (String)"Naming", null);
    }

    public static interface ClassNameProvider<T> {
        public String getBindingClassName(T var1);
    }
}

