/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.ute.UTEHelperFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class JmsErrorUtils {
    private static TraceComponent tc = SibTr.register(JmsErrorUtils.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final boolean filterStack = true;
    private static final String className = JmsErrorUtils.class.getName();

    static Throwable newThrowable(Class throwableClass, String messageKey, Object[] messageInserts, Throwable caughtThrowable, String probeId, Object caller, TraceComponent traceComponent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newThrowable", (Object)new Object[]{throwableClass, messageKey, caughtThrowable, probeId, caller});
        }
        Throwable t = null;
        try {
            if (UTEHelperFactory.jmsTestEnvironmentEnabled) {
                String defaultIfMissing = "XXX_MISSING_XXX";
                String msg = nls.getFormattedMessage(messageKey, messageInserts, defaultIfMissing);
                if (defaultIfMissing.equals(msg)) {
                    throw new IllegalArgumentException("The message key " + messageKey + " does not exist.");
                }
                int numInserts = JmsErrorUtils.getNumberOfInserts(messageKey);
                int gotInserts = 0;
                if (messageInserts != null) {
                    gotInserts = messageInserts.length;
                }
                if (numInserts != gotInserts) {
                    throw new IllegalArgumentException("Expected " + numInserts + " for " + messageKey + " but got " + gotInserts);
                }
            }
            if (!Throwable.class.isAssignableFrom(throwableClass)) {
                RuntimeException re = new RuntimeException("JmsErrorUtils.newThrowable#1");
                FFDCFilter.processException((Throwable)re, (String)"JmsErrorUtils.newThrowable", (String)"JmsErrorUtils.newThrowable#1");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"exception : ", (Object)re);
                }
                throw re;
            }
            boolean wantJMSExceptionOrSubclass = JMSException.class.isAssignableFrom(throwableClass);
            Constructor throwableConstructor = null;
            try {
                throwableConstructor = wantJMSExceptionOrSubclass ? throwableClass.getConstructor(String.class, String.class) : throwableClass.getConstructor(String.class);
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException("JmsErrorUtils.newThrowable#2");
                re.initCause(e);
                FFDCFilter.processException((Throwable)re, (String)"JmsErrorUtils.newThrowable", (String)"JmsErrorUtils.newThrowable#2");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"exception : ", (Object)re);
                }
                throw re;
            }
            String reason = nls.getFormattedMessage(messageKey, messageInserts, null);
            String errorCode = null;
            if (messageKey.length() >= 9) {
                errorCode = messageKey.substring(messageKey.length() - 9);
            }
            try {
                t = wantJMSExceptionOrSubclass ? (Throwable)throwableConstructor.newInstance(reason, errorCode) : (Throwable)throwableConstructor.newInstance(reason);
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException("JmsErrorUtils.newThrowable#3");
                re.initCause(e);
                FFDCFilter.processException((Throwable)re, (String)"JmsErrorUtils.newThrowable", (String)"JmsErrorUtils.newThrowable#3");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"exception : ", (Object)re);
                }
                throw re;
            }
            if (caughtThrowable instanceof Exception && wantJMSExceptionOrSubclass) {
                Exception caughtException = (Exception)caughtThrowable;
                ((JMSException)t).setLinkedException(caughtException);
            }
            if (caughtThrowable != null) {
                t.initCause(caughtThrowable);
            }
            JmsErrorUtils.filterThrowable(t);
            if (traceComponent != null && TraceComponent.isAnyTracingEnabled() && traceComponent.isDebugEnabled()) {
                SibTr.debug((TraceComponent)traceComponent, (String)"throwable : ", (Object)t);
            }
            if (probeId != null) {
                String sourceId = "";
                int index = probeId.indexOf(35);
                sourceId = index == -1 ? probeId : probeId.substring(0, index);
                Throwable foo = caughtThrowable != null ? caughtThrowable : t;
                if (caller != null) {
                    FFDCFilter.processException((Throwable)foo, (String)sourceId, (String)probeId, (Object)caller);
                } else {
                    FFDCFilter.processException((Throwable)foo, (String)sourceId, (String)probeId);
                }
            }
        }
        catch (RuntimeException re) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"caught : ", (Object)re);
            }
            FFDCFilter.processException((Throwable)re, (String)"JmsErrorUtils.newThrowable", (String)"newThrowable#4");
            throw re;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newThrowable", (Object)t);
        }
        return t;
    }

    private static int getNumberOfInserts(String messageKey) {
        String unInsertedMessage = nls.getString(messageKey);
        int numInserts = 0;
        for (int i = 0; i < 20 && unInsertedMessage.indexOf("{" + i + "}") != -1; ++i) {
            ++numInserts;
        }
        return numInserts;
    }

    static Throwable newThrowable(Class throwableClass, String messageKey, Object[] messageInserts, TraceComponent traceComponent) {
        return JmsErrorUtils.newThrowable(throwableClass, messageKey, messageInserts, null, null, null, traceComponent);
    }

    protected static String getFirstApplicationStackString() {
        String val = null;
        Exception e = new Exception();
        StackTraceElement[] ste = e.getStackTrace();
        String jmsImplPackageName = JmsErrorUtils.class.getPackage().getName();
        for (int i = 1; i < ste.length; ++i) {
            String recordClassName = ste[i].getClassName();
            if (recordClassName.startsWith(jmsImplPackageName)) continue;
            val = ste[i].toString();
            break;
        }
        return val;
    }

    private static void filterThrowable(Throwable t) {
        StackTraceElement[] stackLines = t.getStackTrace();
        if (stackLines != null && stackLines.length > 1) {
            Vector<StackTraceElement> v = new Vector<StackTraceElement>();
            boolean euStarted = false;
            int index = 0;
            for (index = 0; index < stackLines.length; ++index) {
                StackTraceElement ste = stackLines[index];
                if (className.equals(ste.getClassName())) {
                    euStarted = true;
                    continue;
                }
                if (!euStarted) continue;
                v.add(ste);
            }
            if (v.size() != 0) {
                StackTraceElement[] filteredSTE = new StackTraceElement[v.size()];
                for (int i = 0; i < filteredSTE.length; ++i) {
                    filteredSTE[i] = (StackTraceElement)v.elementAt(i);
                }
                t.setStackTrace(filteredSTE);
            }
        }
    }

    public static Throwable getJMS2Exception(JMSException jmse, Class exceptionToBeThrown) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJMS2Exceptions", (Object)new Object[]{jmse, exceptionToBeThrown});
        }
        JMSRuntimeException jmsre = null;
        try {
            jmsre = (JMSRuntimeException)exceptionToBeThrown.getConstructor(String.class, String.class, Throwable.class).newInstance(jmse.getMessage(), jmse.getErrorCode(), jmse.getLinkedException());
        }
        catch (Exception e) {
            try {
                RuntimeException re = new RuntimeException("JmsErrorUtils.newThrowable#5", e);
                re.initCause(jmse);
                FFDCFilter.processException((Throwable)re, (String)"JmsErrorUtils.newThrowable", (String)"JmsErrorUtils.newThrowable#5");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"exception : ", (Object)re);
                }
                throw re;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getJMS2Exceptions", jmsre);
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJMS2Exceptions", (Object)jmsre);
        }
        return jmsre;
    }
}

