/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.internal.InstallLicenseImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.asset.InstallAsset;
import com.ibm.ws.install.internal.asset.SubsytemEntry;
import com.ibm.ws.install.repository.FeatureAsset;
import com.ibm.ws.install.repository.FeatureCollectionAsset;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.cmdline.ThirdPartyLicenseProvider;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.ZipLicenseProvider;

public class ESABaseAsset
extends InstallAsset
implements FeatureAsset,
FeatureCollectionAsset {
    protected String featureName;
    protected String shortName;
    protected String repoType;
    protected SubsytemEntry subsystemEntry = null;
    protected ProvisioningFeatureDefinition featureDefinition = null;
    protected LicenseProvider licenseProvider;
    protected Map<Locale, InstallLicense> licenseMap;
    protected ZipFile zip;

    public ESABaseAsset(String id, String featureName, String repoType, File assetFile, boolean isTemporary) throws ZipException, IOException {
        super(id, assetFile, isTemporary);
        this.featureName = featureName;
        this.repoType = repoType;
        if (assetFile != null) {
            this.zip = new ZipFile(assetFile);
            this.subsystemEntry = new SubsytemEntry(this.zip);
            ZipEntry subsystemEntry = this.subsystemEntry.getSubsystemEntry();
            if (subsystemEntry != null) {
                this.featureDefinition = new SubsystemFeatureDefinitionImpl(this.getRepoType(repoType), this.zip.getInputStream(subsystemEntry));
                this.shortName = InstallUtils.getShortName(this.featureDefinition);
            }
        }
    }

    public ESABaseAsset(File assetFile, String repoType, boolean temporary) throws ZipException, IOException {
        super(assetFile, temporary);
        this.zip = new ZipFile(assetFile);
        this.repoType = repoType;
        this.subsystemEntry = new SubsytemEntry(this.zip);
        ZipEntry subsystemEntry = this.subsystemEntry.getSubsystemEntry();
        if (subsystemEntry != null) {
            this.featureDefinition = new SubsystemFeatureDefinitionImpl(this.getRepoType(repoType), this.zip.getInputStream(subsystemEntry));
            this.featureName = this.featureDefinition.getSymbolicName();
            this.shortName = InstallUtils.getShortName(this.featureDefinition);
            this.setName(this.shortName == null ? this.featureName : this.shortName);
        } else {
            this.featureName = null;
            this.shortName = null;
        }
    }

    public ESABaseAsset(ZipFile indexZip, String featureName, String repoType, boolean temporary) throws IOException {
        super(temporary);
        this.zip = indexZip;
        this.repoType = repoType;
        this.subsystemEntry = new SubsytemEntry(this.zip, featureName);
        ZipEntry subsystemEntry = this.subsystemEntry.getSubsystemEntry();
        if (subsystemEntry != null) {
            this.featureDefinition = new SubsystemFeatureDefinitionImpl(this.getRepoType(repoType), this.zip.getInputStream(subsystemEntry));
            this.featureName = this.featureDefinition.getSymbolicName();
            this.shortName = InstallUtils.getShortName(this.featureDefinition);
            this.setName(this.shortName == null ? this.featureName : this.shortName);
        } else {
            this.featureName = null;
            this.shortName = null;
        }
    }

    protected String getRepoType(String toVal) {
        if (toVal == null || "usr".equals(toVal)) {
            return "usr";
        }
        if ("core".equals(toVal)) {
            return "";
        }
        return toVal;
    }

    protected LicenseProvider createLicenseProvider(String licenseAgreementPrefix, String licenseInformationPrefix, String subsystemLicenseType) {
        if (licenseInformationPrefix == null) {
            LicenseProvider lp = ZipLicenseProvider.createInstance((ZipFile)this.zip, (String)licenseAgreementPrefix);
            if (lp != null) {
                return lp;
            }
        } else {
            ReturnCode licenseReturnCode = ZipLicenseProvider.buildInstance((ZipFile)this.zip, (String)licenseAgreementPrefix, (String)licenseInformationPrefix);
            if (licenseReturnCode == ReturnCode.OK) {
                return ZipLicenseProvider.getInstance();
            }
        }
        if (subsystemLicenseType != null && subsystemLicenseType.length() > 0) {
            return new ThirdPartyLicenseProvider(this.featureDefinition.getFeatureName(), subsystemLicenseType);
        }
        return null;
    }

    protected String getHeader(String header, Locale locale) {
        ResourceBundle rb;
        String value = this.featureDefinition.getHeader(header);
        if (value == null || value.isEmpty() || locale == null) {
            return value;
        }
        if (value.charAt(0) == '%' && (rb = this.getResourceBundle(locale)) != null) {
            value = rb.getString(value.substring(1));
        }
        return value;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        try {
            ZipEntry entry = this.getEntry("OSGI-INF/l10n/subsystem_" + locale.getLanguage() + ".properties");
            if (entry == null) {
                entry = this.getEntry("OSGI-INF/l10n/subsystem.properties");
            }
            if (entry != null) {
                return new PropertyResourceBundle(this.getInputStream(entry));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean isAutoFeature() {
        return this.featureDefinition != null & this.featureDefinition.isAutoFeature();
    }

    public boolean isPublic() {
        return this.featureDefinition.getVisibility() == Visibility.PUBLIC || this.featureDefinition.getVisibility() == Visibility.INSTALL;
    }

    @Override
    public boolean isAddon() {
        return this.featureDefinition.getVisibility() == Visibility.INSTALL;
    }

    public boolean installWhenSatisfied() {
        String installPolicy = this.featureDefinition.getHeader("IBM-Install-Policy");
        return installPolicy != null && "when-satisfied".equals(installPolicy);
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getRepoType() {
        return this.repoType;
    }

    public void setRepoType(String repoType) throws IOException {
        if (this.repoType == null ? repoType == null : this.repoType.equalsIgnoreCase(repoType)) {
            return;
        }
        this.repoType = repoType;
        this.featureDefinition = new SubsystemFeatureDefinitionImpl(this.getRepoType(repoType), this.zip.getInputStream(this.subsystemEntry.getSubsystemEntry()));
    }

    public ProvisioningFeatureDefinition getProvisioningFeatureDefinition() {
        return this.featureDefinition;
    }

    public ZipEntry getEntry(String name) {
        return this.zip.getEntry(name);
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.zip.getInputStream(entry);
    }

    public ZipEntry getSubsystemEntry() {
        return this.subsystemEntry != null ? this.subsystemEntry.getSubsystemEntry() : null;
    }

    public String getSubsystemEntryName() {
        return this.subsystemEntry != null ? this.subsystemEntry.getSubsystemEntryName() : null;
    }

    public String getLicenseId() {
        return this.featureDefinition.getHeader("Subsystem-License");
    }

    public boolean matchFeature(String feature) {
        return this.featureName != null && this.featureName.equals(feature) || this.getName() != null && this.getName().equalsIgnoreCase(feature);
    }

    public LicenseProvider getLicenseProvider(Locale locale) {
        if (this.licenseProvider == null) {
            String licenseAgreementPrefix = this.featureDefinition.getHeader("IBM-License-Agreement");
            String licenseInformationPrefix = this.featureDefinition.getHeader("IBM-License-Information");
            this.licenseProvider = this.createLicenseProvider(licenseAgreementPrefix, licenseInformationPrefix, this.getLicenseId());
        }
        return this.licenseProvider;
    }

    @Override
    public boolean isFeature() {
        return true;
    }

    @Override
    public String installedLogMsg() {
        return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALLED_FEATURE", this.getDisplayName()).replaceAll("CWWKF1304I:", "").trim();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getProvideFeature() {
        String manifestSymbolicName = this.featureDefinition.getHeader("Subsystem-SymbolicName");
        int i = manifestSymbolicName.indexOf(";");
        if (i >= 0) {
            manifestSymbolicName = manifestSymbolicName.substring(0, i);
        }
        return manifestSymbolicName.trim();
    }

    @Override
    public Collection<String> getRequireFeature() {
        ArrayList<String> requireFeatures = new ArrayList<String>();
        for (FeatureResource fr : this.featureDefinition.getConstituents(null)) {
            SubsystemContentType type = fr.getType();
            if (SubsystemContentType.FEATURE_TYPE != type) continue;
            requireFeatures.add(fr.getSymbolicName());
        }
        return requireFeatures;
    }

    @Override
    public String getDisplayName(Locale locale) {
        String displayName = this.getHeader("Subsystem-Name", locale);
        if (displayName == null && (displayName = this.getHeader("Subsystem-Name", new Locale(locale.getLanguage()))) == null) {
            displayName = this.getHeader("Subsystem-Name", Locale.ENGLISH);
        }
        if (displayName != null && !displayName.isEmpty() && !displayName.equalsIgnoreCase("%name")) {
            return displayName;
        }
        displayName = this.getShortName();
        if (displayName != null && !displayName.isEmpty()) {
            return displayName;
        }
        return this.featureName;
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayName(Locale.ENGLISH);
    }

    @Override
    public String getId() {
        return this.featureName;
    }

    @Override
    public String getDescription(Locale locale) {
        String description = this.getHeader("Subsystem-Description", locale);
        if (description == null && (description = this.getHeader("Subsystem-Description", new Locale(locale.getLanguage()))) == null) {
            description = this.getHeader("Subsystem-Description", Locale.ENGLISH);
        }
        return description;
    }

    @Override
    public String getDescription() {
        return this.getDescription(Locale.ENGLISH);
    }

    @Override
    public InstallLicense getLicense(Locale locale) {
        if (this.licenseMap == null) {
            this.licenseMap = new HashMap<Locale, InstallLicense>();
        }
        if (this.licenseMap.containsKey(locale)) {
            return this.licenseMap.get(locale);
        }
        String licenseId = this.getLicenseId();
        if (licenseId != null && !licenseId.isEmpty()) {
            InstallLicenseImpl ili = new InstallLicenseImpl(licenseId, null, this.getLicenseProvider(locale), false);
            ili.addFeature(this.getProvideFeature());
            this.licenseMap.put(locale, ili);
            return ili;
        }
        return null;
    }

    @Override
    public InstallLicense getLicense() {
        return this.getLicense(Locale.ENGLISH);
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public void delete() {
        InstallUtils.close(this.zip);
        super.delete();
    }
}

