/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.outbound.HttpOSCReadCallback;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCReadAhead
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCReadAhead.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final HttpOSCReadAhead myInstance = new HttpOSCReadAhead();

    private HttpOSCReadAhead() {
    }

    public static final HttpOSCReadAhead getRef() {
        return myInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        int state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: vc=" + vc), (Object[])new Object[0]);
        }
        HttpOutboundServiceContextImpl osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        osc.markReadCancelFailure();
        Object object = osc.stateSyncObject;
        synchronized (object) {
            state = osc.getReadState();
            osc.setCallbackState(4, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Read-ahead state: " + state), (Object[])new Object[0]);
        }
        switch (state) {
            case 0: {
                IOException ioe = new IOException("Unexpected read complete");
                osc.getAppReadCallback().error(vc, (Throwable)ioe);
                break;
            }
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error: Read-ahead completed after init() call.", (Object[])new Object[0]);
                }
                osc.setCallbackState(2, new IOException("Invalid read-ahead data"));
                break;
            }
            case 3: {
                osc.wakeupReadAhead();
                break;
            }
            case 4: {
                HttpOSCReadCallback.getRef().complete(vc, rsc);
                break;
            }
            default: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Unexpected read-ahead state: " + state), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        int state;
        HttpOutboundServiceContextImpl osc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: vc=" + vc + " ioe=" + ioe), (Object[])new Object[0]);
        }
        if ((osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).markReadCancelSuccess()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring error callback on canceled read", (Object[])new Object[0]);
            }
            return;
        }
        Object object = osc.stateSyncObject;
        synchronized (object) {
            state = osc.getReadState();
            osc.setCallbackState(2, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Read-ahead state: " + state), (Object[])new Object[0]);
        }
        switch (state) {
            case 0: {
                osc.getAppReadCallback().error(vc, (Throwable)ioe);
                break;
            }
            case 1: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"Received the read-ahead immed timeout.", (Object[])new Object[0]);
                break;
            }
            case 3: {
                osc.wakeupReadAhead();
                break;
            }
            case 4: {
                osc.setPersistent(false);
                osc.reConnect(vc, ioe);
                break;
            }
            default: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Unexpected read-ahead state: " + state), (Object[])new Object[0]);
            }
        }
    }
}

