/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.BaseLocalizationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.QualifiedDestinationName;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.impl.AbstractBaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PtoPInputHandler;
import com.ibm.ws.sib.processor.impl.PubSubInputHandler;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ReportHandler;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.destination.AbstractProtoRealization;
import com.ibm.ws.sib.processor.impl.destination.JSPtoPRealization;
import com.ibm.ws.sib.processor.impl.destination.LocalisationManager;
import com.ibm.ws.sib.processor.impl.destination.PubSubRealization;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionIndex;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.LocalizationPoint;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.PtoPRealization;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProxyReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SourceProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetProtocolItemStream;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.impl.AnycastInputControl;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.MPRuntimeEvent;
import com.ibm.ws.sib.processor.runtime.impl.Queue;
import com.ibm.ws.sib.processor.runtime.impl.RemoteQueuePoint;
import com.ibm.ws.sib.processor.runtime.impl.Topicspace;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINonDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BaseDestinationHandler
extends AbstractBaseDestinationHandler
implements MessageEventListener {
    private static final TraceComponent tc = SibTr.register(BaseDestinationHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc_cwsik = SibTr.register(new Object(){}.getClass(), (String)"SIBProcessor", (String)"com.ibm.websphere.sib.CWSIKMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private String _name = null;
    private Index _remoteQueuePoints = null;
    private ExceptionDestinationHandlerImpl _exceptionDestination = null;
    private boolean _hasReconciledStreamsToBeDeleted = false;
    private volatile boolean _toBeDeleted = false;
    private boolean _deleteInProgress = false;
    private boolean _toBeIgnored;
    protected boolean _isCorruptOrIndoubt;
    private boolean _isTemporary = false;
    boolean _isToBeReallocated = false;
    private boolean _reconciled = true;
    private ReportHandler _reportHandler = null;
    private boolean _isSystem;
    private boolean _isOrderingRequired;
    private boolean _isUnableToOrder;
    private List<SIDestinationAddress> _forwardRoutingPath = null;
    private JsDestinationAddress _replyDestination = null;
    private boolean _replySet = false;
    private JsDestinationAddress _destinationAddr = null;
    private boolean _singleServer;
    private PubSubRealization _pubSubRealization = null;
    protected JSPtoPRealization _ptoPRealization = null;
    protected AbstractProtoRealization _protoRealization = null;
    protected LocalisationManager _localisationManager = null;
    protected Object readyConsumerPointLock = new Object();

    public BaseDestinationHandler() {
    }

    protected BaseDestinationHandler(DestinationDefinition myDestinationDefinition, MessageProcessor messageProcessor, SIMPItemStream parentItemStream, TransactionCommon transaction, HashMap<String, Object> durableSubscriptionsTable, String busName) throws SIResourceException {
        super(messageProcessor, myDestinationDefinition, busName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)new Object[]{myDestinationDefinition, messageProcessor, parentItemStream, transaction, durableSubscriptionsTable, busName});
        }
        transaction.registerCallback((TransactionCallback)new DestinationAddTransactionCallback());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Creating " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName() + "on bus " + busName));
        }
        this.setIsOrdered(myDestinationDefinition.isOrderingRequired());
        this._name = myDestinationDefinition.getName();
        this._destinationAddr = SIMPUtils.createJsDestinationAddress(this._name, null, this.getBus());
        if (this._name.startsWith("_Q") || this._name.startsWith("_T")) {
            this._isTemporary = true;
            this._isSystem = false;
            this.setStorageStrategy(2);
        } else {
            this._isTemporary = false;
            this._isSystem = this._name.startsWith("_P");
            this.setStorageStrategy(4);
        }
        try {
            Transaction msTran = messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
            parentItemStream.addItemStream(this, msTran);
            this.createRealizationAndState(messageProcessor, transaction);
            if (this.isPubSub()) {
                this.createControlAdapter();
            }
            this._protoRealization.getRemoteSupport().createGDProtocolItemStreams(transaction);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.BaseDestinationHandler", (String)"1:485:1.700.3.45", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        this.initializeNonPersistent(messageProcessor, durableSubscriptionsTable, transaction);
        this._forwardRoutingPath = null;
        QualifiedDestinationName[] names = this.definition.getForwardRoutingPath();
        if (names != null) {
            this._forwardRoutingPath = new ArrayList<SIDestinationAddress>(names.length);
            for (int name = 0; name < names.length; ++name) {
                this._forwardRoutingPath.add((SIDestinationAddress)SIMPUtils.createJsDestinationAddress(names[name].getDestination(), null, names[name].getBus()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Created " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)this);
        }
    }

    protected BaseDestinationHandler(MessageProcessor messageProcessor, SIMPItemStream parentItemStream, TransactionCommon transaction, HashMap<String, Object> durableSubscriptionsTable, String busName) throws SIResourceException {
        super(messageProcessor, null, busName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)new Object[]{messageProcessor, parentItemStream, transaction, durableSubscriptionsTable, busName});
        }
        transaction.registerCallback((TransactionCallback)new DestinationAddTransactionCallback());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Creating " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName() + "on bus " + busName));
        }
        this._isTemporary = false;
        this._isSystem = false;
        this.setStorageStrategy(4);
        try {
            Transaction msTran = messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
            parentItemStream.addItemStream(this, msTran);
            this.createRealizationAndState(messageProcessor, transaction);
            this._protoRealization.getRemoteSupport().createGDProtocolItemStreams(transaction);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.BaseDestinationHandler", (String)"1:620:1.700.3.45", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        this.initializeNonPersistent(messageProcessor, durableSubscriptionsTable, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Created " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BaseDestinationHandler", (Object)this);
        }
    }

    protected void createRealizationAndState(MessageProcessor messageProcessor, TransactionCommon transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRealizationAndState", (Object)new Object[]{messageProcessor, transaction});
        }
        if (this.isPubSub()) {
            this._pubSubRealization = new PubSubRealization(this, messageProcessor, this.getLocalisationManager(), transaction);
            this._protoRealization = this._pubSubRealization;
        } else {
            this._ptoPRealization = new JSPtoPRealization(this, messageProcessor, this.getLocalisationManager());
            this._protoRealization = this._ptoPRealization;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRealizationAndState");
        }
    }

    protected void createRealizationAndState(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRealizationAndState", (Object)new Object[]{messageProcessor});
        }
        if (this.isPubSub()) {
            this._pubSubRealization = new PubSubRealization(this, messageProcessor, this.getLocalisationManager());
            this._protoRealization = this._pubSubRealization;
        } else {
            this._ptoPRealization = new JSPtoPRealization(this, messageProcessor, this.getLocalisationManager());
            this._protoRealization = this._ptoPRealization;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRealizationAndState");
        }
    }

    void initializeNonPersistent(MessageProcessor messageProcessor, HashMap<String, Object> durableSubscriptionsTable, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)new Object[]{messageProcessor, durableSubscriptionsTable, transaction});
        }
        this._singleServer = messageProcessor.isSingleServer();
        if (this.isPubSub()) {
            this._pubSubRealization.initialise(true, durableSubscriptionsTable);
        } else {
            this._ptoPRealization.initialise();
            this._remoteQueuePoints = new Index();
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    protected void reconstitute(MessageProcessor processor, HashMap<String, Object> durableSubscriptionsTable, int startMode) throws SIResourceException {
        String name;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Object[]{processor, durableSubscriptionsTable, startMode});
        }
        super.reconstitute(processor);
        if (!this.isLink()) {
            this._name = this.getDefinition().getName();
            this._destinationAddr = SIMPUtils.createJsDestinationAddress(this._name, null, this.getBus());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Reconstituting " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName()));
        }
        if ((name = this.getName()).startsWith("_Q") || name.startsWith("_T")) {
            this._isTemporary = true;
            this._isSystem = false;
        } else {
            this._isTemporary = false;
            this._isSystem = name.startsWith("_P");
        }
        try {
            this.createRealizationAndState(this.messageProcessor);
            this._protoRealization.getRemoteSupport().reconstituteGD();
            if (this.isPubSub()) {
                this._reconciled = false;
                this.createControlAdapter();
                this._singleServer = this.messageProcessor.isSingleServer();
                this._pubSubRealization.reconstitute(startMode, durableSubscriptionsTable);
            } else {
                this.initializeNonPersistent(processor, durableSubscriptionsTable, null);
                this._reconciled = false;
                this._ptoPRealization.reconstitute(startMode, this.definition, this.isToBeDeleted(), this.isSystem());
            }
            this._protoRealization.reconstituteGDTargetStreams();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.reconstitute", (String)"1:945:1.700.3.45", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            this._isCorruptOrIndoubt = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)e);
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Reconstituted " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    public void deleteMsgsWithNoReferences() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteMsgsWithNoReferences");
        }
        if (null != this._pubSubRealization) {
            this._pubSubRealization.deleteMsgsWithNoReferences();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteMsgsWithNoReferences");
        }
    }

    private void reconstituteEnoughForDeletion(MessageProcessor processor, HashMap<String, Object> durableSubscriptionsTable) throws MessageStoreException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteEnoughForDeletion", (Object)new Object[]{processor, durableSubscriptionsTable});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Reconstituting for deletion " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName()));
        }
        this.initializeNonPersistent(processor, durableSubscriptionsTable, null);
        this._protoRealization.reconstituteEnoughForDeletion();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Reconstituted for deletion " + (this.isPubSub() ? "pubsub" : "ptp") + " BaseDestinationHandler " + this.getName()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteEnoughForDeletion");
        }
    }

    protected void deleteDirtyTemporary(MessageProcessor processor, HashMap<String, Object> durableSubscriptionsTable) throws SIRollbackException, SIConnectionLostException, MessageStoreException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDirtyTemporary", (Object)new Object[]{processor, durableSubscriptionsTable});
        }
        this.reconstituteEnoughForDeletion(processor, durableSubscriptionsTable);
        LocalTransaction siTran = this.txManager.createLocalTransaction(true);
        this.removeAll((Transaction)siTran);
        siTran.commit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDirtyTemporary");
        }
    }

    @Override
    public InputHandler getInputHandler(ProtocolType type, SIBUuid8 sourceMEUuid, JsMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInputHandler", (Object)new Object[]{type, sourceMEUuid, msg});
        }
        InputHandler msgHandler = null;
        if (type == ProtocolType.UNICASTINPUT) {
            msgHandler = this.getInputHandler();
        } else if (type == ProtocolType.PUBSUBINPUT) {
            msgHandler = this.getInputHandler();
        } else if (type == ProtocolType.ANYCASTINPUT) {
            SIBUuid12 destID = msg.getGuaranteedTargetDestinationDefinitionUUID();
            SIBUuid12 gatheringTargetDestUuid = msg.getGuaranteedGatheringTargetUUID();
            msgHandler = this._protoRealization.getRemoteSupport().getAnycastInputHandlerByPseudoDestId(destID);
            if (msgHandler == null) {
                msgHandler = this.getAnycastInputHandler(sourceMEUuid, gatheringTargetDestUuid, true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInputHandler", (Object)msgHandler);
        }
        return msgHandler;
    }

    @Override
    public OutputHandler choosePtoPOutputHandler(SIBUuid8 fixedMEUuid, SIBUuid8 preferredMEUuid, boolean localMessage, boolean forcePut, HashSet<SIBUuid8> scopedMEs) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)new Object[]{fixedMEUuid, preferredMEUuid, localMessage, forcePut, scopedMEs});
        }
        OutputHandler result = this._protoRealization.choosePtoPOutputHandler(fixedMEUuid, preferredMEUuid, localMessage, forcePut, this._singleServer, scopedMEs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)result);
        }
        return result;
    }

    @Override
    public int checkCanAcceptMessage(SIBUuid8 MEUuid, HashSet<SIBUuid8> scopedMEs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkCanAcceptMessage", (Object)new Object[]{MEUuid, scopedMEs});
        }
        int returnValue = 1;
        if (this.isPubSub()) {
            if (this.getPublishPoint().isQHighLimit()) {
                returnValue = 3;
            }
        } else {
            returnValue = this.checkPtoPOutputHandlers(MEUuid, scopedMEs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkCanAcceptMessage", (Object)returnValue);
        }
        return returnValue;
    }

    @Override
    public int checkPtoPOutputHandlers(SIBUuid8 fixedMEUuid, HashSet<SIBUuid8> scopedMEs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPtoPOutputHandlers", (Object)new Object[]{this, fixedMEUuid, scopedMEs});
        }
        int result = 2;
        if (this.isSendAllowed()) {
            result = 0;
            int localResult = -1;
            boolean checkLocal = false;
            if (this.hasLocal()) {
                if (fixedMEUuid == null && scopedMEs == null) {
                    checkLocal = true;
                } else if (fixedMEUuid != null && fixedMEUuid.equals((Object)this.getMessageProcessor().getMessagingEngineUuid())) {
                    checkLocal = true;
                } else if (scopedMEs != null && scopedMEs.contains(this.getMessageProcessor().getMessagingEngineUuid())) {
                    checkLocal = true;
                }
                if (checkLocal) {
                    localResult = this._ptoPRealization.checkAbleToSend();
                }
            }
            if (!(this._singleServer && !this.isLink() || localResult == 1 || checkLocal && fixedMEUuid != null)) {
                result = this.getLocalisationManager().checkRemoteMessagePointOutputHandlers(fixedMEUuid, scopedMEs);
            }
            if (result == 0 && localResult != -1) {
                result = localResult;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPtoPOutputHandlers", (Object)result);
        }
        return result;
    }

    @Override
    public RemoteConsumerDispatcher getRemoteConsumerDispatcher(SIBUuid8 meId, SIBUuid12 gatheringTargetDestUuid, boolean createAIH) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerDispatcher", (Object)meId);
        }
        AnycastInputHandler aih = this.getAnycastInputHandler(meId, gatheringTargetDestUuid, createAIH);
        RemoteConsumerDispatcher result = null;
        if (aih != null) {
            result = aih.getRCD();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerDispatcher", (Object)result);
        }
        return result;
    }

    public void setHasReconciledStreamsToBeDeleted(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setHasReconciledStreamsToBeDeleted", (Object)value);
        }
        this._hasReconciledStreamsToBeDeleted = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setHasReconciledStreamsToBeDeleted");
        }
    }

    public boolean getHasReconciledStreamsToBeDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHasReconciledStreamsToBeDeleted");
            SibTr.exit((TraceComponent)tc, (String)"getHasReconciledStreamsToBeDeleted", (Object)this._hasReconciledStreamsToBeDeleted);
        }
        return this._hasReconciledStreamsToBeDeleted;
    }

    @Override
    public void notifyReceiveAllowedRCD(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowedRCD", (Object)new Object[]{destinationHandler});
        }
        this._protoRealization.getRemoteSupport().notifyReceiveAllowedRCD(destinationHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowedRCD");
        }
    }

    @Override
    public void notifyRCDReceiveExclusiveChange(boolean isReceiveExclusive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyRCDReceiveExclusiveChange", (Object)new Object[]{isReceiveExclusive});
        }
        if (!this.isPubSub()) {
            if (this._ptoPRealization != null) {
                this._ptoPRealization.getRemoteSupport().notifyRCDReceiveExclusiveChange(isReceiveExclusive);
            }
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:1458:1.700.3.45"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.notifyRCDReceiveExclusiveChange", (String)"1:1463:1.700.3.45", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:1470:1.700.3.45"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"notifyRCDReceiveExclusiveChange", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyRCDReceiveExclusiveChange");
        }
    }

    @Override
    public ControlHandler getControlHandler(ProtocolType type, SIBUuid8 sourceMEUuid, ControlMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlHandler", (Object)new Object[]{type, sourceMEUuid, msg});
        }
        ControlHandler msgHandler = null;
        if (type != ProtocolType.UNICASTINPUT && type != ProtocolType.UNICASTOUTPUT) {
            if (type == ProtocolType.PUBSUBINPUT) {
                msgHandler = (ControlHandler)((Object)this.inputHandler);
            } else if (type == ProtocolType.PUBSUBOUTPUT) {
                msgHandler = this._pubSubRealization.getControlHandler(sourceMEUuid);
            } else if (type == ProtocolType.ANYCASTINPUT) {
                SIBUuid12 destID = msg.getGuaranteedTargetDestinationDefinitionUUID();
                SIBUuid12 gatheringTargetDestUuid = msg.getGuaranteedGatheringTargetUUID();
                if (this.isPubSub()) {
                    msgHandler = this._protoRealization.getRemoteSupport().getAnycastInputHandlerByPseudoDestId(destID);
                }
                if (msgHandler == null) {
                    msgHandler = this.getAnycastInputHandler(sourceMEUuid, gatheringTargetDestUuid, false);
                }
            } else if (type == ProtocolType.ANYCASTOUTPUT) {
                SIBUuid12 destID = msg.getGuaranteedTargetDestinationDefinitionUUID();
                msgHandler = this._protoRealization.getRemoteSupport().getAnycastOutputHandlerByPseudoDestId(destID);
                if (msgHandler == null) {
                    msgHandler = this.getAnycastOutputHandler();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlHandler", msgHandler);
        }
        return msgHandler;
    }

    @Override
    public ConsumerDispatcher getDurableSubscriptionConsumerDispatcher(ConsumerDispatcherState subState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableSubscriptionConsumerDispatcher", (Object)subState);
        }
        ConsumerDispatcher consumerDispatcher = this._pubSubRealization.getDurableSubscriptionConsumerDispatcher(subState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableSubscriptionConsumerDispatcher", (Object)consumerDispatcher);
        }
        return consumerDispatcher;
    }

    @Override
    public ConsumerManager getLocalPtoPConsumerManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalPtoPConsumerManager");
        }
        JSConsumerManager consumerManager = null;
        consumerManager = this._ptoPRealization.getLocalPtoPConsumerManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalPtoPConsumerManager", (Object)consumerManager);
        }
        return consumerManager;
    }

    @Override
    public ConsumerDispatcher createSubscriptionConsumerDispatcher(ConsumerDispatcherState subState) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINonDurableSubscriptionMismatchException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcher", (Object)subState);
        }
        ConsumerDispatcher cd = this._pubSubRealization.createSubscriptionConsumerDispatcher(subState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcher", (Object)cd);
        }
        return cd;
    }

    @Override
    public ConsumerKey createSubscriptionConsumerDispatcherAndAttachCP(LocalConsumerPoint consumerPoint, ConsumerDispatcherState subState) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException, SINonDurableSubscriptionMismatchException, SINotPossibleInCurrentConfigurationException, SIDestinationLockedException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcherAndAttachCP", (Object)new Object[]{consumerPoint, subState});
        }
        ConsumerKey consumerKey = this._pubSubRealization.createSubscriptionConsumerDispatcherAndAttachCP(consumerPoint, subState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcherAndAttachCP", (Object)consumerKey);
        }
        return consumerKey;
    }

    public final synchronized AnycastOutputHandler getAnycastOutputHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastOutputHandler");
        }
        AnycastOutputHandler aoh = null;
        if (this._ptoPRealization != null) {
            aoh = this._ptoPRealization.getAnycastOutputHandler(this.definition, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastOutputHandler", (Object)aoh);
        }
        return aoh;
    }

    @Override
    public PubSubOutputHandler getPubSubOutputHandler(SIBUuid8 neighbourUUID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutputHandler", (Object)neighbourUUID);
        }
        PubSubOutputHandler handler = this._pubSubRealization.getPubSubOutputHandler(neighbourUUID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutputHandler", (Object)handler);
        }
        return handler;
    }

    @Override
    public synchronized PubSubOutputHandler createPubSubOutputHandler(Neighbour neighbour) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPubSubOutputHandler", (Object)new Object[]{neighbour});
        }
        PubSubOutputHandler handler = this._pubSubRealization.createPubSubOutputHandler(neighbour);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPubSubOutputHandler", (Object)handler);
        }
        return handler;
    }

    @Override
    public HashMap getAllPubSubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllPubSubOutputHandlers");
        }
        HashMap<SIBUuid8, PubSubOutputHandler> handlers = this._pubSubRealization.getAllPubSubOutputHandlers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllPubSubOutputHandlers", handlers);
        }
        return handlers;
    }

    public HashMap cloneAllPubSubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cloneAllPubSubOutputHandlers");
        }
        HashMap<SIBUuid8, PubSubOutputHandler> clone = this._pubSubRealization.cloneAllPubSubOutputHandlers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cloneAllPubSubOutputHandlers", clone);
        }
        return clone;
    }

    @Override
    public void unlockPubsubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockPubsubOutputHandlers");
        }
        this._pubSubRealization.unlockPubsubOutputHandlers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockPubsubOutputHandlers");
        }
    }

    @Override
    public synchronized void deletePubSubOutputHandler(SIBUuid8 neighbourUUID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deletePubSubOutputHandler", (Object)neighbourUUID);
        }
        this._pubSubRealization.deletePubSubOutputHandler(neighbourUUID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deletePubSubOutputHandler");
        }
    }

    public synchronized void deleteAllPubSubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAllPubSubOutputHandlers");
        }
        this._pubSubRealization.deleteAllPubSubOutputHandlers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAllPubSubOutputHandlers");
        }
    }

    public void handleRollback(LocalTransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)transaction);
        }
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.handleRollback", (String)"1:1828:1.700.3.45", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    public Object[] getPostReconstitutePseudoIds() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPostReconstitutePseudoIds");
        }
        Object[] result = this._protoRealization.getRemoteSupport().getPostReconstitutePseudoIds();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPostReconstitutePseudoIds", (Object)result);
        }
        return result;
    }

    public void dereferenceSubscriptionConsumerDispatcher(ConsumerDispatcher cd, boolean isNonDurable, boolean callProxyCode) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceSubscriptionConsumerDispatcher", (Object)new Object[]{cd, isNonDurable, callProxyCode});
        }
        this._pubSubRealization.dereferenceSubscriptionConsumerDispatcher(cd, isNonDurable, callProxyCode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceSubscriptionConsumerDispatcher");
        }
    }

    @Override
    public void addConsumerPointMatchTarget(DispatchableKey consumerPointData, SIBUuid8 cmUuid, SelectionCriteria criteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)new Object[]{consumerPointData, criteria});
        }
        this.messageProcessor.getMessageProcessorMatching().addConsumerPointMatchTarget(consumerPointData, this.getUuid(), cmUuid, criteria);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget");
        }
    }

    @Override
    public void removeConsumerPointMatchTarget(DispatchableKey consumerPointData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerPointMatchTarget", (Object)consumerPointData);
        }
        this.messageProcessor.getMessageProcessorMatching().removeConsumerPointMatchTarget(consumerPointData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerPointMatchTarget");
        }
    }

    @Override
    public UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage msg, int exceptionReason, String[] exceptionInserts, TransactionCommon tran) throws SIResourceException {
        return this.handleUndeliverableMessage(msg, exceptionReason, exceptionInserts, tran, null);
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage msg, int exceptionReason, String[] exceptionInserts, TransactionCommon tran, String subscriptionID) throws SIResourceException {
        UndeliverableReturnCode rc;
        block23: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{msg, exceptionReason, exceptionInserts, subscriptionID});
            }
            if (this._exceptionDestination == null) {
                this._exceptionDestination = new ExceptionDestinationHandlerImpl(this);
            }
            boolean tranCreated = false;
            if (tran == null) {
                tran = this.txManager.createLocalTransaction(false);
                tranCreated = true;
            }
            rc = null;
            try {
                rc = this._exceptionDestination.handleUndeliverableMessage(msg, tran, exceptionReason, exceptionInserts, subscriptionID);
                if (rc == UndeliverableReturnCode.OK || rc == UndeliverableReturnCode.DISCARD) {
                    try {
                        if (msg.isInStore()) {
                            Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction(tran);
                            if (rc == UndeliverableReturnCode.DISCARD) {
                                SibTr.info((TraceComponent)tc, (String)"DISCARD_MESSAGE_INFO_CWSIP00216", (Object)new Object[]{msg.getID()});
                            }
                            msg.remove(msTran, msg.getLockID());
                        }
                    }
                    catch (MessageStoreException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.handleUndeliverableMessage", (String)"1:2051:1.700.3.45", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2058:1.700.3.45", e, this.getName()});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)((Object)e));
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2070:1.700.3.45", e, this.getName()}, null), (Throwable)e);
                    }
                    try {
                        if (tranCreated) {
                            ((LocalTransaction)tran).commit();
                        }
                        break block23;
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.handleUndeliverableMessage", (String)"1:2087:1.700.3.45", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2094:1.700.3.45", e});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)((Object)e));
                        }
                        if (e instanceof SIRollbackException) {
                            tran = null;
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2109:1.700.3.45", e}, null), (Throwable)e);
                    }
                }
                if ((rc == UndeliverableReturnCode.BLOCK || rc == UndeliverableReturnCode.ERROR) && tranCreated) {
                    this.handleRollback((LocalTransaction)tran);
                }
            }
            catch (SIResourceException e) {
                if (tranCreated) {
                    this.handleRollback((LocalTransaction)tran);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)((Object)e));
                }
                throw e;
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.handleUndeliverableMessage", (String)"1:2145:1.700.3.45", (Object)this);
                if (tranCreated) {
                    this.handleRollback((LocalTransaction)tran);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)e);
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2168:1.700.3.45", e}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingThread() {
        BaseDestinationHandler baseDestinationHandler = this;
        synchronized (baseDestinationHandler) {
            this.notifyAll();
        }
    }

    public void attachPtoPLocalisation(PtoPMessageItemStream ptoPMessageItemStream, boolean localisationIsRemote) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachPtoPLocalisation", (Object)new Object[]{ptoPMessageItemStream, localisationIsRemote});
        }
        this._ptoPRealization.attachPtoPLocalisation(ptoPMessageItemStream, localisationIsRemote);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachPtoPLocalisation");
        }
    }

    protected LocalizationPoint addNewPtoPLocalization(boolean localisationIsRemote, TransactionCommon transaction, SIBUuid8 messagingEngineUuid, LocalizationDefinition destinationLocalizationDefinition, boolean queuePoint) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewPtoPLocalization", (Object)new Object[]{localisationIsRemote, transaction, messagingEngineUuid, destinationLocalizationDefinition, queuePoint});
        }
        if (this._ptoPRealization == null) {
            this._ptoPRealization = new JSPtoPRealization(this, this.messageProcessor, this._localisationManager);
            this._ptoPRealization.initialise();
        }
        LocalizationPoint newMsgItemStream = this._ptoPRealization.addNewPtoPLocalization(localisationIsRemote, transaction, messagingEngineUuid, (BaseLocalizationDefinition)destinationLocalizationDefinition, queuePoint);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewPtoPLocalization", (Object)newMsgItemStream);
        }
        return newMsgItemStream;
    }

    protected void addPubSubLocalisation(LocalizationDefinition destinationLocalizationDefinition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPubSubLocalisation", (Object)new Object[]{destinationLocalizationDefinition});
        }
        this._pubSubRealization.addPubSubLocalisation(destinationLocalizationDefinition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPubSubLocalisation");
        }
    }

    public void assignQueuePointOutputHandler(OutputHandler outputHandler, SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assignQueuePointOutputHandler", (Object)new Object[]{outputHandler, messagingEngineUuid});
        }
        this._ptoPRealization.assignQueuePointOutputHandler(outputHandler, messagingEngineUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assignQueuePointOutputHandler");
        }
    }

    @Override
    public boolean isCorruptOrIndoubt() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isCorruptOrIndoubt");
            SibTr.exit((TraceComponent)tc, (String)"isCorruptOrIndoubt", (Object)new Boolean(this._isCorruptOrIndoubt));
        }
        return this._isCorruptOrIndoubt;
    }

    @Override
    public synchronized void setCorrupt(boolean newCorrupt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCorrupt", (Object)newCorrupt);
        }
        boolean oldCorrupt = this._isCorruptOrIndoubt;
        this._isCorruptOrIndoubt = newCorrupt;
        if (newCorrupt && !oldCorrupt) {
            this.destinationManager.corruptDestination(this);
            SibTr.info((TraceComponent)tc_cwsik, (String)"DELIVERY_ERROR_SIRC_27", (Object)new Object[]{this.getName() + " " + this.getUuid().toString()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCorrupt");
        }
    }

    @Override
    public synchronized void setIndoubt(boolean newIndoubt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIndoubt", (Object)new Boolean(newIndoubt));
        }
        this._isCorruptOrIndoubt = newIndoubt;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIndoubt");
        }
    }

    @Override
    public boolean hasLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasLocal");
        }
        boolean hasLocal = this.getLocalisationManager().hasLocal();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasLocal", (Object)hasLocal);
        }
        return hasLocal;
    }

    @Override
    public boolean hasRemote() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasRemote");
        }
        boolean hasRemote = this.getLocalisationManager().hasRemote();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasRemote", (Object)hasRemote);
        }
        return hasRemote;
    }

    public void setRemote(boolean hasRemote) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRemote", (Object)hasRemote);
        }
        this.getLocalisationManager().setRemote(hasRemote);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRemote");
        }
    }

    public void setLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLocal");
        }
        this.getLocalisationManager().setLocal();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLocal");
        }
    }

    @Override
    public boolean isTemporary() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporary");
            SibTr.exit((TraceComponent)tc, (String)"isTemporary", (Object)this._isTemporary);
        }
        return this._isTemporary;
    }

    @Override
    public boolean isToBeDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isToBeDeleted", (Object)new Object[]{this.getName(), this.getUuid().toString()});
            SibTr.exit((TraceComponent)tc, (String)"isToBeDeleted", (Object)this._toBeDeleted);
        }
        return this._toBeDeleted;
    }

    public boolean isToBeIgnored() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isToBeIgnored");
            SibTr.exit((TraceComponent)tc, (String)"isToBeIgnored", (Object)this._toBeIgnored);
        }
        return this._toBeIgnored;
    }

    public synchronized void setDeleteInProgress(boolean deleteInProgress) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDeleteInProgress");
        }
        this._deleteInProgress = deleteInProgress;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDeleteInProgress", (Object)this._deleteInProgress);
        }
    }

    public synchronized boolean isDeleteInProgress() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDeleteInProgress");
            SibTr.exit((TraceComponent)tc, (String)"isDeleteInProgress", (Object)this._deleteInProgress);
        }
        return this._deleteInProgress;
    }

    public void setToBeDeleted(boolean delete) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setToBeDeleted", (Object)delete);
        }
        this._toBeDeleted = delete;
        if (delete && this._protoRealization != null) {
            this._protoRealization.setToBeDeleted();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setToBeDeleted");
        }
    }

    @Override
    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        if (this._isCorruptOrIndoubt) {
            this._toBeIgnored = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Destination " + this.getName() + " on bus " + this.getBus() + " set to be ignored on restart"));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, dataVersion});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            HashMap hm = (HashMap)ois.readObject();
            this.restorePersistentDestinationData(hm);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.restore", (String)"1:2664:1.700.3.45", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2671:1.700.3.45", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2681:1.700.3.45", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void restorePersistentDestinationData(HashMap hm) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restorePersistentDestinationData", (Object)new Object[]{hm});
        }
        super.restorePersistentData(hm);
        this._toBeDeleted = (Boolean)hm.get("toBeDeleted");
        this._isTemporary = (Boolean)hm.get("isTemporary");
        this._toBeIgnored = (Boolean)hm.get("toBeIgnored");
        this._isSystem = this.definition.getName().startsWith("_P");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restorePersistentDestinationData");
        }
    }

    @Override
    public int getPersistentVersion() {
        return 1;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap hm = new HashMap();
            this.addPersistentDestinationData(hm);
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.getPersistentData", (String)"1:2759:1.700.3.45", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2770:1.700.3.45", e, this.getName()});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:2779:1.700.3.45", e, this.getName()}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void addPersistentDestinationData(HashMap hm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentDestinationData", (Object)hm);
        }
        super.addPersistentData(hm);
        hm.put("toBeDeleted", this._toBeDeleted);
        hm.put("isTemporary", this._isTemporary);
        hm.put("toBeIgnored", this._toBeIgnored);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentDestinationData");
        }
    }

    @Override
    public SubscriptionIndex getSubscriptionIndex() {
        return this._pubSubRealization.getSubscriptionIndex();
    }

    @Override
    public void updateDefinition(BaseDestinationDefinition destinationDefinition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDefinition", (Object)new Object[]{destinationDefinition});
        }
        DestinationDefinition oldDefinition = this.definition;
        DestinationDefinition newDefinition = (DestinationDefinition)destinationDefinition;
        super.updateDefinition(destinationDefinition);
        this._maxFailedDeliveries = this.definition.getMaxFailedDeliveries();
        this._blockedRetryInterval = this.definition.getBlockedRetryTimeout();
        this.registerDestination();
        QualifiedDestinationName[] names = this.definition.getForwardRoutingPath();
        if (names != null) {
            ArrayList<SIDestinationAddress> newFRP = new ArrayList<SIDestinationAddress>(names.length);
            for (int name = 0; name < names.length; ++name) {
                newFRP.add((SIDestinationAddress)SIMPUtils.createJsDestinationAddress(names[name].getDestination(), null, names[name].getBus()));
            }
            this._forwardRoutingPath = newFRP;
        } else {
            this._forwardRoutingPath = null;
        }
        this._replyDestination = null;
        this._replySet = false;
        if (oldDefinition != null && oldDefinition.isSendAllowed() != newDefinition.isSendAllowed()) {
            this.fireSendAllowedStateChangeEvent(newDefinition.isSendAllowed());
        }
        if (oldDefinition != null && oldDefinition.isReceiveAllowed() != newDefinition.isReceiveAllowed()) {
            this.fireReceiveAllowedStateChangeEvent(newDefinition.isReceiveAllowed());
        }
        if (!this._reconciled) {
            this.setIsOrdered(this.definition.isOrderingRequired());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDefinition");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyAOHReceiveExclusiveChange(boolean newValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyAOHReceiveExclusiveChange", (Object)new Object[]{newValue});
        }
        BaseDestinationHandler baseDestinationHandler = this;
        synchronized (baseDestinationHandler) {
            this._protoRealization.getRemoteSupport().notifyAOHReceiveExclusiveChange(newValue);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyAOHReceiveExclusiveChange");
        }
    }

    void registerDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestination");
        }
        if (!this.isTemporary() && !this._isSystem) {
            this.getLocalisationManager().registerDestination();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    void deregisterDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
        }
        if (!this.isTemporary() && !this._isSystem) {
            this.getLocalisationManager().deregisterDestination();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    public Object getMediationConsumerLockObject() {
        return new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanupBaseDestination() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupBaseDestination");
        }
        boolean allCleanedUp = true;
        Object object = this.getMediationConsumerLockObject();
        synchronized (object) {
            if (!this.isDeleted() && !this.isCorruptOrIndoubt()) {
                if (!this.isPubSub()) {
                    this._protoRealization.getReallocationLockManager().lockExclusive();
                }
                try {
                    BaseDestinationHandler baseDestinationHandler = this;
                    synchronized (baseDestinationHandler) {
                        if (this.isDeleteInProgress()) {
                            allCleanedUp = false;
                        } else {
                            allCleanedUp = this.cleanupLocalisations();
                            if (this.isToBeDeleted() && !this.assureAllFlushed()) {
                                allCleanedUp = false;
                            }
                            if (!this.isPubSub()) {
                                if (this.isToBeDeleted() && allCleanedUp) {
                                    try {
                                        LocalTransaction siTran = this.txManager.createLocalTransaction(false);
                                        BatchHandler sourceBatchHandler = this.messageProcessor.getSourceBatchHandler();
                                        sourceBatchHandler.completeBatch(true);
                                        this._protoRealization.getRemoteSupport().removeProtocolItems((TransactionCommon)siTran);
                                        this._protoRealization.getRemoteSupport().resetProtocolStreams();
                                        siTran.registerCallback((TransactionCallback)new DestinationRemoveTransactionCallback());
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Statistics stats = this.getStatistics();
                                            SibTr.debug((TraceComponent)tc, (String)("Destination :" + this.getName() + " " + this.getUuid().toString() + " Adding : " + stats.getAddingItemCount() + " Available : " + stats.getAvailableItemCount() + " Expiring : " + stats.getExpiringItemCount() + " Locked : " + stats.getLockedItemCount() + " Removing : " + stats.getRemovingItemCount() + " Total : " + stats.getTotalItemCount() + " Unavailable : " + stats.getUnavailableItemCount() + " Updating : " + stats.getUpdatingItemCount()));
                                        }
                                        Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)siTran);
                                        this.remove(msTran, -2L);
                                        siTran.commit();
                                        this.setDeleted();
                                    }
                                    catch (MessageStoreException e) {
                                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.cleanupBaseDestination", (String)"1:3138:1.700.3.45", (Object)this);
                                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                            SibTr.exit((TraceComponent)tc, (String)"cleanupBaseDestination", (Object)"SIResourceException");
                                        }
                                        throw new SIResourceException((Throwable)e);
                                    }
                                }
                            } else if (this.isToBeDeleted() && allCleanedUp) {
                                this._pubSubRealization.stopDeletingMsgsWihoutReferencesTask(true);
                                this._pubSubRealization.cleanupDestination();
                            }
                            if (this.getHasReconciledStreamsToBeDeleted()) {
                                this.setHasReconciledStreamsToBeDeleted(false);
                            }
                        }
                    }
                }
                finally {
                    if (!this.isPubSub()) {
                        this._protoRealization.getReallocationLockManager().unlockExclusive();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupBaseDestination", (Object)allCleanedUp);
        }
        return allCleanedUp;
    }

    public boolean cleanupDestination() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupDestination");
        }
        boolean allCleanedUp = this.cleanupBaseDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupDestination", (Object)allCleanedUp);
        }
        return allCleanedUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cleanupLocalisations() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupLocalisations");
        }
        boolean allCleanedUp = true;
        boolean reallocationCanBeCalled = false;
        if (!this.isDeleted()) {
            BaseDestinationHandler baseDestinationHandler = this;
            synchronized (baseDestinationHandler) {
                if (this.isToBeDeleted()) {
                    this.addAllLocalisationsForCleanUp();
                }
                allCleanedUp = this._protoRealization.cleanupPremediatedItemStreams();
                if (!this.isPubSub()) {
                    if (this.isToBeDeleted()) {
                        boolean remoteGetCleanup = this._ptoPRealization.cleanupLocalisations();
                        if (allCleanedUp) {
                            allCleanedUp = remoteGetCleanup;
                        }
                    } else {
                        reallocationCanBeCalled = true;
                    }
                } else if (this.isToBeDeleted()) {
                    boolean pubSubCleanedUp = this._pubSubRealization.cleanupLocalisations();
                    if (allCleanedUp) {
                        allCleanedUp = pubSubCleanedUp;
                    }
                } else {
                    reallocationCanBeCalled = true;
                }
            }
        }
        if (reallocationCanBeCalled) {
            boolean syncReallocRequiredCheck;
            BaseDestinationHandler baseDestinationHandler = this;
            synchronized (baseDestinationHandler) {
                syncReallocRequiredCheck = this._isToBeReallocated;
                this._isToBeReallocated = false;
            }
            if (syncReallocRequiredCheck) {
                this.reallocateTransmissionStreams(null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupLocalisations", (Object)allCleanedUp);
        }
        return allCleanedUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocalizationSet(Set newQueuePointLocalisingMEUuids) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalizationSet", (Object)new Object[]{newQueuePointLocalisingMEUuids});
        }
        SIBUuid8 messagingEngineUuid = this.messageProcessor.getMessagingEngineUuid();
        BaseDestinationHandler baseDestinationHandler = this;
        synchronized (baseDestinationHandler) {
            if (!newQueuePointLocalisingMEUuids.contains(messagingEngineUuid.toString()) && this._ptoPRealization != null) {
                this._ptoPRealization.localQueuePointRemoved(this.isDeleted(), this._isSystem, this.isTemporary(), messagingEngineUuid);
            }
            if (!this.isPubSub()) {
                this._ptoPRealization.updateRemoteQueuePointSet(newQueuePointLocalisingMEUuids);
            }
        }
        this._protoRealization.updateLocalisationSet(messagingEngineUuid, newQueuePointLocalisingMEUuids);
        this._protoRealization.getRemoteSupport().closeRemoteConsumers(newQueuePointLocalisingMEUuids, this.getLocalisationManager());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalizationSet");
        }
    }

    @Override
    public PubSubMessageItemStream getPublishPoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPublishPoint");
        }
        PubSubMessageItemStream pubSubMessageItemStream = this._pubSubRealization.getPublishPoint();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPublishPoint", (Object)pubSubMessageItemStream);
        }
        return pubSubMessageItemStream;
    }

    @Override
    public LocalizationPoint getQueuePoint(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePoint", (Object)meUuid);
        }
        LocalizationPoint stream = null;
        if (this._ptoPRealization != null) {
            stream = this._ptoPRealization.getQueuePoint(meUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuePoint", (Object)stream);
        }
        return stream;
    }

    PtoPXmitMsgsItemStream getXmitQueuePoint(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getXmitQueuePoint", (Object)meUuid);
        }
        PtoPXmitMsgsItemStream stream = this.getLocalisationManager().getXmitQueuePoint(meUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getXmitQueuePoint", (Object)stream);
        }
        return stream;
    }

    HashSet getQueuePointGuessSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePointGuessSet");
        }
        HashSet theQueuePoints = this._ptoPRealization.getQueuePointGuessSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuePointGuessSet", (Object)theQueuePoints);
        }
        return theQueuePoints;
    }

    public void updatePreRegistration(boolean advertise) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updatePreRegistration", (Object)advertise);
        }
        this.getLocalisationManager().getTRMFacade().updatePreRegistration(advertise);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updatePreRegistration");
        }
    }

    public void updatePostRegistration(boolean advertise) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updatePostRegistration", (Object)advertise);
        }
        this.getLocalisationManager().getTRMFacade().updatePostRegistration(advertise);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updatePostRegistration");
        }
    }

    public void updateGetRegistration(boolean advertise) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateGetRegistration", (Object)advertise);
        }
        this.getLocalisationManager().getTRMFacade().updateGetRegistration(advertise);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateGetRegistration");
        }
    }

    protected void updateLocalizationDefinition(BaseLocalizationDefinition destinationLocalizationDefinition, TransactionCommon transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalizationDefinition", (Object)new Object[]{destinationLocalizationDefinition, transaction});
        }
        if (this.isPubSub()) {
            this._pubSubRealization.updateLocalisationDefinition((LocalizationDefinition)destinationLocalizationDefinition);
        } else if (destinationLocalizationDefinition instanceof LocalizationDefinition) {
            this._ptoPRealization.updateLocalisationDefinition(destinationLocalizationDefinition, transaction);
        } else {
            SIResourceException e = new SIResourceException((Throwable)new UnsupportedOperationException());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"updateLocalizationDefinition", (Object)((Object)e));
            }
            throw e;
        }
        this.getLocalisationManager().updateTrmAdvertisements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalizationDefinition");
        }
    }

    @Override
    public boolean isReconciled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReconciled");
            SibTr.exit((TraceComponent)tc, (String)"isReconciled", (Object)this._reconciled);
        }
        return this._reconciled;
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{event, msg, tran});
        }
        if (event == 7) {
            this._pubSubRealization.itemReferencesDroppedToZero(msg);
        } else if (event == 10) {
            this.eventMessageExpiryNotification(msg, tran);
        } else if (event == 11) {
            this.sendCODMessage(msg, tran);
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:3717:1.700.3.45"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.messageEventOccurred", (String)"1:3723:1.700.3.45", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BaseDestinationHandler", "1:3733:1.700.3.45"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    private void eventMessageExpiryNotification(SIMPMessage msg, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventMessageExpiryNotification", (Object)new Object[]{msg, tran});
        }
        if (this._reportHandler == null) {
            this._reportHandler = new ReportHandler(this.messageProcessor);
        }
        try {
            this._reportHandler.handleMessage(msg, tran, SIApiConstants.REPORT_EXPIRY);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.eventMessageExpiryNotification", (String)"1:3778:1.700.3.45", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventMessageExpiryNotification", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REPORT_MESSAGE_ERROR_CWSIP0422", new Object[]{this.messageProcessor.getMessagingEngineName(), e}, null), (Throwable)e);
        }
        if (this._protoRealization != null) {
            this._protoRealization.onExpiryReport();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventMessageExpiryNotification");
        }
    }

    public String constructPseudoDurableDestName(String subName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"constructPseudoDurableDestName", (Object)subName);
        }
        String psuedoDestName = this.constructPseudoDurableDestName(this.messageProcessor.getMessagingEngineUuid().toString(), subName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"constructPseudoDurableDestName", (Object)psuedoDestName);
        }
        return psuedoDestName;
    }

    public String constructPseudoDurableDestName(String meUUID, String durableName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"constructPseudoDurableDestName", (Object)new Object[]{meUUID, durableName});
        }
        String returnString = meUUID + "##" + durableName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"constructPseudoDurableDestName", (Object)returnString);
        }
        return returnString;
    }

    public String getSubNameFromPseudoDestination(String pseudoDestinationName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubNameFromPseudoDestination", (Object)pseudoDestinationName);
        }
        String strippedSubName = pseudoDestinationName.substring(pseudoDestinationName.indexOf("##") + 2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubNameFromPseudoDestination", (Object)strippedSubName);
        }
        return strippedSubName;
    }

    public AnycastOutputHandler getAnycastOHForPseudoDest(String destName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastOHForPseudoDest", (Object)destName);
        }
        AnycastOutputHandler returnAOH = this._pubSubRealization.getRemotePubSubSupport().getAnycastOHForPseudoDest(destName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastOHForPseudoDest", (Object)returnAOH);
        }
        return returnAOH;
    }

    void sendCODMessage(SIMPMessage msg, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCODMessage", (Object)new Object[]{msg, tran});
        }
        if (msg.getReportCOD() != null) {
            if (this._reportHandler == null) {
                this._reportHandler = new ReportHandler(this.messageProcessor);
            }
            try {
                this._reportHandler.handleMessage(msg, tran, SIApiConstants.REPORT_COD);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.sendCODMessage", (String)"1:3909:1.700.3.45", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendCODMessage", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("REPORT_MESSAGE_ERROR_CWSIP0423", new Object[]{this.messageProcessor.getMessagingEngineName(), e}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCODMessage");
        }
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)msg);
        }
        msg.registerMessageEventListener(10, this);
        msg.registerMessageEventListener(7, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    @Override
    public boolean isSystem() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSystem");
            SibTr.exit((TraceComponent)tc, (String)"isSystem", (Object)this._isSystem);
        }
        return this._isSystem;
    }

    @Override
    public boolean isTargetedAtLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTargetedAtLink");
            SibTr.exit((TraceComponent)tc, (String)"isTargetedAtLink", (Object)false);
        }
        return false;
    }

    protected void clearLocalisingUuidsSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearLocalisingUuidsSet");
        }
        this.getLocalisationManager().clearLocalisingUuidsSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearLocalisingUuidsSet");
        }
    }

    @Override
    public List getSubscriptionList() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionList");
        }
        List<String> subscriptions = this._pubSubRealization.getSubscriptionList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionList", subscriptions);
        }
        return subscriptions;
    }

    protected void addAllLocalisationsForCleanUp() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addAllLocalisationsForCleanUp");
        }
        this._protoRealization.addAllLocalisationsForCleanUp(this._singleServer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addAllLocalisationsForCleanUp");
        }
    }

    public void addLocalisationForCleanUp(SIBUuid8 meUuid, PtoPMessageItemStream ptoPMessageItemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLocalisationForCleanUp", (Object)new Object[]{meUuid, ptoPMessageItemStream});
        }
        this._protoRealization.addLocalisationForCleanUp(meUuid, ptoPMessageItemStream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLocalisationForCleanUp");
        }
    }

    @Override
    public void announceWasOpenForEBusiness() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceWasOpenForEBusiness");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceWasOpenForEBusiness");
        }
    }

    @Override
    public void announceWasClosedForEBusiness() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceWasClosedForEBusiness");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceWasClosedForEBusiness");
        }
    }

    @Override
    public void announceMPStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStarted");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStarted");
        }
    }

    @Override
    public void announceMPStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStopping");
        }
        if (this.isPubSub() && null != this._pubSubRealization) {
            this._pubSubRealization.stopDeletingMsgsWihoutReferencesTask(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStopping");
        }
    }

    @Override
    public TargetProtocolItemStream getTargetProtocolItemStream() {
        return this._protoRealization.getRemoteSupport().getTargetProtocolItemStream();
    }

    @Override
    public ProxyReferenceStream getProxyReferenceStream() {
        return this._pubSubRealization.getProxyReferenceStream();
    }

    @Override
    public SourceProtocolItemStream getSourceProtocolItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceProtocolItemStream");
        }
        SourceProtocolItemStream sourceProtocolItemStream = this._protoRealization.getRemoteSupport().getSourceProtocolItemStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSourceProtocolItemStream", (Object)((Object)sourceProtocolItemStream));
        }
        return sourceProtocolItemStream;
    }

    @Override
    public void registerForMessageEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForMessageEvents", (Object)msg);
        }
        this.registerForEvents(msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForMessageEvents");
        }
    }

    @Override
    public BaseDestinationHandler getResolvedDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getResolvedDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getResolvedDestinationHandler", (Object)this);
        }
        return this;
    }

    @Override
    public LockManager getReallocationLockManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReallocationLockManager");
        }
        LockManager reallocationLockManager = this._protoRealization.getReallocationLockManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReallocationLockManager", (Object)reallocationLockManager);
        }
        return reallocationLockManager;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(int mode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)mode);
        }
        this.deregisterDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public int deleteDurableFromRemote(String subName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDurableFromRemote", (Object)subName);
        }
        int status = this._pubSubRealization.deleteDurableFromRemote(subName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDurableFromRemote", (Object)status);
        }
        return status;
    }

    public int createDurableFromRemote(String subName, SelectionCriteria criteria, String user, boolean isCloned, boolean isNoLocal, boolean isSIBServerSubject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableFromRemote", (Object)new Object[]{subName, criteria, user, isSIBServerSubject});
        }
        int status = 0;
        ConsumerDispatcherState subState = new ConsumerDispatcherState(subName, this.definition.getUUID(), criteria, isNoLocal, this.messageProcessor.getMessagingEngineName(), this.definition.getName(), this.getBus());
        subState.setUser(user, isSIBServerSubject);
        subState.setIsCloned(isCloned);
        try {
            this._pubSubRealization.createLocalDurableSubscription(subState, null);
        }
        catch (SIDurableSubscriptionAlreadyExistsException e) {
            status = 1;
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.BaseDestinationHandler.createDurableFromRemote", (String)"1:4436:1.700.3.45", (Object)this);
            status = 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableFromRemote", (Object)status);
        }
        return status;
    }

    public void attachDurableFromRemote(ControlCreateStream request) throws SIDestinationLockedException, SIDurableSubscriptionMismatchException, SIDurableSubscriptionNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachDurableFromRemote", (Object)request);
        }
        this._pubSubRealization.attachDurableFromRemote(request);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachDurableFromRemote");
        }
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = this.isPubSub() ? new Topicspace(this.messageProcessor, this) : new Queue(this.messageProcessor, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public ConsumableKey attachToDurableSubscription(LocalConsumerPoint consumerPoint, ConsumerDispatcherState subState) throws SIDurableSubscriptionMismatchException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachToDurableSubscription", (Object)new Object[]{consumerPoint, subState});
        }
        ConsumableKey result = this._pubSubRealization.attachToDurableSubscription(consumerPoint, subState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachToDurableSubscription", (Object)result);
        }
        return result;
    }

    @Override
    public void createDurableSubscription(ConsumerDispatcherState subState, TransactionCommon transaction) throws SIDurableSubscriptionAlreadyExistsException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableSubscription", (Object)new Object[]{subState, transaction});
        }
        this._pubSubRealization.createLocalDurableSubscription(subState, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableSubscription");
        }
    }

    @Override
    public void deleteDurableSubscription(String subscriptionId, String durableHome) throws SIDestinationLockedException, SIDurableSubscriptionNotFoundException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDurableSubscription", (Object)new Object[]{subscriptionId, durableHome});
        }
        this._pubSubRealization.deleteLocalDurableSubscription(subscriptionId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDurableSubscription");
        }
    }

    protected void setReconciled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReconciled");
        }
        this._reconciled = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReconciled");
        }
    }

    public LocalizationPoint getLocalLocalizationPoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalLocalizationPoint");
        }
        LocalizationPoint localizationPoint = null;
        localizationPoint = this._ptoPRealization.getPtoPLocalLocalizationPoint();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalLocalizationPoint", (Object)localizationPoint);
        }
        return localizationPoint;
    }

    public Index getRemoteQueuePoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteQueuePoints");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePoints", (Object)this._remoteQueuePoints);
        }
        return this._remoteQueuePoints;
    }

    @Override
    public List<SIDestinationAddress> getForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardRoutingPath");
            SibTr.exit((TraceComponent)tc, (String)"getForwardRoutingPath", this._forwardRoutingPath);
        }
        return this._forwardRoutingPath;
    }

    @Override
    public SIDestinationAddress[] getDefaultForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultForwardRoutingPath");
        }
        QualifiedDestinationName[] names = this.definition.getForwardRoutingPath();
        SIDestinationAddress[] frp = null;
        if (names != null) {
            frp = new SIDestinationAddress[names.length];
            for (int name = 0; name < names.length; ++name) {
                frp[name] = SIMPUtils.createJsDestinationAddress(names[name].getDestination(), null, names[name].getBus());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultForwardRoutingPath", (Object)frp);
        }
        return frp;
    }

    @Override
    public JsDestinationAddress getReplyDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReplyDestination");
        }
        if (!this._replySet) {
            QualifiedDestinationName name = this.definition.getReplyDestination();
            if (name != null) {
                this._replyDestination = SIMPUtils.createJsDestinationAddress(name.getDestination(), this.messageProcessor.getMessagingEngineUuid(), name.getBus());
            }
            this._replySet = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", (Object)this._replyDestination);
        }
        return this._replyDestination;
    }

    @Override
    public JsDestinationAddress getRoutingDestinationAddr(JsDestinationAddress inAddress, boolean fixedMessagePoint) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRoutingDestinationAddr", (Object)new Object[]{this, inAddress, fixedMessagePoint});
        }
        JsDestinationAddress routingAddress = null;
        SIBUuid8 encodedME = null;
        if (this._isSystem || this._isTemporary) {
            encodedME = SIMPUtils.parseME(inAddress.getDestinationName());
        }
        if (encodedME != null && !encodedME.equals((Object)this.getMessageProcessor().getMessagingEngineUuid())) {
            routingAddress = inAddress;
        } else if (fixedMessagePoint) {
            routingAddress = this._destinationAddr;
        } else if (inAddress != null && inAddress.getME() != null) {
            routingAddress = this._destinationAddr;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRoutingDestinationAddr", (Object)routingAddress);
        }
        return routingAddress;
    }

    @Override
    public boolean checkDestinationAccess(SecurityContext secContext, OperationType operation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{secContext, operation});
        }
        boolean allow = false;
        if (this.accessChecker.checkDestinationAccess(secContext, this.getBus(), this.getDefinition().getName(), operation)) {
            allow = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)allow);
        }
        return allow;
    }

    @Override
    public boolean checkDiscriminatorAccess(SecurityContext secContext, OperationType operation) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)new Object[]{secContext, operation});
        }
        boolean allow = true;
        if (this.isTopicAccessCheckRequired() && !this.accessChecker.checkDiscriminatorAccess(secContext, this, secContext.getDiscriminator(), operation)) {
            allow = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)allow);
        }
        return allow;
    }

    public void deleteRemoteDurableRME(ConsumerDispatcherState subState) throws SIDurableSubscriptionNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRemoteDurableRME", (Object)new Object[]{subState});
        }
        this._pubSubRealization.deleteRemoteDurableRME(subState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableRME");
        }
    }

    public void deleteRemoteDurableDME(String subName) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRemoteDurableDME", (Object)new Object[]{subName});
        }
        this._pubSubRealization.getRemotePubSubSupport().deleteRemoteDurableDME(subName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableDME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReallocation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestReallocation");
        }
        if (!this.isCorruptOrIndoubt()) {
            BaseDestinationHandler baseDestinationHandler = this;
            synchronized (baseDestinationHandler) {
                this._isToBeReallocated = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"requestReallocation", (Object)"Have set reallocation flag");
                }
            }
            this.destinationManager.getDestinationIndex().cleanup(this);
            this.destinationManager.startAsynchDeletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestReallocation");
        }
    }

    private void reallocateTransmissionStreams(PtoPXmitMsgsItemStream ignoredStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocateTransmissionStreams", (Object)ignoredStream);
        }
        this.getLocalisationManager().reallocateTransmissionStreams(ignoredStream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateTransmissionStreams");
        }
    }

    @Override
    public void registerControlAdapters() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapters");
        }
        this._protoRealization.registerControlAdapters();
        SIMPIterator itr = null;
        if (this._remoteQueuePoints != null) {
            itr = this._remoteQueuePoints.iterator();
            while (itr.hasNext()) {
                ControlAdapter remote = (ControlAdapter)itr.next();
                remote.registerControlAdapterAsMBean();
            }
            itr.finished();
        }
        if (this.isLink()) {
            Iterator<PtoPMessageItemStream> it = this._localisationManager.getXmitQueueIterator();
            while (it.hasNext()) {
                ControlAdapter remote = ((PtoPXmitMsgsItemStream)it.next()).getControlAdapter();
                remote.registerControlAdapterAsMBean();
            }
        }
        if (this.isLink()) {
            this.getControlAdapter().registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapters");
        }
    }

    @Override
    public ConsumerManager chooseConsumerManager(SIBUuid12 gatheringTargetUuid, SIBUuid8 fixedMEUuid, HashSet<SIBUuid8> scopedMEs) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chooseConsumerManager", (Object)new Object[]{gatheringTargetUuid, fixedMEUuid, scopedMEs});
        }
        ConsumerManager consumerManager = null;
        consumerManager = this._ptoPRealization.chooseConsumerManager(this.definition, this.isReceiveAllowed(), gatheringTargetUuid, fixedMEUuid, scopedMEs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chooseConsumerManager", (Object)consumerManager);
        }
        return consumerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIMPRemoteQueuePointControllable getRemoteQueuePointControl(SIBUuid8 remoteME, boolean create) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteQueuePointControl", (Object)new Object[]{remoteME, create});
        }
        SIMPRemoteQueuePointControllable rqp = null;
        Index index = this._remoteQueuePoints;
        synchronized (index) {
            rqp = (SIMPRemoteQueuePointControllable)this._remoteQueuePoints.get(remoteME);
            if (create && rqp == null) {
                rqp = new RemoteQueuePoint(remoteME, this, this.getMessageProcessor());
                this._remoteQueuePoints.put(remoteME, rqp);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControl", (Object)rqp);
        }
        return rqp;
    }

    @Override
    public AnycastInputHandler getAnycastInputHandler(SIBUuid8 dmeId, SIBUuid12 gatheringTargetDestUuid, boolean createAIH) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)new Object[]{dmeId, gatheringTargetDestUuid, createAIH});
        }
        AnycastInputHandler aih = this._protoRealization.getRemoteSupport().getAnycastInputHandler(dmeId, gatheringTargetDestUuid, this.definition, createAIH);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)aih);
        }
        return aih;
    }

    @Override
    public boolean isTopicAccessCheckRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTopicAccessCheckRequired");
        }
        if (!this.isPubSub() || this.isTemporary()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)Boolean.FALSE);
            }
            return false;
        }
        boolean check = super.isTopicAccessCheckRequired();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)check);
        }
        return check;
    }

    public Map getPseudoDurableAIHMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPseudoDurableAIHMap");
        }
        Map pseudoDurableAIHMap = this._pubSubRealization.getRemotePubSubSupport().getPseudoDurableAIHMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPseudoDurableAIHMap", (Object)pseudoDurableAIHMap);
        }
        return pseudoDurableAIHMap;
    }

    public boolean removeAnycastInputHandlerAndRCD(String key) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAnycastInputHandlerAndRCD", (Object)key);
        }
        boolean removed = this._protoRealization.getRemoteSupport().removeAnycastInputHandlerAndRCD(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAnycastInputHandlerAndRCD", (Object)removed);
        }
        return removed;
    }

    @Override
    public void closeConsumers() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeConsumers");
        }
        this._protoRealization.getRemoteSupport().closeConsumers();
        super.closeConsumers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeConsumers");
        }
    }

    public void closeRemoteConsumer(SIBUuid8 dmeUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeRemoteConsumer", (Object)dmeUuid);
        }
        this._protoRealization.getRemoteSupport().closeRemoteConsumers(dmeUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeRemoteConsumer");
        }
    }

    protected boolean assureAllFlushed() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assureAllFlushed");
        }
        boolean done = true;
        if (this.isPubSub()) {
            PubSubInputHandler pHandler = (PubSubInputHandler)this.inputHandler;
            boolean resultOne = pHandler.flushAllForDeleteSource();
            boolean resultTwo = pHandler.flushAllForDeleteTarget();
            done = resultOne && resultTwo;
        } else {
            if (this.getSourceProtocolItemStream() != null) {
                done = this._ptoPRealization.flushQueuePointOutputHandler();
            }
            if (this.getTargetProtocolItemStream() != null) {
                done &= ((PtoPInputHandler)this.inputHandler).flushAllForDelete();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assureAllFlushed", (Object)done);
        }
        return done;
    }

    private void fireSendAllowedStateChangeEvent(boolean newState) {
        MessageProcessor messageProcessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireSendAllowedStateChangeEvent", (Object)newState);
        }
        if ((messageProcessor = this.getMessageProcessor()).getMessagingEngine().isEventNotificationEnabled()) {
            String message = nls.getFormattedMessage("NOTIFY_SEND_ALLOWED_STATE_CHANGE_CWSIP0551", new Object[]{this.getName(), this.getUuid().toString(), newState}, null);
            Properties props = new Properties();
            props.put("destination.name", this.getName());
            props.put("destination.UUID", this.getUuid().toString());
            if (newState) {
                props.put("send.allowed.state", "send.allowed.true");
            } else {
                props.put("send.allowed.state", "send.allowed.false");
            }
            MPRuntimeEvent MPevent = new MPRuntimeEvent("SIB.messagepoint.send.allowed.state", message, props);
            this.runtimeEventOccurred(MPevent);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"fireSendAllowedStateChangeEvent", (Object)"Event Notification is disabled, cannot fire event");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireSendAllowedStateChangeEvent");
        }
    }

    private void fireReceiveAllowedStateChangeEvent(boolean newState) {
        MessageProcessor messageProcessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireReceiveAllowedStateChangeEvent", (Object)newState);
        }
        if ((messageProcessor = this.getMessageProcessor()).getMessagingEngine().isEventNotificationEnabled()) {
            String message = nls.getFormattedMessage("NOTIFY_RECEIVE_ALLOWED_STATE_CHANGE_CWSIP0552", new Object[]{this.getName(), this.getUuid().toString(), newState}, null);
            Properties props = new Properties();
            props.put("destination.name", this.getName());
            props.put("destination.UUID", this.getUuid().toString());
            if (newState) {
                props.put("receive.allowed.state", "receive.allowed.true");
            } else {
                props.put("receive.allowed.state", "receive.allowed.false");
            }
            MPRuntimeEvent MPevent = new MPRuntimeEvent("SIB.messagepoint.receive.allowed.state", message, props);
            this.runtimeEventOccurred(MPevent);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"fireReceiveAllowedStateChangeEvent", (Object)"Event Notification is disabled, cannot fire event");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireReceiveAllowedStateChangeEvent");
        }
    }

    private void runtimeEventOccurred(MPRuntimeEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)event);
        }
        if (this.isPubSub()) {
            this._pubSubRealization.runtimeEventOccurred(event);
        } else {
            this._ptoPRealization.runtimeEventOccurred(event);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }

    public PubSubRealization getPubSubRealization() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubRealization");
            SibTr.exit((TraceComponent)tc, (String)"getPubSubRealization", (Object)this._pubSubRealization);
        }
        return this._pubSubRealization;
    }

    public PtoPRealization getPtoPRealization() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPtoPRealization");
            SibTr.exit((TraceComponent)tc, (String)"getPtoPRealization", (Object)this._ptoPRealization);
        }
        return this._ptoPRealization;
    }

    public AbstractProtoRealization getProtocolRealization() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProtocolRealization");
            SibTr.exit((TraceComponent)tc, (String)"getProtocolRealization", (Object)this._protoRealization);
        }
        return this._protoRealization;
    }

    public LocalisationManager getLocalisationManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalisationManager", (Object)this);
        }
        if (this._localisationManager == null) {
            this._localisationManager = new LocalisationManager(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalisationManager", (Object)this._localisationManager);
        }
        return this._localisationManager;
    }

    @Override
    public boolean isOrdered() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOrdered");
            SibTr.exit((TraceComponent)tc, (String)"isOrdered", (Object)this._isOrderingRequired);
        }
        return this._isOrderingRequired;
    }

    public void setIsOrdered(boolean isOrderingRequired) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIsOrdered", (Object)isOrderingRequired);
        }
        if (isOrderingRequired && this._isUnableToOrder) {
            SibTr.error((TraceComponent)tc, (String)"ORDERING_INITIALISATION_ERROR_CWSIP0671", (Object)new Object[]{this.getName(), this.messageProcessor.getMessagingEngineName()});
        }
        this._isOrderingRequired = isOrderingRequired;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIsOrdered");
        }
    }

    public void setIsUnableToOrder(boolean isUnableToOrder) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIsUnableToOrder", (Object)new Boolean(isUnableToOrder));
        }
        this._isUnableToOrder = isUnableToOrder;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIsUnableToOrder");
        }
    }

    public final Object getReadyConsumerPointLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReadyConsumerPointLock");
            SibTr.exit((TraceComponent)tc, (String)"getReadyConsumerPointLock", (Object)this.readyConsumerPointLock);
        }
        return this.readyConsumerPointLock;
    }

    @Override
    public Iterator<AnycastInputControl> getAIControlAdapterIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIControlAdapterIterator");
        }
        Iterator<AnycastInputControl> it = this._protoRealization.getRemoteSupport().getAIControlAdapterIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAIControlAdapterIterator", it);
        }
        return it;
    }

    @Override
    public Iterator<ControlAdapter> getAOControlAdapterIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAOControlAdapterIterator");
        }
        Iterator<ControlAdapter> it = this._protoRealization.getRemoteSupport().getAOControlAdapterIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAOControlAdapterIterator", it);
        }
        return it;
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        super.xmlWriteOn(writer);
        writer.newLine();
        writer.taggedValue("toBeDeleted", (Object)this._toBeDeleted);
        writer.newLine();
        writer.taggedValue("toBeIgnored", (Object)this._toBeIgnored);
    }

    @Override
    public long getQHighMsgDepth() {
        long qHighMsgLimit = this._ptoPRealization.getQhighMsgLimit();
        return qHighMsgLimit;
    }

    public class DestinationAddTransactionCallback
    implements TransactionCallback {
        public void beforeCompletion(TransactionCommon transaction) {
        }

        public void afterCompletion(TransactionCommon transaction, boolean committed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, committed});
            }
            if (committed) {
                BaseDestinationHandler.this.registerControlAdapters();
                BaseDestinationHandler.this.destinationManager.activateDestination(BaseDestinationHandler.this);
                if (BaseDestinationHandler.this._ptoPRealization != null) {
                    BaseDestinationHandler.this._ptoPRealization.registerDestination(BaseDestinationHandler.this.hasLocal(), BaseDestinationHandler.this.isDeleted());
                }
            } else {
                BaseDestinationHandler.this.destinationManager.removeDestination(BaseDestinationHandler.this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
            }
        }
    }

    public class DestinationRemoveTransactionCallback
    implements TransactionCallback {
        public void beforeCompletion(TransactionCommon transaction) {
        }

        public void afterCompletion(TransactionCommon transaction, boolean committed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, committed});
            }
            BaseDestinationHandler.this.deregisterDestination();
            BaseDestinationHandler.this.notifyWaitingThread();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
            }
        }
    }
}

