/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.writer;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics23.writer.JSONMetricWriter23;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.helper.Util30;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JSONMetricWriter30
extends JSONMetricWriter23 {
    private static final TraceComponent tc = Tr.register(JSONMetricWriter30.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = 2634795529546483001L;

    public JSONMetricWriter30(Writer writer) {
        super(writer);
    }

    @Override
    protected JSONObject getMetricsAsJson(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        return this.getJsonFromMetricMap(Util30.getMetricsAsMap(registryName), Util30.getMetricsMetadataAsMap(registryName));
    }

    @Override
    protected JSONObject getMetricsAsJson(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        return this.getJsonFromMetricMap(Util30.getMetricsAsMap(registryName, metricName), Util30.getMetricsMetadataAsMap(registryName, metricName));
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    @FFDCIgnore(value={IllegalStateException.class})
    protected JSONObject getJsonFromMetricMap(Map<MetricID, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<MetricID, Metric> entry : metricMap.entrySet()) {
            Metric metric;
            String metricName;
            MetricID metricID = entry.getKey();
            TreeMap<String, String> tagsMap = metricID.getTags();
            Tag[] globalTags = Util30.getCachedGlobalTags();
            if (globalTags != null) {
                Tag[] metricTags = metricID.getTagsAsArray();
                TreeMap<String, String> tagsMapWithGlobalTags = new TreeMap<String, String>();
                for (Tag t : globalTags) {
                    tagsMapWithGlobalTags.put(t.getTagName(), t.getTagValue());
                }
                for (Tag t : metricTags) {
                    tagsMapWithGlobalTags.put(t.getTagName(), t.getTagValue());
                }
                tagsMap = tagsMapWithGlobalTags;
            }
            String metricNameWithTags = metricName = metricID.getName();
            String tags = "";
            Metadata metricMetaData = metricMetadataMap.get(metricName);
            String unit = metricMetaData.getUnit();
            double conversionFactor = 1.0;
            switch (unit) {
                case "nanoseconds": {
                    conversionFactor = 1.0;
                    break;
                }
                case "microseconds": {
                    conversionFactor = 1000.0;
                    break;
                }
                case "milliseconds": {
                    conversionFactor = 1000000.0;
                    break;
                }
                case "seconds": {
                    conversionFactor = 1.0E9;
                    break;
                }
                case "minutes": {
                    conversionFactor = 6.0E10;
                    break;
                }
                case "hours": {
                    conversionFactor = 3.6E12;
                    break;
                }
                case "days": {
                    conversionFactor = 8.64E13;
                }
            }
            if (tagsMap.size() != 0) {
                for (Map.Entry tagsMapEntrySet : tagsMap.entrySet()) {
                    String tagValue = (String)tagsMapEntrySet.getValue();
                    if (tagValue.contains(";")) {
                        tagValue = tagValue.replaceAll(";", "_");
                    }
                    tags = tags + ";" + (String)tagsMapEntrySet.getKey() + "=" + tagValue;
                }
                metricNameWithTags = metricName + tags;
            }
            if (Counter.class.isInstance(metric = entry.getValue())) {
                jsonObject.put((Object)metricNameWithTags, (Object)((Counter)metric).getCount());
                continue;
            }
            if (ConcurrentGauge.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util30.getConcurrentGaugeNumbers((ConcurrentGauge)metric, tags), metricName, jsonObject));
                continue;
            }
            if (Gauge.class.isInstance(metric)) {
                try {
                    jsonObject.put((Object)metricNameWithTags, ((Gauge)metric).getValue());
                }
                catch (IllegalStateException illegalStateException) {}
                continue;
            }
            if (Timer.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util30.getTimerNumbers((Timer)metric, tags, conversionFactor), metricName, jsonObject));
                continue;
            }
            if (SimpleTimer.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMapAsObject(Util30.getSimpleTimerNumbersAsObjects((SimpleTimer)metric, tags, conversionFactor), metricName, jsonObject));
                continue;
            }
            if (Histogram.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util30.getHistogramNumbers((Histogram)metric, tags), metricName, jsonObject));
                continue;
            }
            if (Meter.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util30.getMeterNumbers((Meter)metric, tags), metricName, jsonObject));
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metric type '" + metric.getClass() + " for " + metricName + " is invalid."), (Object[])new Object[0]);
        }
        return jsonObject;
    }

    protected JSONObject getJsonFromMapAsObject(Map<String, Object> metricMap, String metricName, JSONObject parentJSONObject) {
        JSONObject jsonObject = parentJSONObject.containsKey((Object)metricName) ? (JSONObject)parentJSONObject.get((Object)metricName) : new JSONObject();
        for (Map.Entry<String, Object> entry : metricMap.entrySet()) {
            jsonObject.put((Object)entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }
}

