/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.FlowCallNode;
import jakarta.faces.flow.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.flow.Freezable;

public class FlowCallNodeImpl
extends FlowCallNode
implements Freezable {
    private String id;
    private String calledFlowId;
    private ValueExpression calledFlowIdEL;
    private String calledFlowDocumentId;
    private ValueExpression calledFlowDocumentIdEL;
    private Map<String, Parameter> outboundParametersMap;
    private Map<String, Parameter> unmodifiableOutboundParametersMap;
    private boolean initialized;

    public FlowCallNodeImpl(String id) {
        this.id = id;
        this.outboundParametersMap = new HashMap<String, Parameter>();
        this.unmodifiableOutboundParametersMap = Collections.unmodifiableMap(this.outboundParametersMap);
    }

    public Map<String, Parameter> getOutboundParameters() {
        return this.unmodifiableOutboundParametersMap;
    }

    public void putOutboundParameter(String key, Parameter value) {
        this.checkInitialized();
        this.outboundParametersMap.put(key, value);
    }

    public String getCalledFlowDocumentId(FacesContext context) {
        if (this.calledFlowDocumentIdEL != null) {
            return (String)this.calledFlowDocumentIdEL.getValue(context.getELContext());
        }
        return this.calledFlowDocumentId;
    }

    public String getCalledFlowId(FacesContext context) {
        if (this.calledFlowIdEL != null) {
            return (String)this.calledFlowIdEL.getValue(context.getELContext());
        }
        return this.calledFlowId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.checkInitialized();
        this.id = id;
    }

    public void setCalledFlowId(String calledFlowId) {
        this.checkInitialized();
        this.calledFlowId = calledFlowId;
        this.calledFlowIdEL = null;
    }

    public void setCalledFlowDocumentId(String calledFlowDocumentId) {
        this.checkInitialized();
        this.calledFlowDocumentId = calledFlowDocumentId;
        this.calledFlowDocumentIdEL = null;
    }

    @Override
    public void freeze() {
        this.initialized = true;
        for (Map.Entry<String, Parameter> entry : this.outboundParametersMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setCalledFlowId(ValueExpression calledFlowIdEL) {
        this.calledFlowIdEL = calledFlowIdEL;
        this.calledFlowId = null;
    }

    public void setCalledFlowDocumentId(ValueExpression calledFlowDocumentIdEL) {
        this.calledFlowDocumentIdEL = calledFlowDocumentIdEL;
        this.calledFlowDocumentId = null;
    }
}

