/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.ObserverMethod;
import java.lang.annotation.Annotation;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.EventMetadataImpl;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Observers;

public class FastEvent<T> {
    protected final ResolvedObservers<T> resolvedObserverMethods;

    public static <T> FastEvent<T> of(Class<T> type, BeanManagerImpl manager, Annotation ... qualifiers) {
        return FastEvent.of(type, manager, manager.getAccessibleLenientObserverNotifier(), qualifiers);
    }

    public static <T> FastEvent<T> of(Class<T> type, BeanManagerImpl manager, ObserverNotifier notifier, Annotation ... qualifiers) {
        ResolvedObservers resolvedObserverMethods = notifier.resolveObserverMethods(type, qualifiers);
        if (resolvedObserverMethods.isMetadataRequired()) {
            EventMetadataImpl metadata = new EventMetadataImpl(type, null, qualifiers);
            CurrentEventMetadata metadataService = manager.getServices().get(CurrentEventMetadata.class);
            return new FastEventWithMetadataPropagation(resolvedObserverMethods, metadata, metadataService);
        }
        return new FastEvent(resolvedObserverMethods);
    }

    private FastEvent(ResolvedObservers<T> resolvedObserverMethods) {
        this.resolvedObserverMethods = resolvedObserverMethods;
    }

    public void fire(T event) {
        for (ObserverMethod<T> observer : this.resolvedObserverMethods.getImmediateSyncObservers()) {
            observer.notify(event);
        }
    }

    private static class FastEventWithMetadataPropagation<T>
    extends FastEvent<T> {
        private final EventMetadata metadata;
        private final CurrentEventMetadata metadataService;

        private FastEventWithMetadataPropagation(ResolvedObservers<T> resolvedObserverMethods, EventMetadata metadata, CurrentEventMetadata metadataService) {
            super(resolvedObserverMethods);
            this.metadata = metadata;
            this.metadataService = metadataService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire(T event) {
            ThreadLocalStack.ThreadLocalStackReference<EventMetadata> stack = this.metadataService.pushIfNotNull(this.metadata);
            try {
                for (ObserverMethod observer : this.resolvedObserverMethods.getImmediateSyncObservers()) {
                    Observers.notify(observer, event, this.metadata);
                }
            }
            finally {
                stack.pop();
            }
        }
    }
}

