/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadContext;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;

public class ThreadManager {
    private static final TraceComponent tc = Tr.register(ThreadManager.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static ThreadManager thisClass = null;
    private static ThreadLocal<ThreadContext> threadLocStorage = new ThreadLocal();
    private static InheritableThreadLocal<ThreadContext> inheritableThreadLocStorage = new InheritableThreadLocal();
    private static boolean useInheritableThreadLocal = false;

    private ThreadManager() {
    }

    public static ThreadManager getInstance() {
        if (thisClass == null) {
            thisClass = new ThreadManager();
            String useInheritableThreadLocalString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.useInheritableThreadLocalOnClient");
            if (useInheritableThreadLocalString != null && (useInheritableThreadLocalString.equalsIgnoreCase("true") || useInheritableThreadLocalString.equalsIgnoreCase("yes"))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"useInheritableThreadLocal is enabled.", (Object[])new Object[0]);
                }
                useInheritableThreadLocal = true;
            }
        }
        return thisClass;
    }

    public ThreadContext getThreadContext() {
        if (useInheritableThreadLocal && !SSLConfigManager.getInstance().isServerProcess()) {
            ThreadContext context = (ThreadContext)inheritableThreadLocStorage.get();
            if (context == null) {
                context = new ThreadContext();
                inheritableThreadLocStorage.set(context);
            }
            return context;
        }
        ThreadContext context = threadLocStorage.get();
        if (context == null) {
            context = new ThreadContext();
            threadLocStorage.set(context);
        }
        return context;
    }

    public Properties getPropertiesOnThread() {
        return this.getThreadContext().getProperties();
    }

    public void setPropertiesOnThread(Properties sslProps) {
        this.getThreadContext().setProperties(sslProps);
    }

    public boolean getSetSignerOnThread() {
        return this.getThreadContext().getSetSignerOnThread();
    }

    public void setSetSignerOnThread(boolean flag) {
        this.getThreadContext().setSetSignerOnThread(flag);
    }

    public boolean getAutoAcceptBootstrapSigner() {
        return this.getThreadContext().getAutoAcceptBootstrapSigner();
    }

    public void setAutoAcceptBootstrapSigner(boolean flag) {
        this.getThreadContext().setAutoAcceptBootstrapSigner(flag);
    }

    public boolean getAutoAcceptBootstrapSignerWithoutStorage() {
        return this.getThreadContext().getAutoAcceptBootstrapSignerWithoutStorage();
    }

    public void setAutoAcceptBootstrapSignerWithoutStorage(boolean flag) {
        this.getThreadContext().setAutoAcceptBootstrapSignerWithoutStorage(flag);
    }

    public X509Certificate[] getSignerChain() {
        return this.getThreadContext().getSignerChain();
    }

    public void setSignerChain(X509Certificate[] signerChain) {
        this.getThreadContext().setSignerChain(signerChain);
    }

    public Map<String, Object> getInboundConnectionInfo() {
        return this.getThreadContext().getInboundConnectionInfo();
    }

    public void setInboundConnectionInfo(Map<String, Object> connectionInfo) {
        this.getThreadContext().setInboundConnectionInfo(connectionInfo);
    }

    public Map<String, Object> getOutboundConnectionInfo() {
        return this.getThreadContext().getOutboundConnectionInfo();
    }

    public void setOutboundConnectionInfo(Map<String, Object> connectionInfo) {
        this.getThreadContext().setOutboundConnectionInfo(connectionInfo);
    }

    public Map<String, Object> getOutboundConnectionInfoInternal() {
        return this.getThreadContext().getOutboundConnectionInfoInternal();
    }

    public void setOutboundConnectionInfoInternal(Map<String, Object> connectionInfo) {
        this.getThreadContext().setOutboundConnectionInfoInternal(connectionInfo);
    }
}

