/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.el.ValueExpression;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Locale;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class NumberConverter
implements Converter,
PartialStateHolder {
    public static final String CONVERTER_ID = "jakarta.faces.Number";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    public static final String CURRENCY_ID = "jakarta.faces.converter.NumberConverter.CURRENCY";
    public static final String NUMBER_ID = "jakarta.faces.converter.NumberConverter.NUMBER";
    public static final String PATTERN_ID = "jakarta.faces.converter.NumberConverter.PATTERN";
    public static final String PERCENT_ID = "jakarta.faces.converter.NumberConverter.PERCENT";
    private String _currencyCode;
    private String _currencySymbol;
    private Locale _locale;
    private int _maxFractionDigits;
    private int _maxIntegerDigits;
    private int _minFractionDigits;
    private int _minIntegerDigits;
    private String _pattern;
    private String _type = "number";
    private boolean _groupingUsed = true;
    private boolean _integerOnly = false;
    private boolean _transient;
    private boolean _maxFractionDigitsSet;
    private boolean _maxIntegerDigitsSet;
    private boolean _minFractionDigitsSet;
    private boolean _minIntegerDigitsSet;
    private boolean _initialStateMarked = false;

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null || value.isBlank()) {
            return null;
        }
        NumberFormat format = this.getNumberFormat(facesContext);
        format.setParseIntegerOnly(this._integerOnly);
        DecimalFormat df = (DecimalFormat)format;
        ValueExpression valueExpression = uiComponent.getValueExpression("value");
        Class destType = null;
        if (valueExpression != null && (destType = valueExpression.getType(facesContext.getELContext())) != null && (BigDecimal.class.isAssignableFrom(destType) || BigInteger.class.isAssignableFrom(destType))) {
            df.setParseBigDecimal(true);
        }
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        boolean changed = false;
        if (dfs.getGroupingSeparator() == '\u00a0') {
            dfs.setGroupingSeparator(' ');
            df.setDecimalFormatSymbols(dfs);
            value = value.replace('\u00a0', ' ');
            changed = true;
        }
        this.formatCurrency(format);
        try {
            return this.parse(value, format, destType);
        }
        catch (ParseException e) {
            if (changed) {
                dfs.setGroupingSeparator('\u00a0');
                df.setDecimalFormatSymbols(dfs);
            }
            try {
                return this.parse(value, format, destType);
            }
            catch (ParseException pe) {
                if (this.getPattern() != null) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, PATTERN_ID, new Object[]{value, "$###,###", MessageUtils.getLabel(facesContext, uiComponent)}));
                }
                if (this.getType().equals("number")) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, NUMBER_ID, new Object[]{value, format.format(21L), MessageUtils.getLabel(facesContext, uiComponent)}));
                }
                if (this.getType().equals("currency")) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, CURRENCY_ID, new Object[]{value, format.format(42.25), MessageUtils.getLabel(facesContext, uiComponent)}));
                }
                if (this.getType().equals("percent")) {
                    throw new ConverterException(MessageUtils.getErrorMessage(facesContext, PERCENT_ID, new Object[]{value, format.format(0.9), MessageUtils.getLabel(facesContext, uiComponent)}));
                }
                return null;
            }
        }
    }

    private Object parse(String value, NumberFormat format, Class<?> destType) throws ParseException {
        char decimalSeparater;
        int decimalParseIndex;
        Number parsed = null;
        ParsePosition parsePosition = new ParsePosition(0);
        parsed = destType == BigInteger.class ? ((BigDecimal)format.parse(value, parsePosition)).toBigInteger() : format.parse(value, parsePosition);
        if (this.isIntegerOnly() ? (decimalParseIndex = value.indexOf(decimalSeparater = new DecimalFormatSymbols(this.getLocale()).getDecimalSeparator())) != -1 && decimalParseIndex != parsePosition.getIndex() : parsePosition.getIndex() != value.length()) {
            throw new ParseException(value, parsePosition.getIndex());
        }
        return parsed;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        NumberFormat format = this.getNumberFormat(facesContext);
        format.setGroupingUsed(this._groupingUsed);
        if (this._maxFractionDigitsSet) {
            format.setMaximumFractionDigits(this._maxFractionDigits);
        }
        if (this._maxIntegerDigitsSet) {
            format.setMaximumIntegerDigits(this._maxIntegerDigits);
        }
        if (this._minFractionDigitsSet) {
            format.setMinimumFractionDigits(this._minFractionDigits);
        }
        if (this._minIntegerDigitsSet) {
            format.setMinimumIntegerDigits(this._minIntegerDigits);
        }
        this.formatCurrency(format);
        try {
            return format.format(value);
        }
        catch (Exception e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }

    private NumberFormat getNumberFormat(FacesContext facesContext) {
        Locale locale;
        Locale locale2 = locale = this._locale != null ? this._locale : facesContext.getViewRoot().getLocale();
        if (this._pattern == null && this._type == null) {
            throw new ConverterException("Cannot get NumberFormat, either type or pattern needed.");
        }
        if (this._pattern != null) {
            return new DecimalFormat(this._pattern, new DecimalFormatSymbols(locale));
        }
        if (this._type.equals("number")) {
            return NumberFormat.getNumberInstance(locale);
        }
        if (this._type.equals("currency")) {
            return NumberFormat.getCurrencyInstance(locale);
        }
        if (this._type.equals("percent")) {
            return NumberFormat.getPercentInstance(locale);
        }
        throw new ConverterException("Cannot get NumberFormat, illegal type " + this._type);
    }

    private void formatCurrency(NumberFormat format) {
        boolean useCurrencyCode;
        if (this._currencyCode == null && this._currencySymbol == null) {
            return;
        }
        boolean bl = useCurrencyCode = this._currencyCode != null;
        if (useCurrencyCode) {
            try {
                format.setCurrency(Currency.getInstance(this._currencyCode));
            }
            catch (Exception e) {
                throw new ConverterException("Unable to get Currency instance for currencyCode " + this._currencyCode);
            }
        } else if (format instanceof DecimalFormat) {
            DecimalFormat dFormat = (DecimalFormat)format;
            DecimalFormatSymbols symbols = dFormat.getDecimalFormatSymbols();
            symbols.setCurrencySymbol(this._currencySymbol);
            dFormat.setDecimalFormatSymbols(symbols);
        }
    }

    @Override
    public void restoreState(FacesContext facesContext, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this._currencyCode = (String)values[0];
            this._currencySymbol = (String)values[1];
            this._locale = (Locale)values[2];
            Integer value = (Integer)values[3];
            this._maxFractionDigits = value != null ? value : 0;
            value = (Integer)values[4];
            this._maxIntegerDigits = value != null ? value : 0;
            value = (Integer)values[5];
            this._minFractionDigits = value != null ? value : 0;
            value = (Integer)values[6];
            this._minIntegerDigits = value != null ? value : 0;
            this._pattern = (String)values[7];
            this._type = (String)values[8];
            this._groupingUsed = (Boolean)values[9];
            this._integerOnly = (Boolean)values[10];
            this._maxFractionDigitsSet = (Boolean)values[11];
            this._maxIntegerDigitsSet = (Boolean)values[12];
            this._minFractionDigitsSet = (Boolean)values[13];
            this._minIntegerDigitsSet = (Boolean)values[14];
        }
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this._currencyCode, this._currencySymbol, this._locale, this._maxFractionDigitsSet ? Integer.valueOf(this._maxFractionDigits) : null, this._maxIntegerDigitsSet ? Integer.valueOf(this._maxIntegerDigits) : null, this._minFractionDigitsSet ? Integer.valueOf(this._minFractionDigits) : null, this._minIntegerDigitsSet ? Integer.valueOf(this._minIntegerDigits) : null, this._pattern, this._type, this._groupingUsed ? Boolean.TRUE : Boolean.FALSE, this._integerOnly ? Boolean.TRUE : Boolean.FALSE, this._maxFractionDigitsSet ? Boolean.TRUE : Boolean.FALSE, this._maxIntegerDigitsSet ? Boolean.TRUE : Boolean.FALSE, this._minFractionDigitsSet ? Boolean.TRUE : Boolean.FALSE, this._minIntegerDigitsSet ? Boolean.TRUE : Boolean.FALSE};
            return values;
        }
        return null;
    }

    public String getCurrencyCode() {
        return this._currencyCode != null ? this._currencyCode : this.getDecimalFormatSymbols().getInternationalCurrencySymbol();
    }

    public void setCurrencyCode(String currencyCode) {
        this._currencyCode = currencyCode;
        this.clearInitialState();
    }

    public String getCurrencySymbol() {
        return this._currencySymbol != null ? this._currencySymbol : this.getDecimalFormatSymbols().getCurrencySymbol();
    }

    public void setCurrencySymbol(String currencySymbol) {
        this._currencySymbol = currencySymbol;
        this.clearInitialState();
    }

    public boolean isGroupingUsed() {
        return this._groupingUsed;
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this._groupingUsed = groupingUsed;
        this.clearInitialState();
    }

    public boolean isIntegerOnly() {
        return this._integerOnly;
    }

    public void setIntegerOnly(boolean integerOnly) {
        this._integerOnly = integerOnly;
        this.clearInitialState();
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        this.clearInitialState();
    }

    public int getMaxFractionDigits() {
        return this._maxFractionDigits;
    }

    public void setMaxFractionDigits(int maxFractionDigits) {
        this._maxFractionDigitsSet = true;
        this._maxFractionDigits = maxFractionDigits;
        this.clearInitialState();
    }

    public int getMaxIntegerDigits() {
        return this._maxIntegerDigits;
    }

    public void setMaxIntegerDigits(int maxIntegerDigits) {
        this._maxIntegerDigitsSet = true;
        this._maxIntegerDigits = maxIntegerDigits;
        this.clearInitialState();
    }

    public int getMinFractionDigits() {
        return this._minFractionDigits;
    }

    public void setMinFractionDigits(int minFractionDigits) {
        this._minFractionDigitsSet = true;
        this._minFractionDigits = minFractionDigits;
        this.clearInitialState();
    }

    public int getMinIntegerDigits() {
        return this._minIntegerDigits;
    }

    public void setMinIntegerDigits(int minIntegerDigits) {
        this._minIntegerDigitsSet = true;
        this._minIntegerDigits = minIntegerDigits;
        this.clearInitialState();
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
        this.clearInitialState();
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean aTransient) {
        this._transient = aTransient;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
        this.clearInitialState();
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        return new DecimalFormatSymbols(this.getLocale());
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

