/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public class FrameGoAway
extends Frame {
    private int errorCode = -1;
    private int lastStreamId = -1;
    private byte[] debugData = null;

    public FrameGoAway(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.GOAWAY;
    }

    public FrameGoAway(int streamId, byte[] debugData, int errorCode, int lastStreamId, boolean reserveBit) {
        super(streamId, 8, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        if (debugData != null) {
            this.payloadLength += debugData.length;
            this.debugData = debugData;
        } else {
            this.debugData = new byte[0];
        }
        this.errorCode = errorCode;
        this.lastStreamId = lastStreamId;
        this.frameType = FrameTypes.GOAWAY;
        this.writeFrameLength += this.payloadLength;
        this.setInitialized();
    }

    public FrameGoAway() {
        this(0, new byte[0], 0, 1, false);
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        byte firstPayloadByte = frp.grabNextByte();
        this.reservedBit = utils.getReservedBit(firstPayloadByte);
        firstPayloadByte = (byte)(firstPayloadByte & 0x7F);
        this.setLastStreamId(frp.grabNext24BitInt(firstPayloadByte));
        this.setErrorCode(frp.grabNext32BitInt());
        int payloadIndex = 8;
        if (this.payloadLength - payloadIndex > 0) {
            this.debugData = new byte[this.payloadLength - payloadIndex];
            int i = 0;
            while (payloadIndex++ < this.payloadLength) {
                this.debugData[i] = frp.grabNextByte();
                ++i;
            }
        }
    }

    @Override
    public WsByteBuffer buildFrameForWrite() {
        WsByteBuffer buffer = super.buildFrameForWrite();
        byte[] frame = buffer.hasArray() ? buffer.array() : super.createFrameArray();
        this.setFrameHeaders(frame, (byte)7);
        int frameIndex = 9;
        utils.Move31BitstoByteArray(this.lastStreamId, frame, frameIndex);
        utils.Move31BitstoByteArray(this.getErrorCode(), frame, frameIndex += 4);
        frameIndex += 4;
        for (int i = 0; i < this.debugData.length; ++i) {
            frame[frameIndex] = this.debugData[i];
            ++frameIndex;
        }
        buffer.put(frame, 0, this.writeFrameLength);
        buffer.flip();
        return buffer;
    }

    public int getLastStreamId() {
        return this.lastStreamId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public byte[] getDebugData() {
        return this.debugData;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException {
        if (this.streamId != 0) {
            throw new ProtocolException("GOAWAY frame streamID must be 0x0 - received: " + this.streamId);
        }
    }

    @Override
    protected void setFlags() {
    }

    private void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    private void setLastStreamId(int lastStreamId) {
        this.lastStreamId = lastStreamId;
    }

    public void setDebugData(byte[] debugData) {
        this.debugData = debugData;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FrameGoAway)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"equals: object is not a FrameGoAway", (Object[])new Object[0]);
            }
            return false;
        }
        FrameGoAway frameGoAwayToCompare = (FrameGoAway)object;
        if (!super.equals(frameGoAwayToCompare)) {
            return false;
        }
        if (this.getLastStreamId() != frameGoAwayToCompare.getLastStreamId()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getLastStreamId() = " + this.getLastStreamId() + " frameGoAwayToCompare.getLastStreamId() = " + frameGoAwayToCompare.getLastStreamId()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getErrorCode() != frameGoAwayToCompare.getErrorCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getErrorCode() = " + this.getErrorCode() + " frameGoAwayToCompare.getErrorCode() = " + frameGoAwayToCompare.getErrorCode()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("LastStreamId: " + this.getLastStreamId() + "\n");
        frameToString.append("ErrorCode: " + this.getErrorCode() + "\n");
        String errorCode = "";
        if (this.getDebugData() != null) {
            errorCode = new String(this.getDebugData());
        }
        frameToString.append("DebugData: " + errorCode + "\n");
        return frameToString.toString();
    }
}

