/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.openliberty.http.netty.channel.utils.HeaderValidator;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HeaderHandler {
    private static final TraceComponent tc = Tr.register(HeaderHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    HttpChannelConfig config;
    HttpResponse response;
    HttpHeaders headers;
    private static final String NOCACHE_VALUE = "no-cache=\"set-cookie, set-cookie2\"";
    private static final String LONG_AGO = "Thu, 01 Dec 1994 16:00:00 GMT";
    static final long serialVersionUID = -6141400678337508222L;

    public HeaderHandler(HttpChannelConfig config, HttpResponse response) {
        Objects.requireNonNull(config);
        this.config = config;
        Objects.requireNonNull(response);
        this.response = response;
        this.headers = response.headers();
    }

    @ManualTrace
    public void complianceCheck() {
        byte[] serverHeader;
        String method = "headerComplianceCheck";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)method, (Object[])new Object[0]);
        }
        if (!this.headers.contains(HttpHeaderKeys.HDR_DATE.getName())) {
            byte[] date = HttpDispatcher.getDateFormatter().getRFC1123TimeAsBytes(this.config.getDateHeaderRange());
            this.headers.set(HttpHeaderKeys.HDR_DATE.getName(), (Object)new String(date, StandardCharsets.UTF_8));
        }
        if (this.response.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            if (this.headers.contains(HttpHeaderKeys.HDR_TRANSFER_ENCODING.getName())) {
                this.response.headers().remove(HttpHeaderKeys.HDR_TRANSFER_ENCODING.getName());
            }
        } else if (!HttpUtil.isContentLengthSet((HttpMessage)this.response) && !this.headers.contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            if (this.response.status().equals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS)) {
                HttpUtil.setContentLength((HttpMessage)this.response, (long)0L);
                HttpUtil.setTransferEncodingChunked((HttpMessage)this.response, (boolean)false);
            } else {
                HttpUtil.setTransferEncodingChunked((HttpMessage)this.response, (boolean)true);
            }
        }
        if (this.config.removeServerHeader()) {
            if (this.headers.contains(HttpHeaderKeys.HDR_SERVER.getName())) {
                Tr.debug((TraceComponent)tc, (String)"Configuration forcing removal of Server header", (Object[])new Object[0]);
                this.headers.remove(HttpHeaderKeys.HDR_SERVER.getName());
            }
        } else if (!this.headers.contains(HttpHeaderKeys.HDR_SERVER.getName()) && Objects.nonNull(serverHeader = this.config.getServerHeaderValue())) {
            this.headers.set(HttpHeaderKeys.HDR_SERVER.getName(), (Object)new String(serverHeader, StandardCharsets.UTF_8));
            Tr.debug((TraceComponent)tc, (String)("Adding the Server header value: " + this.headers.get(HttpHeaderKeys.HDR_SERVER.getName())), (Object[])new Object[0]);
        }
        if (this.config.shouldCookiesConfigureNoCache()) {
            this.updateCacheControl();
        }
        if (this.config.useHeadersConfiguration()) {
            String value;
            String name;
            for (List<Map.Entry<String, String>> list : this.config.getConfiguredHeadersToAdd().values()) {
                for (Map.Entry<String, String> header : list) {
                    name = HeaderValidator.process(header.getKey(), HeaderValidator.FieldType.NAME, this.config);
                    value = HeaderValidator.process(header.getValue(), HeaderValidator.FieldType.VALUE, this.config);
                    this.headers.add(name, (Object)value);
                }
            }
            for (Map.Entry entry : this.config.getConfiguredHeadersToSet().values()) {
                name = HeaderValidator.process((String)entry.getKey(), HeaderValidator.FieldType.NAME, this.config);
                value = HeaderValidator.process((String)entry.getValue(), HeaderValidator.FieldType.VALUE, this.config);
                this.headers.set(name, (Object)value);
            }
            for (Map.Entry entry : this.config.getConfiguredHeadersToSetIfMissing().values()) {
                if (this.headers.contains((String)entry.getKey())) continue;
                name = HeaderValidator.process((String)entry.getKey(), HeaderValidator.FieldType.NAME, this.config);
                value = HeaderValidator.process((String)entry.getValue(), HeaderValidator.FieldType.VALUE, this.config);
                this.headers.set(name, (Object)value);
            }
            for (String string : this.config.getConfiguredHeadersToRemove().values()) {
                if (!this.headers.contains(string)) continue;
                this.headers.remove(string);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)method);
        }
    }

    private void updateCacheControl() {
        boolean hasCookiev1 = this.headers.contains(HttpHeaderKeys.HDR_SET_COOKIE.getName());
        boolean hasCookiev2 = this.headers.contains(HttpHeaderKeys.HDR_SET_COOKIE2.getName());
        if (!hasCookiev1 && !hasCookiev2) {
            return;
        }
        if (!this.headers.contains(HttpHeaderKeys.HDR_EXPIRES.getName())) {
            this.headers.set(HttpHeaderKeys.HDR_EXPIRES.getName(), (Object)LONG_AGO);
        }
        if (this.headers.contains(HttpHeaderKeys.HDR_CACHE_CONTROL.getName())) {
            String currentCacheControl = this.headers.get(HttpHeaderKeys.HDR_CACHE_CONTROL.getName());
            if (!currentCacheControl.contains("no-cache")) {
                StringBuilder builder = new StringBuilder(currentCacheControl);
                boolean updated = false;
                if (hasCookiev1) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append("no-cache=\"set-cookie\"");
                    updated = true;
                }
                if (hasCookiev2) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append("no-cache=\"set-cookie2\"");
                    updated = true;
                }
                if (updated) {
                    this.headers.set(HttpHeaderKeys.HDR_CACHE_CONTROL.getName(), (Object)builder.toString());
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Adding Cache-Control due to Set-Cookie", (Object[])new Object[0]);
            }
            this.headers.set(HttpHeaderKeys.HDR_CACHE_CONTROL.getName(), (Object)NOCACHE_VALUE);
        }
    }
}

