/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.address.DefaultAddressParser;
import org.apache.james.mime4j.field.address.ParseException;
import org.apache.james.mime4j.stream.Field;

public class MailboxListFieldImpl
extends AbstractField
implements MailboxListField {
    private boolean parsed = false;
    private MailboxList mailboxList;
    private ParseException parseException;
    public static final FieldParser<MailboxListField> PARSER = new FieldParser<MailboxListField>(){

        @Override
        public MailboxListField parse(Field rawField, DecodeMonitor monitor) {
            return new MailboxListFieldImpl(rawField, monitor);
        }
    };

    MailboxListFieldImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    @Override
    public MailboxList getMailboxList() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mailboxList;
    }

    @Override
    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    private void parse() {
        String body = this.getBody();
        try {
            this.mailboxList = DefaultAddressParser.DEFAULT.parseAddressList(body, this.monitor).flatten();
        }
        catch (ParseException e) {
            this.parseException = e;
        }
        this.parsed = true;
    }
}

