/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTServletRequestThreadData {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData";
    private IWebAppDispatcherContext _dispatchContext;
    private String _requestURI = null;
    private String _pathInfo = null;
    private String _queryString = null;
    private Map _parameters = null;
    private LinkedList _queryStringList = null;
    private boolean _qsSetExplicit = false;
    final Thread thread = Thread.currentThread();
    private static WSThreadLocal<SRTServletRequestThreadData> instance = new WSThreadLocal();

    public static SRTServletRequestThreadData getInstance() {
        SRTServletRequestThreadData tempState = null;
        tempState = (SRTServletRequestThreadData)instance.get();
        if (tempState == null) {
            tempState = new SRTServletRequestThreadData();
            instance.set((Object)tempState);
        }
        return tempState;
    }

    public SRTServletRequestThreadData() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructor", " " + super.toString());
        }
    }

    public void init(SRTServletRequestThreadData data) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "int [" + super.toString() + "] ", "init data : " + data);
        }
        if (data == null) {
            this._dispatchContext = null;
            this._requestURI = null;
            this._pathInfo = null;
            this._queryString = null;
            this._parameters = null;
            this._queryStringList = null;
            this._qsSetExplicit = false;
        } else {
            this._dispatchContext = data.getDispatchContext();
            this._requestURI = data.getRequestURI();
            this._pathInfo = data.getPathInfo();
            this._queryString = data.getQueryString();
            this._parameters = data.getParameters();
            this._queryStringList = data.getQueryStringList();
            this._qsSetExplicit = data.isQSSetExplicit();
        }
    }

    public String toString() {
        return super.toString() + ", [_requestURI=" + this._requestURI + ", _pathInfo=" + this._pathInfo + ", _queryString=" + this._queryString + ", _parameters=" + this._parameters + ", _qsSetExplicit=" + this._qsSetExplicit + ", _dispatchContext= " + this._dispatchContext + "]";
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public void setRequestURI(String requestURI) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setRequestURI", requestURI);
        }
        this._requestURI = requestURI;
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setPathInfo", pathInfo);
        }
        this._pathInfo = pathInfo;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public void setQueryString(String queryString) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setQueryString", queryString);
        }
        this._qsSetExplicit = true;
        this._queryString = queryString;
    }

    public boolean isQSSetExplicit() {
        return this._qsSetExplicit;
    }

    public IWebAppDispatcherContext getDispatchContext() {
        return this._dispatchContext;
    }

    public void setDispatchContext(IWebAppDispatcherContext dispatchContext) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setDispatchContext", "dispatchContext = " + dispatchContext);
        }
        this._dispatchContext = dispatchContext;
    }

    public Map getParameters() {
        return this._parameters;
    }

    public void setParameters(Map parameters) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setParameters", "Number of parameters = " + (parameters == null ? "none" : Integer.valueOf(parameters.size())));
        }
        this._parameters = parameters;
    }

    public LinkedList getQueryStringList() {
        return this._queryStringList;
    }

    public void setQueryStringList(LinkedList _queryStringList) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setQueryStringList", "Number in list = " + (_queryStringList == null ? "none" : Integer.valueOf(_queryStringList.size())));
        }
        this._queryStringList = _queryStringList;
    }
}

