/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tls.impl.handler;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.openliberty.netty.internal.tls.impl.options.SslOption;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertySslHandler
extends SslHandler {
    private static final TraceComponent tc = Tr.register(LibertySslHandler.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private final boolean suppressLogError;
    private final long maxLogEntries;
    private static final AttributeKey<Long> SSL_EXCEPTION_LOG_ENTRIES = AttributeKey.valueOf((String)"SSL_EXCEPTION_LOG_ENTRIES");
    private static final AttributeKey<AtomicBoolean> SSL_EXCEPTION_LOGGING_STOPPED = AttributeKey.valueOf((String)"SSL_EXCEPTION_LOGGING_STOPPED");
    static final long serialVersionUID = 7520666365905016582L;

    public LibertySslHandler(SSLEngine engine, Map<String, Object> sslOptions, Channel channel) {
        super(engine);
        Boolean enforceCipherOrder = (Boolean)SslOption.ENFORCE_CIPHER_ORDER.parse(sslOptions);
        this.engine().getSSLParameters().setUseCipherSuitesOrder(enforceCipherOrder);
        this.suppressLogError = (Boolean)SslOption.SUPPRESS_HANDSHAKE_ERRORS.parse(sslOptions);
        this.maxLogEntries = (Long)SslOption.SUPPRESS_HANDSHAKE_ERRORS_COUNT.parse(sslOptions);
        if (Objects.nonNull(channel.parent())) {
            channel.parent().attr(SSL_EXCEPTION_LOG_ENTRIES).setIfAbsent((Object)new Long(0L));
            channel.parent().attr(SSL_EXCEPTION_LOGGING_STOPPED).setIfAbsent((Object)new AtomicBoolean(false));
        } else {
            channel.attr(SSL_EXCEPTION_LOG_ENTRIES).setIfAbsent((Object)new Long(0L));
            channel.attr(SSL_EXCEPTION_LOGGING_STOPPED).setIfAbsent((Object)new AtomicBoolean(false));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof SSLHandshakeException) {
            InetSocketAddress local = (InetSocketAddress)ctx.channel().localAddress();
            InetSocketAddress remote = (InetSocketAddress)ctx.channel().remoteAddress();
            this.noteHandshakeError((Exception)cause, local.getAddress(), local.getPort(), remote.getAddress(), remote.getPort(), ctx.channel());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Non-SSL exception caught: " + cause.getMessage()), (Object[])new Object[0]);
        }
        super.exceptionCaught(ctx, cause);
    }

    private void noteHandshakeError(Exception failure, InetAddress localAddr, int localPort, InetAddress remoteAddr, int remotePort, Channel channel) {
        AtomicBoolean loggingStopped;
        long logCount;
        if (Objects.nonNull(channel.parent())) {
            logCount = (Long)channel.parent().attr(SSL_EXCEPTION_LOG_ENTRIES).get();
            channel.parent().attr(SSL_EXCEPTION_LOG_ENTRIES).set((Object)(++logCount));
            loggingStopped = (AtomicBoolean)channel.parent().attr(SSL_EXCEPTION_LOGGING_STOPPED).get();
        } else {
            logCount = (Long)channel.attr(SSL_EXCEPTION_LOG_ENTRIES).get();
            channel.attr(SSL_EXCEPTION_LOG_ENTRIES).set((Object)(++logCount));
            loggingStopped = (AtomicBoolean)channel.parent().attr(SSL_EXCEPTION_LOGGING_STOPPED).get();
        }
        Exception ssle = failure;
        if (failure.getMessage().contains("plaintext connection?")) {
            ssle = new SSLException("The WebSphere server received an unencrypted inbound communication on a secure connection. This does not indicate a problem with the WebSphere server. To resolve the issue, configure the client to use SSL or to connect to a port on the WebSphere server that does not require SSL.", failure.getCause());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("noteHandshakeError (" + logCount + "): " + ssle.getMessage()), (Object[])new Object[]{ssle});
        }
        if (!this.suppressLogError) {
            if (logCount <= this.maxLogEntries) {
                Tr.error((TraceComponent)tc, (String)"handshake.failure", (Object[])new Object[]{ssle, remoteAddr.getHostAddress(), remotePort, localAddr.getHostAddress(), localPort});
            } else if (!loggingStopped.get() && logCount > this.maxLogEntries) {
                loggingStopped.set(true);
                Tr.info((TraceComponent)tc, (String)"handshake.failure.stop.logging", (Object[])new Object[0]);
            }
        }
    }
}

