/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.asm.ASMHelper;
import io.openliberty.checkpoint.internal.CheckpointImpl;
import io.openliberty.checkpoint.internal.criu.DeployCheckpoint;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CheckpointTransformer
implements ClassFileTransformer {
    private static final TraceComponent tc = Tr.register(CheckpointTransformer.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
    private static final String CLASS_DEPLOY_CHECKPOINT_NAME = DeployCheckpoint.class.getName();
    private static final String CLASS_DEPLOY_CHECKPOINT_PATH = CLASS_DEPLOY_CHECKPOINT_NAME.replace('.', '/');
    static final long serialVersionUID = -2006657680619248511L;

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        CheckpointImpl.debug(tc, () -> "transforming class" + className);
        if (this.noClassFound(loader)) {
            return null;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(cr, ASMHelper.getCurrentASM());
        ClassVisitor cv = new ClassVisitor(ASMHelper.getCurrentASM(), (ClassVisitor)cw){
            boolean visitedStaticBlock;
            private boolean isStaticClass;
            private boolean isInterface;
            static final long serialVersionUID = -2111800551232474879L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.visitedStaticBlock = false;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.isStaticClass = (access & 8) != 0;
                this.isInterface = (access & 0x200) != 0;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                boolean isStaticMethod;
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                boolean bl = isStaticMethod = (access & 8) != 0;
                if (!this.isStaticClass && !this.isInterface && isStaticMethod && "<clinit>".equals(name)) {
                    this.visitedStaticBlock = true;
                    mv = new StaticBlockMethodVisitor(mv);
                }
                return mv;
            }

            public void visitEnd() {
                if (!(this.isStaticClass || this.isInterface || this.visitedStaticBlock)) {
                    MethodVisitor mv = this.visitMethod(8, "<clinit>", "()V", null, null);
                    mv.visitCode();
                    mv.visitInsn(177);
                    mv.visitMaxs(0, 0);
                    mv.visitEnd();
                }
                super.visitEnd();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointTransformer$1", 1.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
            }

            @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
            @InjectedFFDC
            @TraceOptions
            class StaticBlockMethodVisitor
            extends MethodVisitor {
                static final long serialVersionUID = 5854736726113314904L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                StaticBlockMethodVisitor(MethodVisitor mv) {
                    super(ASMHelper.getCurrentASM(), mv);
                }

                public void visitCode() {
                    super.visitCode();
                    this.mv.visitMethodInsn(184, CLASS_DEPLOY_CHECKPOINT_PATH, "checkpoint", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointTransformer$1$StaticBlockMethodVisitor", StaticBlockMethodVisitor.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
                }
            }
        };
        cr.accept(cv, 0);
        return cw.toByteArray();
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private boolean noClassFound(ClassLoader loader) {
        try {
            loader.loadClass(CLASS_DEPLOY_CHECKPOINT_NAME);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return false;
    }
}

