/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.data.AccessLogConfig;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.CollectorManager;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryLifecycleManager;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemtryLifecycleManagerImpl;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.openliberty.microprofile.telemetry.spi.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry20.logging.internal.MpTelemetryLogMappingUtils;
import io.openliberty.microprofile.telemetry20.logging.internal.semconv.SemconvConstantsAccessor;
import io.opentelemetry.api.logs.LogRecordBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.SatisfyingConditionTarget;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="io.openliberty.microprofile.telemetry20.logging.internal.OpenTelemetryLogHandler", service={Handler.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"})
@SatisfyingConditionTarget(value="(osgi.condition.id=io.openliberty.process.running)")
public class OpenTelemetryLogHandler
implements SynchronousHandler,
OpenTelemtryLifecycleManagerImpl.OpenTelemetryInfoReadyListener {
    private static final TraceComponent tc = Tr.register(OpenTelemetryLogHandler.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    public static final String COMPONENT_NAME = "io.openliberty.microprofile.telemetry20.logging.internal.OpenTelemetryLogHandler";
    @Reference
    OpenTelemetryLifecycleManager openTelemetryLifecycleManager;
    OpenTelemtryLifecycleManagerImpl openTelemtryLifecycleManagerImpl;
    protected static volatile boolean isInit = false;
    protected CollectorManager collectorMgr = null;
    private static final String SOURCE_LIST_KEY = "source";
    private OpenTelemetryInfo runtimeOtelInfo;
    private List<String> sourcesList = new ArrayList<String>();
    static String accessLogField = null;
    @Reference
    SemconvConstantsAccessor semconvConstantsAccessor;
    private final ThreadLocal<List<Object>> queuedMessages = ThreadLocal.withInitial(() -> new ArrayList());
    static final long serialVersionUID = 1032620718683703171L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"In activate()", (Object[])new Object[0]);
        }
        this.runtimeOtelInfo = OpenTelemetryAccessor.getOpenTelemetryInfo();
        this.sourcesList = this.validateSources(configuration);
        this.setAccessLogField(configuration);
        this.openTelemtryLifecycleManagerImpl = (OpenTelemtryLifecycleManagerImpl)this.openTelemetryLifecycleManager;
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"In deactivate()", (Object[])new Object[0]);
        }
        this.collectorMgr = null;
    }

    /*
     * WARNING - void declaration
     */
    @Modified
    protected void modified(Map<String, Object> configuration) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"In modified()", (Object[])new Object[0]);
            }
            List<String> newSources = this.validateSources(configuration);
            this.setAccessLogField(configuration);
            if (this.collectorMgr == null || !isInit) {
                this.sourcesList = newSources;
                return;
            }
            try {
                ArrayList<String> oldSources = new ArrayList<String>(this.sourcesList);
                ArrayList<String> sourcesToRemove = new ArrayList<String>(oldSources);
                sourcesToRemove.removeAll(newSources);
                this.collectorMgr.unsubscribe((Handler)this, this.convertToSourceIDList(sourcesToRemove));
                ArrayList<String> sourcesToAdd = new ArrayList<String>(newSources);
                sourcesToAdd.removeAll(oldSources);
                this.collectorMgr.subscribe((Handler)this, this.convertToSourceIDList(sourcesToAdd));
                this.sourcesList = newSources;
            }
            catch (Exception oldSources) {
                void e;
                FFDCFilter.processException((Throwable)oldSources, (String)COMPONENT_NAME, (String)"141", (Object)this, (Object[])new Object[]{configuration});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Caught an exception when subscribing/unsubscribing the Collector Manager", (Object[])new Object[]{e});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(CollectorManager collectorManager) {
        block2: {
            try {
                this.collectorMgr = collectorManager;
                this.collectorMgr.subscribe((Handler)this, this.convertToSourceIDList(this.sourcesList));
                isInit = true;
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)COMPONENT_NAME, (String)"156", (Object)this, (Object[])new Object[]{collectorManager});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Caught an exception when subscribing to Collector Manager", (Object[])new Object[]{e});
            }
        }
    }

    public String getHandlerName() {
        return COMPONENT_NAME;
    }

    private void formatEvent(LogRecordBuilder builder, String source, Object event) {
        String eventType = MpTelemetryLogMappingUtils.getLibertyEventType(source);
        MpTelemetryLogMappingUtils.mapLibertyEventToOpenTelemetry(builder, eventType, event, this.semconvConstantsAccessor);
    }

    public void synchronousWrite(Object event) {
        OpenTelemetryInfo otelInstance = null;
        if (OpenTelemetryAccessor.isRuntimeEnabled()) {
            otelInstance = this.runtimeOtelInfo;
            this.synchronousWriteInternal(event, otelInstance);
        } else if (!this.openTelemtryLifecycleManagerImpl.isOpenTelemetryInitalized()) {
            this.queuedMessages.get().add(event);
        } else {
            otelInstance = OpenTelemetryAccessor.getOpenTelemetryInfo();
            this.synchronousWriteInternal(event, otelInstance);
        }
    }

    public void notifyOpenTelemetryInfoReady(OpenTelemetryInfo otelInstance) {
        for (Object event : this.queuedMessages.get()) {
            this.synchronousWriteInternal(event, otelInstance);
        }
        this.queuedMessages.set(null);
    }

    @Trivial
    private void synchronousWriteInternal(Object event, OpenTelemetryInfo otelInstance) {
        if (otelInstance != null && otelInstance.isEnabled()) {
            GenericData genData = null;
            if (!(event instanceof GenericData)) {
                throw new IllegalArgumentException("Event is not an instance of GenericData.");
            }
            genData = (GenericData)event;
            String eventSourceName = this.getSourceNameFromDataObject(genData);
            if (!eventSourceName.isEmpty()) {
                if (this.isOTelMappedEvent(event)) {
                    return;
                }
                if (AgentDetection.isAgentActive() && !this.isTrEvent(event)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Agent is active, and received event is NOT logged by Tr.", (Object[])new Object[]{event.toString()});
                    }
                    return;
                }
                LogRecordBuilder builder = otelInstance.getOpenTelemetry().getLogsBridge().loggerBuilder("io.openliberty.microprofile.telemetry").build().logRecordBuilder();
                this.formatEvent(builder, eventSourceName, event);
                if (builder != null) {
                    builder.emit();
                }
            }
        }
    }

    private boolean isOTelMappedEvent(Object event) {
        boolean isOTelMappedEvent = false;
        String eventMsg = "";
        if (event instanceof LogTraceData) {
            eventMsg = ((LogTraceData)event).getMessage();
        } else if (event instanceof FFDCData) {
            eventMsg = ((FFDCData)event).getMessage();
        }
        if (eventMsg != null) {
            isOTelMappedEvent = eventMsg.contains("scopeInfo:");
        }
        return isOTelMappedEvent;
    }

    private boolean isTrEvent(Object event) {
        boolean isTrEvent = true;
        if (event instanceof LogTraceData) {
            isTrEvent = ((LogTraceData)event).isTr();
        }
        return isTrEvent;
    }

    private List<String> validateSources(Map<String, Object> config) {
        Object[] sources;
        ArrayList<String> validatedList = new ArrayList<String>();
        if (config.containsKey(SOURCE_LIST_KEY) && (sources = (String[])config.get(SOURCE_LIST_KEY)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Original sources list: ", (Object[])new Object[]{Arrays.toString(sources)});
            }
            for (Object source : sources) {
                if (((String)source).isEmpty()) continue;
                if (this.getSourceName(((String)source).trim()).isEmpty()) {
                    Tr.warning((TraceComponent)tc, (String)"CWMOT5005.mptelemetry.unknown.log.source", (Object[])new Object[]{source});
                    continue;
                }
                validatedList.add((String)source);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Validated sources list: ", (Object[])new Object[]{Arrays.toString(validatedList.toArray())});
        }
        return validatedList;
    }

    private List<String> convertToSourceIDList(List<String> sourceList) {
        ArrayList<String> sourceIDList = new ArrayList<String>();
        for (String source : sourceList) {
            String sourceName = this.getSourceName(source);
            if (sourceName.equals("")) continue;
            if (!sourceName.contains("audit")) {
                sourceIDList.add(this.getSourceName(source) + "|" + "memory");
                continue;
            }
            sourceIDList.add(this.getSourceName(source) + "|" + "server");
        }
        return sourceIDList;
    }

    private String getSourceName(String source) {
        if (source.equalsIgnoreCase("message")) {
            return "com.ibm.ws.logging.source.message";
        }
        if (source.equalsIgnoreCase("trace")) {
            return "com.ibm.ws.logging.source.trace";
        }
        if (source.equalsIgnoreCase("ffdc")) {
            return "com.ibm.ws.logging.ffdc.source.ffdcsource";
        }
        if (source.equalsIgnoreCase("audit")) {
            return "audit";
        }
        if (source.equalsIgnoreCase("accessLog")) {
            return "com.ibm.ws.http.logging.source.accesslog";
        }
        return "";
    }

    private String getSourceNameFromDataObject(Object event) {
        GenericData genData = (GenericData)event;
        String sourceName = genData.getSourceName();
        if (sourceName.equals("com.ibm.ws.logging.source.message")) {
            return "com.ibm.ws.logging.source.message";
        }
        if (sourceName.equals("com.ibm.ws.logging.source.trace")) {
            return "com.ibm.ws.logging.source.trace";
        }
        if (sourceName.equals("com.ibm.ws.logging.ffdc.source.ffdcsource")) {
            return "com.ibm.ws.logging.ffdc.source.ffdcsource";
        }
        if (sourceName.contains("audit")) {
            return "audit";
        }
        if (sourceName.equals("com.ibm.ws.http.logging.source.accesslog")) {
            return "com.ibm.ws.http.logging.source.accesslog";
        }
        return "";
    }

    private void setAccessLogField(Map<String, Object> configuration) {
        accessLogField = (String)configuration.get("accessLogFields");
        AccessLogConfig.accessLogFieldsTelemetryConfig = accessLogField != null ? (accessLogField.toLowerCase().equals("default") || accessLogField.toLowerCase().equals("logformat") ? accessLogField : "default") : "default";
    }

    public void unsetBufferManager(String arg0, BufferManager arg1) {
    }

    public void setBufferManager(String arg0, BufferManager arg1) {
    }
}

