/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi40.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OpenAPIValidator;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIDefinition31Validator
extends TypeValidator<OpenAPI> {
    private static final TraceComponent tc = Tr.register(OpenAPIDefinition31Validator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final OpenAPIDefinition31Validator INSTANCE = new OpenAPIDefinition31Validator();
    static final long serialVersionUID = -3772625864227955225L;

    public static OpenAPIDefinition31Validator getInstance() {
        return INSTANCE;
    }

    private OpenAPIDefinition31Validator() {
    }

    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OpenAPI t) {
        if (t != null) {
            String message;
            String openapiVersion = t.getOpenapi();
            ValidatorUtils.validateRequiredField((Object)openapiVersion, (OpenAPIModelWalker.Context)context, (String)"openapi").ifPresent(arg_0 -> ((ValidationHelper)helper).addValidationEvent(arg_0));
            ValidatorUtils.validateRequiredField((Object)t.getInfo(), (OpenAPIModelWalker.Context)context, (String)"info").ifPresent(arg_0 -> ((ValidationHelper)helper).addValidationEvent(arg_0));
            if (openapiVersion != null && !openapiVersion.startsWith("3.")) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"openAPIVersionInvalid", (Object[])new Object[]{openapiVersion});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (t.getPaths() == null && t.getComponents() == null && t.getWebhooks() == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"openAPIMissingRequiredFields", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            OpenAPIValidator.getInstance().validateTags(helper, context, t);
        }
    }
}

