/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidMessageException;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SourceStream
extends ControllableStream
implements BatchListener {
    private static final TraceComponent tc = SibTr.register(SourceStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private StreamSet streamSet;
    private SourceStreamState sourceStreamState = SourceStreamState.ACTIVE;
    private int priority;
    private Reliability reliability;
    private DownstreamControl downControl;
    private StateStream oststream;
    private long oack = 0L;
    private boolean ackExpAlarmStarted = false;
    private final AckExpExpiryHandler ackExpExpiryHandler;
    private BlockedStreamAlarm blockedStreamAlarm;
    private DestinationHandler dh;
    private MessageProcessor mp;
    private MPAlarmManager am;
    private long lastMsgAdded = 0L;
    private long lastMsgSent = 0L;
    private long timerStartSendTick = 0L;
    private long ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
    private SIBUuid12 stream;
    private boolean containsGuesses = false;
    private long definedSendWindow;
    private long sendWindow = this.definedSendWindow = 1000L;
    private long firstMsgOutsideWindow = Long.MAX_VALUE;
    private long totalMessages = 0L;
    private long totalMessagesSent = 0L;
    private long timeLastMsgSent = 0L;
    private SourceStreamControl srcStreamControl;
    List batchList = null;
    List batchSendList = null;
    private boolean inboundFlow = true;
    private long lastAckExpTick;
    private long lastNackReceivedTick;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceStream(int priority, Reliability reliability, DownstreamControl downControl, List scratch, StreamSet streamSet, MPAlarmManager am, DestinationHandler dh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SourceStream", (Object)new Object[]{priority, reliability, downControl, scratch, streamSet, am, dh});
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream = new StateStream();
            this.oststream.init();
            this.downControl = downControl;
            this.priority = priority;
            this.reliability = reliability;
            this.streamSet = streamSet;
            this.stream = streamSet.getStreamID();
            this.am = am;
            this.dh = dh;
            this.mp = dh.getMessageProcessor();
            this.ackExpExpiryHandler = new AckExpExpiryHandler(this);
            this.batchList = new ArrayList();
            this.batchSendList = new ArrayList();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SourceStream", (Object)this);
        }
    }

    @Override
    public int getPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)this.priority);
        }
        return this.priority;
    }

    @Override
    public Reliability getReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReliability");
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    @Override
    public long getCompletedPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCompletedPrefix");
        }
        long returnValue = this.oststream.getCompletedPrefix();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)returnValue);
        }
        return returnValue;
    }

    public long getAckPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAckPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getAckPrefix", (Object)this.oack);
        }
        return this.oack;
    }

    public synchronized long getLastMsgAdded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLastMsgAdded");
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgAdded", (Object)this.lastMsgAdded);
        }
        return this.lastMsgAdded;
    }

    public synchronized long getLastMsgSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLastMsgSent");
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgSent", (Object)this.lastMsgSent);
        }
        return this.lastMsgSent;
    }

    public synchronized long getTotalMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTotalMessages");
            SibTr.exit((TraceComponent)tc, (String)"getTotalMessages", (Object)this.totalMessages);
        }
        return this.totalMessages;
    }

    public synchronized long getTotalMessagesSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTotalMessagesSent");
            SibTr.exit((TraceComponent)tc, (String)"getTotalMessagesSent", (Object)this.totalMessagesSent);
        }
        return this.totalMessagesSent;
    }

    public synchronized long getLastMsgSentTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLastMsgSentTime");
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgSentTime", (Object)this.timeLastMsgSent);
        }
        return this.timeLastMsgSent;
    }

    public synchronized long getFirstMsgOutsideWindow() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFirstMsgOutsideWindow");
            SibTr.exit((TraceComponent)tc, (String)"getFirstMsgOutsideWindow", (Object)this.firstMsgOutsideWindow);
        }
        return this.firstMsgOutsideWindow;
    }

    public synchronized long getSendWindow() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSendWindow");
            SibTr.exit((TraceComponent)tc, (String)"getSendWindow", (Object)this.sendWindow);
        }
        return this.sendWindow;
    }

    public synchronized boolean containsGuesses() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"containsGuesses");
            SibTr.exit((TraceComponent)tc, (String)"containsGuesses", (Object)this.containsGuesses);
        }
        return this.containsGuesses;
    }

    @Override
    public StateStream getStateStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStateStream");
            SibTr.exit((TraceComponent)tc, (String)"getStateStream", (Object)this.oststream);
        }
        return this.oststream;
    }

    public SourceStreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStreamState");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.sourceStreamState);
        }
        return this.sourceStreamState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUncommitted(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeUncommitted", (Object)new Object[]{m});
        }
        TickRange tr = null;
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long starts = jsMsg.getGuaranteedValueStartTick();
        long ends = jsMsg.getGuaranteedValueEndTick();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeUncommitted at: " + stamp + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            if (m.getStreamIsGuess()) {
                this.newGuessInStream(stamp);
            }
            this.msgAdded(stamp);
            tr = TickRange.newUncommittedTick(stamp);
            tr.startstamp = starts;
            tr.endstamp = ends;
            tr.value = m;
            this.oststream.writeCombinedRange(tr);
            this.lastMsgAdded = stamp;
            if (this.blockedStreamAlarm == null) {
                this.blockedStreamAlarm = new BlockedStreamAlarm(this.getCompletedPrefix());
                this.am.create(this.mp.getCustomProperties().getBlockedStreamHealthCheckInterval(), this.blockedStreamAlarm);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeUncommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeValue(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeValue", (Object)m);
        }
        TickRange tr = null;
        boolean sendMessage = true;
        long msgStoreId = -1L;
        try {
            if (m.isInStore()) {
                msgStoreId = m.getID();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.writeValue", (String)"1:520:1.138", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long starts = jsMsg.getGuaranteedValueStartTick();
        long ends = jsMsg.getGuaranteedValueEndTick();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeValue at: " + stamp + " with Value from: " + starts + " to " + ends + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tr = TickRange.newValueTick(stamp, null, msgStoreId);
            tr.startstamp = starts;
            tr.endstamp = ends;
            this.oststream.writeCombinedRange(tr);
            sendMessage = this.msgCanBeSent(stamp, false);
            if (sendMessage) {
                if (stamp > this.lastMsgSent) {
                    this.lastMsgSent = stamp;
                }
                if (!this.ackExpAlarmStarted) {
                    this.ackExpAlarmStarted = true;
                    this.timerStartSendTick = this.lastMsgSent;
                    this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                    this.am.create(this.ackExpInterval, this.ackExpExpiryHandler);
                }
                if (this.blockedStreamAlarm != null) {
                    this.blockedStreamAlarm.checkState(false);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)sendMessage);
        }
        return sendMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSilence(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{m});
        }
        boolean sendMessage = true;
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long start = jsMsg.getGuaranteedValueStartTick();
        long end = jsMsg.getGuaranteedValueEndTick();
        if (end < stamp) {
            end = stamp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilence from: " + start + " to " + end + " on Stream " + this.stream));
        }
        TickRange tr = new TickRange(7, start, end);
        ArrayList<TickRange> sendList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream.writeCompletedRange(tr);
            sendMessage = this.msgCanBeSent(stamp, false);
            if (sendMessage && stamp > this.lastMsgSent) {
                this.lastMsgSent = stamp;
            }
            TickRange tr1 = null;
            tr1 = this.msgRemoved(stamp, this.oststream, null);
            if (tr1 != null) {
                sendList = new ArrayList<TickRange>();
                sendList.add(tr1);
                if (tr1.valuestamp > this.lastMsgSent) {
                    this.lastMsgSent = tr1.valuestamp;
                }
            }
            if (this.blockedStreamAlarm != null) {
                this.blockedStreamAlarm.checkState(false);
            }
        }
        if (sendList != null) {
            this.sendMsgs(sendList, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
        return sendMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSilenceForced(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilenceForced", (Object)new Object[]{m});
        }
        boolean msgRemoved = true;
        JsMessage jsMsg = m.getMessage();
        long start = jsMsg.getGuaranteedValueStartTick();
        long end = jsMsg.getGuaranteedValueEndTick();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + start + " to " + end + " on Stream " + this.stream));
        }
        TickRange tr = new TickRange(7, start, end);
        LinkedList<TickRange> sendList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            if (end <= this.getCompletedPrefix()) {
                msgRemoved = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Message " + end + " already completed"), (Object)m);
                }
            } else {
                this.oststream.writeCompletedRangeForced(tr);
                TickRange str = null;
                str = this.msgRemoved(jsMsg.getGuaranteedValueValueTick(), this.oststream, null);
                if (str != null) {
                    sendList = new LinkedList<TickRange>();
                    sendList.add(str);
                    if (str.valuestamp > this.lastMsgSent) {
                        this.lastMsgSent = str.valuestamp;
                    }
                }
            }
        }
        if (sendList != null) {
            this.sendMsgs(sendList, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced", (Object)msgRemoved);
        }
        return msgRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(TickRange vtr) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilenceForced", (Object)new Object[]{vtr});
        }
        long start = vtr.startstamp;
        long end = vtr.endstamp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + start + " to " + end + " on Stream " + this.stream));
        }
        TickRange tr = new TickRange(7, start, end);
        LinkedList<TickRange> sendList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream.writeCompletedRangeForced(tr);
            TickRange str = null;
            str = this.msgRemoved(vtr.valuestamp, this.oststream, null);
            if (str != null) {
                sendList = new LinkedList<TickRange>();
                sendList.add(str);
                if (str.valuestamp > this.lastMsgSent) {
                    this.lastMsgSent = str.valuestamp;
                }
            }
        }
        if (sendList != null) {
            this.sendMsgs(sendList, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSilenceForced(long tick) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilenceForced", (Object)tick);
        }
        long startTick = -1L;
        long endTick = -1L;
        long completedPrefix = -1L;
        LinkedList<TickRange> sendList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            TickRange silenceRange;
            this.oststream.setCursor(tick);
            TickRange tr = this.oststream.getNext();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + tr.startstamp + " to " + tr.endstamp + " on Stream " + this.stream));
            }
            if ((silenceRange = this.oststream.writeCompletedRangeForced(tr)) != null) {
                startTick = silenceRange.startstamp;
                endTick = silenceRange.endstamp;
                completedPrefix = this.getCompletedPrefix();
            }
            TickRange str = null;
            str = this.msgRemoved(tick, this.oststream, null);
            if (str != null) {
                sendList = new LinkedList<TickRange>();
                sendList.add(str);
                if (str.valuestamp > this.lastMsgSent) {
                    this.lastMsgSent = str.valuestamp;
                }
            }
        }
        if (startTick != -1L) {
            this.downControl.sendSilenceMessage(startTick, endTick, completedPrefix, false, this.priority, this.reliability, this.stream);
        }
        if (sendList != null) {
            this.sendMsgs(sendList, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List writeAckPrefix(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeAckPrefix", (Object)stamp);
        }
        ArrayList<TickRange> indexList = new ArrayList<TickRange>();
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            if (stamp >= this.lastAckExpTick) {
                this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.ACK_EXPECTED_STATE, 2);
                this.lastAckExpTick = Long.MAX_VALUE;
            }
            if (stamp >= this.lastNackReceivedTick) {
                this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.NACK_RECEIVED_STATE, 2);
                this.lastNackReceivedTick = Long.MAX_VALUE;
            }
            this.inboundFlow = true;
            long completedPrefix = this.oststream.getCompletedPrefix();
            if (stamp > completedPrefix) {
                this.oststream.setCursor(completedPrefix + 1L);
                TickRange tr = this.oststream.getNext();
                TickRange tr2 = null;
                while (tr.startstamp <= stamp && tr != tr2) {
                    if (tr.type == 3) {
                        indexList.add(tr);
                        ++this.totalMessagesSent;
                        this.timeLastMsgSent = System.currentTimeMillis();
                    } else if (tr.type != 7) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Invalid message found processing ack stamp " + stamp + ": completed prefix " + completedPrefix), (Object)tr);
                        }
                        InvalidMessageException invalidMessageException = new InvalidMessageException();
                        FFDCFilter.processException((Throwable)invalidMessageException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.writeAckPrefix", (String)"1:981:1.138", (Object)this, (Object[])new Object[]{stamp, completedPrefix, tr});
                        long endstamp = tr.endstamp;
                        if (endstamp > stamp) {
                            endstamp = stamp;
                        }
                        TickRange completedTr = new TickRange(7, tr.startstamp, endstamp);
                        this.oststream.writeCompletedRangeForced(completedTr);
                    }
                    tr2 = tr;
                    tr = this.oststream.getNext();
                }
                if ((long)indexList.size() > this.sendWindow) {
                    this.sendWindow = indexList.size();
                    while (tr.type == 7 && tr.endstamp != Long.MAX_VALUE) {
                        tr = this.oststream.getNext();
                    }
                    this.firstMsgOutsideWindow = tr.valuestamp;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("firstMsgOutsideWindow: " + this.firstMsgOutsideWindow + ", sendWindow: " + this.sendWindow));
                    }
                }
                this.oststream.setCompletedPrefix(stamp);
                this.oack = this.oststream.getCompletedPrefix();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeAckPrefix", (Object)Boolean.FALSE);
        }
        return indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNack(ControlNack nm) throws SIResourceException {
        long completedPrefix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processNack", (Object)nm);
        }
        boolean sendPending = false;
        ArrayList<TickRange> sendList = new ArrayList<TickRange>();
        boolean sendLeadingSilence = false;
        long lsstart = 0L;
        long lsend = 0L;
        boolean sendTrailingSilence = false;
        long tsstart = 0L;
        long tsend = 0L;
        long startstamp = nm.getStartTick();
        long endstamp = nm.getEndTick();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("processNack from: " + startstamp + " to " + endstamp + " on Stream " + this.stream));
        }
        TickRange r = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.NACK_RECEIVED_STATE, 1);
            this.lastNackReceivedTick = endstamp;
            this.inboundFlow = true;
            completedPrefix = this.oststream.getCompletedPrefix();
            if (startstamp <= completedPrefix) {
                sendLeadingSilence = true;
                lsstart = startstamp;
                lsend = completedPrefix;
                startstamp = completedPrefix + 1L;
            }
            if (endstamp > completedPrefix) {
                this.oststream.setCursor(startstamp);
                TickRange tr = this.oststream.getNext();
                TickRange tr2 = null;
                while (tr.startstamp <= endstamp && tr != tr2 && tr.type != 0 && tr.type != 1) {
                    if (tr.type == 3) {
                        if (sendPending) {
                            sendList.add(r);
                        }
                        if (!this.msgCanBeSent(tr.valuestamp, true)) break;
                        r = (TickRange)tr.clone();
                        sendPending = true;
                    } else if (tr.type == 2 && sendPending) {
                        if (tr.valuestamp > r.valuestamp + 1L) {
                            r.endstamp = tr.valuestamp - 1L;
                        }
                        sendList.add(r);
                        sendPending = false;
                    }
                    tr2 = tr;
                    tr = this.oststream.getNext();
                }
                if (tr2 != null && tr2.type == 7) {
                    if (sendPending) {
                        r.endstamp = tr2.endstamp;
                    } else if (this.msgCanBeSent(tr2.startstamp, true)) {
                        sendTrailingSilence = true;
                        tsstart = tr2.startstamp;
                        tsend = tr2.endstamp;
                    }
                }
                if (sendPending) {
                    sendList.add(r);
                }
            }
        }
        if (sendLeadingSilence) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("processNack sending Silence from: " + lsstart + " to " + lsend + " on Stream " + this.stream));
            }
            try {
                this.downControl.sendSilenceMessage(lsstart, lsend, completedPrefix, true, nm.getPriority(), nm.getReliability(), this.stream);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.processNack", (String)"1:1222:1.138", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (sendList.size() != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("processNack resending Value messages on Stream " + this.stream));
            }
            this.sendMsgs(sendList, true);
        }
        if (sendTrailingSilence) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("processNack sending Silence from: " + tsstart + " to " + tsend + " on Stream " + this.stream));
            }
            try {
                this.downControl.sendSilenceMessage(tsstart, tsend, completedPrefix, true, nm.getPriority(), nm.getReliability(), this.stream);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.processNack", (String)"1:1267:1.138", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List restoreStream(int startMode) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreStream");
        }
        ArrayList<Long> sentMsgs = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream.setCursor(0L);
            TickRange tr = this.oststream.getNext();
            long prevValue = 0L;
            while (tr.endstamp != Long.MAX_VALUE) {
                if (tr.type == 3 || tr.type == 2) {
                    if (prevValue + 1L < tr.valuestamp) {
                        TickRange tr1 = new TickRange(7, prevValue + 1L, tr.valuestamp - 1L);
                        this.oststream.writeCompletedRange(tr1);
                    }
                    prevValue = tr.valuestamp;
                    ++this.totalMessages;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("totalMessages: " + this.totalMessages + ", sendWindow: " + this.sendWindow));
                    }
                    if (this.totalMessages > this.sendWindow) {
                        if (this.firstMsgOutsideWindow == Long.MAX_VALUE) {
                            this.firstMsgOutsideWindow = tr.valuestamp;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("firstMsgOutsideWindow: " + this.firstMsgOutsideWindow));
                            }
                        }
                    } else if (tr.type == 3) {
                        this.lastMsgSent = tr.valuestamp;
                        if (sentMsgs == null) {
                            sentMsgs = new ArrayList<Long>();
                        }
                        sentMsgs.add(tr.itemStreamIndex);
                    }
                    this.oststream.setCursor(tr.valuestamp);
                    tr = this.oststream.getNext();
                }
                tr = this.oststream.getNext();
            }
            this.lastMsgAdded = prevValue;
            if (this.containsGuesses) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Stream is in guess state with " + this.totalMessages + " messages (" + this.sendWindow + ")"));
                }
                this.containsGuesses = false;
                if (this.totalMessages < this.sendWindow) {
                    this.sendWindow = this.totalMessages;
                    this.persistSendWindow(this.sendWindow, null);
                }
            }
            if ((startMode & 2) == 0 && !this.ackExpAlarmStarted) {
                this.ackExpAlarmStarted = true;
                this.timerStartSendTick = this.lastMsgSent;
                this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                this.am.create(this.ackExpInterval, this.ackExpExpiryHandler);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreStream");
        }
        return sentMsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreUncommitted(SIMPMessage m) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreUncommitted", (Object)new Object[]{m});
        }
        TickRange tr = null;
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long starts = jsMsg.getGuaranteedValueStartTick();
        long ends = jsMsg.getGuaranteedValueEndTick();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("restoreUncommitted at: " + stamp + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tr = TickRange.newUncommittedTick(stamp);
            tr.startstamp = starts;
            tr.endstamp = ends;
            tr.value = m;
            this.oststream.writeCombinedRange(tr);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreUncommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreValue(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreValue", (Object)m);
        }
        TickRange tr = null;
        long msgStoreId = -1L;
        try {
            if (m.isInStore()) {
                msgStoreId = m.getID();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.restoreValue", (String)"1:1484:1.138", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restoreValue", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long starts = jsMsg.getGuaranteedValueStartTick();
        long ends = jsMsg.getGuaranteedValueEndTick();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("restoreValue at: " + stamp + " with Silence from: " + starts + " to " + ends + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tr = TickRange.newValueTick(stamp, null, msgStoreId);
            tr.startstamp = starts;
            tr.endstamp = ends;
            this.oststream.writeCombinedRange(tr);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreValue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"releaseMemory");
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream = new StateStream();
            this.oststream.init();
            this.oststream.setCompletedPrefix(this.oack);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseMemory");
        }
    }

    public String toString() {
        String ret = "SourceStream (" + this.hashCode() + "): Stream ID " + this.stream + " Priority " + this.priority + " Reliability " + this.reliability;
        return ret;
    }

    public synchronized boolean flushable() {
        TickRange range = new TickRange(0, 0L, Long.MAX_VALUE);
        return !this.oststream.containsState(range, (byte)3) && !this.oststream.containsState(range, (byte)2) && !this.oststream.containsState(range, (byte)8);
    }

    public synchronized void newGuessInStream(long tick) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newGuessInStream", (Object)new Object[]{tick, this.containsGuesses, this.sendWindow, this.totalMessages, this.firstMsgOutsideWindow});
        }
        if (!this.containsGuesses) {
            this.containsGuesses = true;
            if (this.sendWindow > this.totalMessages) {
                this.sendWindow = this.totalMessages;
                this.persistSendWindow(this.sendWindow, null);
                this.firstMsgOutsideWindow = tick;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newGuessInStream", (Object)new Object[]{this.containsGuesses, this.sendWindow, this.firstMsgOutsideWindow});
        }
    }

    public synchronized void guessesInStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"guessesInStream", (Object)this.containsGuesses);
        }
        this.containsGuesses = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"guessesInStream", (Object)this.containsGuesses);
        }
    }

    public synchronized void noGuessesInStream() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"noGuessesInStream");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("oldContainesGuesses:" + this.containsGuesses + "firstMsgOutsideWindow: " + this.firstMsgOutsideWindow + ", oldSendWindow: " + this.sendWindow));
        }
        this.containsGuesses = false;
        if (this.definedSendWindow > this.sendWindow) {
            long oldSendWindow = this.sendWindow;
            this.sendWindow = this.definedSendWindow;
            this.persistSendWindow(this.sendWindow, null);
            this.sendMsgsInWindow(oldSendWindow, this.sendWindow);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("no processing : definedSendWindow=" + this.definedSendWindow + ", sendWindow=" + this.sendWindow));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"noGuessesInStream");
        }
    }

    public synchronized void initialiseSendWindow(long sendWindow, long definedSendWindow) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialiseSendWindow", (Object)new Object[]{sendWindow, definedSendWindow});
        }
        if (sendWindow == Long.MAX_VALUE) {
            this.definedSendWindow = definedSendWindow;
            this.sendWindow = 1000L;
            this.persistSendWindow(this.sendWindow, null);
        } else {
            this.sendWindow = sendWindow;
            this.definedSendWindow = definedSendWindow;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseSendWindow");
        }
    }

    public synchronized void setDefinedSendWindow(long newSendWindow) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDefinedSendWindow", (Object)newSendWindow);
        }
        this.definedSendWindow = newSendWindow;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDefinedSendWindow", (Object)newSendWindow);
        }
    }

    public synchronized void updateAndPersistSendWindow() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateAndPersistSendWindow");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("definedSendWindow is: " + this.definedSendWindow + " sendWindow is " + this.sendWindow + " containsGuesses is " + this.containsGuesses + " totalMessages is " + this.totalMessages));
        }
        if (this.definedSendWindow > this.sendWindow) {
            if (!this.containsGuesses) {
                long oldSendWindow = this.sendWindow;
                this.sendWindow = this.definedSendWindow;
                this.persistSendWindow(this.sendWindow, null);
                this.sendMsgsInWindow(oldSendWindow, this.sendWindow);
            }
        } else if (this.definedSendWindow > this.totalMessages) {
            this.sendWindow = this.definedSendWindow;
            this.persistSendWindow(this.sendWindow, null);
        } else if (this.totalMessages < this.sendWindow) {
            this.sendWindow = this.totalMessages;
            this.persistSendWindow(this.sendWindow, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateAndPersistSendWindow");
        }
    }

    public synchronized void msgAdded(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"msgAdded", (Object)new Object[]{stamp, this.totalMessages, this.sendWindow, this.firstMsgOutsideWindow});
        }
        ++this.totalMessages;
        if (this.totalMessages > this.sendWindow && this.firstMsgOutsideWindow == Long.MAX_VALUE) {
            this.firstMsgOutsideWindow = stamp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"msgAdded", (Object)this.firstMsgOutsideWindow);
        }
    }

    private synchronized boolean msgCanBeSent(long stamp, boolean nackMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"msgCanBeSent", (Object)new Object[]{stamp, nackMsg, this.firstMsgOutsideWindow, this.containsGuesses});
        }
        boolean sendMessage = true;
        if (stamp >= this.firstMsgOutsideWindow || this.containsGuesses && !nackMsg) {
            sendMessage = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("firstMsgOutsideWindow is: " + this.firstMsgOutsideWindow + " sendWindow is " + this.sendWindow + " containsGuesses is " + this.containsGuesses));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"msgCanBeSent", (Object)sendMessage);
        }
        return sendMessage;
    }

    private synchronized TickRange msgRemoved(long tick, StateStream ststream, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"msgRemoved", (Object)new Object[]{tick, ststream, tran});
        }
        TickRange tr1 = null;
        boolean sendMessage = false;
        long stamp = tick;
        --this.totalMessages;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("totalMessages: " + this.totalMessages + ", sendWindow: " + this.sendWindow + ", definedSendWindow: " + this.definedSendWindow + ", firstMsgOutsideSendWindow: " + this.firstMsgOutsideWindow));
        }
        if ((this.containsGuesses || this.sendWindow > this.definedSendWindow) && stamp < this.firstMsgOutsideWindow) {
            if (this.sendWindow > 0L) {
                --this.sendWindow;
                this.persistSendWindow(this.sendWindow, tran);
            }
        } else if (stamp <= this.firstMsgOutsideWindow) {
            ststream.setCursor(this.firstMsgOutsideWindow);
            tr1 = ststream.getNext();
            if (tr1.type == 3) {
                sendMessage = true;
            }
            TickRange tr = null;
            if (this.totalMessages > this.sendWindow) {
                tr = ststream.getNext();
                while (tr.type == 7 && tr.endstamp != Long.MAX_VALUE) {
                    tr = ststream.getNext();
                }
                this.firstMsgOutsideWindow = tr.valuestamp;
            } else {
                this.firstMsgOutsideWindow = Long.MAX_VALUE;
                this.containsGuesses = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("firstMsgOutsideSendWindow: " + this.firstMsgOutsideWindow));
            }
        }
        if (!sendMessage) {
            tr1 = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"msgRemoved", (Object)tr1);
        }
        return tr1;
    }

    private synchronized void sendMsgsInWindow(long oldSendWindow, long newSendWindow) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMsgsInWindow", (Object)new Object[]{oldSendWindow, newSendWindow});
        }
        long newFirstMsgOutsideWindow = Long.MAX_VALUE;
        long messagesToSend = 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("totalMessages: " + this.totalMessages + ", sendWindow: " + this.sendWindow + ", definedSendWindow: " + this.definedSendWindow + ", firstMsgOutsideSendWindow: " + this.firstMsgOutsideWindow));
        }
        if (this.totalMessages > oldSendWindow) {
            messagesToSend = this.totalMessages > newSendWindow ? newSendWindow - oldSendWindow : this.totalMessages - oldSendWindow;
            this.oststream.setCursor(this.firstMsgOutsideWindow);
            TickRange tr = this.oststream.getNext();
            ArrayList<TickRange> sendList = new ArrayList<TickRange>();
            while ((long)sendList.size() < messagesToSend && tr.endstamp != Long.MAX_VALUE) {
                if (tr.type == 3) {
                    sendList.add(tr);
                    this.lastMsgSent = tr.valuestamp;
                } else if (tr.type == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("uncommited tick range: " + tr + " : reducing messagesToSend from " + messagesToSend + " to " + (messagesToSend - 1L)));
                    }
                    --messagesToSend;
                }
                tr = this.oststream.getNext();
            }
            if (this.totalMessages > newSendWindow) {
                while (tr.type == 7 && tr.endstamp != Long.MAX_VALUE) {
                    tr = this.oststream.getNext();
                }
                newFirstMsgOutsideWindow = tr.valuestamp;
            }
            if (sendList.size() != 0) {
                this.sendMsgs(sendList, false);
            }
        }
        this.firstMsgOutsideWindow = newFirstMsgOutsideWindow;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMsgsInWindow", (Object)this.firstMsgOutsideWindow);
        }
    }

    void persistSendWindow(long tick, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistSendWindow", (Object)new Object[]{tick, tran});
        }
        this.streamSet.setPersistentData(this.priority, this.reliability, tick);
        this.streamSet.requestUpdate(this.reliability, tran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistSendWindow");
        }
    }

    public synchronized List getMessagesAfterSendWindow() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessagesAfterSendWindow", (Object)this.firstMsgOutsideWindow);
        }
        ArrayList<Long> msgs = new ArrayList<Long>();
        if (this.firstMsgOutsideWindow != Long.MAX_VALUE) {
            this.oststream.setCursor(this.firstMsgOutsideWindow);
            TickRange tr = this.oststream.getNext();
            while (tr.endstamp < Long.MAX_VALUE) {
                if (tr.type == 3) {
                    msgs.add(tr.itemStreamIndex);
                }
                if (tr.type == 2) {
                    tr.reallocateOnCommit();
                }
                tr = this.oststream.getNext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagesAfterSendWindow", msgs);
        }
        return msgs;
    }

    public synchronized List getAllMessagesOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        LinkedList<Long> msgs = new LinkedList<Long>();
        this.oststream.setCursor(0L);
        TickRange tr = this.oststream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == 3) {
                msgs.add(tr.itemStreamIndex);
            }
            if (tr.type == 2) {
                tr.reallocateOnCommit();
            }
            tr = this.oststream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        return Collections.unmodifiableList(msgs);
    }

    public synchronized List<TickRange> getAllMessageItemsOnStream(boolean includeUncommitted) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllMessageItemsOnStream", (Object)includeUncommitted);
        }
        LinkedList<TickRange> msgs = new LinkedList<TickRange>();
        this.oststream.setCursor(0L);
        TickRange tr = this.oststream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == 3) {
                msgs.add((TickRange)tr.clone());
            } else if (tr.type == 2 && includeUncommitted && tr.value != null) {
                msgs.add((TickRange)tr.clone());
            }
            tr = this.oststream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessageItemsOnStream", msgs);
        }
        return Collections.unmodifiableList(msgs);
    }

    public synchronized long countAllMessagesOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long count = 0L;
        this.oststream.setCursor(0L);
        TickRange tr = this.oststream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == 3) {
                ++count;
            }
            tr = this.oststream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)count);
        }
        return count;
    }

    @Override
    public synchronized TickRange getTickRange(long tick) {
        this.oststream.setCursor(tick);
        return (TickRange)this.oststream.getNext().clone();
    }

    private void sendMsgs(List sendList, boolean requestedOnly) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMsgs", (Object)sendList);
        }
        if (!this.ackExpAlarmStarted) {
            this.ackExpAlarmStarted = true;
            this.timerStartSendTick = this.lastMsgSent;
            this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
            this.am.create(this.ackExpInterval, this.ackExpExpiryHandler);
        }
        List expiredMsgs = null;
        try {
            expiredMsgs = this.downControl.sendValueMessages(sendList, this.getCompletedPrefix(), requestedOnly, this.priority, this.reliability, this.streamSet.getStreamID());
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.sendMsgs", (String)"1:2495:1.138", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendMsgs", (Object)((Object)e));
            }
            throw e;
        }
        if (expiredMsgs != null) {
            TickRange vtr = null;
            for (int i = 0; i < expiredMsgs.size(); ++i) {
                vtr = (TickRange)expiredMsgs.get(i);
                this.writeSilenceForced(vtr);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchPrecommit(TransactionCommon currentTran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchPrecommit", (Object)currentTran);
        }
        TickRange tr1 = null;
        TickRange tickRange = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            if (!this.streamSet.isPersistent() || this.streamSet.isInStore()) {
                for (int i = 0; i < this.batchList.size(); ++i) {
                    tickRange = (TickRange)this.batchList.get(i);
                    try {
                        tr1 = this.msgRemoved(tickRange.valuestamp, this.oststream, currentTran);
                        if (tr1 == null) continue;
                        this.batchSendList.add(tr1);
                        this.lastMsgSent = tr1.valuestamp;
                        continue;
                    }
                    catch (SIResourceException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.batchPrecommit", (String)"1:2558:1.138", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchPrecommit");
        }
    }

    @Override
    public void batchCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchCommitted");
        }
        if (this.batchSendList.size() != 0) {
            try {
                this.sendMsgs(this.batchSendList, false);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.batchCommitted", (String)"1:2590:1.138", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        this.batchList.clear();
        this.batchSendList.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchCommitted");
        }
    }

    @Override
    public void batchRolledBack() {
    }

    public void addToBatchList(TickRange tr) {
        this.batchList.add(tr);
    }

    public SourceStreamControl getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.srcStreamControl == null) {
            this.srcStreamControl = new SourceStreamControl(this, this.streamSet, this.downControl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.srcStreamControl);
        }
        return this.srcStreamControl;
    }

    public synchronized boolean isOutsideSendWindow(long guaranteedValueValueTick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isOutsideSendWindow", (Object)new Object[]{guaranteedValueValueTick, this.firstMsgOutsideWindow});
        }
        boolean outside = true;
        if (guaranteedValueValueTick < this.firstMsgOutsideWindow) {
            outside = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOutsideSendWindow", (Object)outside);
        }
        return outside;
    }

    public synchronized void setLatestAckExpected(long ackExpStamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLatestAckExpected", (Object)ackExpStamp);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLatestAckExpected");
        }
        this.lastAckExpTick = ackExpStamp;
    }

    public class AckExpExpiryHandler
    implements AlarmListener {
        private SourceStream sourceStream;

        public AckExpExpiryHandler(SourceStream sourceStream) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"AckExpExpiryHandler", (Object)sourceStream);
            }
            this.sourceStream = sourceStream;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AckExpExpiryHandler", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object thandle) {
            block16: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)this);
                }
                try {
                    long localTimerStartSendTick;
                    long completedPrefix;
                    SourceStream sourceStream = this.sourceStream;
                    synchronized (sourceStream) {
                        completedPrefix = SourceStream.this.getCompletedPrefix();
                        localTimerStartSendTick = SourceStream.this.timerStartSendTick;
                    }
                    if (localTimerStartSendTick > completedPrefix) {
                        SourceStream.this.downControl.sendAckExpectedMessage(localTimerStartSendTick, SourceStream.this.priority, SourceStream.this.reliability, SourceStream.this.stream);
                    }
                    sourceStream = this.sourceStream;
                    synchronized (sourceStream) {
                        completedPrefix = SourceStream.this.getCompletedPrefix();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("lastMsgSent:" + SourceStream.this.lastMsgSent + " completedPrefix:" + completedPrefix + " inboundFLow:" + SourceStream.this.inboundFlow));
                        }
                        if (SourceStream.this.lastMsgSent > completedPrefix) {
                            if (!SourceStream.this.inboundFlow) {
                                SourceStream.this.ackExpInterval = SourceStream.this.ackExpInterval * 2L > (long)GDConfig.GD_ACK_EXPECTED_THRESHOLD_MAX ? (long)GDConfig.GD_ACK_EXPECTED_THRESHOLD_MAX : SourceStream.this.ackExpInterval * 2L;
                            } else {
                                SourceStream.this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                            }
                            SourceStream.this.timerStartSendTick = SourceStream.this.lastMsgSent;
                            SourceStream.this.am.create(SourceStream.this.ackExpInterval, SourceStream.this.ackExpExpiryHandler);
                        } else {
                            SourceStream.this.ackExpAlarmStarted = false;
                            SourceStream.this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                        }
                        SourceStream.this.inboundFlow = false;
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStream.AckExpExpiryHandler.alarm", (String)"1:1844:1.138", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    public class BlockedStreamAlarm
    implements AlarmListener {
        private long previousCompletedPrefix;
        private String blockingTran = null;
        private int blockedCount = 0;

        public BlockedStreamAlarm(long completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"BlockedStreamAlarm", (Object)completedPrefix);
            }
            this.previousCompletedPrefix = completedPrefix;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BlockedStreamAlarm", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkState(boolean create) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkState", (Object)new Object[]{create, this.previousCompletedPrefix, this.blockedCount});
            }
            boolean allClear = false;
            SourceStream sourceStream = SourceStream.this;
            synchronized (sourceStream) {
                if (SourceStream.this.totalMessages > 0L) {
                    long completedPrefix = SourceStream.this.getCompletedPrefix();
                    SourceStream.this.oststream.setCursor(completedPrefix + 1L);
                    TickRange tr = SourceStream.this.oststream.getNext();
                    if (tr.type == 2 && completedPrefix == this.previousCompletedPrefix) {
                        if (create) {
                            SourceStream.this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_STREAM_STATE, 1);
                            ++this.blockedCount;
                            int countInterval = 1;
                            int blockedStreamCheckInterval = SourceStream.this.mp.getCustomProperties().getBlockedStreamHealthCheckInterval();
                            if (blockedStreamCheckInterval < 300000 && blockedStreamCheckInterval > 0) {
                                countInterval = 300000 / blockedStreamCheckInterval;
                            }
                            if (this.blockedCount % countInterval == SourceStream.this.mp.getCustomProperties().getBlockedStreamRatio()) {
                                SIMPMessage msg;
                                String name = SourceStream.this.dh.getName();
                                if (SourceStream.this.dh.isLink()) {
                                    name = ((LinkHandler)SourceStream.this.dh).getBusName();
                                }
                                if ((msg = (SIMPMessage)tr.value) != null && msg.getTransactionId() != null) {
                                    this.blockingTran = msg.getTransactionId().toString();
                                } else {
                                    this.blockingTran = "NULL";
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)"No Item or transaction associated with this committing value ", (Object)new Object[]{tr, msg, SourceStream.this.dh});
                                    }
                                    InvalidMessageException invalidMessageException = new InvalidMessageException();
                                    FFDCFilter.processException((Throwable)invalidMessageException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.BlockedStreamAlarm.checkState", (String)"1:1674:1.138", (Object)this, (Object[])new Object[]{tr, msg, SourceStream.this.dh});
                                }
                                SibTr.info((TraceComponent)tc, (String)"STREAM_BLOCKED_BY_COMMITTING_MESSAGE_CWSIP0785", (Object)new Object[]{name, SourceStream.this.dh.getMessageProcessor().getMessagingEngineName(), new Long(this.blockedCount * SourceStream.this.mp.getCustomProperties().getBlockedStreamHealthCheckInterval() / 1000), this.blockingTran});
                            }
                        }
                    } else {
                        this.blockedCount = 0;
                        this.previousCompletedPrefix = completedPrefix;
                        SourceStream.this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_STREAM_STATE, 2);
                        if (this.blockingTran != null) {
                            allClear = true;
                        }
                    }
                    if (create) {
                        SourceStream.this.am.create(SourceStream.this.mp.getCustomProperties().getBlockedStreamHealthCheckInterval(), this);
                    }
                } else {
                    if (create) {
                        SourceStream.this.blockedStreamAlarm = null;
                    }
                    SourceStream.this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_STREAM_STATE, 2);
                }
                if (allClear) {
                    String name = SourceStream.this.dh.getName();
                    if (SourceStream.this.dh.isLink()) {
                        name = ((LinkHandler)SourceStream.this.dh).getBusName();
                    }
                    SibTr.info((TraceComponent)tc, (String)"STREAM_UNBLOCKED_BY_COMMITTING_MESSAGE_CWSIP0786", (Object)new Object[]{name, SourceStream.this.dh.getMessageProcessor().getMessagingEngineName(), this.blockingTran});
                    this.blockingTran = null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkState");
            }
        }

        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)this);
            }
            this.checkState(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    public static class SourceStreamState
    implements SIMPDeliveryTransmitControllable.StreamState {
        public static final SourceStreamState ACTIVE = new SourceStreamState("Active", 0);
        private String state;
        private int value = -1;

        private SourceStreamState(String _state, int _value) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"SourceStreamState", (Object)new Object[]{_state, _value});
            }
            this.state = _state;
            this.value = _value;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"SourceStreamState", (Object)this);
            }
        }

        public String toString() {
            return this.state;
        }

        public int getValue() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getValue");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getValue", (Object)this.value);
            }
            return this.value;
        }
    }
}

