/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.client.ClientAsynchEventThreadPool;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.ConsumerMonitorListenerCache;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.DestinationListenerCache;
import com.ibm.ws.sib.comms.client.MSSIXAResourceProvidingConnectionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.mfp.impl.CompHandshakeFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ProxyReceiveListener
implements ConversationReceiveListener {
    private static String CLASS_NAME = ProxyReceiveListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ProxyReceiveListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static CommsByteBufferPool bufferPool = CommsByteBufferPool.getInstance();

    @Override
    public ConversationReceiveListener dataReceived(WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived", (Object)new Object[]{data, segmentType, requestNumber, priority, allocatedFromBufferPool, partOfExchange});
        }
        CommsByteBuffer buffer = bufferPool.allocate();
        buffer.reset(data);
        boolean releaseBuffer = true;
        switch (segmentType) {
            case 221: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received an ASYNC message");
                }
                releaseBuffer = false;
                this.processMessage(buffer, true, false, conversation, false);
                break;
            }
            case 248: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a chunked ASYNC message");
                }
                releaseBuffer = false;
                this.processMessage(buffer, true, false, conversation, true);
                break;
            }
            case 222: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a BROWSE message");
                }
                releaseBuffer = false;
                this.processMessage(buffer, false, true, conversation, false);
                break;
            }
            case 249: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a chunked BROWSE message");
                }
                releaseBuffer = false;
                this.processMessage(buffer, false, true, conversation, true);
                break;
            }
            case 220: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a PROXY message");
                }
                releaseBuffer = false;
                this.processMessage(buffer, false, true, conversation, false);
                break;
            }
            case 247: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a chunked PROXY message");
                }
                releaseBuffer = false;
                this.processMessage(buffer, false, true, conversation, true);
                break;
            }
            case 225: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a Server Event");
                }
                this.processEvent(buffer, conversation);
                break;
            }
            case 226: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a connection info event");
                }
                this.processConnectionInfo(buffer, conversation);
                break;
            }
            case 230: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a message schema");
                }
                this.processSchema(buffer, conversation);
                break;
            }
            case 251: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received a chunk of a SYNC message");
                }
                this.processSyncMessageChunk(buffer, conversation, false);
                break;
            }
            case 250: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received a chunk of a SYNC connection message");
                }
                this.processSyncMessageChunk(buffer, conversation, true);
                break;
            }
            case 120: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received a DestinationListener callback");
                }
                this.processDestinationListenerCallback(buffer, conversation);
                break;
            }
            case 123: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received async session stopped callback");
                }
                this.processAsyncSessionStoppedCallback(buffer, conversation);
                break;
            }
            case 133: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received a ConsumerSetChangeCallback callback");
                }
                this.processConsumerSetChangeCallback(buffer, conversation);
                break;
            }
            default: {
                String connectionInfo = ((ClientConversationState)conversation.getAttachment()).getCommsConnection().getConnectionInfo();
                String seg = segmentType + " (0x" + Integer.toHexString(segmentType).toUpperCase() + ")";
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("UNEXPECTED_MESS_RECVD_SICO1010", new Object[]{seg, connectionInfo}, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".dataReceived"), (String)"1-008-0001", (Object[])new Object[]{SibTr.formatBytes((byte[])data.array(), (int)0, (int)data.array().length), this});
                SibTr.error((TraceComponent)tc, (String)"UNEXPECTED_MESS_RECVD_SICO1010", (Object)new Object[]{seg, connectionInfo});
                try {
                    conversation.close();
                    break;
                }
                catch (SIConnectionLostException ce) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".dataReceived"), (String)"1-008-0002", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((TraceComponent)tc, (String)ce.getMessage(), (Object)((Object)ce));
                }
            }
        }
        if (allocatedFromBufferPool && releaseBuffer) {
            buffer.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
        }
        return null;
    }

    @Override
    public void errorOccurred(SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
        ClientConversationState convState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"errorOccurred");
        }
        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-004-0010", (Object)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] debug = new Object[]{"Segment type  : " + segmentType + " (0x" + Integer.toHexString(segmentType) + ")", "Request number: " + requestNumber, "Priority      : " + priority};
            SibTr.debug((TraceComponent)tc, (String)"Received an error in the ProxyReceiveListener", (Object)debug);
            SibTr.debug((TraceComponent)tc, (String)"Primary exception:");
            SibTr.exception((TraceComponent)tc, (Exception)((Object)exception));
        }
        if (conversation != null && (convState = (ClientConversationState)conversation.getAttachment()) != null) {
            SICoreConnection conn = convState.getSICoreConnection();
            ProxyQueueConversationGroup proxyQueueGroup = convState.getProxyQueueConversationGroup();
            ClientAsynchEventThreadPool.getInstance().dispatchCommsException(conn, proxyQueueGroup, exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"errorOccurred");
        }
    }

    @Override
    public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer buff, int segType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getThreadContext", (Object)new Object[]{conversation, buff, segType});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getThreadContext", null);
        }
        return null;
    }

    private void processMessage(CommsByteBuffer buffer, boolean asyncMessage, boolean enableReadAhead, Conversation conversation, boolean chunk) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processMessage", (Object)new Object[]{buffer, asyncMessage, enableReadAhead, conversation, chunk});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            buffer.dump(this, tc, -1);
        }
        short connectionObjectID = buffer.getShort();
        short clientSessionID = buffer.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"connectionObjectId: ", (Object)("" + connectionObjectID));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"clientSessionID: ", (Object)("" + clientSessionID));
        }
        boolean lastInBatch = false;
        if (asyncMessage) {
            short flags = buffer.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"lastInBatchFlag: ", (Object)("" + flags));
            }
            if (flags == 1) {
                lastInBatch = true;
            }
        }
        short messageBatch = buffer.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"messageBatch: ", (Object)("" + messageBatch));
        }
        if (chunk) {
            long next8bytes = buffer.peekLong();
            long messageLength = next8bytes >> 24;
            messageLength &= 0xFFFFFF00FFFFFFFFL;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Received a message chunk of length: " + messageLength));
            }
        } else {
            int messageLength = (int)buffer.peekLong();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Received a message of length: " + messageLength));
            }
        }
        ProxyQueueConversationGroup pqcg = ((ClientConversationState)conversation.getAttachment()).getProxyQueueConversationGroup();
        if (pqcg == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("NO_PROXY_CONV_GROUP_SICO1011", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processAsyncMessage"), (String)"1-008-0003", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"NO_PROXY_CONV_GROUP_SICO1011", (Object)e);
            throw e;
        }
        ProxyQueue proxyQueue = pqcg.find(clientSessionID);
        if (proxyQueue == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processAsyncMessage"), (String)"1-008-0003", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", (Object)e);
            throw e;
        }
        proxyQueue.put(buffer, messageBatch, lastInBatch, chunk);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processMessage");
        }
    }

    private void processEvent(CommsByteBuffer buffer, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processEvent", (Object)new Object[]{buffer, conversation});
        }
        buffer.getShort();
        short eventId = buffer.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Event Id", (Object)("" + eventId));
        }
        if (eventId == 2 || eventId == 3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Received an ME event");
            }
            ClientAsynchEventThreadPool.getInstance().dispatchAsynchEvent(eventId, conversation);
        } else if (eventId == 4) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Received an Async exception event");
            }
            short clientSessionId = buffer.getShort();
            Exception exception = buffer.getException(conversation);
            ProxyQueueConversationGroup pqcg = ((ClientConversationState)conversation.getAttachment()).getProxyQueueConversationGroup();
            if (pqcg == null) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("NO_PROXY_CONV_GROUP_SICO1011", null, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processEvent"), (String)"1-008-0005", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"NO_PROXY_CONV_GROUP_SICO1011", (Object)e);
                throw e;
            }
            ProxyQueue proxyQueue = pqcg.find(clientSessionId);
            if (proxyQueue == null) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", null, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processEvent"), (String)"1-008-0006", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_FIND_PROXY_QUEUE_SICO1012", (Object)e);
                throw e;
            }
            ClientAsynchEventThreadPool.getInstance().dispatchAsynchException(proxyQueue, exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processEvent");
        }
    }

    private void processConnectionInfo(CommsByteBuffer buffer, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processConnectionInfo", (Object)new Object[]{buffer, conversation});
        }
        ClientConversationState convState = (ClientConversationState)conversation.getAttachment();
        short connectionObjectId = buffer.getShort();
        String meName = buffer.getString();
        convState.setConnectionObjectID(connectionObjectId);
        ConnectionProxy connectionProxy = conversation.getHandshakeProperties().getFapLevel() >= 5 ? new MSSIXAResourceProvidingConnectionProxy(conversation) : new ConnectionProxy(conversation);
        convState.setSICoreConnection(connectionProxy);
        connectionProxy.setMeName(meName);
        short idLength = buffer.getShort();
        if (idLength != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Got unique id of length:", (Object)idLength);
            }
            byte[] uniqueId = buffer.get(idLength);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.bytes((TraceComponent)tc, (byte[])uniqueId);
            }
            connectionProxy.setInitialUniqueId(uniqueId);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No unique Id was returned");
        }
        String meUuid = buffer.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ME Uuid: ", (Object)meUuid);
        }
        connectionProxy.setMeUuid(meUuid);
        String resolvedUserId = buffer.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Resolved UserId: ", (Object)resolvedUserId);
        }
        connectionProxy.setResolvedUserId(resolvedUserId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processConnectionInfo");
        }
    }

    private void processSchema(CommsByteBuffer buffer, Conversation conversation) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processSchema", (Object)new Object[]{buffer, conversation});
            }
            ClientConversationState convState = (ClientConversationState)conversation.getAttachment();
            byte[] mfpDataAsBytes = buffer.getRemaining();
            CommsConnection cc = convState.getCommsConnection();
            try {
                HandshakeProperties handshakeGroup = conversation.getHandshakeProperties();
                short productVersion = handshakeGroup.getMajorVersion();
                CompHandshake ch = (CompHandshake)CompHandshakeFactory.getInstance();
                ch.compData(cc, (int)productVersion, mfpDataAsBytes);
            }
            catch (Exception e1) {
                FFDCFilter.processException((Throwable)e1, (String)(CLASS_NAME + ".processSchema"), (String)"1-008-0008", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)"MFP unable to create CompHandshake Singleton", (Object)e1);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processSchema");
        }
    }

    private void processSyncMessageChunk(CommsByteBuffer buffer, Conversation conversation, boolean connectionMessage) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processSyncMessageChunk", (Object)new Object[]{buffer, conversation, connectionMessage});
        }
        ClientConversationState convState = (ClientConversationState)conversation.getAttachment();
        ConnectionProxy connProxy = (ConnectionProxy)convState.getSICoreConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Found connection: ", (Object)connProxy);
        }
        buffer.getShort();
        if (connectionMessage) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding message part directly to connection");
            }
            connProxy.addMessagePart(buffer);
        } else {
            short consumerSessionId = buffer.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Consumer Session Id:", (Object)("" + consumerSessionId));
            }
            ConsumerSessionProxy consumer = connProxy.getConsumerSessionProxy(consumerSessionId);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Found consumer:", (Object)consumer);
            }
            consumer.addMessagePart(buffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processSyncMessageChunk");
        }
    }

    private void processDestinationListenerCallback(CommsByteBuffer buffer, Conversation conversation) {
        DestinationListenerCache destinationListenerCache;
        DestinationListener destinationListener;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processDestinationListenerCallback", (Object)new Object[]{buffer, conversation});
        }
        ClientConversationState convState = (ClientConversationState)conversation.getAttachment();
        SICoreConnection connection = convState.getSICoreConnection();
        short connectionObjectId = buffer.getShort();
        short destinationListenerId = buffer.getShort();
        SIDestinationAddress destinationAddress = buffer.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
        short destinationAvailabilityShort = buffer.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("connectionObjectId=" + connectionObjectId));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("destinationListenerId=" + destinationListenerId));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("destinationAddress=" + destinationAddress));
        }
        DestinationAvailability destinationAvailability = null;
        if (destinationAvailabilityShort != -1) {
            destinationAvailability = DestinationAvailability.getDestinationAvailability((int)destinationAvailabilityShort);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("destinationAvailability=" + destinationAvailability));
        }
        if ((destinationListener = (destinationListenerCache = convState.getDestinationListenerCache()).get(destinationListenerId)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("DestinationListener id=" + destinationListenerId + " not found in DestinationListenerCache"));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)destinationListenerCache.toString());
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("UNABLE_TO_FIND_DESTINATION_LISTENER_SICO8019", new Object[]{destinationListenerId}, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processDestinationListenerCallback"), (String)"1-008-0010", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_FIND_DESTINATION_LISTENER_SICO8019", (Object)e);
            throw e;
        }
        ClientAsynchEventThreadPool.getInstance().dispatchDestinationListenerEvent(connection, destinationAddress, destinationAvailability, destinationListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processDestinationListenerCallback");
        }
    }

    private void processAsyncSessionStoppedCallback(CommsByteBuffer buffer, Conversation conversation) {
        ClientConversationState convState;
        ProxyQueueConversationGroup pqcg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processAsyncSessionStoppedCallback", (Object)new Object[]{buffer, conversation});
        }
        short connectionObjectId = buffer.getShort();
        short clientSessionId = buffer.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("connectionObjectId=" + connectionObjectId));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("clientSessionId=" + clientSessionId));
        }
        if ((pqcg = (convState = (ClientConversationState)conversation.getAttachment()).getProxyQueueConversationGroup()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ProxyQueueConversationGroup=null");
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("NULL_PROXY_QUEUE_CONV_GROUP_CWSICO8020", new Object[0], null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processAsyncSessionStoppedCallback"), (String)"1-008-0011", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"NULL_PROXY_QUEUE_CONV_GROUP_CWSICO8020", (Object)e);
            throw e;
        }
        ProxyQueue proxyQueue = pqcg.find(clientSessionId);
        if (!(proxyQueue instanceof AsynchConsumerProxyQueue)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("proxyQueue not an instance of AsynchConsumerProxyQueue is an instance of " + proxyQueue.getClass().getName()));
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("WRONG_CLASS_CWSICO8021", new Object[]{proxyQueue.getClass().getName()}, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processAsyncSessionStoppedCallback"), (String)"1-008-0012", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"WRONG_CLASS_CWSICO8021", (Object)e);
            throw e;
        }
        ConsumerSessionProxy consumerSessionProxy = ((AsynchConsumerProxyQueue)proxyQueue).getConsumerSessionProxy();
        ClientAsynchEventThreadPool.getInstance().dispatchStoppableConsumerSessionStopped(consumerSessionProxy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processAsyncSessionStoppedCallback");
        }
    }

    private void processConsumerSetChangeCallback(CommsByteBuffer buffer, Conversation conversation) {
        ConsumerMonitorListenerCache consumerMonitorListenerCache;
        ConsumerSetChangeCallback consumerSetChangeCallback;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processConsumerSetChangeCallback", (Object)new Object[]{buffer, conversation});
        }
        ClientConversationState convState = (ClientConversationState)conversation.getAttachment();
        short connectionObjectId = buffer.getShort();
        short consumerMonitorListenerid = buffer.getShort();
        boolean isEmpty = buffer.getBoolean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("connectionObjectId=" + connectionObjectId));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("consumerMonitorListenerid=" + consumerMonitorListenerid));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("isEmpty=" + isEmpty));
        }
        if ((consumerSetChangeCallback = (consumerMonitorListenerCache = convState.getConsumerMonitorListenerCache()).get(consumerMonitorListenerid)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("consumerMonitorListenerid=" + consumerMonitorListenerid + " not found in consumerMonitorListenerCache"));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)consumerMonitorListenerCache.toString());
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("UNABLE_TO_FIND_CONSUMER_MONITOR_LISTENER_SICO8024", new Object[]{consumerMonitorListenerid}, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processConsumerSetChangeCallback"), (String)"1-008-0013", (Object)this);
            SibTr.error((TraceComponent)tc, (String)("An internal error occurred. The consumerMonitorListenerid " + consumerMonitorListenerid + " received by the client can not be located."));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"processConsumerSetChangeCallback");
            }
            throw e;
        }
        ClientAsynchEventThreadPool.getInstance().dispatchConsumerSetChangeCallbackEvent(consumerSetChangeCallback, isEmpty);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processConsumerSetChangeCallback");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ProxyReceiveListener.java, SIB.comms, WASX.SIB, uu1215.01 1.87");
        }
    }
}

