/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.h2internal.H2TCPConnectionContext;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;

public class H2TCPWriteRequestContext
implements TCPWriteRequestContext {
    H2TCPConnectionContext h2TcpConnectionContext = null;
    Integer streamID = null;
    H2InboundLink muxLink = null;
    private WsByteBuffer[] buffers;
    private final WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private ByteBuffer[] byteBufferArray = null;
    private ByteBuffer[] byteBufferArrayDirect = null;
    private ByteBuffer[] byteBufferArrayOf1 = null;
    private ByteBuffer[] byteBufferArrayOf2 = null;
    private ByteBuffer[] byteBufferArrayOf3 = null;
    private ByteBuffer[] byteBufferArrayOf4 = null;
    private static final TraceComponent tc = Tr.register(H2TCPWriteRequestContext.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public H2TCPWriteRequestContext(Integer id, H2InboundLink link, H2TCPConnectionContext x) {
        this.streamID = id;
        this.muxLink = link;
        this.h2TcpConnectionContext = x;
    }

    public TCPConnectionContext getInterface() {
        return this.h2TcpConnectionContext;
    }

    public long write(long numBytes, int timeout) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"H2TCPWriteRequestContext.write(long numBytes, int timeout) unexpectedly called, returning 0", (Object[])new Object[0]);
        }
        return 0L;
    }

    public VirtualConnection write(long numBytes, TCPWriteCompletedCallback callback, boolean forceQueue, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"H2TCPWriteRequestContext.write(long numBytes, TCPWriteCompletedCallback callback, ...) unexpectedly called, returning null", (Object[])new Object[0]);
        }
        return null;
    }

    public void clearBuffers() {
        if (null != this.buffers) {
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i].clear();
            }
        }
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public void setBuffers(WsByteBuffer[] bufs) {
        int i;
        this.buffers = bufs;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        if (bufs != null) {
            int numBufs;
            for (numBufs = 0; numBufs < bufs.length && bufs[numBufs] != null; ++numBufs) {
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBuffers number of buffers is " + numBufs), (Object[])new Object[0]);
            }
            if (numBufs == 1) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
            } else if (numBufs == 2) {
                if (this.byteBufferArrayOf2 == null) {
                    this.byteBufferArrayOf2 = new ByteBuffer[2];
                }
                this.byteBufferArray = this.byteBufferArrayOf2;
            } else if (numBufs == 3) {
                if (this.byteBufferArrayOf3 == null) {
                    this.byteBufferArrayOf3 = new ByteBuffer[3];
                }
                this.byteBufferArray = this.byteBufferArrayOf3;
            } else if (numBufs == 4) {
                if (this.byteBufferArrayOf4 == null) {
                    this.byteBufferArrayOf4 = new ByteBuffer[4];
                }
                this.byteBufferArray = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArray = new ByteBuffer[numBufs];
            }
            if (numBufs > 1) {
                for (int i2 = 0; i2 < numBufs; ++i2) {
                    this.byteBufferArray[i2] = bufs[i2].getWrappedByteBufferNonSafe();
                }
            } else if (numBufs == 1) {
                this.byteBufferArray[0] = bufs[0].getWrappedByteBufferNonSafe();
            }
        } else {
            this.byteBufferArray = null;
        }
    }

    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    public void setBuffer(WsByteBuffer buf) {
        int i;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        this.defaultBuffers[0] = null;
        if (buf != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = buf;
            if (this.byteBufferArrayOf1 == null) {
                this.byteBufferArrayOf1 = new ByteBuffer[1];
            }
            this.byteBufferArray = this.byteBufferArrayOf1;
            this.byteBufferArray[0] = buf.getWrappedByteBufferNonSafe();
        } else {
            this.buffers = null;
            this.byteBufferArray = null;
        }
    }

    public Socket getSocket() {
        return this.muxLink.h2MuxTCPWriteContext.getSocket();
    }
}

