/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.common.service.CommonServiceFacade;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.ClientConnectionFactory;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.mfp.trm.TrmClientBootstrapReply;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessage;
import com.ibm.ws.sib.trm.TrmSICoreConnectionFactory;
import com.ibm.ws.sib.trm.client.ClientAttachProperties;
import com.ibm.ws.sib.trm.client.ClientBootstrapHandler;
import com.ibm.ws.sib.trm.client.CredentialType;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.utils.comms.ProviderEndPoint;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public final class TrmSICoreConnectionFactoryImpl
extends TrmSICoreConnectionFactory {
    private static final String className = TrmSICoreConnectionFactoryImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(TrmSICoreConnectionFactoryImpl.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");

    @Override
    public SICoreConnection createConnection(Subject subject, Map connectionProperties) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection ", (Object)new Object[]{subject, connectionProperties});
        }
        SICoreConnection sc = null;
        try {
            sc = this.createConnection(new CredentialType((String)connectionProperties.get("busName"), subject), connectionProperties);
        }
        catch (SINotAuthorizedException sinae) {
            throw sinae;
        }
        catch (SINotPossibleInCurrentConfigurationException sinpicce) {
            throw sinpicce;
        }
        catch (SIResourceException sire) {
            throw sire;
        }
        catch (SIIncorrectCallException siice) {
            throw siice;
        }
        catch (SIErrorException siee) {
            throw siee;
        }
        catch (SIAuthenticationException siae) {
            throw siae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection ", (Object)sc);
        }
        return sc;
    }

    @Override
    public SICoreConnection createConnection(String username, String password, Map connectionProperties) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection ", (Object)new Object[]{username, password, connectionProperties});
        }
        SICoreConnection sc = null;
        try {
            sc = this.createConnection(new CredentialType(username, password), connectionProperties);
        }
        catch (SINotAuthorizedException sinae) {
            throw sinae;
        }
        catch (SINotPossibleInCurrentConfigurationException sinpicce) {
            throw sinpicce;
        }
        catch (SIResourceException sire) {
            throw sire;
        }
        catch (SIIncorrectCallException siice) {
            throw siice;
        }
        catch (SIErrorException siee) {
            throw siee;
        }
        catch (SIAuthenticationException siae) {
            throw siae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection ", (Object)sc);
        }
        return sc;
    }

    private SICoreConnection createConnection(CredentialType credentialType, Map props) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection ", (Object)new Object[]{credentialType, props});
        }
        ClientAttachProperties cap = new ClientAttachProperties(props, credentialType.getPassword() != null && !credentialType.getPassword().trim().equals(""));
        Exception finalException = null;
        SICoreConnection sc = null;
        try {
            AuditManager auditManager = new AuditManager();
            if (cap.getProviderEPs().isEmpty()) {
                auditManager.setJMSCallType("local");
                sc = this.getConnectionToLocalME(credentialType, props, cap);
            } else {
                auditManager.setJMSCallType("remote");
                sc = this.remoteBootstrap(credentialType, cap);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)" Create connection failed", (Object)e);
            }
            finalException = e;
        }
        if (null == sc && null != finalException) {
            if (finalException instanceof SIAuthenticationException) {
                throw (SIAuthenticationException)finalException;
            }
            if (finalException instanceof SIErrorException) {
                throw (SIErrorException)finalException;
            }
            if (finalException instanceof SIIncorrectCallException) {
                throw (SIIncorrectCallException)finalException;
            }
            if (finalException instanceof SINotAuthorizedException) {
                throw (SINotAuthorizedException)finalException;
            }
            if (finalException instanceof SINotPossibleInCurrentConfigurationException) {
                throw (SINotPossibleInCurrentConfigurationException)finalException;
            }
            if (finalException instanceof SIResourceException) {
                throw (SIResourceException)finalException;
            }
        }
        if (null == sc && cap.getProviderEPs().isEmpty()) {
            if (CommonServiceFacade.getJsAdminService() != null) {
                throw new SIResourceException(nls.getFormattedMessage("LIBERTY_BINDING_FAILED_CWSIT0134", null, null));
            }
            throw new SIResourceException(nls.getFormattedMessage("LIBERTY_BINDING_FAILED_CWSIT0132", new Object[]{"wasJmsServer-1.0"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection ", (Object)sc);
        }
        return sc;
    }

    private SICoreConnection getConnectionToLocalME(CredentialType credentialType, Map props, ClientAttachProperties cap) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionToLocalME ", (Object)new Object[]{credentialType, props, cap});
        }
        SICoreConnection sc = null;
        JsAdminService admnService = CommonServiceFacade.getJsAdminService();
        JsMessagingEngine local_ME = null;
        if (admnService != null) {
            local_ME = admnService.getMessagingEngine("defaultBus", "defaultME");
        }
        if (local_ME != null) {
            SICoreConnectionFactory scf = (SICoreConnectionFactory)((Object)local_ME.getMessageProcessor());
            sc = credentialType.getSubject() != null ? scf.createConnection(credentialType.getSubject(), cap.getProperties()) : scf.createConnection(credentialType.getUserid(), credentialType.getPassword(), cap.getProperties());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)" local_ME is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnectionToLocalME ", sc);
        }
        return sc;
    }

    private SICoreConnection remoteBootstrap(CredentialType credentialType, ClientAttachProperties cap) throws SIAuthenticationException, SIErrorException, SIIncorrectCallException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteBootstrap", (Object)new Object[]{credentialType, cap});
        }
        SICoreConnection sc = null;
        ClientConnectionFactory ccf = CommonServiceFacade.getClientConnectionFactory();
        if (ccf == null) {
            throw new SIErrorException(nls.getString("NO_CCF_CWSIT0004"));
        }
        ContactBootstrapServiceResponse cbsr = this.contactBootstrapService(credentialType, cap, ccf);
        ClientConnection cc = cbsr.getClientConnection();
        TrmClientBootstrapReply cbr = cbsr.getClientBootstrapReply();
        int rc = cbsr.getReturnCode();
        boolean goodReply = cbsr.isGoodReply();
        ProviderEndPoint ep = cbsr.getEndPoint();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("cc=" + cc + ", cbr=" + cbr + ", rc=" + rc + ", goodReply=" + goodReply + ", ep=" + ep.getEndPointInfo()));
        }
        if (goodReply) {
            if (rc == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Staying with bootstrap messaging engine");
                }
                sc = cc.getSICoreConnection();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"*** shouldn't ever get here!");
            }
        } else {
            List uncontactableBootstrapServers = cbsr.getUncontactableBootstrapServers();
            List failedBootstrapServers = cbsr.getFailedBootstrapServers();
            Exception firstMirroredFailureException = cbsr.getFirstMirroredFailureException();
            Exception firstBootstrapFailureException = cbsr.getFirstBootstrapFailureException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("uncontactableBootstrapServers=" + uncontactableBootstrapServers + ", failedBootstrapServers=" + failedBootstrapServers + ", firstMirroredFailureException=" + firstMirroredFailureException + ", firstBootstrapFailureException=" + firstBootstrapFailureException));
            }
            if (null != firstMirroredFailureException) {
                if (firstMirroredFailureException instanceof SIAuthenticationException) {
                    throw (SIAuthenticationException)firstMirroredFailureException;
                }
                if (firstMirroredFailureException instanceof SINotAuthorizedException) {
                    throw (SINotAuthorizedException)firstMirroredFailureException;
                }
                this.generateException(this.getRC(firstMirroredFailureException), nls.getFormattedMessage("LIBERTY_BOOTSTRAP_FAILURE_CWSIT0126", new Object[]{failedBootstrapServers.get(0).toString(), Utils.getFailureMessage(cbr.getFailureReason())}, null), firstMirroredFailureException, true);
            } else {
                this.generateException(this.getRC(firstBootstrapFailureException), nls.getFormattedMessage("LIBERTY_NO_BOOTSTRAP_CWSIT0127", new Object[]{uncontactableBootstrapServers.toString()}, null), firstBootstrapFailureException, true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteBootstrap", (Object)sc);
        }
        return sc;
    }

    private ContactBootstrapServiceResponse contactBootstrapService(CredentialType credentialType, ClientAttachProperties cap, ClientConnectionFactory ccf) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"contactBootstrapService", (Object)new Object[]{credentialType, cap, ccf});
        }
        ClientConnection cc = null;
        TrmClientBootstrapReply cbr = null;
        int rc = -1;
        ArrayList<String> uncontactableBootstrapServers = new ArrayList<String>();
        ArrayList<String> failedBootstrapServers = new ArrayList<String>();
        Exception firstMirroredFailureException = null;
        SIResourceException firstBootstrapFailureException = null;
        boolean goodReply = false;
        List endpoints = cap.getProviderEPs();
        Iterator i = endpoints.iterator();
        ProviderEndPoint ep = null;
        while (i.hasNext()) {
            ep = (ProviderEndPoint)i.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Making bootstrap request to " + ep.getEndPointInfo()));
            }
            if ((cc = ccf.createClientConnection()) != null) {
                Object[] objs;
                ConnectionProperties cp = new ConnectionProperties(ep);
                cp.setClientConnectionPropertyMap(cap.getProperties());
                ClientBootstrapHandler cbh = new ClientBootstrapHandler(cap, credentialType, ep.getChain());
                try {
                    cc.connect(cp, cbh);
                    TrmFirstContactMessage fcm = cbh.getReply();
                    cbr = fcm.makeInboundTrmClientBootstrapReply();
                    rc = cbr.getReturnCode();
                    if (rc == -9) {
                        firstMirroredFailureException = this.generateException(rc, nls.getFormattedMessage("LIBERTY_FAILED_AUTHENTICATION_CWSIT0128", new Object[]{cap.getBusName(), ep.getEndPointInfo(), Utils.getFailureMessage(cbr.getFailureReason())}, null), null, false);
                        cc.close();
                        break;
                    }
                    if (rc == -6) {
                        firstMirroredFailureException = this.generateException(rc, nls.getFormattedMessage("LIBERTY_NOT_AUTHORIZED_CWSIT0129", new Object[]{cap.getBusName(), ep.getEndPointInfo(), Utils.getFailureMessage(cbr.getFailureReason())}, null), null, false);
                        cc.close();
                        break;
                    }
                    if (rc == 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Made a bootstrap request to " + ep.getEndPointInfo() + ". Response was " + (rc == 0 ? "OK" : "REDIRECT")));
                        }
                        goodReply = true;
                        break;
                    }
                    objs = new Object[]{ep.getEndPointInfo(), cap.getBusName(), rc == 1 ? "REDIRECT TWAS" : Utils.getFailureMessage(cbr.getFailureReason())};
                    Exception exception = this.generateException(rc, nls.getFormattedMessage("LIBERTY_MIRRORED_FAILURE_CWSIT0130", objs, null), cbh.getException(), false);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                    if (null == firstMirroredFailureException) {
                        firstMirroredFailureException = exception;
                    }
                    failedBootstrapServers.add(ep.getEndPointInfo());
                    cc.close();
                }
                catch (Exception e) {
                    objs = new Object[]{ep.getEndPointInfo(), e.toString()};
                    SIResourceException sire = new SIResourceException(nls.getFormattedMessage("LIBERTY_BOOTSTRAP_FAILED_CWSIT0131", objs, null), e);
                    SibTr.exception((TraceComponent)tc, (Exception)sire);
                    if (null == firstBootstrapFailureException) {
                        firstBootstrapFailureException = sire;
                    }
                    uncontactableBootstrapServers.add(ep.getEndPointInfo());
                }
                continue;
            }
            throw new SIErrorException(nls.getString("NO_CC_CWSIT0005"));
        }
        ContactBootstrapServiceResponse cbsr = new ContactBootstrapServiceResponse(cc, cbr, rc, uncontactableBootstrapServers, failedBootstrapServers, firstMirroredFailureException, firstBootstrapFailureException, goodReply, ep);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"contactBootstrapService", (Object)cbsr);
        }
        return cbsr;
    }

    private int getRC(Exception linkedException) {
        int rc = -2;
        if (null != linkedException) {
            if (linkedException instanceof SIConnectionLostException) {
                rc = -3;
            } else if (linkedException instanceof SILimitExceededException) {
                rc = -4;
            } else if (linkedException instanceof SIErrorException) {
                rc = -5;
            } else if (linkedException instanceof SINotAuthorizedException) {
                rc = -6;
            } else if (linkedException instanceof SINotPossibleInCurrentConfigurationException) {
                rc = -7;
            } else if (linkedException instanceof SIIncorrectCallException) {
                rc = -8;
            } else if (linkedException instanceof SIAuthenticationException) {
                rc = -9;
            }
        }
        return rc;
    }

    private Exception generateException(int rc, String text, Exception linkedException, boolean throwIt) throws SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        Exception theException;
        if (rc == -2) {
            SIResourceException sire = new SIResourceException(text);
            if (null != linkedException) {
                sire.initCause(linkedException);
            }
            if (throwIt) {
                throw sire;
            }
            theException = sire;
        } else if (rc == -3) {
            SIConnectionLostException sicle = new SIConnectionLostException(text);
            if (null != linkedException) {
                sicle.initCause(linkedException);
            }
            if (throwIt) {
                throw sicle;
            }
            theException = sicle;
        } else if (rc == -4) {
            SILimitExceededException silee = new SILimitExceededException(text);
            if (null != linkedException) {
                // empty if block
            }
            if (throwIt) {
                throw silee;
            }
            theException = silee;
        } else if (rc == -5) {
            SIErrorException siee = new SIErrorException(text);
            if (null != linkedException) {
                siee.initCause(linkedException);
            }
            if (throwIt) {
                throw siee;
            }
            theException = siee;
        } else if (rc == -6) {
            SINotAuthorizedException sinae = new SINotAuthorizedException(text);
            if (null != linkedException) {
                // empty if block
            }
            if (throwIt) {
                throw sinae;
            }
            theException = sinae;
        } else if (rc == -7) {
            SINotPossibleInCurrentConfigurationException sinpicce = new SINotPossibleInCurrentConfigurationException(text);
            if (null != linkedException) {
                sinpicce.initCause(linkedException);
            }
            if (throwIt) {
                throw sinpicce;
            }
            theException = sinpicce;
        } else if (rc == -8) {
            SIIncorrectCallException siice = new SIIncorrectCallException(text);
            if (null != linkedException) {
                siice.initCause(linkedException);
            }
            if (throwIt) {
                throw siice;
            }
            theException = siice;
        } else if (rc == -9) {
            SIAuthenticationException siae = new SIAuthenticationException(text);
            if (null != linkedException) {
                // empty if block
            }
            if (throwIt) {
                throw siae;
            }
            theException = siae;
        } else {
            SIErrorException siee = new SIErrorException(text);
            if (null != linkedException) {
                siee.initCause(linkedException);
            }
            if (throwIt) {
                throw siee;
            }
            theException = siee;
        }
        return theException;
    }

    @Override
    public SICoreConnection createConnection(ClientConnection cc, String credentialType, String userid, String password) throws SIResourceException, SINotAuthorizedException, SIAuthenticationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnection", (Object)new Object[]{cc, credentialType, userid, password});
        }
        SibTr.error((TraceComponent)tc, (String)"This method should not have been called");
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConnection", null);
        }
        return null;
    }

    static class ContactBootstrapServiceResponse {
        private final ClientConnection cc;
        private final TrmClientBootstrapReply cbr;
        private final int rc;
        private final List uncontactableBootstrapServers;
        private final List failedBootstrapServers;
        private final Exception firstMirroredFailureException;
        private final Exception firstBootstrapFailureException;
        private final boolean goodReply;
        private final ProviderEndPoint ep;

        ContactBootstrapServiceResponse(ClientConnection cc, TrmClientBootstrapReply cbr, int rc, List uncontactableBootstrapServers, List failedBootstrapServers, Exception firstMirroredFailureException, Exception firstBootstrapFailureException, boolean goodReply, ProviderEndPoint ep) {
            this.cc = cc;
            this.cbr = cbr;
            this.rc = rc;
            this.uncontactableBootstrapServers = uncontactableBootstrapServers;
            this.failedBootstrapServers = failedBootstrapServers;
            this.firstMirroredFailureException = firstMirroredFailureException;
            this.firstBootstrapFailureException = firstBootstrapFailureException;
            this.goodReply = goodReply;
            this.ep = ep;
        }

        ClientConnection getClientConnection() {
            return this.cc;
        }

        TrmClientBootstrapReply getClientBootstrapReply() {
            return this.cbr;
        }

        int getReturnCode() {
            return this.rc;
        }

        List getFailedBootstrapServers() {
            return this.failedBootstrapServers;
        }

        List getUncontactableBootstrapServers() {
            return this.uncontactableBootstrapServers;
        }

        Exception getFirstMirroredFailureException() {
            return this.firstMirroredFailureException;
        }

        Exception getFirstBootstrapFailureException() {
            return this.firstBootstrapFailureException;
        }

        boolean isGoodReply() {
            return this.goodReply;
        }

        ProviderEndPoint getEndPoint() {
            return this.ep;
        }

        public String toString() {
            return "cc=" + this.cc + ",cbr=" + this.cbr + ",rc=" + this.rc + ",uncontactableBootstrapServers=" + this.uncontactableBootstrapServers + ",failedBootstrapServers=" + this.failedBootstrapServers + ",firstMirroredFailureException=" + this.firstMirroredFailureException + ",firstBootstrapFailureException=" + this.firstBootstrapFailureException + ",goodReply=" + this.goodReply + ",ep=" + this.ep.getEndPointInfo();
        }
    }
}

