/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.async.AsyncListenerEnum;
import com.ibm.ws.webcontainer.async.ListenerHelper;
import com.ibm.ws.webcontainer.async.ServiceWrapper;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class DispatchRunnable
extends ServiceWrapper
implements Runnable {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.async.DispatchRunnable";
    private WebAppRequestDispatcher requestDispatcher;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private IExtendedRequest extRequest;
    private AsyncContextImpl asyncContextImpl;
    private SRTServletRequestThreadData requestDataOnDispatchRequestThread;

    public DispatchRunnable(WebAppRequestDispatcher requestDispatcher, AsyncContextImpl asyncContextImpl) {
        super(asyncContextImpl);
        this.requestDispatcher = requestDispatcher;
        this.asyncContextImpl = asyncContextImpl;
        this.servletRequest = asyncContextImpl.getRequest();
        this.servletResponse = asyncContextImpl.getResponse();
        this.extRequest = asyncContextImpl.getIExtendedRequest();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "constructor", " " + this);
        }
        this.requestDataOnDispatchRequestThread = new SRTServletRequestThreadData();
        this.requestDataOnDispatchRequestThread.init(SRTServletRequestThreadData.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "run", this);
        }
        if (!this.asyncContextImpl.transferContext()) {
            this.popContextData();
        }
        WebContainerRequestState reqState = WebContainerRequestState.createInstance();
        try {
            reqState.setCurrentThreadsIExtendedRequest(this.extRequest);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "run", "Context Class loader before dispatch: " + Thread.currentThread().getContextClassLoader());
            }
            SRTServletRequestThreadData.getInstance().init(this.requestDataOnDispatchRequestThread);
            this.extRequest.setAsyncStarted(false);
            this.requestDispatcher.dispatch(this.servletRequest, this.servletResponse, DispatcherType.ASYNC);
        }
        catch (Throwable th) {
            logger.logp(Level.WARNING, CLASS_NAME, "run", "error.calling.async.dispatch", th);
            ListenerHelper.invokeAsyncErrorHandling(this.asyncContextImpl, reqState, th, AsyncListenerEnum.ERROR, ListenerHelper.ExecuteNextRunnable.FALSE, ListenerHelper.CheckDispatching.FALSE);
        }
        finally {
            if (!this.asyncContextImpl.transferContext()) {
                this.resetContextData();
            }
            AsyncContextImpl asyncContextImpl = this.asyncContextImpl;
            synchronized (asyncContextImpl) {
                if (!(this.asyncContextImpl.isComplete() || reqState.isAsyncMode() || this.asyncContextImpl.isCompletePending())) {
                    this.asyncContextImpl.complete();
                }
            }
            SRTServletRequestThreadData.getInstance().init(null);
            this.asyncContextImpl.executeNextRunnable();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "run", this);
        }
    }
}

