/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS30.appSecurity;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authorization.util.RoleMethodAuthUtil;
import com.ibm.ws.security.authorization.util.UnauthenticatedException;
import com.ibm.ws.security.context.SubjectManager;
import jakarta.annotation.Priority;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Priority(value=2001)
@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyAuthFilter
implements ContainerRequestFilter {
    @Context
    HttpServletRequest req;
    @Context
    HttpServletResponse resp;
    @Context
    SecurityContext securityContext;
    @Context
    ResourceInfo resourceInfo;
    private UnauthenticatedSubjectService unauthenticatedSubjectService;
    static final long serialVersionUID = -1343346582864679496L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={UnauthenticatedException.class, UnauthenticatedException.class})
    public void filter(ContainerRequestContext context) {
        try {
            this.handleMessage();
        }
        catch (UnauthenticatedException ex) {
            try {
                if (this.authenticate()) {
                    this.handleMessage();
                    return;
                }
            }
            catch (UnauthenticatedException unauthenticatedException) {
                // empty catch block
            }
            context.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private boolean authenticate() {
        try {
            return this.req.authenticate(this.resp);
        }
        catch (ServletException | IOException throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.restfulWS30.appSecurity.LibertyAuthFilter", (String)"90", (Object)this, (Object[])new Object[0]);
            return false;
        }
    }

    private void handleMessage() throws UnauthenticatedException, ForbiddenException {
        Method method = this.resourceInfo.getResourceMethod();
        if (method == null) {
            throw new ForbiddenException("Method is not available : Unauthorized");
        }
        this.setUnauthenticatedSubjectIfNeeded();
        if (this.securityContext != null && RoleMethodAuthUtil.parseMethodSecurity((Method)method, (Supplier)new Supplier<Principal>(){
            static final long serialVersionUID = 4969691052944848478L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Principal get() {
                return LibertyAuthFilter.this.securityContext.getUserPrincipal();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS30.appSecurity.LibertyAuthFilter$1", 1.class, (String)"RESTfulWS", null);
            }
        }, s -> this.securityContext.isUserInRole(s))) {
            return;
        }
        if (RoleMethodAuthUtil.parseMethodSecurity((Method)method, (Supplier)new Supplier<Principal>(){
            static final long serialVersionUID = -111594025542896423L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Principal get() {
                return LibertyAuthFilter.this.req.getUserPrincipal();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS30.appSecurity.LibertyAuthFilter$2", 2.class, (String)"RESTfulWS", null);
            }
        }, s -> this.req.isUserInRole(s))) {
            return;
        }
        throw new ForbiddenException("Unauthorized");
    }

    private void setUnauthenticatedSubjectIfNeeded() {
        this.getUnauthenticatedSubjectService();
        SubjectManager subjectManager = new SubjectManager();
        if (subjectManager.getInvocationSubject() == null) {
            subjectManager.setInvocationSubject(this.unauthenticatedSubjectService.getUnauthenticatedSubject());
        }
        if (subjectManager.getCallerSubject() == null) {
            subjectManager.setCallerSubject(this.unauthenticatedSubjectService.getUnauthenticatedSubject());
        }
    }

    private void getUnauthenticatedSubjectService() {
        if (this.unauthenticatedSubjectService == null) {
            BundleContext context = FrameworkUtil.getBundle(UnauthenticatedSubjectService.class).getBundleContext();
            ServiceReference serviceRef = context.getServiceReference(UnauthenticatedSubjectService.class);
            this.unauthenticatedSubjectService = (UnauthenticatedSubjectService)context.getService(serviceRef);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS30.appSecurity.LibertyAuthFilter", LibertyAuthFilter.class, (String)"RESTfulWS", null);
    }
}

