/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroupFactory;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsLightTrace;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.StoppableAsynchConsumerCallback;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConsumerSessionProxy
extends DestinationSessionProxy
implements ConsumerSession {
    private static final TraceComponent tc = SibTr.register(ConsumerSessionProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static String CLASS_NAME = ConsumerSessionProxy.class.getName();
    private AsynchConsumerProxyQueue proxyQueue = null;
    private boolean isReadAhead = false;
    private final Object callbackLock = new Object();
    private Object synchLock = new Object();
    boolean asynchConsumerRegistered = false;
    private String destName = null;
    private volatile StateEnum state = StateEnum.STOPPED;
    private Object lmeMonitor = new Object();
    private Reliability unrecoverableReliabilty = null;
    private long messageProcessorId;
    private final DestinationType destType;
    private OrderingContextProxy currentOrderingContext = null;
    private List<DataSlice> pendingMessageSlices = null;
    private Object pendingMessageSliceLock = new Object();
    private volatile boolean executingReceiveWithWait = false;
    private CallbackThreadState callbackThreadState = CallbackThreadState.STARTED_REGISTERED;
    private AsynchConsumerCallback callbackThreadCallback = null;
    private int callbackThreadMaxActiveMessages;
    private long callbackThreadMessageLockExpiry;
    private int callbackThreadMaxBatchSize;
    private OrderingContext callbackThreadOrderingContext;
    private int callbackMaxSequentialFailures;
    private long callbackHiddenMessageDelay;
    private boolean callbackStoppable;

    public void resetCallbackThreadState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetCallbackThreadState");
        }
        this.callbackThreadState = CallbackThreadState.STARTED_REGISTERED;
        this.callbackThreadCallback = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resetCallbackThreadState");
        }
    }

    public boolean performInCallbackActions() throws SIConnectionLostException, SIResourceException, SIErrorException, SISessionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"performInCallbackActions");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("callbackThreadState=" + (Object)((Object)this.callbackThreadState)));
        }
        boolean result = false;
        switch (this.callbackThreadState) {
            case CLOSED: {
                this.close();
                result = false;
                break;
            }
            case STOPPED_DEREGISTERED: {
                this.stop();
                this.deregisterAsynchConsumerCallback();
                result = false;
                break;
            }
            case STOPPED_REGISTERED: {
                this.stop();
                if (this.callbackThreadCallback != null) {
                    if (this.callbackStoppable) {
                        this.registerStoppableAsynchConsumerCallback((StoppableAsynchConsumerCallback)this.callbackThreadCallback, this.callbackThreadMaxActiveMessages, this.callbackThreadMessageLockExpiry, this.callbackThreadMaxBatchSize, this.callbackThreadOrderingContext, this.callbackMaxSequentialFailures, this.callbackHiddenMessageDelay);
                    } else {
                        this.registerAsynchConsumerCallback(this.callbackThreadCallback, this.callbackThreadMaxActiveMessages, this.callbackThreadMessageLockExpiry, this.callbackThreadMaxBatchSize, this.callbackThreadOrderingContext);
                    }
                }
                result = false;
                break;
            }
            case STARTED_DEREGISTERED: {
                this.stop();
                this.deregisterAsynchConsumerCallback();
                this.start(false);
                result = true;
                break;
            }
            case STARTED_REGISTERED: {
                if (this.callbackThreadCallback != null) {
                    this.stop();
                    if (this.callbackStoppable) {
                        this.registerStoppableAsynchConsumerCallback((StoppableAsynchConsumerCallback)this.callbackThreadCallback, this.callbackThreadMaxActiveMessages, this.callbackThreadMessageLockExpiry, this.callbackThreadMaxBatchSize, this.callbackThreadOrderingContext, this.callbackMaxSequentialFailures, this.callbackHiddenMessageDelay);
                    } else {
                        this.registerAsynchConsumerCallback(this.callbackThreadCallback, this.callbackThreadMaxActiveMessages, this.callbackThreadMessageLockExpiry, this.callbackThreadMaxBatchSize, this.callbackThreadOrderingContext);
                    }
                    this.start(false);
                }
                result = true;
                break;
            }
            default: {
                FFDCFilter.processException((Throwable)new Exception(), (String)(CLASS_NAME + ".performInCallbackActions"), (String)"1-003-0012", (Object)((Object)this.callbackThreadState));
                result = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"performInCallbackActions", (Object)result);
        }
        return result;
    }

    public ConsumerSessionProxy(Conversation con, ConnectionProxy cp, CommsByteBuffer buf, AsynchConsumerProxyQueue readAheadProxyQueue, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destType, long messageProcessorId) {
        super(con, cp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{con, cp, buf, readAheadProxyQueue, unrecoverableReliability, destAddr, destType, messageProcessorId});
        }
        this.setDestinationAddress(destAddr);
        this.destName = destAddr.getDestinationName();
        this.inflateData(buf);
        this.destType = destType;
        this.isReadAhead = readAheadProxyQueue != null;
        this.proxyQueue = readAheadProxyQueue;
        this.unrecoverableReliabilty = unrecoverableReliability;
        this.messageProcessorId = messageProcessorId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public ConsumerSessionProxy() {
        super(null, null);
        this.setProxyID((short)123);
        this.destType = null;
    }

    public Reliability getUnrecoverableReliability() {
        return this.unrecoverableReliabilty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessagePart(CommsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addMessagePart", (Object)buffer);
        }
        byte flags = buffer.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Flags: ", (Object)flags);
        }
        Object object = this.pendingMessageSliceLock;
        synchronized (object) {
            if (this.pendingMessageSlices == null) {
                this.pendingMessageSlices = new ArrayList<DataSlice>();
            }
            this.pendingMessageSlices.add(buffer.getDataSlice());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message parts: ", this.pendingMessageSlices);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addMessagePart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveNoWait(SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveNoWait", (Object)tran);
        }
        SIBusMessage mess = null;
        if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        if (this.executingReceiveWithWait) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("ALREADY_IN_RECEIVE_WAIT_SICO1060", null, "ALREADY_IN_RECEIVE_WAIT_SICO1060"));
        }
        Object object = this.synchLock;
        synchronized (object) {
            if (tran != null) {
                SITransaction sITransaction = tran;
                synchronized (sITransaction) {
                    if (!((Transaction)tran).isValid()) {
                        throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                    }
                    mess = this._receiveNoWait(tran);
                }
            } else {
                mess = this._receiveNoWait(null);
            }
        }
        if (mess != null) {
            // empty if block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveNoWait");
        }
        return mess;
    }

    private SIBusMessage _receiveNoWait(SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_receiveNoWait");
        }
        SIBusMessage mess = null;
        boolean consumeSuccessful = false;
        if (this.isReadAhead) {
            try {
                mess = this.proxyQueue.receiveNoWait(tran);
            }
            catch (MessageDecodeFailedException mdfe) {
                FFDCFilter.processException((Throwable)mdfe, (String)(CLASS_NAME + "._receiveNoWait"), (String)"1-003-0001", (Object)this);
                SIResourceException resourceException = new SIResourceException(nls.getFormattedMessage("UNABLE_TO_CREATE_JSMESSAGE_SICO1002", null, null));
                resourceException.initCause((Throwable)mdfe);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"receiveNoWait", (Object)resourceException);
                }
                throw resourceException;
            }
        } else {
            mess = this.performReceive(-1L, tran);
        }
        consumeSuccessful = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_receiveNoWait");
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveWithWait(SITransaction tran, long timeout) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        SIBusMessage mess;
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveWithWait", (Object)new Object[]{tran, "" + timeout});
            }
            mess = null;
            if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            this.executingReceiveWithWait = true;
            try {
                if (tran != null) {
                    SITransaction sITransaction = tran;
                    synchronized (sITransaction) {
                        if (!((Transaction)tran).isValid()) {
                            throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                        }
                        mess = this._receiveWithWait(tran, timeout);
                        break block12;
                    }
                }
                mess = this._receiveWithWait(null, timeout);
            }
            finally {
                this.executingReceiveWithWait = false;
                if (mess != null) {
                    // empty if block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveWithWait");
        }
        return mess;
    }

    private SIBusMessage _receiveWithWait(SITransaction tran, long timeout) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_receiveWithWait");
        }
        SIBusMessage mess = null;
        boolean successfulConsume = false;
        if (this.isReadAhead) {
            try {
                mess = this.proxyQueue.receiveWithWait(timeout, tran);
            }
            catch (MessageDecodeFailedException mdfe) {
                FFDCFilter.processException((Throwable)mdfe, (String)(CLASS_NAME + "._receiveWithWait"), (String)"1-003-0002", (Object)this);
                SIResourceException resourceException = new SIResourceException(nls.getFormattedMessage("UNABLE_TO_CREATE_JSMESSAGE_SICO1002", null, null));
                resourceException.initCause((Throwable)mdfe);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"receiveWithWait", (Object)resourceException);
                }
                throw resourceException;
            }
        } else {
            mess = this.performReceive(timeout, tran);
        }
        successfulConsume = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_receiveWithWait");
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIBusMessage performReceive(long timeout, SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"performReceive", (Object)new Object[]{"" + timeout, tran});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(">>>> performReceive invoked with conversation: " + this.getConversation()));
        }
        if (this.proxyQueue != null && !this.isReadAhead) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("INCORRECT_RECEIVE_CALL_SICO1061", null, "INCORRECT_RECEIVE_CALL_SICO1061"));
        }
        if (timeout < -1L) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8004", new Object[]{"" + timeout}, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".performReceive"), (String)"1-003-0006", (Object)this);
            throw e;
        }
        SIBusMessage mess = null;
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putShort(this.getProxyID());
        request.putSITransaction(tran);
        request.putLong(timeout);
        CommsByteBuffer reply = this.jfapExchange(request, 78, 7, true);
        try {
            short err = reply.getCommandCompletionCode(206);
            if (err != 0) {
                this.checkFor_SISessionUnavailableException(reply, err);
                this.checkFor_SISessionDroppedException(reply, err);
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SILimitExceededException(reply, err);
                this.checkFor_SINotAuthorizedException(reply, err);
                this.checkFor_SIIncorrectCallException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            Object object = this.pendingMessageSliceLock;
            synchronized (object) {
                if (this.pendingMessageSlices == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received the entire message");
                    }
                    reply.getShort();
                    reply.getShort();
                    mess = reply.getMessage(this.getCommsConnection());
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received the final slice");
                    }
                    reply.getShort();
                    reply.getShort();
                    this.addMessagePart(reply);
                    try {
                        mess = JsMessageFactory.getInstance().createInboundJsMessage(this.pendingMessageSlices, (Object)this.getCommsConnection());
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".performReceive"), (String)"1-003-0006", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to recreate message", (Object)e);
                        }
                        throw new SIResourceException((Throwable)e);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled()) {
                    CommsLightTrace.traceMessageId(tc, "ReceiveMsgTrace", mess);
                }
                this.pendingMessageSlices = null;
            }
        }
        finally {
            if (reply != null) {
                reply.release(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"performReceive", (Object)mess);
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_close");
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putShort(this.getProxyID());
        CommsByteBuffer reply = this.jfapExchange(request, 73, 7, true);
        try {
            short err = reply.getCommandCompletionCode(201);
            if (err != 0) {
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closingConnection) throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)closingConnection);
        }
        if (this.executingOnCallbackThread()) {
            this.callbackThreadState = CallbackThreadState.CLOSED;
        } else {
            Object object = this.callbackLock;
            synchronized (object) {
                boolean closeProxyQueue = false;
                Object object2 = this.synchLock;
                synchronized (object2) {
                    if (this.state != StateEnum.CLOSED && this.state != StateEnum.CLOSING) {
                        this.state = StateEnum.CLOSING;
                        if (this.proxyQueue != null) {
                            closeProxyQueue = true;
                        } else {
                            this.state = StateEnum.CLOSED;
                            if (!closingConnection && !this.isClosed()) {
                                this._close();
                                if (this.currentOrderingContext != null) {
                                    this.currentOrderingContext.decrementUseCount();
                                    this.currentOrderingContext = null;
                                }
                            }
                        }
                    }
                }
                if (closeProxyQueue) {
                    this.proxyQueue.closing();
                }
                object2 = this.synchLock;
                synchronized (object2) {
                    if (this.state == StateEnum.CLOSING) {
                        this.state = StateEnum.CLOSED;
                        if (!closingConnection && this.proxyQueue != null) {
                            this.proxyQueue.closed();
                            if (this.currentOrderingContext != null) {
                                this.currentOrderingContext.decrementUseCount();
                                this.currentOrderingContext = null;
                            }
                        }
                    }
                }
            }
        }
        this.getConnectionProxy().consumerClosedNotification(this.getProxyID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this.close(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean deliverImmediately) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)("" + deliverImmediately));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("**** start invoked with conversation: " + this.getConversation()));
        }
        if (this.executingOnCallbackThread()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Start is being called on the callback thread, callbackThreadState=" + (Object)((Object)this.callbackThreadState)));
            }
            if (this.callbackThreadState == CallbackThreadState.CLOSED || this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            if (this.callbackThreadState == CallbackThreadState.STOPPED_DEREGISTERED) {
                this.callbackThreadState = CallbackThreadState.STARTED_DEREGISTERED;
            } else if (this.callbackThreadState == CallbackThreadState.STOPPED_REGISTERED) {
                this.callbackThreadState = CallbackThreadState.STARTED_REGISTERED;
            }
        } else {
            Object object = this.callbackLock;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Got asynch lock");
                }
                Object object2 = this.synchLock;
                synchronized (object2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Got sync lock");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current state is: " + (Object)((Object)this.state)));
                    }
                    if (this.state == StateEnum.STOPPING) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"currently stopping - will perform start on thread invoking stop() method");
                        }
                        this.state = StateEnum.STOPPING_THEN_STARTED;
                    } else {
                        if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
                        }
                        if (this.state != StateEnum.STARTED) {
                            this.startInternal();
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void startInternal() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && ConsumerSessionProxy.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)ConsumerSessionProxy.tc, (String)"startInternal");
        }
        this.state = StateEnum.STARTED;
        if (this.proxyQueue != null) {
            this.proxyQueue.start();
        } else {
            request = this.getCommsByteBuffer();
            request.putShort(this.getConnectionObjectID());
            request.putShort(this.getProxyID());
            props = this.getConversation().getHandshakeProperties();
            if (props.getFapLevel() >= 3) {
                reply = this.jfapExchange(request, 85, 7, true);
                try {
                    err = reply.getCommandCompletionCode(244);
                    if (err == 0) ** GOTO lbl30
                    this.checkFor_SISessionUnavailableException(reply, err);
                    this.checkFor_SISessionDroppedException(reply, err);
                    this.checkFor_SIConnectionUnavailableException(reply, err);
                    this.checkFor_SIConnectionDroppedException(reply, err);
                    this.checkFor_SIResourceException(reply, err);
                    this.checkFor_SIConnectionLostException(reply, err);
                    this.checkFor_SIErrorException(reply, err);
                    this.defaultChecker(reply, err);
                }
                finally {
                    if (reply != null) {
                        reply.release();
                    }
                }
            } else {
                this.jfapSend(request, 85, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD);
            }
        }
lbl30:
        // 4 sources

        if (TraceComponent.isAnyTracingEnabled() && ConsumerSessionProxy.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)ConsumerSessionProxy.tc, (String)"startInternal");
        }
    }

    public void stop() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        this.stopInternal(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInternal(boolean notifypeer) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopInternal", (Object)("notifypeer=" + notifypeer));
        }
        if (this.executingOnCallbackThread()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("called from within asynch consumer callback, callbackThreadState=" + (Object)((Object)this.callbackThreadState)));
            }
            if (this.callbackThreadState == CallbackThreadState.CLOSED || this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            if (this.state == StateEnum.STOPPING || this.state == StateEnum.STOPPED) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Session already stopping/stopped");
                }
            } else if (this.callbackThreadState == CallbackThreadState.STARTED_DEREGISTERED) {
                this.callbackThreadState = CallbackThreadState.STOPPED_DEREGISTERED;
            } else if (this.callbackThreadState == CallbackThreadState.STARTED_REGISTERED) {
                this.callbackThreadState = CallbackThreadState.STOPPED_REGISTERED;
            }
        } else {
            Object object;
            boolean stopProxyQueue = false;
            Object object2 = this.callbackLock;
            synchronized (object2) {
                if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                    throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
                }
                object = this.synchLock;
                synchronized (object) {
                    if (this.state != StateEnum.STOPPED && this.state != StateEnum.STOPPING && this.state != StateEnum.STOPPING_THEN_STARTED) {
                        this.state = StateEnum.STOPPING;
                        if (this.proxyQueue != null) {
                            stopProxyQueue = true;
                        } else {
                            this.state = StateEnum.STOPPED;
                            if (notifypeer) {
                                CommsByteBuffer request = this.getCommsByteBuffer();
                                request.putShort(this.getConnectionObjectID());
                                request.putShort(this.getProxyID());
                                CommsByteBuffer reply = this.jfapExchange(request, 86, 7, true);
                                try {
                                    short err = reply.getCommandCompletionCode(214);
                                    if (err != 0) {
                                        this.checkFor_SISessionUnavailableException(reply, err);
                                        this.checkFor_SISessionDroppedException(reply, err);
                                        this.checkFor_SIConnectionUnavailableException(reply, err);
                                        this.checkFor_SIConnectionDroppedException(reply, err);
                                        this.checkFor_SIResourceException(reply, err);
                                        this.checkFor_SIConnectionLostException(reply, err);
                                        this.checkFor_SIErrorException(reply, err);
                                        this.defaultChecker(reply, err);
                                    }
                                }
                                finally {
                                    if (reply != null) {
                                        reply.release();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (stopProxyQueue) {
                this.proxyQueue.stopping(notifypeer);
            }
            object2 = this.callbackLock;
            synchronized (object2) {
                object = this.synchLock;
                synchronized (object) {
                    boolean doStart;
                    boolean bl = doStart = this.state == StateEnum.STOPPING_THEN_STARTED;
                    if (this.state == StateEnum.STOPPING || this.state == StateEnum.STOPPING_THEN_STARTED) {
                        this.state = StateEnum.STOPPED;
                        if (this.proxyQueue != null) {
                            this.proxyQueue.stopped();
                        }
                    }
                    if (doStart) {
                        this.startInternal();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
        if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        Object object = this.synchLock;
        synchronized (object) {
            if (this.proxyQueue != null) {
                this.proxyQueue.unlockAll();
            } else {
                CommsByteBuffer request = this.getCommsByteBuffer();
                request.putShort(this.getConnectionObjectID());
                request.putShort(this.getProxyID());
                CommsByteBuffer reply = this.jfapExchange(request, 88, 7, true);
                try {
                    short err = reply.getCommandCompletionCode(216);
                    if (err != 0) {
                        this.checkFor_SISessionUnavailableException(reply, err);
                        this.checkFor_SISessionDroppedException(reply, err);
                        this.checkFor_SIConnectionUnavailableException(reply, err);
                        this.checkFor_SIConnectionDroppedException(reply, err);
                        this.checkFor_SIResourceException(reply, err);
                        this.checkFor_SIConnectionLostException(reply, err);
                        this.checkFor_SIErrorException(reply, err);
                        this.defaultChecker(reply, err);
                    }
                }
                finally {
                    if (reply != null) {
                        reply.release();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    public void unlockSet(SIMessageHandle[] msgHandles) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{msgHandles.length + " msg ids"});
        }
        this.unlockSet(msgHandles, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockSet(SIMessageHandle[] msgHandles, boolean incrementLockCount) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{msgHandles.length + " msg ids", incrementLockCount});
        }
        if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        Object object = this.synchLock;
        synchronized (object) {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putShort(this.getConnectionObjectID());
            request.putShort(this.getProxyID());
            request.putSIMessageHandles(msgHandles);
            short fapLevel = this.getConversation().getHandshakeProperties().getFapLevel();
            if (fapLevel >= 7 && fapLevel != 9) {
                request.put((byte)(incrementLockCount ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 104, 7, true);
            try {
                short err = reply.getCommandCompletionCode(233);
                if (err != 0) {
                    this.checkFor_SISessionUnavailableException(reply, err);
                    this.checkFor_SISessionDroppedException(reply, err);
                    this.checkFor_SIConnectionUnavailableException(reply, err);
                    this.checkFor_SIConnectionDroppedException(reply, err);
                    this.checkFor_SIResourceException(reply, err);
                    this.checkFor_SIConnectionLostException(reply, err);
                    this.checkFor_SIIncorrectCallException(reply, err);
                    this.checkFor_SIMessageNotLockedException(reply, err);
                    this.checkFor_SIErrorException(reply, err);
                    this.defaultChecker(reply, err);
                }
            }
            finally {
                if (reply != null) {
                    reply.release();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteSet(SIMessageHandle[] msgHandles, SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_deleteSet", (Object)new Object[]{msgHandles.length + " msg handles", tran});
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            CommsLightTrace.traceMessageIds(tc, "DeleteSetMsgTrace", msgHandles);
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putShort(this.getProxyID());
        request.putSITransaction(tran);
        request.putSIMessageHandles(msgHandles);
        CommsByteBuffer reply = this.jfapExchange(request, 91, 7, true);
        try {
            short err = reply.getCommandCompletionCode(219);
            if (err != 0) {
                this.checkFor_SISessionUnavailableException(reply, err);
                this.checkFor_SISessionDroppedException(reply, err);
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SILimitExceededException(reply, err);
                this.checkFor_SIIncorrectCallException(reply, err);
                this.checkFor_SIMessageNotLockedException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSet(SIMessageHandle[] msgHandles, SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteSet", (Object)new Object[]{msgHandles.length + " msg handles", tran});
        }
        if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        Object object = this.synchLock;
        synchronized (object) {
            if (tran == null) {
                this._deleteSet(msgHandles, null);
            } else {
                SITransaction sITransaction = tran;
                synchronized (sITransaction) {
                    if (!((Transaction)tran).isValid()) {
                        throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                    }
                    this._deleteSet(msgHandles, tran);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsynchConsumerCallback(AsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, OrderingContext orderingContext) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerAsynchConsumerCallback", (Object)new Object[]{callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderingContext});
        }
        if (this.executingOnCallbackThread()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("called from within asynch consumer callback, callbackThreadState=" + (Object)((Object)this.callbackThreadState)));
            }
            if (this.callbackThreadState == CallbackThreadState.CLOSED || this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            if (this.callbackThreadState == CallbackThreadState.STARTED_DEREGISTERED || this.callbackThreadState == CallbackThreadState.STARTED_REGISTERED) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("CALLBACK_CHANGE_WHILE_STARTED_SICO1015", null, null));
            }
            if (callback == null) {
                if (this.callbackThreadState == CallbackThreadState.STOPPED_REGISTERED) {
                    this.callbackThreadState = CallbackThreadState.STOPPED_DEREGISTERED;
                }
            } else {
                this.callbackThreadCallback = callback;
                this.callbackThreadMaxActiveMessages = maxActiveMessages;
                this.callbackThreadMessageLockExpiry = messageLockExpiry;
                this.callbackThreadMaxBatchSize = maxBatchSize;
                this.callbackThreadOrderingContext = orderingContext;
                this.callbackStoppable = false;
                if (this.callbackThreadState == CallbackThreadState.STOPPED_DEREGISTERED) {
                    this.callbackThreadState = CallbackThreadState.STOPPED_REGISTERED;
                }
            }
        } else {
            Object object = this.callbackLock;
            synchronized (object) {
                Object object2 = this.synchLock;
                synchronized (object2) {
                    this._registerAsynchConsumerCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderingContext, 0, 0L, false);
                    if (this.proxyQueue != null) {
                        this.proxyQueue.setAsynchCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderingContext, 0, 0L, false);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerAsynchConsumerCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _registerAsynchConsumerCallback(AsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, OrderingContext orderContext, int maxSequentialFailures, long hiddenMessageDelay, boolean stoppable) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_registerAsynchConsumerCallback", (Object)new Object[]{callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable});
        }
        boolean completed = false;
        if (callback != null) {
            OrderingContextProxy oc = (OrderingContextProxy)orderContext;
            if (oc == null) {
                if (this.currentOrderingContext != null) {
                    this.currentOrderingContext.decrementUseCount();
                    this.currentOrderingContext = null;
                }
            } else if (this.currentOrderingContext == null && this.asynchConsumerRegistered) {
                oc.incrementUseCount();
            } else if (this.currentOrderingContext != null && this.asynchConsumerRegistered) {
                if (oc != this.currentOrderingContext) {
                    this.currentOrderingContext.decrementUseCount();
                    oc.incrementUseCount();
                }
            } else if (!this.asynchConsumerRegistered) {
                oc.incrementUseCount();
            }
            try {
                try {
                    if (this.isReadAhead) {
                        if (maxActiveMessages != 0 || messageLockExpiry != 0L || stoppable) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && stoppable) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Forcing Read Ahead off because callback is Stoppable");
                            }
                            short seqNumber = this.proxyQueue.getCurrentMessageBatchSequenceNumber();
                            short id = this.proxyQueue.getId();
                            ProxyQueueConversationGroup pqcg = ((ClientConversationState)this.getConversation().getAttachment()).getProxyQueueConversationGroup();
                            seqNumber = (short)(seqNumber + 1);
                            this.isReadAhead = false;
                            this.proxyQueue = pqcg.createAsynchConsumerProxyQueue(id, seqNumber, orderContext);
                            this.proxyQueue.setConsumerSession(this);
                            this.proxyQueue.setAsynchCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable);
                        } else {
                            this.proxyQueue.setAsynchCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, null, maxSequentialFailures, hiddenMessageDelay, stoppable);
                        }
                    } else if (this.proxyQueue != null) {
                        this.proxyQueue.setAsynchCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable);
                    } else {
                        ClientConversationState clientConvState = (ClientConversationState)this.getConversation().getAttachment();
                        ProxyQueueConversationGroup pqcg = clientConvState.getProxyQueueConversationGroup();
                        if (pqcg == null) {
                            ProxyQueueConversationGroupFactory pqFact = ProxyQueueConversationGroupFactory.getRef();
                            pqcg = pqFact.create(this.getConversation());
                            clientConvState.setProxyQueueConversationGroup(pqcg);
                        }
                        this.proxyQueue = pqcg.createAsynchConsumerProxyQueue(orderContext);
                        this.proxyQueue.setConsumerSession(this);
                        this.proxyQueue.setAsynchCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable);
                    }
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + "._registerAsynchConsumerCallback"), (String)"1-003-0004", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a resource exception", (Object)((Object)e));
                    }
                    throw new SIConnectionDroppedException(e.getMessage(), (Throwable)e);
                }
                completed = true;
                this.currentOrderingContext = oc;
                this.asynchConsumerRegistered = true;
            }
            finally {
                if (!completed && oc != null) {
                    oc.decrementUseCount();
                }
            }
        }
        this.deregisterAsynchConsumerCallback();
        if (this.currentOrderingContext != null) {
            this.currentOrderingContext.decrementUseCount();
            this.currentOrderingContext = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_registerAsynchConsumerCallback");
        }
    }

    public void deregisterAsynchConsumerCallback() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deregisterAsynchConsumerCallback");
        }
        this._deregisterAsynchConsumerCallback(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deregisterAsynchConsumerCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deregisterAsynchConsumerCallback(boolean stoppable) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_deregisterAsynchConsumerCallback", (Object)("stoppable=" + stoppable));
        }
        if (this.executingOnCallbackThread()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("called from within asynch consumer callback, callbackThreadState=" + (Object)((Object)this.callbackThreadState)));
            }
            if (this.callbackThreadState == CallbackThreadState.CLOSED || this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            if (this.callbackThreadState == CallbackThreadState.STARTED_DEREGISTERED || this.callbackThreadState == CallbackThreadState.STARTED_REGISTERED) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("CALLBACK_CHANGE_WHILE_STARTED_SICO1015", null, null));
            }
            this.callbackThreadCallback = null;
            if (this.callbackThreadState == CallbackThreadState.STOPPED_REGISTERED) {
                this.callbackThreadState = CallbackThreadState.STOPPED_DEREGISTERED;
            }
        } else {
            if (this.state == StateEnum.STARTED) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("CALLBACK_CHANGE_WHILE_STARTED_SICO1015", null, null));
            }
            Object object = this.callbackLock;
            synchronized (object) {
                Object object2 = this.synchLock;
                synchronized (object2) {
                    if (this.asynchConsumerRegistered) {
                        this.asynchConsumerRegistered = false;
                        this.proxyQueue.setAsynchCallback(null, 0, 0L, 0, null, 0, 0L, stoppable);
                        if (!this.isReadAhead) {
                            this.proxyQueue = null;
                        }
                        if (this.currentOrderingContext != null) {
                            this.currentOrderingContext.decrementUseCount();
                            this.currentOrderingContext = null;
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_deregisterAsynchConsumerCallback");
        }
    }

    public void activateAsynchConsumer(boolean deliveryImmediately) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"activateAsynchConsumer", (Object)("" + deliveryImmediately));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"activateAsynchConsumer");
        }
        throw new SIErrorException(nls.getFormattedMessage("CLIENT_METHOD_INVALID_SICO1021", new Object[]{"activateAsynchConsumer"}, null));
    }

    public long getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getId", (Object)("" + this.messageProcessorId));
        }
        return this.messageProcessorId;
    }

    public void deliverAsyncException(Throwable e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliverAsyncException", (Object)e);
        }
        if (this.proxyQueue != null) {
            this.proxyQueue.deliverException(e);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"** Odd - we are not async?!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliverAsyncException");
        }
    }

    private boolean executingOnCallbackThread() {
        AsynchConsumerProxyQueue localProxyQueue = this.proxyQueue;
        return localProxyQueue != null && localProxyQueue.getAsynchConsumerThread() == Thread.currentThread();
    }

    public Object getLMEMonitor() {
        return this.lmeMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStoppableAsynchConsumerCallback(StoppableAsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, OrderingContext orderingContext, int maxSequentialFailures, long hiddenMessageDelay) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerStoppableAsynchConsumerCallback", (Object)new Object[]{callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderingContext, maxSequentialFailures, hiddenMessageDelay});
        }
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        CommsUtils.checkFapLevel(props, (short)9);
        if (this.executingOnCallbackThread()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("called from within asynch consumer callback, callbackThreadState=" + (Object)((Object)this.callbackThreadState)));
            }
            if (this.callbackThreadState == CallbackThreadState.CLOSED || this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
                throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
            }
            if (this.callbackThreadState == CallbackThreadState.STARTED_DEREGISTERED || this.callbackThreadState == CallbackThreadState.STARTED_REGISTERED) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("CALLBACK_CHANGE_WHILE_STARTED_SICO1015", null, null));
            }
            if (callback == null) {
                if (this.callbackThreadState == CallbackThreadState.STOPPED_REGISTERED) {
                    this.callbackThreadState = CallbackThreadState.STOPPED_DEREGISTERED;
                }
            } else {
                this.callbackThreadCallback = callback;
                this.callbackThreadMaxActiveMessages = maxActiveMessages;
                this.callbackThreadMessageLockExpiry = messageLockExpiry;
                this.callbackThreadMaxBatchSize = maxBatchSize;
                this.callbackThreadOrderingContext = orderingContext;
                this.callbackMaxSequentialFailures = maxSequentialFailures;
                this.callbackHiddenMessageDelay = hiddenMessageDelay;
                this.callbackStoppable = true;
                if (this.callbackThreadState == CallbackThreadState.STOPPED_DEREGISTERED) {
                    this.callbackThreadState = CallbackThreadState.STOPPED_REGISTERED;
                }
            }
        } else {
            Object object = this.callbackLock;
            synchronized (object) {
                Object object2 = this.synchLock;
                synchronized (object2) {
                    this._registerAsynchConsumerCallback((AsynchConsumerCallback)callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderingContext, maxSequentialFailures, hiddenMessageDelay, true);
                    if (this.proxyQueue != null) {
                        this.proxyQueue.setAsynchCallback((AsynchConsumerCallback)callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderingContext, maxSequentialFailures, hiddenMessageDelay, true);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerStoppableAsynchConsumerCallback");
        }
    }

    public void deregisterStoppableAsynchConsumerCallback() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deregisterStoppableAsynchConsumerCallback");
        }
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        CommsUtils.checkFapLevel(props, (short)9);
        this._deregisterAsynchConsumerCallback(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deregisterStoppableAsynchConsumerCallback");
        }
    }

    public void stoppableConsumerSessionStopped() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stoppableConsumerSessionStopped");
        }
        try {
            this.stopInternal(false);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processAsyncSessionStoppedCallback"), (String)"1-003-0011", (Object)this);
        }
        AsynchConsumerCallback asynchConsumerCallback = this.proxyQueue.getAsynchConsumerCallback();
        if (asynchConsumerCallback instanceof StoppableAsynchConsumerCallback) {
            StoppableAsynchConsumerCallback stoppableAsynchConsumerCallback = (StoppableAsynchConsumerCallback)asynchConsumerCallback;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"** Calling application StoppableAsynchConsumerCallback");
                }
                stoppableAsynchConsumerCallback.consumerSessionStopped();
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".stoppableConsumerSessionStopped"), (String)"1-003-0009", (Object)this);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("asynchConsumerCallback not an instance of StoppableAsynchConsumerCallback is an instance of " + asynchConsumerCallback.getClass().getName()));
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("WRONG_CLASS_CWSICO8022", new Object[]{asynchConsumerCallback.getClass().getName()}, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processAsyncSessionStoppedCallback"), (String)"1-003-0010", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"WRONG_CLASS_CWSICO8022", (Object)e);
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stoppableConsumerSessionStopped");
        }
    }

    public Object getCallbackLock() {
        return this.callbackLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackOccurred() throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackOccurred");
        }
        Object object = this.callbackLock;
        synchronized (object) {
            Object object2 = this.synchLock;
            synchronized (object2) {
                if (this.proxyQueue != null) {
                    this.proxyQueue.rollbackOccurred();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackOccurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll(boolean incrementUnlockCount) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
        if (this.state == StateEnum.CLOSED || this.state == StateEnum.CLOSING) {
            throw new SISessionUnavailableException(nls.getFormattedMessage("SESSION_CLOSED_SICO1013", null, null));
        }
        Object object = this.synchLock;
        synchronized (object) {
            if (this.proxyQueue != null) {
                this.proxyQueue.unlockAll();
            } else {
                CommsByteBuffer request = this.getCommsByteBuffer();
                request.putShort(this.getConnectionObjectID());
                request.putShort(this.getProxyID());
                CommsByteBuffer reply = this.jfapExchange(request, 88, 7, true);
                try {
                    short err = reply.getCommandCompletionCode(216);
                    if (err != 0) {
                        this.checkFor_SISessionUnavailableException(reply, err);
                        this.checkFor_SISessionDroppedException(reply, err);
                        this.checkFor_SIConnectionUnavailableException(reply, err);
                        this.checkFor_SIConnectionDroppedException(reply, err);
                        this.checkFor_SIResourceException(reply, err);
                        this.checkFor_SIConnectionLostException(reply, err);
                        this.checkFor_SIErrorException(reply, err);
                        this.defaultChecker(reply, err);
                    }
                }
                finally {
                    if (reply != null) {
                        reply.release();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    public void dump(FormattedWriter writer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump", (Object)new Object[]{writer});
        }
        try {
            writer.newLine();
            writer.startTag(this.getClass().getSimpleName());
            writer.indent();
            writer.newLine();
            writer.taggedValue("toString", (Object)this.toString());
            writer.newLine();
            writer.taggedValue("DestinationAddress", (Object)this.getDestinationAddress());
            writer.outdent();
            writer.newLine();
            writer.endTag(this.getClass().getSimpleName());
        }
        catch (Throwable t) {
            try {
                if (writer != null) {
                    writer.write("\nUnable to dump " + this + " " + t);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ConsumerSessionProxy.java, SIB.comms, WASX.SIB, uu1215.01 1.137");
        }
    }

    private static enum CallbackThreadState {
        STOPPED_REGISTERED,
        STOPPED_DEREGISTERED,
        STARTED_DEREGISTERED,
        STARTED_REGISTERED,
        CLOSED;

    }

    static enum StateEnum {
        STOPPED,
        STOPPING,
        CLOSED,
        CLOSING,
        STARTED,
        STOPPING_THEN_STARTED;

    }
}

