/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt;

import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claims;

public interface JsonWebToken
extends Principal {
    @Override
    public String getName();

    default public String getRawToken() {
        return (String)this.getClaim(Claims.raw_token.name());
    }

    default public String getIssuer() {
        return (String)this.getClaim(Claims.iss.name());
    }

    default public Set<String> getAudience() {
        return (Set)this.getClaim(Claims.aud.name());
    }

    default public String getSubject() {
        return (String)this.getClaim(Claims.sub.name());
    }

    default public String getTokenID() {
        return (String)this.getClaim(Claims.jti.name());
    }

    default public long getExpirationTime() {
        return (Long)this.getClaim(Claims.exp.name());
    }

    default public long getIssuedAtTime() {
        return (Long)this.getClaim(Claims.iat.name());
    }

    default public Set<String> getGroups() {
        return (Set)this.getClaim(Claims.groups.name());
    }

    public Set<String> getClaimNames();

    default public boolean containsClaim(String claimName) {
        return this.claim(claimName).isPresent();
    }

    public <T> T getClaim(String var1);

    default public <T> Optional<T> claim(String claimName) {
        return Optional.ofNullable(this.getClaim(claimName));
    }
}

