/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.state.ModuleStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ejbcontainer.osgi.EJBContainer;
import com.ibm.ws.ejbcontainer.war.internal.EJBWARMetaDataRuntime;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBWARRuntimeImpl
implements ModuleStateListener {
    private static final TraceComponent tc = Tr.register(EJBWARRuntimeImpl.class, (String)"EJBContainer", null);
    private final AtomicServiceReference<EJBContainer> ejbContainerSR = new AtomicServiceReference("ejbContainer");
    private EJBWARMetaDataRuntime ejbWARMetaDataRuntime;
    static final long serialVersionUID = -9127005639554328502L;

    public void setEJBContainer(ServiceReference<EJBContainer> reference) {
        this.ejbContainerSR.setReference(reference);
    }

    public void unsetEJBContainer(ServiceReference<EJBContainer> reference) {
        this.ejbContainerSR.unsetReference(reference);
    }

    public void setEJBWARMetaDataRuntime(EJBWARMetaDataRuntime runtime) {
        this.ejbWARMetaDataRuntime = runtime;
    }

    public void unsetEJBWARMetaDataRuntime(EJBWARMetaDataRuntime runtime) {
        this.ejbWARMetaDataRuntime = null;
    }

    public void activate(ComponentContext cc) {
        this.ejbContainerSR.activate(cc);
    }

    public void deactivate(ComponentContext cc) {
        this.ejbContainerSR.deactivate(cc);
    }

    private ModuleMetaData getEJBModuleMetaData(ModuleInfo moduleInfo) {
        if (this.ejbWARMetaDataRuntime == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("EJBWARRuntime deactivated, cannot obtain EJBModuleMetaData for " + moduleInfo.getName()), (Object[])new Object[0]);
            }
            return null;
        }
        return this.ejbWARMetaDataRuntime.getEJBModuleMetaData(((ExtendedModuleInfo)moduleInfo).getMetaData());
    }

    public void moduleStarting(ModuleInfo moduleInfo) throws StateChangeException {
        ModuleMetaData ejbMMD = this.getEJBModuleMetaData(moduleInfo);
        if (ejbMMD != null) {
            ((EJBContainer)this.ejbContainerSR.getServiceWithException()).startEJBInWARModule(ejbMMD, moduleInfo.getContainer());
        }
    }

    public void moduleStarted(ModuleInfo moduleInfo) throws StateChangeException {
        ModuleMetaData ejbMMD = this.getEJBModuleMetaData(moduleInfo);
        if (ejbMMD != null) {
            ((EJBContainer)this.ejbContainerSR.getServiceWithException()).startedEJBInWARModule(ejbMMD, moduleInfo.getContainer());
        }
    }

    public void moduleStopping(ModuleInfo moduleInfo) {
    }

    public void moduleStopped(ModuleInfo moduleInfo) {
        ModuleMetaData ejbMMD = this.getEJBModuleMetaData(moduleInfo);
        if (ejbMMD != null) {
            ((EJBContainer)this.ejbContainerSR.getServiceWithException()).stopEJBInWARModule(ejbMMD, moduleInfo.getContainer());
        }
    }
}

