/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTInputStream31;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;

public class AsyncAlreadyReadCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(AsyncAlreadyReadCallback.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private SRTInputStream31 in;
    private ThreadContextManager threadContextManager;
    private SRTServletRequestThreadData _requestDataAsyncReadCallbackThread;

    public AsyncAlreadyReadCallback(SRTInputStream31 in, ThreadContextManager tcm) {
        this.in = in;
        this.threadContextManager = tcm;
        this._requestDataAsyncReadCallbackThread = SRTServletRequestThreadData.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"complete", (Object[])new Object[]{vc});
        }
        Object object = this.in.getCompleteLockObj();
        synchronized (object) {
            SRTServletRequestThreadData.getInstance().init(this._requestDataAsyncReadCallbackThread);
            this.threadContextManager.pushContextData();
            try {
                if (!this.in.isFinished()) {
                    this.in.getReadListener().onDataAvailable();
                }
            }
            catch (Throwable onDataAvailableException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onDataAvailable : " + onDataAvailableException + ", " + this.in.getReadListener()), (Object[])new Object[0]);
                }
                this.threadContextManager.popContextData();
                this.error(vc, onDataAvailableException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"complete");
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Message is fully read, calling ReadListener onAllDataRead : " + this.in.getReadListener()), (Object[])new Object[0]);
            }
            if (this.in.getReadListener() != null) {
                if (this.in.isFinished()) {
                    try {
                        this.in.getReadListener().onAllDataRead();
                    }
                    catch (Throwable onAllDataReadException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onAllDataRead : " + onAllDataReadException + ", " + this.in.getReadListener()), (Object[])new Object[0]);
                        }
                        this.threadContextManager.popContextData();
                        this.error(vc, onAllDataReadException);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"complete");
                        }
                        return;
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("onDataAavailabe returned without reading all data. Read Listener will no be called again : " + this.in.getReadListener()), (Object[])new Object[0]);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ReadListener is not set , stream must be closed, cannot call onAllDataRead()", (Object[])new Object[0]);
                }
            }
            this.threadContextManager.popContextData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Calling user's ReadListener onError : " + this.in.getReadListener()), (Object[])new Object[0]);
        }
        Exception e = null;
        SRTServletRequestThreadData.getInstance().init(this._requestDataAsyncReadCallbackThread);
        this.threadContextManager.pushContextData();
        if (this.in.getReadListener() != null) {
            Object object = this.in.getCompleteLockObj();
            synchronized (object) {
                try {
                    this.in.getReadListener().onError(t);
                }
                catch (Exception onErrorException) {
                    e = onErrorException;
                }
            }
            if (e != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onError : " + e + ", " + this.in.getReadListener()), (Object[])new Object[0]);
            } else if (t != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener and error cannot handle : " + t.getMessage() + ", " + this.in.getReadListener()), (Object[])new Object[0]);
            }
        }
        this.threadContextManager.popContextData();
    }
}

