/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.spi;

import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface AutoConfigurationCustomizer {
    public AutoConfigurationCustomizer addPropagatorCustomizer(BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> var1);

    public AutoConfigurationCustomizer addResourceCustomizer(BiFunction<? super Resource, ConfigProperties, ? extends Resource> var1);

    public AutoConfigurationCustomizer addSamplerCustomizer(BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> var1);

    public AutoConfigurationCustomizer addSpanExporterCustomizer(BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> var1);

    public AutoConfigurationCustomizer addPropertiesSupplier(Supplier<Map<String, String>> var1);

    default public AutoConfigurationCustomizer addPropertiesCustomizer(Function<ConfigProperties, Map<String, String>> propertiesCustomizer) {
        return this;
    }

    default public AutoConfigurationCustomizer addTracerProviderCustomizer(BiFunction<SdkTracerProviderBuilder, ConfigProperties, SdkTracerProviderBuilder> tracerProviderCustomizer) {
        return this;
    }

    default public AutoConfigurationCustomizer addMeterProviderCustomizer(BiFunction<SdkMeterProviderBuilder, ConfigProperties, SdkMeterProviderBuilder> meterProviderCustomizer) {
        return this;
    }

    default public AutoConfigurationCustomizer addMetricExporterCustomizer(BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> exporterCustomizer) {
        return this;
    }

    default public AutoConfigurationCustomizer addLoggerProviderCustomizer(BiFunction<SdkLoggerProviderBuilder, ConfigProperties, SdkLoggerProviderBuilder> meterProviderCustomizer) {
        return this;
    }

    default public AutoConfigurationCustomizer addLogRecordExporterCustomizer(BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> exporterCustomizer) {
        return this;
    }
}

