/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.cdi.interceptors;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.jta.embeddable.UserTransactionController;
import com.ibm.wsspi.uow.ExtendedUOWAction;
import com.ibm.wsspi.uow.UOWManager;
import com.ibm.wsspi.uow.UOWManagerFactory;
import jakarta.enterprise.inject.Stereotype;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import java.util.Set;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class TransactionalInterceptor
implements Serializable {
    private static final long serialVersionUID = 485903803670044161L;
    private static final TraceComponent tc = Tr.register(TransactionalInterceptor.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private final boolean behaveAccordingToSpec = this.behaveAccordingToSpec();

    @ManualTrace
    protected Transactional getTransactionalAnnotation(InvocationContext context, String txLabel) throws Exception {
        CDIService cdiService;
        Transactional interceptor;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransactionalAnnotation", (Object[])new Object[]{context, this});
        }
        if ((interceptor = this.findTransactionalInterceptor(context.getMethod())) == null && (interceptor = this.findTransactionalInterceptor(context.getTarget().getClass().getSuperclass())) == null && (cdiService = (CDIService)priv.getService(FrameworkUtil.getBundle(CDIService.class), CDIService.class)) != null) {
            Set bindings = cdiService.getInterceptorBindingsFromInvocationContext(context);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"bindings:", (Object[])new Object[]{bindings});
            }
            if (bindings != null) {
                for (Annotation anno : bindings) {
                    if (!Transactional.class.equals(anno.annotationType())) continue;
                    interceptor = (Transactional)anno;
                    break;
                }
            }
        }
        if (interceptor == null) {
            throw new Exception("Can't find @Transactional annotation in AroundInvoke for TxType." + txLabel);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransactionalAnnotation", (Object)interceptor);
        }
        return interceptor;
    }

    @ManualTrace
    private Transactional findTransactionalInterceptor(AnnotatedElement element) {
        Transactional t;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findTransactionalInterceptor", (Object[])new Object[]{element, this});
        }
        if ((t = element.getAnnotation(Transactional.class)) == null) {
            t = this.findInterceptorFromStereotype(element.getAnnotations());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findTransactionalInterceptor", (Object)t);
        }
        return t;
    }

    @ManualTrace
    private Transactional findInterceptorFromStereotype(Annotation[] anns) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findInterceptorFromStereotype", (Object[])new Object[]{anns, this});
        }
        Transactional ret = null;
        for (Annotation ann : anns) {
            Class<? extends Annotation> annType;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Examining annotation: " + ann.toString()), (Object[])new Object[0]);
            }
            if ((annType = ann.annotationType()).getAnnotation(Stereotype.class) == null || (ret = this.findTransactionalInterceptor(annType)) == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findInterceptorFromStereotype", (Object)ret);
            }
            return ret;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findInterceptorFromStereotype", null);
        }
        return null;
    }

    protected UOWManager getUOWM() {
        return UOWManagerFactory.getUOWManager();
    }

    private boolean behaveAccordingToSpec() {
        return ConfigurationProviderManager.getConfigurationProvider().isUTAsSpecified();
    }

    @FFDCIgnore(value={Exception.class})
    protected Object runUnderUOW(int uowType, boolean join, final InvocationContext context, String txLabel, final boolean uTEnabled) throws Exception {
        Object object;
        Transactional t = this.getTransactionalAnnotation(context, txLabel);
        final UserTransactionController tranCont = (UserTransactionController)this.getUOWM();
        final boolean isUTEnabled = tranCont.isEnabled();
        ExtendedUOWAction a = new ExtendedUOWAction(){
            static final long serialVersionUID = -3067033047987236444L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() throws Exception {
                Object object;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"1: uTEnabled: {0}, behaveAccordingToSpec: {1}", (Object[])new Object[]{uTEnabled, TransactionalInterceptor.this.behaveAccordingToSpec});
                }
                if (!uTEnabled || TransactionalInterceptor.this.behaveAccordingToSpec) {
                    tranCont.setEnabled(uTEnabled);
                }
                try {
                    object = context.proceed();
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"2: uTEnabled: {0}, behaveAccordingToSpec: {1}", (Object[])new Object[]{uTEnabled, TransactionalInterceptor.this.behaveAccordingToSpec});
                    }
                    if (!uTEnabled || TransactionalInterceptor.this.behaveAccordingToSpec) {
                        tranCont.setEnabled(isUTEnabled);
                    }
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"2: uTEnabled: {0}, behaveAccordingToSpec: {1}", (Object[])new Object[]{uTEnabled, TransactionalInterceptor.this.behaveAccordingToSpec});
                }
                if (!uTEnabled || TransactionalInterceptor.this.behaveAccordingToSpec) {
                    tranCont.setEnabled(isUTEnabled);
                }
                return object;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.tx.jta.cdi.interceptors.TransactionalInterceptor$1", 1.class, null, null);
            }
        };
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"3: uTEnabled: {0}, behaveAccordingToSpec: {1}", (Object[])new Object[]{uTEnabled, this.behaveAccordingToSpec});
            }
            if (!uTEnabled || this.behaveAccordingToSpec) {
                tranCont.setEnabled(true);
            }
            object = this.getUOWM().runUnderUOW(uowType, join, a, t.rollbackOn(), t.dontRollbackOn());
        }
        catch (Exception e) {
            try {
                throw this.processException(context, e);
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"4: uTEnabled: {0}, behaveAccordingToSpec: {1}", (Object[])new Object[]{uTEnabled, this.behaveAccordingToSpec});
                }
                if (!uTEnabled || this.behaveAccordingToSpec) {
                    tranCont.setEnabled(isUTEnabled);
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"4: uTEnabled: {0}, behaveAccordingToSpec: {1}", (Object[])new Object[]{uTEnabled, this.behaveAccordingToSpec});
        }
        if (!uTEnabled || this.behaveAccordingToSpec) {
            tranCont.setEnabled(isUTEnabled);
        }
        return object;
    }

    @Trivial
    private Exception processException(InvocationContext context, Exception e) {
        if (ConfigurationProviderManager.getConfigurationProvider().isThrowCheckedExceptions()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processException: configured to throw any exceptions.", (Object[])new Object[0]);
            }
            return e;
        }
        for (Class<?> declaredException : context.getMethod().getExceptionTypes()) {
            if (declaredException.isAssignableFrom(e.getClass())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processException: {0} is assignable from {1}. We can just return it.", (Object[])new Object[]{declaredException, e.getClass()});
                }
                return e;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"processException: {0} is not assignable from {1}", (Object[])new Object[]{declaredException, e.getClass()});
        }
        if (e instanceof RuntimeException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processException: {0} is already a RuntimeException. We can just return it.", (Object[])new Object[]{e.getClass().getName()});
            }
            return e;
        }
        TransactionalException te = new TransactionalException(e.getMessage(), (Throwable)e);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processException: wrapping {0} in a TransactionalException", (Object[])new Object[]{e.getClass().getName()});
        }
        return te;
    }
}

